/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.impala.util.FsPermissionChecker;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class FsPermissionCheckerTest {
    private final FsPermissionChecker checker = FsPermissionChecker.getInstance();

    @Test
    public void testCheckAccessWhenAuthorizationEnableAndFsPermissionDenied() throws IOException {
        Path path = new Path("hdfs://nameservice/user/impala/work");
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        FsAction read = FsAction.READ;
        ((FileSystem)Mockito.doThrow((Throwable[])new Throwable[]{new AccessControlException()}).when((Object)fs)).access(path, read);
        boolean access = this.checker.checkAccess(path, fs, read, true);
        Assert.assertFalse((boolean)access);
    }

    @Test
    public void testCheckAccessWhenAuthorizationEnableAndPermissionConfirmed() throws IOException {
        Path path = new Path("hdfs://nameservice/user/impala/work");
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        FsAction read = FsAction.READ;
        ((FileSystem)Mockito.doNothing().when((Object)fs)).access(path, read);
        boolean access = this.checker.checkAccess(path, fs, read, true);
        Assert.assertTrue((boolean)access);
    }

    @Test
    public void testCheckAccessWhenAuthorizationDisableAndPermissionDenied() throws IOException {
        Path path = new Path("hdfs://nameservice/user/impala/work");
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        FsAction read = FsAction.READ;
        FileStatus fileStatus = (FileStatus)Mockito.mock(FileStatus.class);
        ((FileSystem)Mockito.doReturn((Object)fileStatus).when((Object)fs)).getFileStatus(path);
        FsPermission permission = FsPermission.valueOf((String)"-r--r-----");
        ((FileStatus)Mockito.doReturn((Object)permission).when((Object)fileStatus)).getPermission();
        boolean access = this.checker.checkAccess(path, fs, read, false);
        Assert.assertFalse((boolean)access);
    }

    @Test
    public void testCheckAccessWhenAuthorizationDisableAndPermissionConfirmed() throws IOException {
        Path path = new Path("hdfs://nameservice/user/impala/work");
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        FsAction read = FsAction.READ;
        FileStatus fileStatus = (FileStatus)Mockito.mock(FileStatus.class);
        ((FileSystem)Mockito.doReturn((Object)fileStatus).when((Object)fs)).getFileStatus(path);
        FsPermission permission = FsPermission.valueOf((String)"-r--r--r--");
        ((FileStatus)Mockito.doReturn((Object)permission).when((Object)fileStatus)).getPermission();
        boolean access = this.checker.checkAccess(path, fs, read, false);
        Assert.assertTrue((boolean)access);
    }
}

