/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Strings;
import org.apache.impala.common.JniUtil;
import org.apache.impala.thrift.TCacheJarParams;
import org.apache.impala.util.CompressionUtil;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.junit.Assert;
import org.junit.Test;

public class CompressionUtilTest {
    private static TBinaryProtocol.Factory protocolFactory_ = new TBinaryProtocol.Factory();

    @Test
    public void testCompressionUtil() throws Exception {
        String[] stringsToTest;
        for (String test : stringsToTest = new String[]{"", "TestString", Strings.repeat((String)"x", (int)0x6400000)}) {
            byte[] compressed = CompressionUtil.deflateCompress((byte[])test.getBytes());
            byte[] decompressed = CompressionUtil.deflateDecompress((byte[])compressed);
            Assert.assertEquals((Object)new String(decompressed), (Object)test);
        }
        TCacheJarParams testObject = new TCacheJarParams("test string");
        byte[] testObjBytes = JniUtil.serializeToThrift((TBase)testObject, (TProtocolFactory)protocolFactory_);
        byte[] compressed = CompressionUtil.deflateCompress((byte[])testObjBytes);
        byte[] decompressed = CompressionUtil.deflateDecompress((byte[])compressed);
        TCacheJarParams deserializedTestObj = new TCacheJarParams();
        JniUtil.deserializeThrift((TProtocolFactory)protocolFactory_, (TBase)deserializedTestObj, (byte[])decompressed);
        Assert.assertEquals((Object)deserializedTestObj.hdfs_location, (Object)"test string");
    }
}

