/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import java.util.Set;
import org.apache.impala.analysis.TableName;
import org.apache.impala.util.CatalogBlacklistUtils;
import org.junit.Assert;
import org.junit.Test;

public class CatalogBlacklistUtilsTest {
    @Test
    public void testParsingBlacklistedDbs() {
        Set blacklistedDbs = CatalogBlacklistUtils.parseBlacklistedDbs((String)"db1,db2", null);
        Assert.assertEquals((long)blacklistedDbs.size(), (long)2L);
        Assert.assertTrue((boolean)blacklistedDbs.contains("db1"));
        Assert.assertTrue((boolean)blacklistedDbs.contains("db2"));
        blacklistedDbs = CatalogBlacklistUtils.parseBlacklistedDbs((String)" db1 , db2 ", null);
        Assert.assertEquals((long)blacklistedDbs.size(), (long)2L);
        Assert.assertTrue((boolean)blacklistedDbs.contains("db1"));
        Assert.assertTrue((boolean)blacklistedDbs.contains("db2"));
        blacklistedDbs = CatalogBlacklistUtils.parseBlacklistedDbs((String)" ", null);
        Assert.assertTrue((boolean)blacklistedDbs.isEmpty());
        blacklistedDbs = CatalogBlacklistUtils.parseBlacklistedDbs((String)"DB1,Db2", null);
        Assert.assertEquals((long)blacklistedDbs.size(), (long)2L);
        Assert.assertTrue((boolean)blacklistedDbs.contains("db1"));
        Assert.assertTrue((boolean)blacklistedDbs.contains("db2"));
        blacklistedDbs = CatalogBlacklistUtils.parseBlacklistedDbs((String)"db1,", null);
        Assert.assertEquals((long)blacklistedDbs.size(), (long)1L);
        Assert.assertTrue((boolean)blacklistedDbs.contains("db1"));
    }

    @Test
    public void testParsingBlacklistedTables() {
        Set blacklistedTables = CatalogBlacklistUtils.parseBlacklistedTables((String)"db3.foo,db3.bar", null);
        Assert.assertEquals((long)blacklistedTables.size(), (long)2L);
        Assert.assertTrue((boolean)blacklistedTables.contains(new TableName("db3", "foo")));
        Assert.assertTrue((boolean)blacklistedTables.contains(new TableName("db3", "bar")));
        blacklistedTables = CatalogBlacklistUtils.parseBlacklistedTables((String)" db3 . foo , db3 . bar  ", null);
        Assert.assertEquals((long)blacklistedTables.size(), (long)2L);
        Assert.assertTrue((boolean)blacklistedTables.contains(new TableName("db3", "foo")));
        Assert.assertTrue((boolean)blacklistedTables.contains(new TableName("db3", "bar")));
        blacklistedTables = CatalogBlacklistUtils.parseBlacklistedTables((String)"foo", null);
        Assert.assertEquals((long)blacklistedTables.size(), (long)1L);
        Assert.assertTrue((boolean)blacklistedTables.contains(new TableName("default", "foo")));
        blacklistedTables = CatalogBlacklistUtils.parseBlacklistedTables((String)"DB3.Foo,db3.Bar", null);
        Assert.assertEquals((long)blacklistedTables.size(), (long)2L);
        Assert.assertTrue((boolean)blacklistedTables.contains(new TableName("db3", "foo")));
        Assert.assertTrue((boolean)blacklistedTables.contains(new TableName("db3", "bar")));
        blacklistedTables = CatalogBlacklistUtils.parseBlacklistedTables((String)"db3.,.bar,,", null);
        Assert.assertEquals((long)blacklistedTables.size(), (long)1L);
        Assert.assertTrue((boolean)blacklistedTables.contains(new TableName("default", "bar")));
    }
}

