/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.util.AcidUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidUtilsTest {
    private static final Logger LOG = LoggerFactory.getLogger(AcidUtilsTest.class);
    private static final Path BASE_PATH = new Path("file:///foo/bar/");

    public AcidUtilsTest() {
        Assume.assumeTrue((String)"Tests require Hive 3 to parse and use WriteIdList", (MetastoreShim.getMajorVersion() == 3L ? 1 : 0) != 0);
    }

    private static List<FileStatus> createMockStats(String ... testStrings) {
        return Arrays.asList(testStrings).stream().map(s -> new FileStatus(0L, s.endsWith("/"), 1, 0L, 1L, new Path(BASE_PATH, s))).collect(Collectors.toList());
    }

    private void assertFiltering(String[] relPaths, String validWriteIdListStr, String[] expectedRelPaths) {
        this.assertFiltering(relPaths, "", validWriteIdListStr, expectedRelPaths);
    }

    private void assertFiltering(String[] relPaths, String validTxnListStr, String validWriteIdListStr, String[] expectedRelPaths) {
        ValidWriteIdList writeIds = MetastoreShim.getValidWriteIdListFromString((String)validWriteIdListStr);
        List<FileStatus> stats = AcidUtilsTest.createMockStats(relPaths);
        List<FileStatus> expectedStats = AcidUtilsTest.createMockStats(expectedRelPaths);
        try {
            Assert.assertThat((Object)AcidUtils.filterFilesForAcidState(stats, (Path)BASE_PATH, (ValidTxnList)new ValidReadTxnList(validTxnListStr), (ValidWriteIdList)writeIds, null), (Matcher)Matchers.containsInAnyOrder((Object[])expectedStats.toArray()));
        }
        catch (CatalogException me) {
            Assert.assertTrue((boolean)false);
        }
    }

    public void filteringError(String[] relPaths, String validTxnListStr, String validWriteIdListStr, String expectedErrorString) {
        Preconditions.checkNotNull((Object)expectedErrorString, (Object)"No expected error message given.");
        try {
            ValidWriteIdList writeIds = MetastoreShim.getValidWriteIdListFromString((String)validWriteIdListStr);
            List<FileStatus> stats = AcidUtilsTest.createMockStats(relPaths);
            AcidUtils.filterFilesForAcidState(stats, (Path)BASE_PATH, (ValidTxnList)new ValidReadTxnList(validTxnListStr), (ValidWriteIdList)writeIds, null);
        }
        catch (Exception e) {
            String errorString = e.getMessage();
            Preconditions.checkNotNull((Object)errorString, (Object)"Stack trace lost during exception.");
            String msg = "got error:\n" + errorString + "\nexpected:\n" + expectedErrorString;
            Assert.assertTrue((String)msg, (boolean)errorString.startsWith(expectedErrorString));
            return;
        }
        Assert.fail((String)"Filtering didn't result in error");
    }

    @Test
    public void testParsingBaseWriteIds() {
        Assert.assertEquals((long)Long.MIN_VALUE, (long)AcidUtils.getBaseWriteId((String)"base_01.txt"));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)AcidUtils.getBaseWriteId((String)"base_01_02"));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)AcidUtils.getBaseWriteId((String)"abc/base_6"));
        Assert.assertEquals((long)2L, (long)AcidUtils.getBaseWriteId((String)"base_00002"));
        Assert.assertEquals((long)2L, (long)AcidUtils.getBaseWriteId((String)"base_00002/foo"));
        Assert.assertEquals((long)2L, (long)AcidUtils.getBaseWriteId((String)"base_00002_v12345"));
        Assert.assertEquals((long)2L, (long)AcidUtils.getBaseWriteId((String)"base_00002_v12345/foo"));
    }

    @Test
    public void testBasePredicate() {
        this.assertFiltering(new String[]{"base_01.txt", "post_upgrade.txt", "base_0000005/", "base_0000005/abc.txt", "base_0000005/0000/", "base_0000005/0000/abc.txt", "_tmp.base_0000005/000000_0.manifest", "abc/", "abc/base_0000006/", "base_00000100/def.txt"}, "default.test:10:1234:1,2,3", new String[]{"base_0000005/abc.txt", "base_0000005/0000/abc.txt"});
    }

    @Test
    public void testOpenTransactions() {
        this.assertFiltering(new String[]{"base_01.txt", "post_upgrade.txt", "base_0000005/", "base_0000005/abc.txt", "base_0000005/0000/", "base_0000005/0000/abc.txt", "_tmp.base_0000005/000000_0.manifest", "delta_0000006_0000006_0000/", "delta_0000006_0000006_0000/000000_0", "delta_0000007_0000007_0000/", "delta_0000007_0000007_0000/000000_0", "delta_0000008_0000008_0000/", "delta_0000008_0000008_0000/000000_0", "delta_0000009_0000009_0000/", "delta_0000009_0000009_0000/000000_0", "delta_0000009_0000009_0000/0000/def.txt"}, "default.test:10:6:6,7,8:", new String[]{"base_0000005/abc.txt", "base_0000005/0000/abc.txt", "delta_0000009_0000009_0000/000000_0", "delta_0000009_0000009_0000/0000/def.txt"});
    }

    @Test
    public void testInProgressCompaction() {
        this.assertFiltering(new String[]{"base_01.txt", "post_upgrade.txt", "base_0000005_v900/", "base_0000005_v900/abc.txt", "base_0000005_v900/0000/", "base_0000005_v900/0000/abc.txt", "base_0000008_v1000/", "base_0000008_v1000/abc.txt", "delta_0000006_0000006_0000/", "delta_0000006_0000006_0000/000000_0", "delta_0000007_0000007_0000/", "delta_0000007_0000007_0000/000000_0", "delta_0000008_0000008_0000/", "delta_0000008_0000008_0000/000000_0", "delta_0000009_0000009_0000/", "delta_0000009_0000009_0000/000000_0", "delta_0000009_0000009_0000/0000/def.txt"}, "1100:1000:1000:", "default.test:10:10::", new String[]{"base_0000005_v900/abc.txt", "base_0000005_v900/0000/abc.txt", "delta_0000006_0000006_0000/000000_0", "delta_0000007_0000007_0000/000000_0", "delta_0000008_0000008_0000/000000_0", "delta_0000009_0000009_0000/000000_0", "delta_0000009_0000009_0000/0000/def.txt"});
    }

    public void testStreamingIngest() {
        this.assertFiltering(new String[]{"delta_0000001_0000005/bucket_0000", "delta_0000001_0000005/bucket_0001", "delta_0000001_0000005/bucket_0002", "delta_0000001_0000005_v01000/bucket_0000", "delta_0000001_0000005_v01000/bucket_0001", "delta_0000001_0000005_v01000/bucket_0002"}, "1100:1000:1000:", "default.test:10:10::", new String[]{"delta_0000001_0000005/bucket_0000", "delta_0000001_0000005/bucket_0001", "delta_0000001_0000005/bucket_0002"});
        this.assertFiltering(new String[]{"delta_0000001_0000005/bucket_0000", "delta_0000001_0000005/bucket_0001", "delta_0000001_0000005/bucket_0002", "delta_0000001_0000005_v01000/bucket_0000", "delta_0000001_0000005_v01000/bucket_0001", "delta_0000001_0000005_v01000/bucket_0002"}, "1100:::", "default.test:10:10::", new String[]{"delta_0000001_0000005_v01000/bucket_0000", "delta_0000001_0000005_v01000/bucket_0001", "delta_0000001_0000005_v01000/bucket_0002"});
    }

    @Test
    public void testAbortedCompaction() {
        this.assertFiltering(new String[]{"base_01.txt", "post_upgrade.txt", "base_0000005_v900/", "base_0000005_v900/abc.txt", "base_0000005_v900/0000/", "base_0000005_v900/0000/abc.txt", "base_0000007_v950/", "base_0000007_v950/abc.txt", "base_0000008_v1000/", "base_0000008_v1000/abc.txt", "delta_0000006_0000006_0000/", "delta_0000006_0000006_0000/000000_0", "delta_0000007_0000007_0000/", "delta_0000007_0000007_0000/000000_0", "delta_0000008_0000008_0000/", "delta_0000008_0000008_0000/000000_0", "delta_0000009_0000009_0000/", "delta_0000009_0000009_0000/000000_0", "delta_0000009_0000009_0000/0000/def.txt"}, "1100:1100::1000", "default.test:10:10::", new String[]{"base_0000007_v950/abc.txt", "delta_0000008_0000008_0000/000000_0", "delta_0000009_0000009_0000/000000_0", "delta_0000009_0000009_0000/0000/def.txt"});
    }

    @Test
    public void testAbortedTransactions() {
        this.assertFiltering(new String[]{"base_01.txt", "post_upgrade.txt", "base_0000005/", "base_0000005/abc.txt", "base_0000005/0000/", "base_0000005/0000/abc.txt", "_tmp.base_0000005/000000_0.manifest", "delta_0000006_0000006_0000/", "delta_0000006_0000006_0000/000000_0", "delta_0000007_0000007_0000/", "delta_0000007_0000007_0000/000000_0", "delta_0000008_0000008_0000/", "delta_0000008_0000008_0000/000000_0", "delta_0000009_0000009_0000/", "delta_0000009_0000009_0000/000000_0", "delta_0000009_0000009_0000/0000/def.txt"}, "default.test:10:1337::7,8,9", new String[]{"base_0000005/abc.txt", "base_0000005/0000/abc.txt", "delta_0000006_0000006_0000/000000_0"});
    }

    @Test
    public void testPostCompactionBase() {
        this.assertFiltering(new String[]{"base_0000003_v0003217/", "base_0000003_v0003217/000000_0", "delta_0000001_0000001_0000/", "delta_0000001_0000001_0000/000000_0", "delta_0000002_0000002_0000/", "delta_0000002_0000002_0000/000000_0", "delta_0000003_0000003_0000/", "delta_0000003_0000003_0000/000000_0"}, "test_acid_compaction_676f9a30.tt:3:9223372036854775807::", new String[]{"base_0000003_v0003217/000000_0"});
    }

    @Test
    public void testDeltaPredicate() {
        String[] paths = new String[]{"delta_000005_0000005/", "delta_000005_0000005/abc.txt", "delta_000005_0000005_0000/", "delta_000005_0000005_0000/abc.txt", "delta_000006_0000020/", "delta_000006_0000020/def.txt", "delta_000005.txt"};
        this.assertFiltering(paths, "default.test:10:1234:1,2,3", new String[]{"delta_000005_0000005/abc.txt", "delta_000006_0000020/def.txt", "delta_000005.txt"});
    }

    @Test
    public void testAcidStateFilter() {
        this.assertFiltering(new String[]{"base_0000009/", "base_0000009/abc.txt", "delta_000005_000005_0000/", "delta_000005_000005_0000/lmn.txt", "base_0000010/", "base_0000010/00000_0", "base_0000010/00001_0", "delta_0000012_0000012_0000/", "delta_0000012_0000012_0000/0000_0", "delta_0000012_0000012_0000/0000_1"}, "", new String[]{"base_0000010/00000_0", "base_0000010/00001_0", "delta_0000012_0000012_0000/0000_0", "delta_0000012_0000012_0000/0000_1"});
    }

    @Test
    public void testAcidStateNoBase() {
        this.assertFiltering(new String[]{"base_01.txt", "post_upgrade.txt", "delta_000005_000005_0000/", "delta_000005_000005_0000/lmn.txt", "base_000010/", "delta_0000012_0000012_0000/", "delta_0000012_0000012_0000/0000_0", "delta_0000012_0000012_0000/0000_1"}, "", new String[]{"delta_0000012_0000012_0000/0000_0", "delta_0000012_0000012_0000/0000_1"});
        this.assertFiltering(new String[]{"base_01.txt", "post_upgrade.txt", "delta_000005_000005_0000/", "delta_000005_000005_0000/lmn.txt", "delta_0000012_0000012_0000/", "delta_0000012_0000012_0000/0000_0", "delta_0000012_0000012_0000/0000_1"}, "", new String[]{"base_01.txt", "post_upgrade.txt", "delta_000005_000005_0000/lmn.txt", "delta_0000012_0000012_0000/0000_0", "delta_0000012_0000012_0000/0000_1"});
    }

    @Test
    public void testMinorCompactionAllTxnsValid() {
        this.assertFiltering(new String[]{"base_0000005/", "base_0000005/abc.txt", "delta_0000006_0000006_v01000/00000", "delta_0000007_0000007_v01000/00000", "delta_0000006_0000007_v01000/00000"}, "", "default.test:10:1234:1,2,3", new String[]{"base_0000005/abc.txt", "delta_0000006_0000007_v01000/00000"});
        this.assertFiltering(new String[]{"base_0000005/", "base_0000005/abc.txt", "delta_0000006_0000006_00001/00000", "delta_0000006_0000006_00002/00000", "delta_0000006_0000006_00003/00000", "delta_0000006_0000006_v01000/00000", "delta_0000006_0000006_v01000/00001"}, "", "default.test:10:1234:", new String[]{"base_0000005/abc.txt", "delta_0000006_0000006_v01000/00000", "delta_0000006_0000006_v01000/00001"});
        this.assertFiltering(new String[]{"delta_0000001_0000001/00000", "delta_0000002_0000002/00000", "delta_0000003_0000003/00000", "delta_0000004_0000004/00000", "delta_0000005_0000005/00000", "delta_0000006_0000006/00000", "delta_0000007_0000007/00000", "delta_0000001_0000003_v00100/00000", "delta_0000004_0000005_v00101/00000", "delta_0000001_0000005_v00102/00000", "delta_0000006_0000007_v00123/00000", "delta_0000006_0000007_v00123/00001"}, "", "default.test:10:1234:", new String[]{"delta_0000001_0000005_v00102/00000", "delta_0000006_0000007_v00123/00000", "delta_0000006_0000007_v00123/00001"});
        this.assertFiltering(new String[]{"delta_0000001_0000001/00000", "delta_0000002_0000002/00000", "delta_0000003_0000003/00000", "delta_0000001_0000003_v01000/00000"}, "", "default.test:10:5::2", new String[]{"delta_0000001_0000003_v01000/00000"});
    }

    @Test
    public void testInProgressMinorCompactions() {
        this.assertFiltering(new String[]{"base_0000005/", "base_0000005/abc.txt", "delta_0000006_0000006/00000", "delta_0000007_0000007/00000", "delta_0000006_0000007_v100/00000"}, "90:90::", "default.test:10:1234:1,2,3", new String[]{"base_0000005/abc.txt", "delta_0000006_0000006/00000", "delta_0000007_0000007/00000"});
        this.assertFiltering(new String[]{"base_0000005/", "base_0000005/abc.txt", "delta_0000006_0000006_00001/00000", "delta_0000006_0000006_00002/00000", "delta_0000006_0000006_00003/00000", "delta_0000006_0000006_v100/00000", "delta_0000006_0000006_v100/00001"}, "110:100:100:", "default.test:10:1234:", new String[]{"base_0000005/abc.txt", "delta_0000006_0000006_00001/00000", "delta_0000006_0000006_00002/00000", "delta_0000006_0000006_00003/00000"});
        this.assertFiltering(new String[]{"delta_0000001_0000001/00000", "delta_0000002_0000002/00000", "delta_0000003_0000003/00000", "delta_0000004_0000004/00000", "delta_0000005_0000005/00000", "delta_0000006_0000006/00000", "delta_0000007_0000007/00000", "delta_0000001_0000003_v00100/00000", "delta_0000004_0000005_v00101/00000", "delta_0000001_0000005_v00102/00000", "delta_0000006_0000007_v00123/00000", "delta_0000006_0000007_v00123/00001"}, "130:102:102:", "default.test:10:1234:", new String[]{"delta_0000001_0000003_v00100/00000", "delta_0000004_0000005_v00101/00000", "delta_0000006_0000007_v00123/00000", "delta_0000006_0000007_v00123/00001"});
    }

    @Test
    public void testDeleteDelta() {
        this.assertFiltering(new String[]{"base_0000005/", "base_0000005/abc.txt", "delete_delta_0000006_0000006/", "delete_delta_0000006_0000006/00000"}, "", "default.test:10:1234:1,2,3", new String[]{"base_0000005/abc.txt", "delete_delta_0000006_0000006/00000"});
        this.assertFiltering(new String[]{"base_0000005/", "base_0000005/abc.txt", "delete_delta_0000006_0000006/", "delete_delta_0000006_0000006/00000", "delete_delta_0000007_0000007/00000", "delete_delta_0000007_0000007/00001", "delete_delta_0000008_0000008/00000", "delete_delta_0000009_0000009/00000", "delete_delta_0000010_0000010/00000", "delete_delta_0000011_0000011/00000"}, "", "default.test:10:1234:6:9", new String[]{"base_0000005/abc.txt", "delete_delta_0000007_0000007/00000", "delete_delta_0000007_0000007/00001", "delete_delta_0000008_0000008/00000", "delete_delta_0000010_0000010/00000"});
    }

    public void testHiveStreamingFail() {
        this.filteringError(new String[]{"base_0000005/", "base_0000005/abc.txt", "delta_0000006_0000016/", "delta_0000006_0000016/00000_0", "delta_0000006_0000016/00000_0_flush_length"}, "", "default.test:22:1234:1,2,3", "Found Hive Streaming side-file");
        this.assertFiltering(new String[]{"base_0000005/", "base_0000005/abc.txt", "delta_0000006_0000016/", "delta_0000006_0000016/00000_0", "delta_0000006_0000016/00000_0_flush_length", "base_0000017_v123/0000_0"}, "", "default.test:22:1234:1,2,3", new String[]{"base_0000017_v123/0000_0"});
    }

    @Test
    public void testMinorCompactionBeforeBase() {
        this.assertFiltering(new String[]{"delta_000005_000008_0000/", "delta_000005_000008_0000/abc.txt", "base_000010/", "base_000010/0000_0", "delta_0000012_0000012_0000/", "delta_0000012_0000012_0000/0000_0", "delta_0000012_0000012_0000/0000_1"}, "default.test:20:15::", new String[]{"base_000010/0000_0", "delta_0000012_0000012_0000/0000_0", "delta_0000012_0000012_0000/0000_1"});
    }

    @Test
    public void testDeletesBeforeBase() {
        this.assertFiltering(new String[]{"delta_000004_000004_0000/", "delta_000004_000004_0000/0000", "delete_delta_000005_000005_0000/", "delete_delta_000005_000005_0000/0000", "base_000010/", "base_000010/0000_0", "delta_0000012_0000012_0000/", "delta_0000012_0000012_0000/0000_0", "delta_0000012_0000012_0000/0000_1"}, "default.test:20:15::", new String[]{"base_000010/0000_0", "delta_0000012_0000012_0000/0000_0", "delta_0000012_0000012_0000/0000_1"});
    }

    @Test
    public void testOpenWriteIdBeforeInsertOverwrite() {
        this.assertFiltering(new String[]{"base_000001/", "base_000001/0000_0", "delta_000002_000002_0000/", "delta_000002_000002_0000/0000", "base_000003/", "base_000003/0000_0"}, "default.test:3:2:1:", new String[]{"base_000003/0000_0"});
    }

    @Test
    public void testWriteIdListCompare() {
        ValidReaderWriteIdList a = new ValidReaderWriteIdList("default.test:1:1:1:");
        ValidReaderWriteIdList b = new ValidReaderWriteIdList("default.test:1:9223372036854775807::");
        assert (AcidUtils.compare((ValidWriteIdList)a, (ValidWriteIdList)b) == -1);
        assert (AcidUtils.compare((ValidWriteIdList)b, (ValidWriteIdList)a) == 1);
    }
}

