/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.testutil;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.impala.catalog.SideloadTableStats;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.junit.Assert;

public class StatsJsonParser {
    private final String fileName_;
    private Map<String, Map<String, SideloadTableStats>> dbStatsMap_;

    public StatsJsonParser(String fileName) {
        this.fileName_ = fileName;
        this.dbStatsMap_ = new HashMap<String, Map<String, SideloadTableStats>>();
    }

    public Map<String, Map<String, SideloadTableStats>> getDbStatsMap() {
        return this.dbStatsMap_;
    }

    private JSONObject open() {
        try {
            String testFileBaseDir = new File(System.getenv("IMPALA_HOME"), "testdata/workloads").getPath();
            File statsFile = new File(testFileBaseDir, this.fileName_);
            JSONParser parser = new JSONParser();
            return (JSONObject)parser.parse((Reader)new FileReader(statsFile));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    private void loadStatsForColumns(SideloadTableStats tableStats, JSONObject columnStats) {
        for (Object colKey : columnStats.keySet()) {
            String colName = (String)colKey;
            JSONObject colStats = (JSONObject)columnStats.get(colKey);
            String colType = (String)colStats.get((Object)"type");
            if (colType.contains("(")) {
                colType = colType.substring(0, colType.indexOf("("));
            }
            ColumnStatisticsData statsData = new ColumnStatisticsData();
            switch (colType) {
                case "BOOLEAN": {
                    BooleanColumnStatsData boolStats = new BooleanColumnStatsData(((Long)colStats.get((Object)"numTrues")).longValue(), ((Long)colStats.get((Object)"numFalses")).longValue(), ((Long)colStats.get((Object)"numNulls")).longValue());
                    statsData.setBooleanStats(boolStats);
                    break;
                }
                case "TINYINT": 
                case "SMALLINT": 
                case "INT": 
                case "BIGINT": 
                case "TIMESTAMP": {
                    LongColumnStatsData longStats = new LongColumnStatsData(((Long)colStats.get((Object)"numNulls")).longValue(), ((Long)colStats.get((Object)"numDVs")).longValue());
                    statsData.setLongStats(longStats);
                    break;
                }
                case "DATE": {
                    DateColumnStatsData dateStats = new DateColumnStatsData(((Long)colStats.get((Object)"numNulls")).longValue(), ((Long)colStats.get((Object)"numDVs")).longValue());
                    statsData.setDateStats(dateStats);
                    break;
                }
                case "FLOAT": 
                case "DOUBLE": {
                    DoubleColumnStatsData doubleStats = new DoubleColumnStatsData(((Long)colStats.get((Object)"numNulls")).longValue(), ((Long)colStats.get((Object)"numDVs")).longValue());
                    statsData.setDoubleStats(doubleStats);
                    break;
                }
                case "CHAR": {
                    StringColumnStatsData charStats = new StringColumnStatsData();
                    charStats.setNumNulls(((Long)colStats.get((Object)"numNulls")).longValue());
                    charStats.setNumDVs(((Long)colStats.get((Object)"numDVs")).longValue());
                    statsData.setStringStats(charStats);
                    break;
                }
                case "VARCHAR": 
                case "STRING": {
                    Object strAvgField = colStats.get((Object)"avgColLen");
                    Double strAvgColLen = strAvgField instanceof Long ? ((Long)strAvgField).doubleValue() : ((Double)strAvgField).doubleValue();
                    StringColumnStatsData stringStats = new StringColumnStatsData(((Long)colStats.get((Object)"maxColLen")).longValue(), strAvgColLen.doubleValue(), ((Long)colStats.get((Object)"numNulls")).longValue(), ((Long)colStats.get((Object)"numDVs")).longValue());
                    statsData.setStringStats(stringStats);
                    break;
                }
                case "BINARY": {
                    Object binAvgField = colStats.get((Object)"avgColLen");
                    Double binAvgColLen = binAvgField instanceof Long ? ((Long)binAvgField).doubleValue() : ((Double)binAvgField).doubleValue();
                    BinaryColumnStatsData binaryStats = new BinaryColumnStatsData(((Long)colStats.get((Object)"maxColLen")).longValue(), binAvgColLen.doubleValue(), ((Long)colStats.get((Object)"numNulls")).longValue());
                    statsData.setBinaryStats(binaryStats);
                    break;
                }
                case "DECIMAL": {
                    DecimalColumnStatsData decimalStats = new DecimalColumnStatsData(((Long)colStats.get((Object)"numNulls")).longValue(), ((Long)colStats.get((Object)"numDVs")).longValue());
                    statsData.setDecimalStats(decimalStats);
                    break;
                }
                default: {
                    Assert.fail((String)"Column type is invalid!");
                }
            }
            tableStats.addColumnStats(colName, statsData);
        }
    }

    private SideloadTableStats loadStatsForTable(String tableName, JSONObject tableStat) {
        long numRows = (Long)tableStat.get((Object)"numRows");
        long totalSize = (Long)tableStat.get((Object)"totalSize");
        SideloadTableStats parsedStats = new SideloadTableStats(tableName, numRows, totalSize);
        this.loadStatsForColumns(parsedStats, (JSONObject)tableStat.get((Object)"columns"));
        return parsedStats;
    }

    public void parseFile() {
        JSONObject statsJson = this.open();
        Preconditions.checkNotNull((Object)statsJson);
        this.dbStatsMap_ = new HashMap<String, Map<String, SideloadTableStats>>();
        for (Object dbKey : statsJson.keySet()) {
            String dbName = (String)dbKey;
            JSONObject tableStats = (JSONObject)statsJson.get(dbKey);
            HashMap<String, SideloadTableStats> tableStatsMap = new HashMap<String, SideloadTableStats>();
            for (Object tableKey : tableStats.keySet()) {
                String tableName = (String)tableKey;
                SideloadTableStats stats = this.loadStatsForTable(tableName, (JSONObject)tableStats.get(tableKey));
                tableStatsMap.put(tableName, stats);
            }
            this.dbStatsMap_.put(dbName, tableStatsMap);
        }
    }
}

