/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.testutil;

import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.AuthorizationManager;
import org.apache.impala.authorization.NoopAuthorizationFactory;
import org.apache.impala.catalog.Catalog;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.hive.executor.HiveJavaFunctionFactory;
import org.apache.impala.hive.executor.TestHiveJavaFunctionFactory;
import org.apache.impala.service.CatalogOpExecutor;
import org.apache.impala.service.Frontend;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.apache.impala.testutil.ImpaladTestCatalog;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TCatalogUpdateResult;
import org.apache.impala.thrift.TCopyTestCaseReq;
import org.apache.impala.thrift.TDdlExecResponse;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;

public class PlannerTestCaseLoader
implements AutoCloseable {
    private final CatalogOpExecutor catalogOpExecutor_;
    private final ImpaladTestCatalog catalog_ = new ImpaladTestCatalog(CatalogServiceTestCatalog.createTransientTestCatalog());
    private final Frontend frontend_ = new Frontend((AuthorizationFactory)new NoopAuthorizationFactory(), (FeCatalog)this.catalog_);

    public PlannerTestCaseLoader() throws ImpalaException {
        this.catalogOpExecutor_ = new CatalogOpExecutor(this.catalog_.getSrcCatalog(), new NoopAuthorizationFactory().getAuthorizationConfig(), (AuthorizationManager)new NoopAuthorizationFactory.NoopAuthorizationManager(), (HiveJavaFunctionFactory)new TestHiveJavaFunctionFactory());
    }

    public Catalog getSrcCatalog() {
        return this.catalog_.getSrcCatalog();
    }

    public String loadTestCase(String testCasePath) throws Exception {
        String stmt = this.catalogOpExecutor_.copyTestCaseData(new TCopyTestCaseReq(testCasePath), new TDdlExecResponse(new TCatalogUpdateResult()), false);
        TQueryCtx queryCtx = TestUtils.createQueryContext(new TQueryOptions().setPlanner_testcase_mode(true));
        queryCtx.client_request.setStmt(stmt);
        return this.frontend_.getExplainString(queryCtx);
    }

    @Override
    public void close() {
        this.getSrcCatalog().close();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException(String.format("Incorrect number of args. Expected 1 argument, found %d. Valid usage: PlannerTestCaseLoader <testcase path>", args.length));
        }
        try (PlannerTestCaseLoader testCaseLoader = new PlannerTestCaseLoader();){
            System.out.println(testCaseLoader.loadTestCase(args[0]));
        }
        System.exit(0);
    }
}

