/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.testutil;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncompetentMetastoreClientPool
extends MetaStoreClientPool {
    private static final Logger LOG = LoggerFactory.getLogger(IncompetentMetastoreClientPool.class);

    public IncompetentMetastoreClientPool(int initialSize, int initialCnxnTimeoutSec) {
        super(initialSize, initialCnxnTimeoutSec, IncompetentMetastoreClientPool.generateHMSConfWithWrongAddr());
    }

    private static HiveConf generateHMSConfWithWrongAddr() {
        LOG.info("Creating IncompetentMetastoreClientPool using a wrong HMS port");
        HiveConf conf = new HiveConf(IncompetentMetastoreClientPool.class);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)"thrift://localhost:123");
        return conf;
    }
}

