/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.testutil;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.impala.analysis.TableName;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.NoopAuthorizationFactory;
import org.apache.impala.catalog.BuiltinsDb;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.HdfsCachePool;
import org.apache.impala.catalog.ImpaladCatalog;
import org.apache.impala.catalog.PrincipalPrivilege;
import org.apache.impala.catalog.Role;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.User;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.apache.impala.thrift.TPrivilege;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.NoOpEventSequence;
import org.apache.impala.util.PatternMatcher;

public class ImpaladTestCatalog
extends ImpaladCatalog {
    private final CatalogServiceCatalog srcCatalog_;

    public ImpaladTestCatalog() {
        this((AuthorizationFactory)new NoopAuthorizationFactory());
    }

    public ImpaladTestCatalog(AuthorizationFactory authzFactory) {
        super(null);
        CatalogServiceTestCatalog catalogServerCatalog = CatalogServiceTestCatalog.createWithAuth(authzFactory);
        this.authPolicy_ = catalogServerCatalog.getAuthPolicy();
        this.srcCatalog_ = catalogServerCatalog;
        this.srcCatalog_.addDb(BuiltinsDb.getInstance());
        this.setIsReady(true);
    }

    public ImpaladTestCatalog(CatalogServiceCatalog catalog) {
        super(null);
        this.srcCatalog_ = (CatalogServiceCatalog)Preconditions.checkNotNull((Object)catalog);
        this.authPolicy_ = this.srcCatalog_.getAuthPolicy();
        this.setIsReady(true);
    }

    public void addDb(Db db) {
        if (db == BuiltinsDb.getInstance()) {
            return;
        }
        this.srcCatalog_.addDb(db);
    }

    @Nullable
    public Db removeDb(String dbName) {
        return this.srcCatalog_.removeDb(dbName);
    }

    public Db getDb(String dbName) {
        if (dbName.equals("_impala_builtins")) {
            return BuiltinsDb.getInstance();
        }
        return this.srcCatalog_.getDb(dbName);
    }

    public List<Db> getDbs(PatternMatcher matcher) {
        return this.srcCatalog_.getDbs(matcher);
    }

    public HdfsCachePool getHdfsCachePool(String poolName) {
        return this.srcCatalog_.getHdfsCachePool(poolName);
    }

    public CatalogServiceCatalog getSrcCatalog() {
        return this.srcCatalog_;
    }

    public void reset() throws CatalogException {
        this.srcCatalog_.reset((EventSequence)NoOpEventSequence.INSTANCE);
    }

    public Table getOrLoadTable(String dbName, String tblName) {
        Db db = this.getDb(dbName);
        if (db == null) {
            return null;
        }
        Table existingTbl = db.getTable(tblName);
        if (existingTbl == null || existingTbl.isLoaded()) {
            return existingTbl;
        }
        Table newTbl = null;
        try {
            newTbl = this.srcCatalog_.getOrLoadTable(dbName, tblName, "test", null);
        }
        catch (CatalogException e) {
            throw new IllegalStateException("Unexpected table loading failure.", e);
        }
        Preconditions.checkNotNull((Object)newTbl);
        Preconditions.checkState((boolean)newTbl.isLoaded());
        db.addTable(newTbl);
        return newTbl;
    }

    public void prioritizeLoad(Set<TableName> tableNames, TUniqueId queryId) {
        for (TableName tbl : tableNames) {
            this.getOrLoadTable(tbl.getDb(), tbl.getTbl());
        }
    }

    public void waitForCatalogUpdate(long timeoutMs) {
    }

    public Role addRole(String roleName) {
        return this.srcCatalog_.addRole(roleName, new HashSet());
    }

    public Role addRoleGrantGroup(String roleName, String groupName) throws CatalogException {
        return this.srcCatalog_.addRoleGrantGroup(roleName, groupName);
    }

    public PrincipalPrivilege addRolePrivilege(String roleName, TPrivilege privilege) throws CatalogException {
        return this.srcCatalog_.addRolePrivilege(roleName, privilege);
    }

    public void removeRole(String roleName) {
        this.srcCatalog_.removeRole(roleName);
    }

    public User addUser(String userName) {
        return this.srcCatalog_.addUser(userName);
    }

    public PrincipalPrivilege addUserPrivilege(String userName, TPrivilege privilege) throws CatalogException {
        return this.srcCatalog_.addUserPrivilege(userName, privilege);
    }

    public void removeUser(String userName) {
        this.srcCatalog_.removeUser(userName);
    }

    public void close() {
        super.close();
        this.srcCatalog_.close();
    }
}

