/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.testutil;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.impala.testutil.ImpalaJdbcClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveJdbcClientPool
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ImpalaJdbcClient.class);
    private static AtomicInteger clientIdGenerator = new AtomicInteger(0);
    private static final String HIVE_SERVER2_DRIVER_NAME = "org.apache.hive.jdbc.HiveDriver";
    private final int poolSize_;
    private final BlockingQueue<HiveJdbcClient> freeClients_;
    private final long timeoutInSeconds_;
    private static final int DEFAULT_PORT_NUMBER = 11050;

    public HiveJdbcClient getClient() throws TimeoutException, InterruptedException {
        try {
            HiveJdbcClient client = this.freeClients_.poll(this.timeoutInSeconds_, TimeUnit.SECONDS);
            if (client == null) {
                throw new TimeoutException("Timed out while waiting to get a new client. Consider increasing the pool size");
            }
            return client;
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while waiting to a Hive JDBC client", (Throwable)e);
            throw e;
        }
    }

    private HiveJdbcClientPool(int poolsize, long timeoutInSeconds) throws ClassNotFoundException, SQLException {
        Preconditions.checkArgument((poolsize > 0 ? 1 : 0) != 0);
        this.poolSize_ = poolsize;
        this.timeoutInSeconds_ = timeoutInSeconds;
        this.freeClients_ = new LinkedBlockingQueue<HiveJdbcClient>(poolsize);
        LOG.info("Using JDBC Driver Name: org.apache.hive.jdbc.HiveDriver");
        Class.forName(HIVE_SERVER2_DRIVER_NAME);
        String connString = String.format("jdbc:hive2://localhost:%d/default", 11050, "default");
        LOG.info("Using connection string: " + connString);
        for (int i = 0; i < this.poolSize_; ++i) {
            this.freeClients_.add(new HiveJdbcClient(connString));
        }
    }

    public static synchronized HiveJdbcClientPool create(int poolSize) throws SQLException, ClassNotFoundException {
        return new HiveJdbcClientPool(poolSize, 300L);
    }

    @Override
    public void close() {
        for (int closedCount = this.poolSize_; closedCount > 0; --closedCount) {
            try {
                HiveJdbcClient client = this.freeClients_.poll(300L, TimeUnit.SECONDS);
                if (client == null) continue;
                if (client.stmt_ != null) {
                    client.stmt_.close();
                }
                if (client.conn_ == null) continue;
                client.conn_.close();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class HiveJdbcClient
    implements AutoCloseable {
        private final Connection conn_;
        private Statement stmt_;
        private final int clientId;

        private HiveJdbcClient(String connString) throws SQLException {
            this.conn_ = DriverManager.getConnection(connString);
            this.stmt_ = this.conn_.createStatement();
            this.clientId = clientIdGenerator.getAndIncrement();
        }

        public int getClientId() {
            return this.clientId;
        }

        @Override
        public void close() throws SQLException {
            if (this.stmt_ != null) {
                this.stmt_.close();
            }
            HiveJdbcClientPool.this.freeClients_.add(this);
        }

        private void validateConnection() throws SQLException {
            Preconditions.checkNotNull((Object)this.conn_, (Object)"Connection not initialized.");
            Preconditions.checkState((!this.conn_.isClosed() ? 1 : 0) != 0, (Object)"Connection is not open");
            Preconditions.checkNotNull((Object)this.stmt_);
            if (this.stmt_.isClosed()) {
                this.stmt_ = this.conn_.createStatement();
            }
        }

        public ResultSet execQuery(String query) throws SQLException {
            this.validateConnection();
            LOG.info("Executing: " + query);
            return this.stmt_.executeQuery(query);
        }

        public boolean executeSql(String sql) throws SQLException {
            this.validateConnection();
            LOG.info("Executing sql : " + sql);
            return this.stmt_.execute(sql);
        }
    }
}

