/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.testutil;

import java.io.File;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.log4j.Logger;

public class EmbeddedMetastoreClientPool
extends MetaStoreClientPool {
    private static final Logger LOG = Logger.getLogger(EmbeddedMetastoreClientPool.class);
    private static final String CONNECTION_URL_TEMPLATE = "jdbc:derby:;databaseName=%s;create=true";
    private Path derbyDataStorePath_;
    private static final String DEFAULT_PARTITION_EXPRESSION_PROXY_CLASS = "org.apache.hadoop.hive.metastore.DefaultPartitionExpressionProxy";
    private static final String METASTORE_TASK_THREAD_ALWAYS_KEY = "metastore.task.threads.always";
    private static final String DEFAULT_EVENT_CLEANER_TASK_CLASS = "org.apache.hadoop.hive.metastore.events.EventCleanerTask";

    public EmbeddedMetastoreClientPool(int initialCnxnTimeoutSec, Path dbStorePath) {
        super(1, initialCnxnTimeoutSec, EmbeddedMetastoreClientPool.generateEmbeddedHMSConf(dbStorePath));
        this.derbyDataStorePath_ = dbStorePath;
    }

    private static HiveConf generateEmbeddedHMSConf(Path dbStorePath) {
        LOG.info((Object)("Creating embedded HMS instance at path: " + dbStorePath));
        HiveConf conf = new HiveConf(EmbeddedMetastoreClientPool.class);
        conf.set(HiveConf.ConfVars.METASTOREURIS.varname, "");
        conf.set(HiveConf.ConfVars.METASTORE_CONNECTION_DRIVER.varname, "org.apache.derby.jdbc.EmbeddedDriver");
        conf.setBoolean(HiveConf.ConfVars.METASTORE_SCHEMA_VERIFICATION.varname, false);
        conf.setBoolean(HiveConf.ConfVars.METASTORE_AUTO_CREATE_ALL.varname, true);
        conf.set(HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, String.format(CONNECTION_URL_TEMPLATE, dbStorePath.toString()));
        conf.set(HiveConf.ConfVars.METASTORE_EXPRESSION_PROXY_CLASS.varname, DEFAULT_PARTITION_EXPRESSION_PROXY_CLASS);
        conf.set(METASTORE_TASK_THREAD_ALWAYS_KEY, DEFAULT_EVENT_CLEANER_TASK_CLASS);
        conf.set(HiveConf.ConfVars.METASTORE_TRANSACTIONAL_EVENT_LISTENERS.varname, "");
        return conf;
    }

    public void close() {
        super.close();
        FileUtils.deleteQuietly((File)this.derbyDataStorePath_.toFile());
    }
}

