/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service.catalogmanager;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.service.catalogmanager.ConfigLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ConfigLoaderTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private File tempDir;

    @Before
    public void setUp() throws Exception {
        this.tempDir = this.tempFolder.newFolder("config");
    }

    private File createConfigFile(String fileName, String content) throws IOException {
        File configFile = new File(this.tempDir, fileName);
        try (FileWriter writer = new FileWriter(configFile);){
            writer.write(content);
        }
        return configFile;
    }

    @Test
    public void testLoadValidConfigs() throws Exception {
        this.createConfigFile("valid1.properties", "connector.name=iceberg\niceberg.catalog.type=rest\n");
        this.createConfigFile("valid2.properties", "connector.name=iceberg\niceberg.catalog.type=rest\n");
        ConfigLoader loader = new ConfigLoader(this.tempDir);
        List configs = loader.loadConfigs();
        Assert.assertEquals((long)2L, (long)configs.size());
        Assert.assertEquals((Object)"iceberg", (Object)((Properties)configs.get(0)).getProperty("connector.name"));
        Assert.assertEquals((Object)"rest", (Object)((Properties)configs.get(0)).getProperty("iceberg.catalog.type"));
    }

    @Test
    public void testMissingConnectorNameThrows() throws IOException {
        this.createConfigFile("bad.properties", "iceberg.catalog.type=rest\n");
        ConfigLoader loader = new ConfigLoader(this.tempDir);
        try {
            loader.loadConfigs();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("connector.name"));
        }
        catch (ImpalaRuntimeException e) {
            Assert.fail((String)"Expected IllegalStateException");
        }
    }

    @Test
    public void testIncorrectCatalogTypeThrows() throws IOException {
        this.createConfigFile("bad.properties", "connector.name=iceberg\niceberg.catalog.type=hive\n");
        ConfigLoader loader = new ConfigLoader(this.tempDir);
        try {
            loader.loadConfigs();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Expected value of 'iceberg.catalog.type'"));
        }
        catch (ImpalaRuntimeException e) {
            Assert.fail((String)"Expected IllegalStateException");
        }
    }

    @Test
    public void testUnreadableFileThrows() throws IOException {
        File unreadableFile = this.createConfigFile("unreadable.properties", "connector.name=iceberg\niceberg.catalog.type=rest\n");
        Assert.assertTrue((boolean)unreadableFile.setReadable(false));
        ConfigLoader loader = new ConfigLoader(this.tempDir);
        try {
            loader.loadConfigs();
            Assert.fail((String)"Expected ImpalaRuntimeException");
        }
        catch (ImpalaRuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unable to read file"));
        }
    }

    @Test
    public void testEmptyDirectoryReturnsEmptyList() throws Exception {
        ConfigLoader loader = new ConfigLoader(this.tempDir);
        List configs = loader.loadConfigs();
        Assert.assertTrue((boolean)configs.isEmpty());
    }
}

