/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.security.JniBasedUnixGroupsMappingWithFallback;
import org.apache.hadoop.security.JniBasedUnixGroupsNetgroupMappingWithFallback;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.ShellBasedUnixGroupsNetgroupMapping;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.JniFrontend;
import org.apache.impala.thrift.TBackendGflags;
import org.apache.impala.thrift.TStringLiteral;
import org.apache.thrift.TBase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class JniFrontendTest {
    private static TBackendGflags origFlags;

    @BeforeClass
    public static void setup() {
        if (BackendConfig.INSTANCE == null) {
            BackendConfig.create((TBackendGflags)new TBackendGflags());
        }
        origFlags = BackendConfig.INSTANCE.getBackendCfg();
    }

    @AfterClass
    public static void teardown() {
        BackendConfig.create((TBackendGflags)origFlags);
    }

    @Test
    public void testCheckGroupsMappingProvider() throws ImpalaException {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping", JniBasedUnixGroupsMappingWithFallback.class.getName());
        Assert.assertTrue((boolean)JniFrontend.checkGroupsMappingProvider((Configuration)conf).isEmpty());
        conf = new Configuration();
        conf.set("hadoop.security.group.mapping", ShellBasedUnixGroupsMapping.class.getName());
        Assert.assertEquals((Object)JniFrontend.checkGroupsMappingProvider((Configuration)conf), (Object)String.format("Hadoop groups mapping provider: %s is known to be problematic. Consider using: %s instead.", ShellBasedUnixGroupsMapping.class.getName(), JniBasedUnixGroupsMappingWithFallback.class.getName()));
        conf = new Configuration();
        conf.set("hadoop.security.group.mapping", ShellBasedUnixGroupsNetgroupMapping.class.getName());
        Assert.assertEquals((Object)JniFrontend.checkGroupsMappingProvider((Configuration)conf), (Object)String.format("Hadoop groups mapping provider: %s is known to be problematic. Consider using: %s instead.", ShellBasedUnixGroupsNetgroupMapping.class.getName(), JniBasedUnixGroupsNetgroupMappingWithFallback.class.getName()));
    }

    @Test
    public void testCheckShortCircuitConfigs() {
        String tmpDir = System.getProperty("java.io.tmpdir", "/tmp");
        File socketDir = new File(tmpDir + "/socketTest", "socks." + System.currentTimeMillis() + "." + new Random().nextInt());
        socketDir.mkdirs();
        socketDir.getParentFile().setExecutable(false);
        Configuration conf = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)conf.getBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, false)).thenReturn((Object)true);
        Mockito.when((Object)conf.getTrimmed("dfs.domain.socket.path", "")).thenReturn((Object)socketDir.getAbsolutePath());
        Mockito.when((Object)conf.getBoolean("dfs.client.use.legacy.blockreader.local", false)).thenReturn((Object)false);
        BackendConfig.INSTANCE = (BackendConfig)Mockito.mock(BackendConfig.class);
        Mockito.when((Object)BackendConfig.INSTANCE.isDedicatedCoordinator()).thenReturn((Object)true);
        String actualErrorMessage = JniFrontend.checkShortCircuitRead((Configuration)conf);
        Assert.assertEquals((Object)"", (Object)actualErrorMessage);
        Mockito.when((Object)BackendConfig.INSTANCE.isDedicatedCoordinator()).thenReturn((Object)false);
        actualErrorMessage = JniFrontend.checkShortCircuitRead((Configuration)conf);
        Assert.assertEquals((Object)"Invalid short-circuit reads configuration:\n  - Impala cannot read or execute the parent directory of dfs.domain.socket.path\n", (Object)actualErrorMessage);
        if (socketDir != null) {
            socketDir.getParentFile().setExecutable(true);
            socketDir.delete();
            socketDir.getParentFile().delete();
        }
    }

    @Test
    public void testGetSecretFromKeyStore() throws ImpalaException {
        String keyName = "openai-api-key-secret";
        TStringLiteral secretKey = new TStringLiteral(StandardCharsets.UTF_8.encode(keyName));
        byte[] secretKeyBytes = JniUtil.serializeToThrift((TBase)secretKey);
        String secret = JniFrontend.getSecretFromKeyStore((byte[])secretKeyBytes);
        Assert.assertEquals((Object)secret, (Object)"secret");
        keyName = "dummy-secret";
        secretKey = new TStringLiteral(StandardCharsets.UTF_8.encode(keyName));
        secretKeyBytes = JniUtil.serializeToThrift((TBase)secretKey);
        try {
            secret = JniFrontend.getSecretFromKeyStore((byte[])secretKeyBytes);
        }
        catch (InternalException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)String.format("Failed to get password from keystore, error: invalid key '%s' or password doesn't exist", keyName));
        }
    }
}

