/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hive.service.rpc.thrift.TGetCatalogsReq;
import org.apache.hive.service.rpc.thrift.TGetColumnsReq;
import org.apache.hive.service.rpc.thrift.TGetFunctionsReq;
import org.apache.hive.service.rpc.thrift.TGetInfoReq;
import org.apache.hive.service.rpc.thrift.TGetSchemasReq;
import org.apache.hive.service.rpc.thrift.TGetTablesReq;
import org.apache.impala.analysis.Parser;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FrontendTestBase;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.service.Frontend;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.thrift.TMetadataOpRequest;
import org.apache.impala.thrift.TMetadataOpcode;
import org.apache.impala.thrift.TResultRow;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TWaitForHmsEventRequest;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class FrontendTest
extends FrontendTestBase {
    @Test
    public void TestGetTypeInfo() throws ImpalaException {
        TMetadataOpRequest getInfoReq = new TMetadataOpRequest();
        getInfoReq.opcode = TMetadataOpcode.GET_TYPE_INFO;
        getInfoReq.get_info_req = new TGetInfoReq();
        TResultSet resp = this.execMetadataOp(getInfoReq);
        Assert.assertEquals((long)18L, (long)resp.schema.columns.size());
        Assert.assertEquals((long)18L, (long)((TResultRow)resp.rows.get((int)0)).colVals.size());
        ArrayList<String> supportedTypes = new ArrayList<String>();
        for (ScalarType stype : Type.getSupportedTypes()) {
            if (!stype.isSupported() || stype.isInternalType()) continue;
            supportedTypes.add(stype.getPrimitiveType().name());
        }
        supportedTypes.add("ARRAY");
        supportedTypes.add("MAP");
        supportedTypes.add("STRUCT");
        Assert.assertEquals((long)supportedTypes.size(), (long)resp.rows.size());
        for (TResultRow row : resp.rows) {
            boolean foundType = false;
            String typeName = ((TColumnValue)row.colVals.get(0)).getString_val();
            if (supportedTypes.contains(typeName)) {
                supportedTypes.remove(typeName);
                foundType = true;
            }
            Assert.assertTrue((boolean)foundType);
        }
        Assert.assertEquals((long)supportedTypes.size(), (long)0L);
    }

    @Test
    public void TestGetSchema() throws ImpalaException {
        TMetadataOpRequest req = new TMetadataOpRequest();
        req.opcode = TMetadataOpcode.GET_SCHEMAS;
        req.get_schemas_req = new TGetSchemasReq();
        req.get_schemas_req.setSchemaName("default%");
        TResultSet resp = this.execMetadataOp(req);
        Assert.assertEquals((long)2L, (long)resp.schema.columns.size());
        Assert.assertEquals((long)2L, (long)((TResultRow)resp.rows.get((int)0)).colVals.size());
        Assert.assertEquals((long)1L, (long)resp.rows.size());
        Assert.assertEquals((Object)"default", (Object)((TColumnValue)((TResultRow)resp.rows.get((int)0)).colVals.get((int)0)).string_val.toLowerCase());
    }

    @Test
    public void TestGetTables() throws ImpalaException {
        TMetadataOpRequest req = new TMetadataOpRequest();
        req.opcode = TMetadataOpcode.GET_TABLES;
        req.get_tables_req = new TGetTablesReq();
        req.get_tables_req.setSchemaName("functional");
        req.get_tables_req.setTableName("all_ypes");
        TResultSet resp = this.execMetadataOp(req);
        Assert.assertEquals((long)5L, (long)resp.schema.columns.size());
        Assert.assertEquals((long)5L, (long)((TResultRow)resp.rows.get((int)0)).colVals.size());
        Assert.assertEquals((long)1L, (long)resp.rows.size());
        Assert.assertEquals((Object)"alltypes", (Object)((TColumnValue)((TResultRow)resp.rows.get((int)0)).colVals.get((int)2)).string_val.toLowerCase());
    }

    @Test
    public void TestGetTablesTypeTable() throws ImpalaException {
        this.AnalyzesOk("select * from functional.alltypes_hive_view");
        this.AnalyzesOk("select * from functional.alltypes_parens");
        this.AnalyzesOk("select * from functional.alltypes_view");
        this.AnalyzesOk("select * from functional.alltypes_view_sub");
        this.AnalyzesOk("select * from functional.alltypes_dp_2_view_1");
        this.AnalyzesOk("select * from functional.alltypes_dp_2_view_2");
        TMetadataOpRequest req = new TMetadataOpRequest();
        req.opcode = TMetadataOpcode.GET_TABLES;
        req.get_tables_req = new TGetTablesReq();
        req.get_tables_req.setSchemaName("functional");
        req.get_tables_req.setTableName("alltypes\\_%");
        req.get_tables_req.setTableTypes(Arrays.asList("TABLE"));
        TResultSet resp = this.execMetadataOp(req);
        Assert.assertEquals((long)5L, (long)resp.schema.columns.size());
        Assert.assertEquals((long)5L, (long)((TResultRow)resp.rows.get((int)0)).colVals.size());
        Assert.assertEquals((long)6L, (long)resp.rows.size());
        Assert.assertEquals((Object)"alltypes_datasource", (Object)((TColumnValue)((TResultRow)resp.rows.get((int)0)).colVals.get((int)2)).string_val.toLowerCase());
        Assert.assertEquals((Object)"alltypes_date_partition", (Object)((TColumnValue)((TResultRow)resp.rows.get((int)1)).colVals.get((int)2)).string_val.toLowerCase());
        Assert.assertEquals((Object)"alltypes_date_partition_2", (Object)((TColumnValue)((TResultRow)resp.rows.get((int)2)).colVals.get((int)2)).string_val.toLowerCase());
        Assert.assertEquals((Object)"alltypes_jdbc_datasource", (Object)((TColumnValue)((TResultRow)resp.rows.get((int)3)).colVals.get((int)2)).string_val.toLowerCase());
        Assert.assertEquals((Object)"alltypes_jdbc_datasource_2", (Object)((TColumnValue)((TResultRow)resp.rows.get((int)4)).colVals.get((int)2)).string_val.toLowerCase());
        Assert.assertEquals((Object)"alltypes_with_date", (Object)((TColumnValue)((TResultRow)resp.rows.get((int)5)).colVals.get((int)2)).string_val.toLowerCase());
    }

    @Test
    public void TestGetTablesTypeView() throws ImpalaException {
        this.AnalyzesOk("select * from functional.alltypes_hive_view");
        this.AnalyzesOk("select * from functional.alltypes_parens");
        this.AnalyzesOk("select * from functional.alltypes_view");
        this.AnalyzesOk("select * from functional.alltypes_view_sub");
        this.AnalyzesOk("select * from functional.alltypes_dp_2_view_1");
        this.AnalyzesOk("select * from functional.alltypes_dp_2_view_2");
        TMetadataOpRequest req = new TMetadataOpRequest();
        req.opcode = TMetadataOpcode.GET_TABLES;
        req.get_tables_req = new TGetTablesReq();
        req.get_tables_req.setSchemaName("functional");
        req.get_tables_req.setTableName("alltypes%");
        req.get_tables_req.setTableTypes(Arrays.asList("VIEW"));
        TResultSet resp = this.execMetadataOp(req);
        Assert.assertEquals((long)5L, (long)resp.schema.columns.size());
        Assert.assertEquals((long)5L, (long)((TResultRow)resp.rows.get((int)0)).colVals.size());
        Assert.assertEquals((long)6L, (long)resp.rows.size());
        Assert.assertEquals((Object)"alltypes_dp_2_view_1", (Object)((TColumnValue)((TResultRow)resp.rows.get((int)0)).colVals.get((int)2)).string_val.toLowerCase());
        Assert.assertEquals((Object)"alltypes_dp_2_view_2", (Object)((TColumnValue)((TResultRow)resp.rows.get((int)1)).colVals.get((int)2)).string_val.toLowerCase());
        Assert.assertEquals((Object)"alltypes_hive_view", (Object)((TColumnValue)((TResultRow)resp.rows.get((int)2)).colVals.get((int)2)).string_val.toLowerCase());
        Assert.assertEquals((Object)"alltypes_parens", (Object)((TColumnValue)((TResultRow)resp.rows.get((int)3)).colVals.get((int)2)).string_val.toLowerCase());
        Assert.assertEquals((Object)"alltypes_view", (Object)((TColumnValue)((TResultRow)resp.rows.get((int)4)).colVals.get((int)2)).string_val.toLowerCase());
        Assert.assertEquals((Object)"alltypes_view_sub", (Object)((TColumnValue)((TResultRow)resp.rows.get((int)5)).colVals.get((int)2)).string_val.toLowerCase());
    }

    @Test
    public void TestGetTablesWithComments() throws ImpalaException {
        String dbName = "tbls_with_comments_test_db";
        Db testDb = this.addTestDb("tbls_with_comments_test_db", "Stores tables with comments");
        Assert.assertNotNull((Object)testDb);
        String tableComment = "this table has a comment";
        String columnComment = "this column has a comment";
        String columnWithCommentName = "column_with_comment";
        String columnWithoutCommentName = "column_without_comment";
        String tableWithCommentsStmt = String.format("create table %s.tbl_with_comments (%s int comment '%s', %s int) comment '%s'", "tbls_with_comments_test_db", "column_with_comment", "this column has a comment", "column_without_comment", "this table has a comment");
        Table tbl = this.addTestTable(tableWithCommentsStmt);
        Assert.assertNotNull((Object)tbl);
        String tableWithoutCommentsStmt = String.format("create table %s.tbl_without_comments (a int)", "tbls_with_comments_test_db");
        tbl = this.addTestTable(tableWithoutCommentsStmt);
        Assert.assertNotNull((Object)tbl);
        TMetadataOpRequest req = new TMetadataOpRequest();
        req.opcode = TMetadataOpcode.GET_TABLES;
        req.get_tables_req = new TGetTablesReq();
        req.get_tables_req.setSchemaName("tbls_with_comments_test_db");
        TResultSet resp = this.execMetadataOp(req);
        Assert.assertEquals((long)2L, (long)resp.rows.size());
        for (TResultRow row : resp.rows) {
            if (((TColumnValue)row.colVals.get((int)2)).string_val.toLowerCase().equals("tbl_with_comments")) {
                Assert.assertEquals((Object)"this table has a comment", (Object)((TColumnValue)row.colVals.get((int)4)).string_val.toLowerCase());
                continue;
            }
            Assert.assertEquals((Object)"", (Object)((TColumnValue)row.colVals.get((int)4)).string_val);
        }
        req = new TMetadataOpRequest();
        req.opcode = TMetadataOpcode.GET_COLUMNS;
        req.get_columns_req = new TGetColumnsReq();
        req.get_columns_req.setSchemaName("tbls_with_comments_test_db");
        req.get_columns_req.setTableName("tbl_with_comments");
        resp = this.execMetadataOp(req);
        Assert.assertEquals((long)2L, (long)resp.rows.size());
        for (TResultRow row : resp.rows) {
            if (((TColumnValue)row.colVals.get((int)3)).string_val.equals("column_with_comment")) {
                Assert.assertEquals((Object)"this column has a comment", (Object)((TColumnValue)row.colVals.get((int)11)).string_val);
                continue;
            }
            Assert.assertEquals(null, (Object)((TColumnValue)row.colVals.get((int)11)).string_val);
        }
    }

    @Test
    public void TestGetTablesWithCommentsOnHive2() throws ImpalaException {
        Assume.assumeTrue((String)"Skipping this test since it is only supported when running against Hive-2", (TestUtils.getHiveMajorVersion() == 2 ? 1 : 0) != 0);
        TMetadataOpRequest req = new TMetadataOpRequest();
        req = new TMetadataOpRequest();
        req.opcode = TMetadataOpcode.GET_TABLES;
        req.get_tables_req = new TGetTablesReq();
        req.get_tables_req.setSchemaName("functional");
        req.get_tables_req.setTableName("hive_index_tbl");
        TResultSet resp = this.execMetadataOp(req);
        Assert.assertEquals((long)1L, (long)resp.rows.size());
    }

    @Test
    public void TestUnloadedView() throws ImpalaException {
        String dbName = "tbls_for_views_test_db";
        Db testDb = this.addTestDb("tbls_for_views_test_db", "Stores views");
        Assert.assertNotNull((Object)testDb);
        Table view = this.addTestView(String.format("create view %s.test_view as select * from functional.alltypes", "tbls_for_views_test_db"));
        Assert.assertNotNull((Object)view);
        TMetadataOpRequest req = new TMetadataOpRequest();
        req.opcode = TMetadataOpcode.GET_TABLES;
        req.get_tables_req = new TGetTablesReq();
        req.get_tables_req.setSchemaName("tbls_for_views_test_db");
        TResultSet resp = this.execMetadataOp(req);
        Assert.assertEquals((long)1L, (long)resp.rows.size());
        for (TResultRow row : resp.rows) {
            Assert.assertEquals((Object)((TColumnValue)row.colVals.get((int)2)).string_val.toLowerCase(), (Object)"test_view");
            Assert.assertEquals((Object)"table", (Object)((TColumnValue)row.colVals.get((int)3)).string_val.toLowerCase());
        }
    }

    @Test
    public void TestLoadedView() throws ImpalaException {
        this.AnalyzesOk("select * from functional.alltypes_view");
        TMetadataOpRequest req = new TMetadataOpRequest();
        req.opcode = TMetadataOpcode.GET_TABLES;
        req.get_tables_req = new TGetTablesReq();
        req.get_tables_req.setSchemaName("functional");
        req.get_tables_req.setTableName("alltypes_view");
        TResultSet resp = this.execMetadataOp(req);
        Assert.assertEquals((long)1L, (long)resp.rows.size());
        for (TResultRow row : resp.rows) {
            Assert.assertEquals((Object)"VIEW", (Object)((TColumnValue)row.colVals.get((int)3)).string_val);
        }
    }

    @Test
    public void TestGetColumns() throws ImpalaException {
        TMetadataOpRequest req = new TMetadataOpRequest();
        req.opcode = TMetadataOpcode.GET_COLUMNS;
        req.get_columns_req = new TGetColumnsReq();
        req.get_columns_req.setSchemaName("functional");
        req.get_columns_req.setTableName("alltypes");
        req.get_columns_req.setColumnName("stri%");
        TResultSet resp = this.execMetadataOp(req);
        Assert.assertEquals((long)23L, (long)resp.schema.columns.size());
        Assert.assertEquals((long)23L, (long)((TResultRow)resp.rows.get((int)0)).colVals.size());
        Assert.assertEquals((long)1L, (long)resp.rows.size());
        TResultRow row = (TResultRow)resp.rows.get(0);
        Assert.assertEquals((Object)"functional", (Object)((TColumnValue)row.colVals.get((int)1)).string_val.toLowerCase());
        Assert.assertEquals((Object)"alltypes", (Object)((TColumnValue)row.colVals.get((int)2)).string_val.toLowerCase());
        Assert.assertEquals((Object)"string_col", (Object)((TColumnValue)row.colVals.get((int)3)).string_val.toLowerCase());
    }

    @Test
    public void TestGetCatalogs() throws ImpalaException {
        TMetadataOpRequest req = new TMetadataOpRequest();
        req.opcode = TMetadataOpcode.GET_CATALOGS;
        req.get_catalogs_req = new TGetCatalogsReq();
        TResultSet resp = this.execMetadataOp(req);
        Assert.assertEquals((long)1L, (long)resp.schema.columns.size());
        Assert.assertEquals((long)0L, (long)resp.rows.size());
    }

    @Test
    public void TestGetTableTypes() throws ImpalaException {
        TMetadataOpRequest req = new TMetadataOpRequest();
        req.opcode = TMetadataOpcode.GET_TABLE_TYPES;
        TResultSet resp = this.execMetadataOp(req);
        Assert.assertEquals((long)2L, (long)resp.rows.size());
        Assert.assertEquals((long)1L, (long)resp.schema.columns.size());
        Assert.assertEquals((long)1L, (long)((TResultRow)resp.rows.get((int)0)).colVals.size());
        Assert.assertEquals((Object)"TABLE", (Object)((TColumnValue)((TResultRow)resp.rows.get((int)0)).getColVals().get((int)0)).string_val);
        Assert.assertEquals((Object)"VIEW", (Object)((TColumnValue)((TResultRow)resp.rows.get((int)1)).getColVals().get((int)0)).string_val);
    }

    @Test
    public void TestGetFunctions() throws ImpalaException {
        TMetadataOpRequest req = new TMetadataOpRequest();
        req.opcode = TMetadataOpcode.GET_FUNCTIONS;
        req.get_functions_req = new TGetFunctionsReq();
        req.get_functions_req.setFunctionName("sub%");
        TResultSet resp = this.execMetadataOp(req);
        Assert.assertEquals((long)6L, (long)resp.schema.columns.size());
        Assert.assertEquals((long)6L, (long)((TResultRow)resp.rows.get((int)0)).colVals.size());
        HashSet fns = Sets.newHashSet();
        for (TResultRow row : resp.rows) {
            String fn = ((TColumnValue)row.colVals.get((int)2)).string_val.toLowerCase();
            fns.add(fn);
        }
        Assert.assertEquals((long)3L, (long)fns.size());
        ArrayList expectedResult = Lists.newArrayList();
        expectedResult.add("subdate");
        expectedResult.add("substr");
        expectedResult.add("substring");
        for (String fn : fns) {
            Assert.assertTrue((String)(fn + " not found"), (boolean)expectedResult.remove(fn));
        }
    }

    private TResultSet execMetadataOp(TMetadataOpRequest req) throws ImpalaException {
        return frontend_.execHiveServer2MetadataOp(req);
    }

    @Test
    public void TestCollectRequiredObjectsForHmsEventSync() throws AnalysisException {
        String db = "session_db";
        this.TestCollectRequiredObjectsHelper("SELECT * FROM db1.tbl1, tbl2, db3.tbl3, tbl4", db, Arrays.asList("db1", "db3", db), Arrays.asList("db1.tbl1", db + ".db1", db + ".tbl2", "db3.tbl3", db + ".db3", db + ".tbl4"));
        this.TestCollectRequiredObjectsHelper("SELECT * FROM tbl1 t where exists (SELECT 1 FROM db1.tbl2 t2 where t2.id=t.id)", db, Arrays.asList("db1", db), Arrays.asList(db + ".tbl1", "db1.tbl2", db + ".db1"));
        this.TestCollectRequiredObjectsHelper("INVALIDATE METADATA", db, Collections.emptyList(), Collections.emptyList());
        this.TestCollectRequiredObjectsHelper("REFRESH AUTHORIZATION", db, Collections.emptyList(), Collections.emptyList());
        this.TestCollectRequiredObjectsHelper("REFRESH FUNCTIONS mydb", db, Arrays.asList("mydb"), Collections.emptyList());
        this.TestCollectRequiredObjectsHelper("INVALIDATE METADATA mydb.foo", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("INVALIDATE METADATA foo", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("REFRESH mydb.foo", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("REFRESH foo", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("REFRESH mydb.foo PARTITION (p=1)", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("REFRESH mydb.foo PARTITION (p=1) PARTITION (p=2)", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("REFRESH foo PARTITION (p=1)", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("CREATE TABLE mydb.foo(i int)", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("CREATE TABLE foo(i int)", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("CREATE TABLE foo LIKE bar", db, Arrays.asList(db), Arrays.asList(db + ".foo", db + ".bar"));
        this.TestCollectRequiredObjectsHelper("CREATE TABLE foo AS SELECT * FROM db1.tbl1", db, Arrays.asList(db, "db1"), Arrays.asList(db + ".foo", db + ".db1", "db1.tbl1"));
        this.TestCollectRequiredObjectsHelper("ALTER TABLE foo DROP PARTITION(p=1)", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("ALTER TABLE mydb.foo ADD PARTITION(p=1)", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("ALTER TABLE foo CONVERT TO ICEBERG", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("ALTER TABLE mydb.foo CONVERT TO ICEBERG", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("DROP TABLE mydb.foo", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("DROP TABLE foo", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("SHOW PARTITIONS mydb.foo", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("SHOW FILES IN mydb.foo", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("SHOW TABLE STATS mydb.foo", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("SHOW COLUMN STATS mydb.foo", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("INSERT INTO foo SELECT * FROM bar, baz", db, Arrays.asList(db), Arrays.asList(db + ".foo", db + ".bar", db + ".baz"));
        this.TestCollectRequiredObjectsHelper("LOAD DATA INPATH 'path' INTO TABLE foo", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("LOAD DATA INPATH 'path' INTO TABLE mydb.foo", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("LOAD DATA INPATH 'path' INTO TABLE foo PARTITION(p=1)", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("LOAD DATA INPATH 'path' INTO TABLE mydb.foo PARTITION(p=1)", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("COMPUTE STATS foo", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("COMPUTE STATS mydb.foo", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("COMPUTE INCREMENTAL STATS foo", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("COMPUTE INCREMENTAL STATS mydb.foo", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("COMPUTE INCREMENTAL STATS foo PARTITION(p=1)", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("COMPUTE INCREMENTAL STATS mydb.foo PARTITION(p=1)", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("DROP STATS foo", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("DROP STATS mydb.foo", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("DROP INCREMENTAL STATS foo PARTITION(p=1)", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("DROP INCREMENTAL STATS mydb.foo PARTITION(p=1)", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("DESCRIBE foo", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("DESCRIBE mydb.tbl", db, Arrays.asList(db, "mydb"), Arrays.asList("mydb.tbl", db + ".mydb"));
        this.TestCollectRequiredObjectsHelper("DESCRIBE mydb.tbl.complex_col", db, Arrays.asList(db, "mydb"), Arrays.asList("mydb.tbl", db + ".mydb"));
        this.TestCollectRequiredObjectsHelper("DESCRIBE mydb.tbl.complex_col.nested_col", db, Arrays.asList(db, "mydb"), Arrays.asList("mydb.tbl", db + ".mydb"));
        this.TestCollectRequiredObjectsHelper("DESCRIBE HISTORY foo", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("DESCRIBE HISTORY mydb.tbl", db, Arrays.asList("mydb"), Arrays.asList("mydb.tbl"));
        this.TestCollectRequiredObjectsHelper("TRUNCATE TABLE foo", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("TRUNCATE TABLE mydb.foo", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("COMMENT ON TABLE foo IS 'comment'", db, Arrays.asList(db), Arrays.asList(db + ".foo"));
        this.TestCollectRequiredObjectsHelper("COMMENT ON TABLE mydb.foo IS 'comment'", db, Arrays.asList("mydb"), Arrays.asList("mydb.foo"));
        this.TestCollectRequiredObjectsHelper("COMMENT ON DATABASE mydb IS 'comment'", db, Arrays.asList("mydb"), Collections.emptyList());
        this.TestCollectRequiredObjectsHelper("CREATE DATABASE mydb", db, Arrays.asList("mydb"), Collections.emptyList());
        this.TestCollectRequiredObjectsHelper("ALTER DATABASE mydb SET OWNER USER user1", db, Arrays.asList("mydb"), Collections.emptyList());
        this.TestCollectRequiredObjectsHelper("DROP DATABASE mydb", db, Arrays.asList("mydb"), Collections.emptyList());
        this.TestCollectRequiredObjectsHelper("SHOW FUNCTIONS", db, Arrays.asList(db), Collections.emptyList());
        this.TestCollectRequiredObjectsHelper("SHOW FUNCTIONS IN mydb", db, Arrays.asList("mydb"), Collections.emptyList());
        this.TestCollectRequiredObjectsHelper("SHOW TABLES", db, Arrays.asList(db), Collections.emptyList());
        this.TestCollectRequiredObjectsHelper("SHOW TABLES IN mydb", db, Arrays.asList("mydb"), Collections.emptyList());
    }

    public void TestCollectRequiredObjectsHelper(String query, String sessionDb, List<String> expectedDbNames, List<String> expectedTableNames) throws AnalysisException {
        StatementBase stmt = Parser.parse((String)query);
        TWaitForHmsEventRequest req = new TWaitForHmsEventRequest();
        Frontend.collectRequiredObjects((TWaitForHmsEventRequest)req, (StatementBase)stmt, (String)sessionDb);
        if (expectedDbNames.isEmpty() && expectedTableNames.isEmpty()) {
            Assert.assertNull((Object)req.object_descs);
            return;
        }
        ArrayList<String> dbNames = new ArrayList<String>();
        ArrayList<String> tableNames = new ArrayList<String>();
        for (TCatalogObject obj : req.getObject_descs()) {
            if (obj.getType() == TCatalogObjectType.DATABASE) {
                dbNames.add(obj.getDb().getDb_name());
                continue;
            }
            Assert.assertEquals((Object)TCatalogObjectType.TABLE, (Object)obj.getType());
            tableNames.add(obj.getTable().getDb_name() + "." + obj.getTable().getTbl_name());
        }
        Collections.sort(dbNames);
        Collections.sort(tableNames);
        Collections.sort(expectedDbNames);
        Collections.sort(expectedTableNames);
        Assert.assertEquals(expectedDbNames, dbNames);
        Assert.assertEquals(expectedTableNames, tableNames);
    }
}

