/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.AggregationNode;
import org.apache.impala.planner.HdfsScanNode;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlannerTestBase;
import org.apache.impala.planner.TupleCacheInfo;
import org.apache.impala.planner.TupleCacheNode;
import org.apache.impala.service.Frontend;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;
import org.junit.Assert;
import org.junit.Test;

public class TupleCacheTest
extends PlannerTestBase {
    @Test
    public void testBasicCacheKeys() {
        this.verifyIdenticalCacheKeys("select id from functional.alltypes", "select id from functional.alltypes");
        this.verifyDifferentCacheKeys("select id from functional.alltypes", "select id from functional.alltypestiny");
        this.verifyDifferentCacheKeys("select id from functional.alltypes", "select id from functional_parquet.alltypes");
        this.verifyDifferentCacheKeys("select id from functional.alltypes", "select int_col from functional.alltypes");
        this.verifyDifferentCacheKeys("select id from functional.alltypes", "select id from functional.alltypes where id = 1");
        this.verifyDifferentCacheKeys("select id from functional.alltypes where id = 1", "select id from functional.alltypes where id = 2");
        this.verifyIdenticalCacheKeys("select nested_struct from functional_parquet.complextypestbl", "select nested_struct from functional_parquet.complextypestbl");
    }

    @Test
    public void testRuntimeFilterCacheKeys() {
        for (boolean isDistributedPlan : Arrays.asList(false, true)) {
            String basicJoinTmpl = "select straight_join probe.id from functional.alltypes probe, functional.alltypestiny build where %s";
            this.verifyIdenticalCacheKeys(String.format(basicJoinTmpl, "probe.id = build.id"), String.format(basicJoinTmpl, "probe.id = build.id"), isDistributedPlan);
            this.verifyIdenticalCacheKeys(String.format(basicJoinTmpl, "probe.id = build.id"), String.format(basicJoinTmpl, "build.id = probe.id"), isDistributedPlan);
            this.verifyOverlappingCacheKeys(String.format(basicJoinTmpl, "probe.id = build.id"), "select straight_join p.id from functional.alltypes p, (" + String.format(basicJoinTmpl, "probe.id = build.id") + ") b where p.id = b.id", isDistributedPlan);
            this.verifyOverlappingCacheKeys(String.format(basicJoinTmpl, "probe.id = build.id"), String.format(basicJoinTmpl, "probe.id + 1 = build.id"), isDistributedPlan);
            this.verifyOverlappingCacheKeys(String.format(basicJoinTmpl, "probe.id + 1 = build.id"), String.format(basicJoinTmpl, "probe.id + 2 = build.id"), isDistributedPlan);
            this.verifyOverlappingCacheKeys(String.format(basicJoinTmpl, "probe.id = build.id"), "select straight_join a.id from functional.alltypes a, functional.alltypes b, functional.alltypestiny c where a.id = b.id and b.id = c.id", isDistributedPlan);
            this.verifyDifferentCacheKeys(String.format(basicJoinTmpl, "probe.id = build.id"), "select straight_join a.id from functional.alltypes a, functional.alltypes b where a.id = b.id", isDistributedPlan);
            this.verifyDifferentCacheKeys(String.format(basicJoinTmpl, "probe.id = build.id"), String.format(basicJoinTmpl, "probe.id = build.id and build.id < 100"), isDistributedPlan);
            List<PlanNode> cacheEligibleNodes = this.getCacheEligibleNodes(String.format(basicJoinTmpl, "probe.id = build.id"));
            for (PlanNode node : cacheEligibleNodes) {
                if (!(node instanceof JoinNode)) continue;
                List hashTraces = node.getTupleCacheInfo().getHashTraces();
                for (TupleCacheInfo.HashTraceElement hashTrace : hashTraces) {
                    Assert.assertTrue((hashTrace.getComment().indexOf("runtime filter") == -1 ? 1 : 0) != 0);
                    Assert.assertTrue((hashTrace.getComment().indexOf("RF0") == -1 ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testAggregateCacheKeys() {
        String basicAgg = "select count(*), count(tinyint_col), min(tinyint_col), max(tinyint_col), sum(tinyint_col), avg(tinyint_col) from functional.alltypesagg";
        this.verifyNIdenticalCacheKeys(basicAgg, basicAgg, 2);
        String groupingAgg = "select tinyint_col, bigint_col, count(*), min(tinyint_col), max(tinyint_col), sum(tinyint_col), avg(tinyint_col) from functional.alltypesagg group by 2, 1";
        this.verifyNIdenticalCacheKeys(groupingAgg, groupingAgg, 2);
        String distinctAgg = "select avg(l_quantity), ndv(l_discount), count(distinct l_partkey) from tpch_parquet.lineitem";
        this.verifyNIdenticalCacheKeys(distinctAgg, distinctAgg, 2);
        String groupDistinctAgg = "select group_concat(distinct string_col) from functional.alltypesagg";
        this.verifyNIdenticalCacheKeys(groupDistinctAgg, groupDistinctAgg, 2);
        String havingAgg = "select 1 from functional.alltypestiny having count(*) > 0";
        this.verifyNIdenticalCacheKeys(havingAgg, havingAgg, 2);
        String twoPhaseAgg = "select bigint_col bc, count(smallint_col) c1, count(distinct int_col) c2 from functional.alltypessmall group by bigint_col order by bc";
        this.verifyNIdenticalCacheKeys(twoPhaseAgg, twoPhaseAgg, 2);
        String rightJoinAgg = "with v1 as (select c_nationkey, c_custkey, count(*) from tpch.customer group by c_nationkey, c_custkey), v2 as (select c_nationkey, c_custkey, count(*) from v1, tpch.orders where c_custkey = o_custkey group by c_nationkey, c_custkey) select c_nationkey, count(*) from v2 group by c_nationkey";
        this.verifyNIdenticalCacheKeys(rightJoinAgg, rightJoinAgg, 2, true);
        this.verifyAllEligible(rightJoinAgg, false);
        String innerJoinAgg = "select count(*) from functional.alltypes t1 inner join functional.alltypestiny t2 on t1.smallint_col = t2.smallint_col group by t1.tinyint_col, t2.smallint_col having count(t2.int_col) = count(t1.bigint_col)";
        this.verifyNIdenticalCacheKeys(innerJoinAgg, innerJoinAgg, 2, true);
        this.verifyAllEligible(innerJoinAgg, false);
        String unionAgg = "select count(*) from (select * from functional.alltypes union all select * from functional.alltypessmall) t limit 10";
        this.verifyNIdenticalCacheKeys(unionAgg, unionAgg, 3, false);
        this.verifyNIdenticalCacheKeys(unionAgg, unionAgg, 4, true);
        String groupConcatGroupAgg = "select day, group_concat(distinct string_col) from (select * from functional.alltypesagg where id % 100 = day order by id limit 99999) a group by day";
        this.verifyNIdenticalCacheKeys(groupConcatGroupAgg, groupConcatGroupAgg, 1);
        for (String aggFn : Arrays.asList("appx_median", "histogram", "sample")) {
            String variableAggQuery = String.format("select %s(tinyint_col) from functional.alltypesagg", aggFn);
            this.verifyNIdenticalCacheKeys(variableAggQuery, variableAggQuery, 1);
        }
        String groupConcatOnlyScan = "select group_concat(string_col) from functional.alltypes";
        this.verifyNIdenticalCacheKeys(groupConcatOnlyScan, groupConcatOnlyScan, 1);
    }

    @Test
    public void testUnions() {
        String select_alltypes_id = "select id from functional.alltypes";
        String select_alltypessmall_id = "select id from functional.alltypessmall";
        this.verifyAllEligible(select_alltypes_id + " union all " + select_alltypessmall_id, false);
        this.verifyAllEligible("select count(*) from (select * from functional.alltypes union all select * from functional.alltypessmall) t", false);
        this.verifyAllEligible(select_alltypes_id + " union distinct " + select_alltypessmall_id, false);
        this.verifyOverlappingCacheKeys(select_alltypes_id + " union all " + select_alltypessmall_id, select_alltypessmall_id + " union all " + select_alltypes_id);
    }

    @Test
    public void testCacheKeyMasking() {
        this.verifyIdenticalCacheKeys("select id from functional.alltypes", "select id from functional.alltypes a");
        this.verifyIdenticalCacheKeys("select id from functional.alltypes", "select id as a from functional.alltypes");
    }

    @Test
    public void testIneligibility() {
        this.verifyCacheIneligible("select id from functional_kudu.alltypes");
        this.verifyCacheIneligible("select id from functional_hbase.alltypes");
        this.verifyCacheIneligible("select count(*) from functional_orc_def.alltypes");
        this.verifyAllEligible("select count(*) from functional_parquet.insert_only_major_and_minor_compacted", false);
        this.verifyCacheIneligible("select a.id from functional.alltypes a, functional_kudu.alltypes b where a.id = b.id");
        this.verifyCacheIneligible("select id from functional.alltypes limit 10");
        this.verifyOverlappingCacheKeys("select a.id from functional.alltypes a, functional.alltypes b", "select a.id from functional.alltypes a, functional.alltypes b limit 10");
        this.verifyCacheIneligible("select id from functional.alltypes where id < 7300 * rand()");
        this.verifyCacheIneligible("select id from functional.alltypes where id < 7300 * random()");
        this.verifyCacheIneligible("select id from functional.alltypes where string_col != uuid()");
        this.verifyCacheIneligible("select timestamp_col from functional.alltypes where timestamp_col < now()");
        this.verifyCacheIneligible("select date_col from functional.date_tbl where date_col < current_date()");
        this.verifyCacheIneligible("select date_col from functional.date_tbl where date_col < CURRENT_date()");
        this.verifyCacheIneligible("select string_col from functional.alltypes where string_col = current_user()");
        this.verifyCacheIneligible("select string_col from functional.alltypes where string_col = coordinator()");
        this.verifyCacheIneligible("select string_col from functional.alltypes where string_col = ai_generate_text_default(string_col)");
        this.addTestFunction("TestUdf", Lists.newArrayList((Object[])new ScalarType[]{Type.INT}), false);
        this.verifyCacheIneligible("select string_col from functional.alltypes where TestUdf(int_col) = int_col");
        this.verifyCacheIneligible("select * from functional.alltypes where id < 5 and string_col = current_user()");
    }

    @Test
    public void testCacheKeyGenerality() {
        this.verifyOverlappingCacheKeys("select straight_join probe.id from functional.alltypes probe, functional.alltypes build where probe.id = build.id", "select straight_join probe.id from functional.alltypestiny probe, functional.alltypes build where probe.id = build.id");
        this.verifyOverlappingCacheKeys("select straight_join probe.id from functional.alltypes probe, functional.alltypes build where probe.id = build.id", "select straight_join probe.id from functional.alltypes probe, functional.alltypes build where probe.id = build.id and probe.int_col=100");
        this.verifyOverlappingCacheKeys("select straight_join probe.id from (select id from functional.alltypes limit 10) probe, functional.alltypes build where probe.id = build.id", "select straight_join probe.id from (select id from functional.alltypes) probe, functional.alltypes build where probe.id = build.id");
        this.verifyOverlappingCacheKeys("select straight_join probe.id from functional.alltypes probe, functional.alltypes build where probe.id = build.id and build.int_col = 100", "select straight_join probe.id from functional.alltypes probe, functional.alltypes build where probe.id = build.id and probe.int_col = 100 and build.int_col = 100");
        this.verifyOverlappingCacheKeys("select straight_join probe1.id from functional.alltypes probe1, functional.alltypes probe2, functional.alltypes build where probe1.id = probe2.id and probe2.id = build.id", "select straight_join probe1.id from functional.alltypes probe1, functional.alltypes build where probe1.id = build.id");
        this.verifyOverlappingCacheKeys("select straight_join probe.id from functional.alltypes probe, (select build1.id from functional.alltypes build1) build where probe.id = build.id", "select straight_join probe.id from functional.alltypes probe, (select build1.id from functional.alltypes build1) build where probe.id = build.id and probe.bool_col = true and probe.int_col = 100");
        String join_union_build = "select straight_join u.id from functional.alltypes t, (select id from functional.alltypessmall union all select id from functional.alltypestiny) u where t.id = u.id";
        this.verifyOverlappingCacheKeys(join_union_build, join_union_build + " and t.int_col = 1");
    }

    @Test
    public void testIceberg() {
        this.verifyIdenticalCacheKeys("select * from functional_parquet.iceberg_v2_delete_both_eq_and_pos", "select * from functional_parquet.iceberg_v2_delete_both_eq_and_pos");
    }

    @Test
    public void testJoins() {
        this.verifyAllEligible("select straight_join probe.id from functional.alltypes probe, functional.alltypes build where probe.id = build.id and probe.int_col <= build.int_col", false);
        this.verifyAllEligible("select straight_join probe.id from functional.alltypes probe, functional.alltypes build where probe.id < build.id", false);
        this.verifyAllEligible("select * from functional_parquet.iceberg_v2_positional_delete_all_rows", false);
        this.verifyOverlappingCacheKeys("select straight_join probe.id from functional.alltypes probe, functional.alltypes build where probe.id = build.id and probe.int_col <= build.int_col", "select straight_join probe.id from functional.alltypes probe, functional.alltypes build where probe.id = build.id and probe.int_col + 1 <= build.int_col");
        this.verifyOverlappingCacheKeys("select straight_join probe.id from functional.alltypes probe, functional.alltypes build where probe.id < build.id", "select straight_join probe.id from functional.alltypes probe, functional.alltypes build where probe.id + 1 < build.id");
        String simple_join_with_hint_template = "select straight_join probe.id from functional.alltypes probe join %s functional.alltypes build on (probe.id = build.id)";
        this.verifyOverlappingCacheKeys(String.format(simple_join_with_hint_template, "/* +broadcast */"), String.format(simple_join_with_hint_template, "/* +shuffle */"), true);
        this.verifyJoinNodesEligible(String.format(simple_join_with_hint_template, "/* +broadcast */"), 1, true);
        this.verifyJoinNodesEligible(String.format(simple_join_with_hint_template, "/* +shuffle */"), 0, true);
        this.verifyJoinNodesEligible("select * from functional_parquet.iceberg_v2_positional_delete_all_rows", 1, true);
        String incorporatePartitionSqlTemplate = "select straight_join build.j, probe.id from functional.alltypes probe, scale_db.num_partitions_1234_blocks_per_partition_1 build where probe.id = build.i and build.j = %s";
        this.verifyOverlappingCacheKeys(String.format(incorporatePartitionSqlTemplate, 1), String.format(incorporatePartitionSqlTemplate, 2));
    }

    @Test
    public void testDeterministicScheduling() {
        List<PlanNode> cacheEligibleNodes = this.getCacheEligibleNodes("select id from functional.alltypes where int_col = 500");
        for (PlanNode node : cacheEligibleNodes) {
            if (!(node instanceof HdfsScanNode)) continue;
            HdfsScanNode hdfsScanNode = (HdfsScanNode)node;
            Assert.assertTrue((boolean)hdfsScanNode.usesDeterministicScanRangeAssignment());
            Assert.assertTrue((boolean)hdfsScanNode.scheduleScanRangesOldestToNewest());
        }
    }

    @Test
    public void testSkipCorrectnessChecking() {
        List<PlanNode> cacheEligibleNodes = this.getCacheEligibleNodes("select int_col, count(*) from functional.alltypes group by int_col", true);
        for (PlanNode node : cacheEligibleNodes) {
            if (!(node instanceof AggregationNode)) continue;
            Assert.assertTrue((boolean)node.getTupleCacheInfo().getStreamingAggVariability());
        }
    }

    protected List<PlanNode> getCacheEligibleNodes(String query, boolean isDistributedPlan) {
        List<PlanFragment> plan = this.getPlan(query, isDistributedPlan);
        PlanNode planRoot = plan.get(0).getPlanRoot();
        List preOrderPlanNodes = planRoot.getNodesPreOrder();
        ArrayList<PlanNode> cacheEligibleNodes = new ArrayList<PlanNode>();
        for (PlanNode node : preOrderPlanNodes) {
            TupleCacheInfo info;
            if (node instanceof TupleCacheNode || !(info = node.getTupleCacheInfo()).isEligible()) continue;
            cacheEligibleNodes.add(node);
        }
        return cacheEligibleNodes;
    }

    protected List<PlanNode> getCacheEligibleNodes(String query) {
        return this.getCacheEligibleNodes(query, false);
    }

    private List<String> getCacheKeys(List<PlanNode> cacheEligibleNodes) {
        ArrayList<String> cacheKeys = new ArrayList<String>();
        for (PlanNode node : cacheEligibleNodes) {
            cacheKeys.add(node.getTupleCacheInfo().getHashString());
        }
        return cacheKeys;
    }

    private List<String> getCacheHashTraces(List<PlanNode> cacheEligibleNodes) {
        ArrayList<String> cacheHashTraces = new ArrayList<String>();
        for (PlanNode node : cacheEligibleNodes) {
            StringBuilder builder = new StringBuilder();
            for (TupleCacheInfo.HashTraceElement elem : node.getTupleCacheInfo().getHashTraces()) {
                builder.append(elem.getHashTrace());
            }
            cacheHashTraces.add(builder.toString());
        }
        return cacheHashTraces;
    }

    private void printQueryNodesCacheInfo(String query, List<PlanNode> nodes, StringBuilder log) {
        log.append("Query: ");
        log.append(query);
        log.append("\n");
        for (PlanNode node : nodes) {
            log.append(node.getDisplayLabel());
            log.append("\n");
            log.append(node.getTupleCacheInfo().toString());
        }
    }

    protected void verifyCacheIneligible(String query, boolean isDistributedPlan) {
        List<PlanNode> cacheEligibleNodes = this.getCacheEligibleNodes(query, isDistributedPlan);
        if (cacheEligibleNodes.size() != 0) {
            StringBuilder errorLog = new StringBuilder();
            errorLog.append("Expected no cache eligible nodes. Instead found:\n");
            this.printQueryNodesCacheInfo(query, cacheEligibleNodes, errorLog);
            Assert.fail((String)errorLog.toString());
        }
    }

    protected void verifyCacheIneligible(String query) {
        this.verifyCacheIneligible(query, false);
    }

    protected void verifyIdenticalCacheKeys(String query1, String query2, boolean isDistributedPlan) {
        this.verifyNIdenticalCacheKeys(query1, query2, 1, isDistributedPlan);
    }

    protected void verifyIdenticalCacheKeys(String query1, String query2) {
        this.verifyIdenticalCacheKeys(query1, query2, false);
    }

    protected void verifyNIdenticalCacheKeys(String query1, String query2, int n, boolean isDistributedPlan) {
        List<PlanNode> cacheEligibleNodes1 = this.getCacheEligibleNodes(query1, isDistributedPlan);
        List<PlanNode> cacheEligibleNodes2 = this.getCacheEligibleNodes(query2, isDistributedPlan);
        Assert.assertTrue((cacheEligibleNodes1.size() >= n ? 1 : 0) != 0);
        List<String> cacheKeys1 = this.getCacheKeys(cacheEligibleNodes1);
        List<String> cacheKeys2 = this.getCacheKeys(cacheEligibleNodes2);
        List<String> cacheHashTraces1 = this.getCacheHashTraces(cacheEligibleNodes1);
        List<String> cacheHashTraces2 = this.getCacheHashTraces(cacheEligibleNodes2);
        if (!cacheKeys1.equals(cacheKeys2) || !cacheHashTraces1.equals(cacheHashTraces2)) {
            StringBuilder errorLog = new StringBuilder();
            errorLog.append("Expected identical cache keys. Instead found:\n");
            this.printQueryNodesCacheInfo(query1, cacheEligibleNodes1, errorLog);
            this.printQueryNodesCacheInfo(query2, cacheEligibleNodes2, errorLog);
            Assert.fail((String)errorLog.toString());
        }
    }

    protected void verifyNIdenticalCacheKeys(String query1, String query2, int n) {
        this.verifyNIdenticalCacheKeys(query1, query2, n, false);
    }

    protected void verifyOverlappingCacheKeys(String query1, String query2, boolean isDistributedPlan) {
        StringBuilder errorLog;
        List<PlanNode> cacheEligibleNodes1 = this.getCacheEligibleNodes(query1, isDistributedPlan);
        List<PlanNode> cacheEligibleNodes2 = this.getCacheEligibleNodes(query2, isDistributedPlan);
        Assert.assertTrue((cacheEligibleNodes1.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((cacheEligibleNodes2.size() > 0 ? 1 : 0) != 0);
        HashSet<String> cacheKeys1 = new HashSet<String>(this.getCacheKeys(cacheEligibleNodes1));
        HashSet<String> cacheKeys2 = new HashSet<String>(this.getCacheKeys(cacheEligibleNodes2));
        HashSet<String> keyIntersection = new HashSet<String>(cacheKeys1);
        keyIntersection.retainAll(cacheKeys2);
        HashSet<String> cacheHashTraces1 = new HashSet<String>(this.getCacheHashTraces(cacheEligibleNodes1));
        HashSet<String> cacheHashTraces2 = new HashSet<String>(this.getCacheHashTraces(cacheEligibleNodes2));
        HashSet<String> hashTraceIntersection = new HashSet<String>(cacheHashTraces1);
        hashTraceIntersection.retainAll(cacheHashTraces2);
        Assert.assertTrue((keyIntersection.size() <= hashTraceIntersection.size() ? 1 : 0) != 0);
        if (keyIntersection.size() == 0 || hashTraceIntersection.size() == 0) {
            errorLog = new StringBuilder();
            errorLog.append("Expected overlapping cache keys. Instead found:\n");
            this.printQueryNodesCacheInfo(query1, cacheEligibleNodes1, errorLog);
            this.printQueryNodesCacheInfo(query2, cacheEligibleNodes2, errorLog);
            Assert.fail((String)errorLog.toString());
        }
        if (cacheKeys1.equals(cacheKeys2) || cacheHashTraces1.equals(cacheHashTraces2)) {
            errorLog = new StringBuilder();
            errorLog.append("Expected some cache keys to differ. Instead found:\n");
            this.printQueryNodesCacheInfo(query1, cacheEligibleNodes1, errorLog);
            this.printQueryNodesCacheInfo(query2, cacheEligibleNodes2, errorLog);
            Assert.fail((String)errorLog.toString());
        }
    }

    protected void verifyOverlappingCacheKeys(String query1, String query2) {
        this.verifyOverlappingCacheKeys(query1, query2, false);
    }

    protected void verifyDifferentCacheKeys(String query1, String query2, boolean isDistributedPlan) {
        List<PlanNode> cacheEligibleNodes1 = this.getCacheEligibleNodes(query1, isDistributedPlan);
        List<PlanNode> cacheEligibleNodes2 = this.getCacheEligibleNodes(query2, isDistributedPlan);
        Assert.assertTrue((cacheEligibleNodes1.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((cacheEligibleNodes2.size() > 0 ? 1 : 0) != 0);
        HashSet<String> cacheKeys1 = new HashSet<String>(this.getCacheKeys(cacheEligibleNodes1));
        HashSet<String> cacheKeys2 = new HashSet<String>(this.getCacheKeys(cacheEligibleNodes2));
        HashSet<String> keyIntersection = new HashSet<String>(cacheKeys1);
        keyIntersection.retainAll(cacheKeys2);
        HashSet<String> cacheHashTraces1 = new HashSet<String>(this.getCacheHashTraces(cacheEligibleNodes1));
        HashSet<String> cacheHashTraces2 = new HashSet<String>(this.getCacheHashTraces(cacheEligibleNodes2));
        HashSet<String> hashTraceIntersection = new HashSet<String>(cacheHashTraces1);
        hashTraceIntersection.retainAll(cacheHashTraces2);
        Assert.assertTrue((keyIntersection.size() <= hashTraceIntersection.size() ? 1 : 0) != 0);
        if (keyIntersection.size() != 0) {
            StringBuilder errorLog = new StringBuilder();
            errorLog.append("Expected different cache keys. Instead found:\n");
            this.printQueryNodesCacheInfo(query1, cacheEligibleNodes1, errorLog);
            this.printQueryNodesCacheInfo(query2, cacheEligibleNodes2, errorLog);
            Assert.fail((String)errorLog.toString());
        }
    }

    protected void verifyDifferentCacheKeys(String query1, String query2) {
        this.verifyDifferentCacheKeys(query1, query2, false);
    }

    protected void verifyAllEligible(String query, boolean isDistributedPlan) {
        List<PlanFragment> plan = this.getPlan(query, isDistributedPlan);
        PlanNode planRoot = plan.get(0).getPlanRoot();
        List preOrderPlanNodes = planRoot.getNodesPreOrder();
        ArrayList<PlanNode> ineligibleNodes = new ArrayList<PlanNode>();
        for (PlanNode node : preOrderPlanNodes) {
            TupleCacheInfo info;
            if (node instanceof TupleCacheNode || (info = node.getTupleCacheInfo()).isEligible()) continue;
            ineligibleNodes.add(node);
        }
        if (ineligibleNodes.size() != 0) {
            StringBuilder errorLog = new StringBuilder();
            errorLog.append("Expected all nodes eligible, instead found ineligible nodes:\n");
            this.printQueryNodesCacheInfo(query, ineligibleNodes, errorLog);
            Assert.fail((String)errorLog.toString());
        }
    }

    protected void verifyJoinNodesEligible(String query, int expectedEligibleJoins, boolean isDistributedPlan) {
        List<PlanFragment> plan = this.getPlan(query, isDistributedPlan);
        PlanNode planRoot = plan.get(0).getPlanRoot();
        List preOrderPlanNodes = planRoot.getNodesPreOrder();
        ArrayList<PlanNode> ineligibleJoinNodes = new ArrayList<PlanNode>();
        int eligibleJoins = 0;
        for (PlanNode node : preOrderPlanNodes) {
            if (!(node instanceof JoinNode)) continue;
            TupleCacheInfo info = node.getTupleCacheInfo();
            if (!info.isEligible()) {
                ineligibleJoinNodes.add(node);
                continue;
            }
            ++eligibleJoins;
        }
        if (eligibleJoins != expectedEligibleJoins) {
            StringBuilder errorLog = new StringBuilder();
            errorLog.append(String.format("Expected %d join nodes eligible, instead found %d.\n", eligibleJoins, expectedEligibleJoins));
            errorLog.append("Ineligible join nodes:");
            this.printQueryNodesCacheInfo(query, ineligibleJoinNodes, errorLog);
            Assert.fail((String)errorLog.toString());
        }
    }

    private List<PlanFragment> getPlan(String query, boolean isDistributedPlan) {
        TQueryCtx queryCtx = TestUtils.createQueryContext("default", System.getProperty("user.name"));
        queryCtx.client_request.setStmt(query);
        TQueryOptions queryOptions = queryCtx.client_request.getQuery_options();
        queryOptions.setNum_nodes(isDistributedPlan ? 0 : 1);
        queryOptions.setEnable_tuple_cache(true);
        Frontend.PlanCtx planCtx = new Frontend.PlanCtx(queryCtx);
        planCtx.requestPlanCapture();
        try {
            frontend_.createExecRequest(planCtx);
        }
        catch (ImpalaException e) {
            Assert.fail((String)e.getMessage());
        }
        return planCtx.getPlan();
    }

    private List<PlanFragment> getPlan(String query) {
        return this.getPlan(query, false);
    }
}

