/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import java.util.List;
import org.apache.impala.analysis.DescriptorTable;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.planner.TupleCacheInfo;
import org.apache.impala.thrift.TUniqueId;
import org.apache.thrift.TBase;
import org.junit.Assert;
import org.junit.Test;

public class TupleCacheInfoTest {
    @Test
    public void testHashThrift() {
        TupleCacheInfo info1 = new TupleCacheInfo(null);
        info1.hashThrift("info1", (TBase)new TUniqueId(1L, 2L));
        info1.finalizeHash();
        List info1HashTraces = info1.getHashTraces();
        Assert.assertEquals((long)info1HashTraces.size(), (long)1L);
        Assert.assertEquals((Object)"info1", (Object)((TupleCacheInfo.HashTraceElement)info1HashTraces.get(0)).getComment());
        Assert.assertEquals((Object)"TUniqueId(hi:1, lo:2)", (Object)((TupleCacheInfo.HashTraceElement)info1HashTraces.get(0)).getHashTrace());
        TupleCacheInfo info2 = new TupleCacheInfo(null);
        info2.hashThrift("info2", (TBase)new TUniqueId(1L, 2L));
        info2.finalizeHash();
        List info2HashTraces = info2.getHashTraces();
        Assert.assertEquals((long)info1HashTraces.size(), (long)info2HashTraces.size());
        Assert.assertEquals((Object)"info2", (Object)((TupleCacheInfo.HashTraceElement)info2HashTraces.get(0)).getComment());
        Assert.assertEquals((Object)((TupleCacheInfo.HashTraceElement)info1HashTraces.get(0)).getHashTrace(), (Object)((TupleCacheInfo.HashTraceElement)info2HashTraces.get(0)).getHashTrace());
        Assert.assertEquals((Object)"b3f5384f81770c6adb83209b2a171dfa", (Object)info1.getHashString());
        Assert.assertEquals((Object)info1.getHashString(), (Object)info2.getHashString());
    }

    @Test
    public void testMergeHash() {
        TupleCacheInfo child1 = new TupleCacheInfo(null);
        child1.hashThrift("child1", (TBase)new TUniqueId(1L, 2L));
        child1.finalizeHash();
        TupleCacheInfo child2 = new TupleCacheInfo(null);
        child2.hashThrift("child2", (TBase)new TUniqueId(3L, 4L));
        child2.finalizeHash();
        TupleCacheInfo parent = new TupleCacheInfo(null);
        parent.mergeChild("child1", child1);
        parent.mergeChild("child2", child2);
        parent.hashThrift("parent", (TBase)new TUniqueId(5L, 6L));
        parent.finalizeHash();
        List hashTraces = parent.getHashTraces();
        Assert.assertEquals((long)hashTraces.size(), (long)3L);
        Assert.assertEquals((Object)"child1", (Object)((TupleCacheInfo.HashTraceElement)hashTraces.get(0)).getComment());
        Assert.assertEquals((Object)child1.getHashString(), (Object)((TupleCacheInfo.HashTraceElement)hashTraces.get(0)).getHashTrace());
        Assert.assertEquals((Object)"child2", (Object)((TupleCacheInfo.HashTraceElement)hashTraces.get(1)).getComment());
        Assert.assertEquals((Object)child2.getHashString(), (Object)((TupleCacheInfo.HashTraceElement)hashTraces.get(1)).getHashTrace());
        Assert.assertEquals((Object)"parent", (Object)((TupleCacheInfo.HashTraceElement)hashTraces.get(2)).getComment());
        Assert.assertEquals((Object)"TUniqueId(hi:5, lo:6)", (Object)((TupleCacheInfo.HashTraceElement)hashTraces.get(2)).getHashTrace());
        Assert.assertEquals((Object)"edf5633bed2280c3c3edb703182f3122", (Object)parent.getHashString());
    }

    @Test
    public void testMergeEligibility() {
        TupleCacheInfo child1 = new TupleCacheInfo(null);
        child1.hashThrift("child1", (TBase)new TUniqueId(1L, 2L));
        child1.finalizeHash();
        Assert.assertTrue((boolean)child1.isEligible());
        TupleCacheInfo child2 = new TupleCacheInfo(null);
        child2.setIneligible(TupleCacheInfo.IneligibilityReason.NOT_IMPLEMENTED);
        child2.finalizeHash();
        Assert.assertTrue((!child2.isEligible() ? 1 : 0) != 0);
        TupleCacheInfo parent = new TupleCacheInfo(null);
        parent.mergeChild("child1", child1);
        Assert.assertTrue((boolean)parent.isEligible());
        parent.mergeChild("child2", child2);
        Assert.assertTrue((!parent.isEligible() ? 1 : 0) != 0);
        parent.finalizeHash();
        Assert.assertTrue((!parent.isEligible() ? 1 : 0) != 0);
    }

    @Test
    public void testIdTranslation() {
        DescriptorTable descTbl = new DescriptorTable();
        TupleDescriptor tuple1 = descTbl.createTupleDescriptor("tuple1");
        Assert.assertEquals((long)tuple1.getId().asInt(), (long)0L);
        SlotDescriptor t1slot = descTbl.addSlotDescriptor(tuple1);
        t1slot.setType((Type)ScalarType.createType((PrimitiveType)PrimitiveType.INT));
        t1slot.setLabel("t1slot");
        Assert.assertEquals((long)t1slot.getId().asInt(), (long)0L);
        TupleDescriptor tuple2 = descTbl.createTupleDescriptor("tuple2");
        Assert.assertEquals((long)tuple2.getId().asInt(), (long)1L);
        SlotDescriptor t2slot = descTbl.addSlotDescriptor(tuple2);
        t2slot.setType((Type)ScalarType.createType((PrimitiveType)PrimitiveType.INT));
        t2slot.setLabel("t2slot");
        Assert.assertEquals((long)t2slot.getId().asInt(), (long)1L);
        tuple1.materializeSlots();
        tuple2.materializeSlots();
        descTbl.computeMemLayout();
        TupleCacheInfo child1 = new TupleCacheInfo(descTbl);
        child1.hashThrift("child1", (TBase)new TUniqueId(1L, 2L));
        child1.registerTuple(tuple1.getId());
        child1.finalizeHash();
        Assert.assertEquals((long)child1.getLocalTupleId(tuple1.getId()).asInt(), (long)0L);
        Assert.assertEquals((long)child1.getLocalSlotId(t1slot.getId()).asInt(), (long)0L);
        List child1HashTraces = child1.getHashTraces();
        Assert.assertEquals((long)3L, (long)child1HashTraces.size());
        Assert.assertEquals((Object)"child1", (Object)((TupleCacheInfo.HashTraceElement)child1HashTraces.get(0)).getComment());
        Assert.assertEquals((Object)"TUniqueId(hi:1, lo:2)", (Object)((TupleCacheInfo.HashTraceElement)child1HashTraces.get(0)).getHashTrace());
        Assert.assertEquals((Object)"TTupleDescriptor(id:0, byteSize:5, numNullBytes:1)", (Object)((TupleCacheInfo.HashTraceElement)child1HashTraces.get(1)).getHashTrace());
        Assert.assertEquals((Object)"TSlotDescriptor(id:0, parent:0, slotType:TColumnType(types:[TTypeNode(type:SCALAR, scalar_type:TScalarType(type:INT))]), materializedPath:[], byteOffset:0, nullIndicatorByte:4, nullIndicatorBit:0, slotIdx:0, virtual_col_type:NONE)", (Object)((TupleCacheInfo.HashTraceElement)child1HashTraces.get(2)).getHashTrace());
        TupleCacheInfo child2 = new TupleCacheInfo(descTbl);
        child2.hashThrift("child2", (TBase)new TUniqueId(1L, 2L));
        child2.registerTuple(tuple2.getId());
        child2.finalizeHash();
        Assert.assertEquals((long)child2.getLocalTupleId(tuple2.getId()).asInt(), (long)0L);
        Assert.assertEquals((long)child2.getLocalSlotId(t2slot.getId()).asInt(), (long)0L);
        List child2HashTraces = child1.getHashTraces();
        Assert.assertEquals((Object)child2HashTraces, (Object)child1HashTraces);
        Assert.assertEquals((Object)child2.getHashString(), (Object)child1.getHashString());
        TupleCacheInfo parent = new TupleCacheInfo(descTbl);
        parent.mergeChild("child2", child2);
        parent.mergeChild("child1", child1);
        parent.finalizeHash();
        Assert.assertEquals((long)parent.getLocalTupleId(tuple1.getId()).asInt(), (long)1L);
        Assert.assertEquals((long)parent.getLocalTupleId(tuple2.getId()).asInt(), (long)0L);
        Assert.assertEquals((long)parent.getLocalSlotId(t1slot.getId()).asInt(), (long)1L);
        Assert.assertEquals((long)parent.getLocalSlotId(t2slot.getId()).asInt(), (long)0L);
        List parentHashTraces = parent.getHashTraces();
        Assert.assertEquals((long)parentHashTraces.size(), (long)2L);
        Assert.assertEquals((Object)"child2", (Object)((TupleCacheInfo.HashTraceElement)parentHashTraces.get(0)).getComment());
        Assert.assertEquals((Object)child2.getHashString(), (Object)((TupleCacheInfo.HashTraceElement)parentHashTraces.get(0)).getHashTrace());
        Assert.assertEquals((Object)"child1", (Object)((TupleCacheInfo.HashTraceElement)parentHashTraces.get(1)).getComment());
        Assert.assertEquals((Object)child1.getHashString(), (Object)((TupleCacheInfo.HashTraceElement)parentHashTraces.get(1)).getHashTrace());
    }
}

