/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.impala.catalog.SideloadTableStats;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.planner.PlannerTestBase;
import org.apache.impala.planner.TpcdsCpuCostPlannerTest;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TReplicaPreference;
import org.apache.impala.thrift.TSlotCountStrategy;
import org.apache.impala.util.RequestPoolService;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TpcdsTupleCachePlannerTest
extends PlannerTestBase {
    private static final String ALLOCATION_FILE = "fair-scheduler-3-groups.xml";
    private static final String LLAMA_CONFIG_FILE = "llama-site-3-groups.xml";
    private static Set<PlannerTestBase.PlannerTestOption> testOptions = TpcdsTupleCachePlannerTest.tpcdsParquetTestOptions();
    private static TQueryOptions options = TpcdsTupleCachePlannerTest.tpcdsParquetQueryOptions().setCompute_processing_cost(true).setMax_fragment_instances_per_node(12).setReplica_preference(TReplicaPreference.REMOTE).setSlot_count_strategy(TSlotCountStrategy.PLANNER_CPU_ASK).setMem_estimate_scale_for_spilling_operator(1.0).setPlanner_testcase_mode(true).setDisable_hdfs_num_rows_estimate(true).setEnable_tuple_cache(true);
    private static String testDb = "tpcds_partitioned_parquet_snap";
    private static Map<String, Map<String, SideloadTableStats>> sideloadStats;
    private static Map<String, Long> scanRangeLimit;
    private static TemporaryFolder tempFolder;

    private static File getClasspathFile(String filename) throws URISyntaxException {
        return new File(TpcdsCpuCostPlannerTest.class.getClassLoader().getResource(filename).toURI());
    }

    private static void setupAdmissionControl() throws IOException, URISyntaxException {
        tempFolder = new TemporaryFolder();
        tempFolder.create();
        File allocationConfFile = tempFolder.newFile(ALLOCATION_FILE);
        Files.copy((File)TpcdsTupleCachePlannerTest.getClasspathFile(ALLOCATION_FILE), (File)allocationConfFile);
        File llamaConfFile = tempFolder.newFile(LLAMA_CONFIG_FILE);
        Files.copy((File)TpcdsTupleCachePlannerTest.getClasspathFile(LLAMA_CONFIG_FILE), (File)llamaConfFile);
        RequestPoolService poolService = RequestPoolService.getInstance((String)allocationConfFile.getAbsolutePath(), (String)llamaConfFile.getAbsolutePath(), (boolean)false);
        poolService.start();
    }

    @BeforeClass
    public static void setUp() throws Exception {
        TpcdsTupleCachePlannerTest.setupAdmissionControl();
        TpcdsTupleCachePlannerTest.setUpTestCluster(10, 10, "root.large");
        TpcdsTupleCachePlannerTest.setUpKuduClientAndLogDir();
        Paths.get(outDir_.toString(), "tpcds_tuple_cache").toFile().mkdirs();
        RuntimeEnv.INSTANCE.setTestEnv(true);
        sideloadStats = TpcdsTupleCachePlannerTest.loadStatsJson("tpcds_cpu_cost/stats-3TB.json");
        RuntimeEnv.INSTANCE.setSideloadStats(sideloadStats);
        for (Map.Entry<String, Long> entry : scanRangeLimit.entrySet()) {
            RuntimeEnv.INSTANCE.addTableScanRangeLimit(testDb, entry.getKey(), entry.getValue().longValue());
        }
        TpcdsTupleCachePlannerTest.invalidateTables();
    }

    @AfterClass
    public static void unsetMetadataScaleAndStopPoolService() {
        RuntimeEnv.INSTANCE.dropSideloadStats();
        RuntimeEnv.INSTANCE.dropTableScanRangeLimit();
        TpcdsTupleCachePlannerTest.invalidateTables();
        RequestPoolService.getInstance().stop();
        tempFolder.delete();
    }

    private static void invalidateTables() {
        for (String db : sideloadStats.keySet()) {
            for (String table : sideloadStats.get(db).keySet()) {
                catalog_.getSrcCatalog().invalidateTableIfExists(testDb, table);
            }
        }
    }

    @Test
    public void testQ1() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q01", testDb, options, testOptions);
    }

    @Test
    public void testQ2() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q02", testDb, options, testOptions);
    }

    @Test
    public void testQ3() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q03", testDb, options, testOptions);
    }

    @Test
    public void testQ4() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q04", testDb, options, testOptions);
    }

    @Test
    public void testQ5() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q05", testDb, options, testOptions);
    }

    @Test
    public void testQ6() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q06", testDb, options, testOptions);
    }

    @Test
    public void testQ7() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q07", testDb, options, testOptions);
    }

    @Test
    public void testQ8() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q08", testDb, options, testOptions);
    }

    @Test
    public void testQ9() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q09", testDb, options, testOptions);
    }

    @Test
    public void testQ10() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q10a", testDb, options, testOptions);
    }

    @Test
    public void testQ11() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q11", testDb, options, testOptions);
    }

    @Test
    public void testQ12() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q12", testDb, options, testOptions);
    }

    @Test
    public void testQ13() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q13", testDb, options, testOptions);
    }

    @Test
    public void testQ14a() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q14a", testDb, options, testOptions);
    }

    @Test
    public void testQ14b() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q14b", testDb, options, testOptions);
    }

    @Test
    public void testQ15() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q15", testDb, options, testOptions);
    }

    @Test
    public void testQ16() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q16", testDb, options, testOptions);
    }

    @Test
    public void testQ17() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q17", testDb, options, testOptions);
    }

    @Test
    public void testQ18() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q18", testDb, options, testOptions);
    }

    @Test
    public void testQ19() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q19", testDb, options, testOptions);
    }

    @Test
    public void testQ20() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q20", testDb, options, testOptions);
    }

    @Test
    public void testQ21() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q21", testDb, options, testOptions);
    }

    @Test
    public void testQ22() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q22", testDb, options, testOptions);
    }

    @Test
    public void testQ23a() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q23a", testDb, options, testOptions);
    }

    @Test
    public void testQ23b() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q23b", testDb, options, testOptions);
    }

    @Test
    public void testQ24a() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q24a", testDb, options, testOptions);
    }

    @Test
    public void testQ24b() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q24b", testDb, options, testOptions);
    }

    @Test
    public void testQ25() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q25", testDb, options, testOptions);
    }

    @Test
    public void testQ26() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q26", testDb, options, testOptions);
    }

    @Test
    public void testQ27() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q27", testDb, options, testOptions);
    }

    @Test
    public void testQ28() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q28", testDb, options, testOptions);
    }

    @Test
    public void testQ29() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q29", testDb, options, testOptions);
    }

    @Test
    public void testQ30() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q30", testDb, options, testOptions);
    }

    @Test
    public void testQ31() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q31", testDb, options, testOptions);
    }

    @Test
    public void testQ32() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q32", testDb, options, testOptions);
    }

    @Test
    public void testQ33() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q33", testDb, options, testOptions);
    }

    @Test
    public void testQ34() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q34", testDb, options, testOptions);
    }

    @Test
    public void testQ35() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q35a", testDb, options, testOptions);
    }

    @Test
    public void testQ36() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q36", testDb, options, testOptions);
    }

    @Test
    public void testQ37() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q37", testDb, options, testOptions);
    }

    @Test
    public void testQ38() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q38", testDb, options, testOptions);
    }

    @Test
    public void testQ39a() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q39a", testDb, options, testOptions);
    }

    @Test
    public void testQ39b() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q39b", testDb, options, testOptions);
    }

    @Test
    public void testQ40() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q40", testDb, options, testOptions);
    }

    @Test
    public void testQ41() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q41", testDb, options, testOptions);
    }

    @Test
    public void testQ42() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q42", testDb, options, testOptions);
    }

    @Test
    public void testQ43() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q43", testDb, options, testOptions);
    }

    @Test
    public void testQ44() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q44", testDb, options, testOptions);
    }

    @Test
    public void testQ45() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q45", testDb, options, testOptions);
    }

    @Test
    public void testQ46() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q46", testDb, options, testOptions);
    }

    @Test
    public void testQ47() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q47", testDb, options, testOptions);
    }

    @Test
    public void testQ48() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q48", testDb, options, testOptions);
    }

    @Test
    public void testQ49() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q49", testDb, options, testOptions);
    }

    @Test
    public void testQ50() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q50", testDb, options, testOptions);
    }

    @Test
    public void testQ51() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q51", testDb, options, testOptions);
    }

    @Test
    public void testQ52() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q52", testDb, options, testOptions);
    }

    @Test
    public void testQ53() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q53", testDb, options, testOptions);
    }

    @Test
    public void testQ54() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q54", testDb, options, testOptions);
    }

    @Test
    public void testQ55() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q55", testDb, options, testOptions);
    }

    @Test
    public void testQ56() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q56", testDb, options, testOptions);
    }

    @Test
    public void testQ57() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q57", testDb, options, testOptions);
    }

    @Test
    public void testQ58() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q58", testDb, options, testOptions);
    }

    @Test
    public void testQ59() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q59", testDb, options, testOptions);
    }

    @Test
    public void testQ60() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q60", testDb, options, testOptions);
    }

    @Test
    public void testQ61() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q61", testDb, options, testOptions);
    }

    @Test
    public void testQ62() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q62", testDb, options, testOptions);
    }

    @Test
    public void testQ63() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q63", testDb, options, testOptions);
    }

    @Test
    public void testQ64() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q64", testDb, options, testOptions);
    }

    @Test
    public void testQ65() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q65", testDb, options, testOptions);
    }

    @Test
    public void testQ66() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q66", testDb, options, testOptions);
    }

    @Test
    public void testQ67() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q67", testDb, options, testOptions);
    }

    @Test
    public void testQ68() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q68", testDb, options, testOptions);
    }

    @Test
    public void testQ69() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q69", testDb, options, testOptions);
    }

    @Test
    public void testQ70() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q70", testDb, options, testOptions);
    }

    @Test
    public void testQ71() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q71", testDb, options, testOptions);
    }

    @Test
    public void testQ72() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q72", testDb, options, testOptions);
    }

    @Test
    public void testQ73() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q73", testDb, options, testOptions);
    }

    @Test
    public void testQ74() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q74", testDb, options, testOptions);
    }

    @Test
    public void testQ75() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q75", testDb, options, testOptions);
    }

    @Test
    public void testQ76() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q76", testDb, options, testOptions);
    }

    @Test
    public void testQ77() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q77", testDb, options, testOptions);
    }

    @Test
    public void testQ78() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q78", testDb, options, testOptions);
    }

    @Test
    public void testQ79() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q79", testDb, options, testOptions);
    }

    @Test
    public void testQ80() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q80", testDb, options, testOptions);
    }

    @Test
    public void testQ81() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q81", testDb, options, testOptions);
    }

    @Test
    public void testQ82() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q82", testDb, options, testOptions);
    }

    @Test
    public void testQ83() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q83", testDb, options, testOptions);
    }

    @Test
    public void testQ84() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q84", testDb, options, testOptions);
    }

    @Test
    public void testQ85() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q85", testDb, options, testOptions);
    }

    @Test
    public void testQ86() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q86", testDb, options, testOptions);
    }

    @Test
    public void testQ87() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q87", testDb, options, testOptions);
    }

    @Test
    public void testQ88() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q88", testDb, options, testOptions);
    }

    @Test
    public void testQ89() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q89", testDb, options, testOptions);
    }

    @Test
    public void testQ90() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q90", testDb, options, testOptions);
    }

    @Test
    public void testQ91() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q91", testDb, options, testOptions);
    }

    @Test
    public void testQ92() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q92", testDb, options, testOptions);
    }

    @Test
    public void testQ93() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q93", testDb, options, testOptions);
    }

    @Test
    public void testQ94() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q94", testDb, options, testOptions);
    }

    @Test
    public void testQ95() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q95", testDb, options, testOptions);
    }

    @Test
    public void testQ96() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q96", testDb, options, testOptions);
    }

    @Test
    public void testQ97() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q97", testDb, options, testOptions);
    }

    @Test
    public void testQ98() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q98", testDb, options, testOptions);
    }

    @Test
    public void testQ99() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-q99", testDb, options, testOptions);
    }

    @Test
    public void testNonTpcdsDdl() {
        this.runPlannerTestFile("tpcds_tuple_cache/ddl", testDb, options, testOptions);
    }

    @Test
    public void testTpcdsDdlParquet() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-ddl-parquet", testDb, options, testOptions);
    }

    @Test
    public void testTpcdsDdlIceberg() {
        this.runPlannerTestFile("tpcds_tuple_cache/tpcds-ddl-iceberg", testDb, options, testOptions);
    }

    static {
        scanRangeLimit = new HashMap<String, Long>(){
            {
                this.put("customer", 593920L);
                this.put("customer_address", 128000L);
                this.put("customer_demographics", 808960L);
                this.put("item", 512000L);
            }
        };
    }
}

