/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.fs.Path;
import org.apache.impala.analysis.ColumnLineageGraph;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.SideloadTableStats;
import org.apache.impala.common.FrontendTestBase;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.planner.HBaseScanNode;
import org.apache.impala.planner.PlannerTest;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.Frontend;
import org.apache.impala.testutil.StatsJsonParser;
import org.apache.impala.testutil.TestFileParser;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TDescriptorTable;
import org.apache.impala.thrift.TExecRequest;
import org.apache.impala.thrift.TExecutorGroupSet;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.THBaseKeyRange;
import org.apache.impala.thrift.THdfsFileSplit;
import org.apache.impala.thrift.THdfsPartition;
import org.apache.impala.thrift.THdfsPartitionLocation;
import org.apache.impala.thrift.THdfsScanNode;
import org.apache.impala.thrift.THdfsTable;
import org.apache.impala.thrift.TLineageGraph;
import org.apache.impala.thrift.TPlanExecInfo;
import org.apache.impala.thrift.TPlanFragment;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryExecRequest;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TScanRangeLocationList;
import org.apache.impala.thrift.TScanRangeSpec;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableSink;
import org.apache.impala.thrift.TTupleDescriptor;
import org.apache.impala.thrift.TUpdateExecutorMembershipRequest;
import org.apache.impala.util.ExecutorMembershipSnapshot;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduScanToken;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlannerTestBase
extends FrontendTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(PlannerTest.class);
    private static final boolean GENERATE_OUTPUT_FILE = true;
    private static final java.nio.file.Path testDir_ = Paths.get("functional-planner", "queries", "PlannerTest");
    protected static java.nio.file.Path outDir_;
    private static KuduClient kuduClient_;
    private final Map<Integer, TPlanNode> planMap_ = Maps.newHashMap();
    private final Map<Integer, TTupleDescriptor> tupleMap_ = Maps.newHashMap();
    private final Map<Integer, TTableDescriptor> tableMap_ = Maps.newHashMap();

    protected static void setUpTestCluster(int num_executors, int expected_num_executors, String exec_group_name_prefix) {
        TUpdateExecutorMembershipRequest updateReq = new TUpdateExecutorMembershipRequest();
        updateReq.setIp_addresses((Set)Sets.newHashSet((Object[])new String[]{"127.0.0.1"}));
        updateReq.setHostnames((Set)Sets.newHashSet((Object[])new String[]{"localhost"}));
        TExecutorGroupSet group_set = new TExecutorGroupSet();
        group_set.curr_num_executors = num_executors;
        group_set.expected_num_executors = expected_num_executors;
        group_set.exec_group_name_prefix = exec_group_name_prefix;
        updateReq.setExec_group_sets(new ArrayList());
        updateReq.getExec_group_sets().add(group_set);
        ExecutorMembershipSnapshot.update((TUpdateExecutorMembershipRequest)updateReq);
    }

    protected static void setUpKuduClientAndLogDir() {
        kuduClient_ = new KuduClient.KuduClientBuilder("127.0.0.1:7051").build();
        String logDir = System.getenv("IMPALA_FE_TEST_LOGS_DIR");
        if (logDir == null) {
            logDir = "/tmp";
        }
        outDir_ = Paths.get(logDir, "PlannerTest");
        BackendConfig.INSTANCE.getBackendCfg().setKudu_master_hosts("127.0.0.1");
    }

    @BeforeClass
    public static void setUp() throws Exception {
        PlannerTestBase.setUpTestCluster(3, 20, "");
        PlannerTestBase.setUpKuduClientAndLogDir();
    }

    @Before
    public void setUpTest() throws Exception {
        RuntimeEnv.INSTANCE.reset();
        RuntimeEnv.INSTANCE.setNumCores(8);
        RuntimeEnv.INSTANCE.setTestEnv(true);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        RuntimeEnv.INSTANCE.reset();
        if (kuduClient_ != null) {
            kuduClient_.close();
            kuduClient_ = null;
        }
    }

    private void buildMaps(TQueryExecRequest execRequest) {
        this.planMap_.clear();
        this.tupleMap_.clear();
        this.tableMap_.clear();
        for (TPlanExecInfo execInfo : execRequest.plan_exec_info) {
            for (TPlanFragment frag : execInfo.fragments) {
                for (TPlanNode node : frag.plan.nodes) {
                    this.planMap_.put(node.node_id, node);
                }
            }
        }
        if (execRequest.query_ctx.isSetDesc_tbl_testonly()) {
            TDescriptorTable descTbl = execRequest.query_ctx.desc_tbl_testonly;
            for (TTupleDescriptor tupleDesc : descTbl.tupleDescriptors) {
                this.tupleMap_.put(tupleDesc.id, tupleDesc);
            }
            if (descTbl.isSetTableDescriptors()) {
                for (TTableDescriptor tableDesc : descTbl.tableDescriptors) {
                    this.tableMap_.put(tableDesc.id, tableDesc);
                }
            }
        }
    }

    private THdfsTable findTable(int nodeId) {
        TPlanNode node = this.planMap_.get(nodeId);
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkState((node.node_id == nodeId && node.isSetHdfs_scan_node() ? 1 : 0) != 0);
        THdfsScanNode scanNode = node.getHdfs_scan_node();
        int tupleId = scanNode.getTuple_id();
        TTupleDescriptor tupleDesc = this.tupleMap_.get(tupleId);
        Preconditions.checkNotNull((Object)tupleDesc);
        Preconditions.checkState((tupleDesc.id == tupleId ? 1 : 0) != 0);
        TTableDescriptor tableDesc = this.tableMap_.get(tupleDesc.tableId);
        Preconditions.checkNotNull((Object)tableDesc);
        Preconditions.checkState((tableDesc.id == tupleDesc.tableId && tableDesc.isSetHdfsTable() ? 1 : 0) != 0);
        return tableDesc.getHdfsTable();
    }

    private THdfsPartition findPartition(int nodeId, THdfsFileSplit split) {
        THdfsTable hdfsTable = this.findTable(nodeId);
        THdfsPartition partition = (THdfsPartition)hdfsTable.getPartitions().get(split.partition_id);
        Preconditions.checkNotNull((Object)partition);
        Preconditions.checkState((partition.id == split.partition_id ? 1 : 0) != 0);
        return partition;
    }

    private void testHdfsPartitionsReferenced(TQueryExecRequest execRequest, String query, StringBuilder errorLog) {
        long insertTableId = -1L;
        HashSet scanRangePartitions = Sets.newHashSet();
        for (TPlanExecInfo execInfo : execRequest.plan_exec_info) {
            if (execInfo.per_node_scan_ranges == null) continue;
            for (Map.Entry entry : execInfo.per_node_scan_ranges.entrySet()) {
                if (entry.getValue() == null || !((TScanRangeSpec)entry.getValue()).isSetConcrete_ranges()) continue;
                for (TScanRangeLocationList tScanRangeLocationList : ((TScanRangeSpec)entry.getValue()).concrete_ranges) {
                    if (!tScanRangeLocationList.scan_range.isSetHdfs_file_split()) continue;
                    THdfsFileSplit split = tScanRangeLocationList.scan_range.getHdfs_file_split();
                    THdfsPartition partition = this.findPartition((Integer)entry.getKey(), split);
                    scanRangePartitions.add(partition);
                }
            }
        }
        if (execRequest.isSetFinalize_params()) {
            insertTableId = execRequest.getFinalize_params().getTable_id();
        }
        boolean first = true;
        if (execRequest.query_ctx.isSetDesc_tbl_testonly() && execRequest.query_ctx.desc_tbl_testonly.isSetTableDescriptors()) {
            for (TTableDescriptor tableDesc : execRequest.query_ctx.desc_tbl_testonly.tableDescriptors) {
                if ((long)tableDesc.getId() == insertTableId || !tableDesc.isSetHdfsTable() || tableDesc.isSetIcebergTable() && scanRangePartitions.isEmpty()) continue;
                THdfsTable hdfsTable = tableDesc.getHdfsTable();
                for (Map.Entry entry : hdfsTable.getPartitions().entrySet()) {
                    THdfsPartition partition = (THdfsPartition)entry.getValue();
                    if (scanRangePartitions.contains(partition)) continue;
                    if (first) {
                        errorLog.append("query:\n" + query + "\n");
                    }
                    errorLog.append(" unreferenced partition: HdfsTable: " + tableDesc.getId() + " HdfsPartition: " + partition.getId() + "\n");
                    first = false;
                }
            }
        }
    }

    private StringBuilder printScanRangeLocations(TQueryExecRequest execRequest) {
        StringBuilder result = new StringBuilder();
        for (TPlanExecInfo execInfo : execRequest.plan_exec_info) {
            if (execInfo.per_node_scan_ranges == null) continue;
            for (Map.Entry entry : execInfo.per_node_scan_ranges.entrySet()) {
                result.append("NODE " + ((Integer)entry.getKey()).toString() + ":\n");
                if (entry.getValue() == null || !((TScanRangeSpec)entry.getValue()).isSetConcrete_ranges()) continue;
                for (TScanRangeLocationList locations : ((TScanRangeSpec)entry.getValue()).concrete_ranges) {
                    result.append("  ");
                    if (locations.scan_range.isSetHdfs_file_split()) {
                        THdfsFileSplit split = locations.scan_range.getHdfs_file_split();
                        THdfsTable table = this.findTable((Integer)entry.getKey());
                        THdfsPartition partition = (THdfsPartition)table.getPartitions().get(split.partition_id);
                        THdfsPartitionLocation location = partition.getLocation();
                        String file_location = location.getSuffix();
                        if (location.prefix_index != -1) {
                            file_location = (String)table.getPartition_prefixes().get(location.prefix_index) + file_location;
                        }
                        Path filePath = new Path(file_location, split.relative_path);
                        filePath = this.cleanseFilePath(filePath);
                        result.append("HDFS SPLIT " + filePath.toString() + " " + Long.toString(split.offset) + ":" + Long.toString(split.length));
                    }
                    if (locations.scan_range.isSetHbase_key_range()) {
                        THBaseKeyRange keyRange = locations.scan_range.getHbase_key_range();
                        result.append("HBASE KEYRANGE ");
                        if (keyRange.isSetStartKey()) {
                            result.append(HBaseScanNode.printKey((byte[])keyRange.getStartKey().getBytes()));
                        } else {
                            result.append("<unbounded>");
                        }
                        result.append(":");
                        if (keyRange.isSetStopKey()) {
                            result.append(HBaseScanNode.printKey((byte[])keyRange.getStopKey().getBytes()));
                        } else {
                            result.append("<unbounded>");
                        }
                    }
                    if (locations.scan_range.isSetKudu_scan_token()) {
                        Preconditions.checkNotNull((Object)kuduClient_, (Object)"Test should not be invoked on platforms that do not support Kudu.");
                        try {
                            String token = KuduScanToken.stringifySerializedToken((byte[])locations.scan_range.kudu_scan_token.array(), (KuduClient)kuduClient_);
                            token = token.replaceAll(" table-id=.*?,", "");
                            result.append(token);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException("Unable to parse Kudu scan token", e);
                        }
                    }
                    result.append("\n");
                }
            }
        }
        return result;
    }

    protected Path cleanseFilePath(Path path) {
        String fileName = path.getName();
        Pattern pattern = Pattern.compile("\\w{16}-\\w{16}_\\d+_data");
        Matcher matcher = pattern.matcher(fileName);
        fileName = matcher.replaceFirst("<UID>_data");
        return new Path(path.getParent(), fileName);
    }

    private String getExpectedErrorMessage(ArrayList<String> expectedPlan) {
        if (expectedPlan == null || expectedPlan.isEmpty()) {
            return null;
        }
        if (!(expectedPlan.get(0).contains("NotImplementedException") || expectedPlan.get(0).contains("InternalException") || expectedPlan.get(0).contains("AnalysisException"))) {
            return null;
        }
        return expectedPlan.get(0).trim();
    }

    private void handleException(String query, String expectedErrorMsg, StringBuilder errorLog, StringBuilder actualOutput, Throwable e) {
        String actualErrorMsg = e.getClass().getSimpleName() + ": " + e.getMessage();
        actualOutput.append(actualErrorMsg).append("\n");
        if (expectedErrorMsg == null) {
            errorLog.append(String.format("Query:\n%s\nError Stack:\n%s\n", query, ExceptionUtils.getStackTrace((Throwable)e)));
        } else if (expectedErrorMsg != null && !expectedErrorMsg.isEmpty() && !actualErrorMsg.toLowerCase().startsWith(expectedErrorMsg.toLowerCase())) {
            errorLog.append("query:\n" + query + "\nExpected error message: '" + expectedErrorMsg + "'\nActual error message: '" + actualErrorMsg + "'\n");
        }
    }

    protected TQueryOptions mergeQueryOptions(TQueryOptions a, TQueryOptions b) {
        for (TQueryOptions._Fields f : TQueryOptions._Fields.values()) {
            if (!b.isSet(f)) continue;
            a.setFieldValue(f, b.getFieldValue(f));
        }
        return a;
    }

    protected TQueryOptions defaultQueryOptions() {
        TQueryOptions options = new TQueryOptions();
        options.setExplain_level(TExplainLevel.STANDARD);
        options.setExec_single_node_rows_threshold(0);
        return options;
    }

    protected static TQueryOptions tpcdsParquetQueryOptions() {
        TQueryOptions options = new TQueryOptions();
        options.setMinmax_filter_threshold(0.5);
        options.setMinmax_filter_sorted_columns(false);
        options.setMinmax_filter_partition_columns(false);
        return options;
    }

    protected static Set<PlannerTestOption> tpcdsParquetTestOptions() {
        return ImmutableSet.of((Object)((Object)PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestOption.INCLUDE_RESOURCE_HEADER), (Object)((Object)PlannerTestOption.VALIDATE_RESOURCES), (Object)((Object)PlannerTestOption.VALIDATE_CARDINALITY));
    }

    private void runTestCase(TestFileParser.TestCase testCase, StringBuilder errorLog, StringBuilder actualOutput, String dbName, Set<PlannerTestOption> testOptions) throws CatalogException {
        String query = testCase.getQuery();
        LOG.info("running query " + query);
        if (query.isEmpty()) {
            throw new IllegalStateException("Cannot plan empty query in " + testCase.getFileNameAndLineNum());
        }
        TQueryCtx queryCtx = TestUtils.createQueryContext(dbName, System.getProperty("user.name"));
        queryCtx.client_request.query_options = testCase.getOptions();
        TExecRequest singleNodeExecRequest = this.testPlan(testCase, TestFileParser.Section.PLAN, queryCtx.deepCopy(), testOptions, errorLog, actualOutput);
        this.validateTableIds(singleNodeExecRequest);
        if (this.scanRangeLocationsCheckEnabled()) {
            this.checkScanRangeLocations(testCase, singleNodeExecRequest, errorLog, actualOutput);
        }
        this.checkColumnLineage(testCase, singleNodeExecRequest, errorLog, actualOutput);
        this.checkLimitCardinality(query, singleNodeExecRequest, errorLog);
        this.testPlan(testCase, TestFileParser.Section.DISTRIBUTEDPLAN, queryCtx.deepCopy(), testOptions, errorLog, actualOutput);
        this.testPlan(testCase, TestFileParser.Section.PARALLELPLANS, queryCtx.deepCopy(), testOptions, errorLog, actualOutput);
    }

    private void validateTableIds(TExecRequest request) {
        TPlanFragment firstPlanFragment;
        if (request == null || !request.isSetQuery_exec_request()) {
            return;
        }
        TQueryExecRequest execRequest = request.query_exec_request;
        HashSet seenTableIds = Sets.newHashSet();
        if (execRequest.query_ctx.isSetDesc_tbl_testonly()) {
            TDescriptorTable descTbl = execRequest.query_ctx.desc_tbl_testonly;
            if (descTbl.isSetTableDescriptors()) {
                for (TTableDescriptor tableDesc : descTbl.tableDescriptors) {
                    if (seenTableIds.contains(tableDesc.id)) {
                        throw new IllegalStateException("Failed to verify table id for table: " + tableDesc.getDbName() + "." + tableDesc.getTableName() + ".\nTable id: " + tableDesc.id + " already used.");
                    }
                    seenTableIds.add(tableDesc.id);
                }
            }
            if (descTbl.isSetTupleDescriptors()) {
                for (TTupleDescriptor tupleDesc : descTbl.tupleDescriptors) {
                    if (!tupleDesc.isSetTableId() || seenTableIds.contains(tupleDesc.tableId)) continue;
                    throw new IllegalStateException("TableDescriptor does not include table idof:\n" + tupleDesc.toString());
                }
            }
        }
        if (execRequest.isSetPlan_exec_info() && !execRequest.plan_exec_info.isEmpty() && (firstPlanFragment = (TPlanFragment)((TPlanExecInfo)execRequest.plan_exec_info.get((int)0)).fragments.get(0)).isSetOutput_sink() && firstPlanFragment.output_sink.isSetTable_sink()) {
            TTableSink tableSink = firstPlanFragment.output_sink.table_sink;
            if (!seenTableIds.contains(tableSink.target_table_id) || tableSink.target_table_id != 0 && !tableSink.isSetIceberg_delete_sink()) {
                throw new IllegalStateException("Table sink id error for target table:\n" + tableSink.toString());
            }
        }
    }

    private TExecRequest testPlan(TestFileParser.TestCase testCase, TestFileParser.Section section, TQueryCtx queryCtx, Set<PlannerTestOption> testOptions, StringBuilder errorLog, StringBuilder actualOutput) {
        ArrayList<String> expectedPlan;
        String query = testCase.getQuery();
        queryCtx.client_request.setStmt(query);
        TQueryOptions queryOptions = queryCtx.client_request.getQuery_options();
        if (section == TestFileParser.Section.PLAN) {
            queryOptions.setNum_nodes(1);
        } else {
            queryOptions.setNum_nodes(0);
        }
        if (!(section != TestFileParser.Section.PARALLELPLANS || queryOptions.isSetMt_dop() && queryOptions.getMt_dop() != 0)) {
            queryCtx.client_request.query_options.setMt_dop(2);
        }
        boolean sectionExists = (expectedPlan = testCase.getSectionContents(section)) != null && !expectedPlan.isEmpty();
        String expectedErrorMsg = this.getExpectedErrorMessage(expectedPlan);
        TExecRequest execRequest = null;
        if (sectionExists) {
            actualOutput.append(section.getHeader() + "\n");
        }
        String explainStr = "";
        try {
            Frontend.PlanCtx planCtx = new Frontend.PlanCtx(queryCtx);
            planCtx.disableDescTblSerialization();
            execRequest = frontend_.createExecRequest(planCtx);
            explainStr = planCtx.getExplainString();
        }
        catch (Exception e) {
            if (!sectionExists) {
                return null;
            }
            this.handleException(query, expectedErrorMsg, errorLog, actualOutput, e);
        }
        if (!sectionExists) {
            return execRequest;
        }
        if (execRequest == null) {
            return null;
        }
        explainStr = this.removeExplainHeader(explainStr, testOptions);
        actualOutput.append(explainStr);
        LOG.info(section.toString() + ":" + explainStr);
        if (expectedErrorMsg != null) {
            errorLog.append(String.format("\nExpected failure, but query produced %s.\nQuery:\n%s\n\n%s:\n%s", new Object[]{section, query, section, explainStr}));
        } else {
            String planDiff;
            ArrayList resultFilters = Lists.newArrayList((Object[])new TestUtils.ResultFilter[]{TestUtils.FILE_SIZE_FILTER});
            if (!testOptions.contains((Object)PlannerTestOption.VALIDATE_RESOURCES)) {
                resultFilters.addAll(TestUtils.RESOURCE_FILTERS);
            }
            if (!testOptions.contains((Object)PlannerTestOption.VALIDATE_CARDINALITY)) {
                resultFilters.add(TestUtils.ROW_SIZE_FILTER);
                resultFilters.add(TestUtils.CARDINALITY_FILTER);
            }
            if (!testOptions.contains((Object)PlannerTestOption.VALIDATE_SCAN_FS)) {
                resultFilters.add(TestUtils.SCAN_NODE_SCHEME_FILTER);
            }
            if (testOptions.contains((Object)PlannerTestOption.DO_NOT_VALIDATE_ROWCOUNT_ESTIMATION_FOR_PARTITIONS)) {
                resultFilters.add(TestUtils.PARTITIONS_FILTER);
            }
            if (!testOptions.contains((Object)PlannerTestOption.VALIDATE_ICEBERG_SNAPSHOT_IDS)) {
                resultFilters.add(TestUtils.ICEBERG_SNAPSHOT_ID_FILTER);
            }
            if (!(planDiff = TestUtils.compareOutput(Lists.newArrayList((Object[])explainStr.split("\n")), expectedPlan, true, resultFilters)).isEmpty()) {
                errorLog.append(String.format("\nSection %s of query at %s:\n%s\n\n%s", new Object[]{section, testCase.getFileNameAndLineNum(), query, planDiff}));
                if (!testOptions.contains((Object)PlannerTestOption.EXTENDED_EXPLAIN)) {
                    String verbosePlan = this.getVerboseExplainPlan(queryCtx);
                    errorLog.append("\nVerbose plan:\n" + verbosePlan);
                }
            }
        }
        return execRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVerboseExplainPlan(TQueryCtx queryCtx) {
        String explainStr;
        TExecRequest execRequest = null;
        TExplainLevel origExplainLevel = queryCtx.client_request.getQuery_options().getExplain_level();
        try {
            queryCtx.client_request.getQuery_options().setExplain_level(TExplainLevel.VERBOSE);
            Frontend.PlanCtx planCtx = new Frontend.PlanCtx(queryCtx);
            planCtx.disableDescTblSerialization();
            execRequest = frontend_.createExecRequest(planCtx);
            explainStr = planCtx.getExplainString();
        }
        catch (ImpalaException e) {
            String string = ExceptionUtils.getStackTrace((Throwable)e);
            return string;
        }
        finally {
            queryCtx.client_request.getQuery_options().setExplain_level(origExplainLevel);
        }
        Preconditions.checkNotNull((Object)execRequest);
        return this.removeExplainHeader(explainStr, Collections.emptySet());
    }

    private void checkScanRangeLocations(TestFileParser.TestCase testCase, TExecRequest execRequest, StringBuilder errorLog, StringBuilder actualOutput) {
        String query = testCase.getQuery();
        String locationsStr = null;
        if (execRequest != null && execRequest.isSetQuery_exec_request()) {
            if (execRequest.query_exec_request.plan_exec_info == null) {
                return;
            }
            this.buildMaps(execRequest.query_exec_request);
            TQueryOptions options = execRequest.getQuery_options();
            if (!options.isSetOptimize_partition_key_scans() || !options.optimize_partition_key_scans) {
                this.testHdfsPartitionsReferenced(execRequest.query_exec_request, query, errorLog);
            }
            locationsStr = this.printScanRangeLocations(execRequest.query_exec_request).toString();
        }
        LOG.info("scan range locations: " + locationsStr);
        ArrayList<String> expectedLocations = testCase.getSectionContents(TestFileParser.Section.SCANRANGELOCATIONS);
        if (expectedLocations.size() > 0 && locationsStr != null) {
            String result = TestUtils.compareOutput(Lists.newArrayList((Object[])locationsStr.split("\n")), expectedLocations, false, Collections.emptyList());
            if (!result.isEmpty()) {
                errorLog.append("section " + (Object)((Object)TestFileParser.Section.SCANRANGELOCATIONS) + " of query:\n" + query + "\n" + result);
            }
            actualOutput.append(TestFileParser.Section.SCANRANGELOCATIONS.getHeader() + "\n");
            ArrayList locations = Lists.newArrayList((Object[])locationsStr.split("\n"));
            ArrayList perNodeLocations = Lists.newArrayList();
            for (int i = 0; i < locations.size(); ++i) {
                if (((String)locations.get(i)).startsWith("NODE")) {
                    if (!perNodeLocations.isEmpty()) {
                        Collections.sort(perNodeLocations);
                        actualOutput.append(Joiner.on((String)"\n").join((Iterable)perNodeLocations)).append("\n");
                        perNodeLocations.clear();
                    }
                    actualOutput.append((String)locations.get(i)).append("\n");
                    continue;
                }
                perNodeLocations.add(locations.get(i));
            }
            if (!perNodeLocations.isEmpty()) {
                Collections.sort(perNodeLocations);
                actualOutput.append(Joiner.on((String)"\n").join((Iterable)perNodeLocations)).append("\n");
            }
        }
    }

    private void checkLimitCardinality(String query, TExecRequest execRequest, StringBuilder errorLog) {
        if (execRequest == null) {
            return;
        }
        if (!execRequest.isSetQuery_exec_request() || execRequest.query_exec_request == null || execRequest.query_exec_request.plan_exec_info == null) {
            return;
        }
        for (TPlanExecInfo execInfo : execRequest.query_exec_request.plan_exec_info) {
            for (TPlanFragment planFragment : execInfo.fragments) {
                if (!planFragment.isSetPlan() || planFragment.plan == null) continue;
                for (TPlanNode node : planFragment.plan.nodes) {
                    if (!node.isSetLimit() || -1L == node.limit || !node.isSetEstimated_stats() || node.estimated_stats == null || node.limit >= node.estimated_stats.cardinality) continue;
                    StringBuilder limitCardinalityError = new StringBuilder();
                    limitCardinalityError.append("Query: " + query + "\n");
                    limitCardinalityError.append("Expected cardinality estimate less than or equal to LIMIT: " + node.limit + "\n");
                    limitCardinalityError.append("Actual cardinality estimate: " + node.estimated_stats.cardinality + "\n");
                    limitCardinalityError.append("In node id " + node.node_id + "\n");
                    errorLog.append(limitCardinalityError.toString());
                }
            }
        }
    }

    protected void checkCardinality(String query, long min, long max) throws ImpalaException {
        TQueryCtx queryCtx = TestUtils.createQueryContext("default", System.getProperty("user.name"));
        queryCtx.client_request.setStmt(query);
        Frontend.PlanCtx planCtx = new Frontend.PlanCtx(queryCtx);
        planCtx.disableDescTblSerialization();
        TExecRequest execRequest = frontend_.createExecRequest(planCtx);
        if (!execRequest.isSetQuery_exec_request() || execRequest.query_exec_request == null || execRequest.query_exec_request.plan_exec_info == null) {
            return;
        }
        for (TPlanExecInfo execInfo : execRequest.query_exec_request.plan_exec_info) {
            for (TPlanFragment planFragment : execInfo.fragments) {
                if (!planFragment.isSetPlan() || planFragment.plan == null) continue;
                for (TPlanNode node : planFragment.plan.nodes) {
                    long cardinality;
                    if (node.estimated_stats == null) {
                        Assert.fail((String)("Query: " + query + " has no estimated statistics"));
                    }
                    if ((cardinality = node.estimated_stats.cardinality) >= min && cardinality <= max) continue;
                    StringBuilder errorLog = new StringBuilder();
                    errorLog.append("Query: " + query + "\n");
                    errorLog.append("Expected cardinality estimate between " + min + " and " + max + "\n");
                    errorLog.append("Actual cardinality estimate: " + cardinality + "\n");
                    errorLog.append("In node id " + node.node_id + "\n");
                    Assert.fail((String)errorLog.toString());
                }
            }
        }
    }

    private void checkColumnLineage(TestFileParser.TestCase testCase, TExecRequest execRequest, StringBuilder errorLog, StringBuilder actualOutput) {
        String query = testCase.getQuery();
        ArrayList<String> expectedLineage = testCase.getSectionContents(TestFileParser.Section.LINEAGE);
        if (expectedLineage == null || expectedLineage.isEmpty()) {
            return;
        }
        if (execRequest == null) {
            errorLog.append("Failed to execute query:\n" + query + "\n");
            return;
        }
        TLineageGraph lineageGraph = null;
        if (execRequest.isSetQuery_exec_request()) {
            lineageGraph = execRequest.query_exec_request.lineage_graph;
        } else if (execRequest.isSetCatalog_op_request()) {
            lineageGraph = execRequest.catalog_op_request.lineage_graph;
        }
        ArrayList<String> expected = testCase.getSectionContents(TestFileParser.Section.LINEAGE);
        if (expected.size() > 0 && lineageGraph != null) {
            String serializedGraph = Joiner.on((String)"\n").join(expected);
            ColumnLineageGraph expectedGraph = ColumnLineageGraph.createFromJSON((String)serializedGraph);
            ColumnLineageGraph outputGraph = ColumnLineageGraph.fromThrift((TLineageGraph)lineageGraph);
            if (expectedGraph == null || outputGraph == null || !outputGraph.equalsForTests((Object)expectedGraph)) {
                StringBuilder lineageError = new StringBuilder();
                lineageError.append("section " + (Object)((Object)TestFileParser.Section.LINEAGE) + " of query:\n" + query + "\n");
                lineageError.append("Output:");
                lineageError.append(TestUtils.prettyPrintJson(outputGraph.toJson() + "\n"));
                lineageError.append("\nExpected:\n");
                lineageError.append(serializedGraph + "\n");
                errorLog.append(lineageError.toString());
            }
            actualOutput.append(TestFileParser.Section.LINEAGE.getHeader());
            actualOutput.append(TestUtils.prettyPrintJson(outputGraph.toJson()));
            actualOutput.append("\n");
        }
    }

    private String removeExplainHeader(String explain, Set<PlannerTestOption> testOptions) {
        if (testOptions.contains((Object)PlannerTestOption.INCLUDE_EXPLAIN_HEADER)) {
            return explain;
        }
        boolean keepResources = testOptions.contains((Object)PlannerTestOption.INCLUDE_RESOURCE_HEADER);
        boolean keepQueryWithImplicitCasts = testOptions.contains((Object)PlannerTestOption.INCLUDE_QUERY_WITH_IMPLICIT_CASTS);
        StringBuilder builder = new StringBuilder();
        boolean inHeader = true;
        boolean inImplictCasts = false;
        for (String line : explain.split("\n")) {
            if (inHeader) {
                if (line.isEmpty()) {
                    inHeader = false;
                    continue;
                }
                if (keepResources && line.contains("Resource")) {
                    builder.append(line).append("\n");
                    continue;
                }
                if (!keepQueryWithImplicitCasts || !(inImplictCasts |= line.contains("Analyzed query:"))) continue;
                builder.append(line).append("\n");
                continue;
            }
            builder.append(line).append("\n");
        }
        return builder.toString();
    }

    protected int getRowSize(String query, TQueryOptions queryOptions) {
        TQueryCtx queryCtx = TestUtils.createQueryContext("default", System.getProperty("user.name"));
        queryCtx.client_request.setStmt(query);
        Frontend.PlanCtx planCtx = new Frontend.PlanCtx(queryCtx);
        queryCtx.client_request.query_options = queryOptions;
        try {
            TExecRequest tExecRequest = frontend_.createExecRequest(planCtx);
        }
        catch (ImpalaException e) {
            Assert.fail((String)("Failed to create exec request for '" + query + "': " + e.getMessage()));
        }
        String explainStr = planCtx.getExplainString();
        Pattern rowSizePattern = Pattern.compile("row-size=([0-9]*)B");
        Matcher m = rowSizePattern.matcher(explainStr);
        boolean matchFound = m.find();
        Assert.assertTrue((String)"Row size not found in plan.", (boolean)matchFound);
        String rowSizeStr = m.group(1);
        return Integer.valueOf(rowSizeStr);
    }

    protected void runPlannerTestFile(String testFile, TQueryOptions options) {
        this.runPlannerTestFile(testFile, "default", options, Collections.emptySet());
    }

    protected void runPlannerTestFile(String testFile, TQueryOptions options, Set<PlannerTestOption> testOptions) {
        this.runPlannerTestFile(testFile, "default", options, testOptions);
    }

    protected void runPlannerTestFile(String testFile, Set<PlannerTestOption> testOptions) {
        this.runPlannerTestFile(testFile, "default", this.defaultQueryOptions(), testOptions);
    }

    protected void runPlannerTestFile(String testFile, String dbName, Set<PlannerTestOption> testOptions) {
        this.runPlannerTestFile(testFile, dbName, this.defaultQueryOptions(), testOptions);
    }

    protected void runPlannerTestFile(String testFile, String dbName, TQueryOptions options) {
        this.runPlannerTestFile(testFile, dbName, options, Collections.emptySet());
    }

    protected void runPlannerTestFile(String testFile, String dbName, TQueryOptions options, Set<PlannerTestOption> testOptions) {
        String fileName = testDir_.resolve(testFile + ".test").toString();
        options = options == null ? this.defaultQueryOptions() : this.mergeQueryOptions(this.defaultQueryOptions(), options);
        if (testOptions.contains((Object)PlannerTestOption.EXTENDED_EXPLAIN)) {
            options.setExplain_level(TExplainLevel.EXTENDED);
        }
        TestFileParser queryFileParser = new TestFileParser(fileName, options);
        StringBuilder actualOutput = new StringBuilder();
        queryFileParser.parseFile();
        StringBuilder errorLog = new StringBuilder();
        for (TestFileParser.TestCase testCase : queryFileParser.getTestCases()) {
            actualOutput.append(testCase.getSectionAsString(TestFileParser.Section.QUERY, true, "\n"));
            actualOutput.append("\n");
            String neededHiveMajorVersion = testCase.getSectionAsString(TestFileParser.Section.HIVE_MAJOR_VERSION, false, "");
            if (neededHiveMajorVersion != null && !neededHiveMajorVersion.isEmpty() && Integer.parseInt(neededHiveMajorVersion) != TestUtils.getHiveMajorVersion()) {
                actualOutput.append("Skipping test case (needs Hive major version: ");
                actualOutput.append(neededHiveMajorVersion);
                actualOutput.append(")\n");
                actualOutput.append("====\n");
                continue;
            }
            String queryOptionsSection = testCase.getSectionAsString(TestFileParser.Section.QUERYOPTIONS, true, "\n");
            if (queryOptionsSection != null && !queryOptionsSection.isEmpty()) {
                actualOutput.append("---- QUERYOPTIONS\n");
                actualOutput.append(queryOptionsSection);
                actualOutput.append("\n");
            }
            try {
                this.runTestCase(testCase, errorLog, actualOutput, dbName, testOptions);
            }
            catch (CatalogException e) {
                errorLog.append(String.format("Failed to plan query\n%s\n%s", testCase.getQuery(), e.getMessage()));
            }
            actualOutput.append("====\n");
        }
        try {
            outDir_.toFile().mkdirs();
            FileWriter fw = new FileWriter(outDir_.resolve(testFile + ".test").toFile());
            fw.write(actualOutput.toString());
            fw.close();
        }
        catch (IOException e) {
            errorLog.append("Unable to create output file: " + e.getMessage());
        }
        if (errorLog.length() != 0) {
            Assert.fail((String)errorLog.toString());
        }
    }

    protected void runPlannerTestFile(String testFile) {
        this.runPlannerTestFile(testFile, "default", this.defaultQueryOptions(), Collections.emptySet());
    }

    protected void runPlannerTestFile(String testFile, String dbName) {
        this.runPlannerTestFile(testFile, dbName, this.defaultQueryOptions(), Collections.emptySet());
    }

    protected boolean scanRangeLocationsCheckEnabled() {
        return true;
    }

    protected static Map<String, Map<String, SideloadTableStats>> loadStatsJson(String statsJsonPath) {
        String fileName = testDir_.resolve(statsJsonPath).toString();
        StatsJsonParser statsParser = new StatsJsonParser(fileName);
        statsParser.parseFile();
        return statsParser.getDbStatsMap();
    }

    protected static enum PlannerTestOption {
        EXTENDED_EXPLAIN,
        INCLUDE_EXPLAIN_HEADER,
        INCLUDE_RESOURCE_HEADER,
        INCLUDE_QUERY_WITH_IMPLICIT_CASTS,
        VALIDATE_RESOURCES,
        VALIDATE_CARDINALITY,
        VALIDATE_SCAN_FS,
        DISABLE_HDFS_NUM_ROWS_ESTIMATE,
        DO_NOT_VALIDATE_ROWCOUNT_ESTIMATION_FOR_PARTITIONS,
        VALIDATE_ICEBERG_SNAPSHOT_IDS;

    }
}

