/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.metrics.ScanMetricsResult;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.HBaseColumn;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.datagenerator.HBaseTestDataRegionAssignment;
import org.apache.impala.planner.HBaseScanNode;
import org.apache.impala.planner.IcebergScanPlanner;
import org.apache.impala.planner.PlannerTestBase;
import org.apache.impala.service.Frontend;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TExecRequest;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TJoinDistributionMode;
import org.apache.impala.thrift.TKuduReplicaSelection;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TRuntimeFilterMode;
import org.apache.impala.thrift.TRuntimeFilterType;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PlannerTest
extends PlannerTestBase {
    @BeforeClass
    public static void setUp() throws Exception {
        PlannerTestBase.setUp();
        HBaseTestDataRegionAssignment assignment = new HBaseTestDataRegionAssignment();
        assignment.performAssignment("functional_hbase.alltypessmall");
        assignment.performAssignment("functional_hbase.alltypesagg");
        assignment.close();
    }

    private void runCardinalityVerifyingTest(String test_file) {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDisable_hdfs_num_rows_estimate(true);
        this.runPlannerTestFile(test_file, options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testScanCardinality() {
        this.runPlannerTestFile("card-scan", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testInnerJoinCardinality() {
        this.runPlannerTestFile("card-inner-join", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testOuterJoinCardinality() {
        this.runPlannerTestFile("card-outer-join", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testMultiJoinCardinality() {
        this.runPlannerTestFile("card-multi-join", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testAggCardinality() {
        this.runPlannerTestFile("card-agg", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testPredicatePropagation() {
        this.runPlannerTestFile("predicate-propagation");
    }

    @Test
    public void testConstant() {
        this.runPlannerTestFile("constant");
    }

    @Test
    public void testConstantFolding() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setUtf8_mode(false);
        this.runPlannerTestFile("constant-folding", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestBase.PlannerTestOption.INCLUDE_QUERY_WITH_IMPLICIT_CASTS)));
        options.setUtf8_mode(true);
        this.runPlannerTestFile("constant-folding-utf8-mode", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestBase.PlannerTestOption.INCLUDE_QUERY_WITH_IMPLICIT_CASTS)));
    }

    @Test
    public void testConstantPropagation() {
        this.runPlannerTestFile("constant-propagation");
    }

    @Test
    public void testEmpty() {
        this.runPlannerTestFile("empty", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testDistinct() {
        this.runPlannerTestFile("distinct");
    }

    @Test
    public void testMultipleDistinct() {
        this.runCardinalityVerifyingTest("multiple-distinct");
    }

    @Test
    public void testMultipleDistinctMaterialization() {
        this.runCardinalityVerifyingTest("multiple-distinct-materialization");
    }

    @Test
    public void testMultipleDistinctPredicates() {
        this.runCardinalityVerifyingTest("multiple-distinct-predicates");
    }

    @Test
    public void testMultipleDistinctLimit() {
        this.runCardinalityVerifyingTest("multiple-distinct-limit");
    }

    @Test
    public void testShuffleByDistinctExprs() {
        this.runCardinalityVerifyingTest("shuffle-by-distinct-exprs");
    }

    @Test
    public void testAggregation() {
        this.runCardinalityVerifyingTest("aggregation");
    }

    @Test
    public void testAggregationNoTupleAnalysis() {
        Set<PlannerTestBase.PlannerTestOption> testOptions = PlannerTest.tpcdsParquetTestOptions();
        TQueryOptions options = PlannerTest.tpcdsParquetQueryOptions();
        this.runPlannerTestFile("aggregation-no-tuple-analysis", "tpcds_parquet", options, testOptions);
    }

    @Test
    public void testGroupingSets() {
        this.runPlannerTestFile("grouping-sets");
    }

    @Test
    public void testAnalyticFns() {
        this.runPlannerTestFile("analytic-fns", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testAnalyticFnsMtDop() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setMt_dop(4);
        this.runPlannerTestFile("analytic-fns-mt-dop", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testAnalyticRankPushdown() {
        this.runPlannerTestFile("analytic-rank-pushdown");
    }

    @Test
    public void testHbase() {
        this.runPlannerTestFile("hbase");
    }

    @Test
    public void testHbaseNoKeyEstimate() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDisable_hbase_num_rows_estimate(true);
        this.runPlannerTestFile("hbase-no-key-est", options);
    }

    @Test
    public void testInsert() {
        this.runPlannerTestFile("insert");
    }

    @Test
    public void testInsertDefaultClustered() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDefault_hints_insert_statement("clustered");
        this.runPlannerTestFile("insert-default-clustered", options);
    }

    @Test
    public void testInsertDefaultNoClustered() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDefault_hints_insert_statement("noclustered  ");
        this.runPlannerTestFile("insert-default-noclustered", options);
    }

    @Test
    public void testInsertDefaultShuffle() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDefault_hints_insert_statement("shuffle");
        this.runPlannerTestFile("insert-default-shuffle", options);
    }

    @Test
    public void testInsertDefaultNoShuffle() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDefault_hints_insert_statement("  noshuffle ");
        this.runPlannerTestFile("insert-default-noshuffle", options);
    }

    @Test
    public void testInsertDefaultClusteredShuffle() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDefault_hints_insert_statement("clustered:shuffle");
        this.runPlannerTestFile("insert-default-clustered-shuffle", options);
    }

    @Test
    public void testInsertDefaultClusteredNoShuffle() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDefault_hints_insert_statement("clustered : noshuffle");
        this.runPlannerTestFile("insert-default-clustered-noshuffle", options);
    }

    @Test
    public void testInsertDefaultNoClusteredShuffle() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDefault_hints_insert_statement("  noclustered:  shuffle");
        this.runPlannerTestFile("insert-default-noclustered-shuffle", options);
    }

    @Test
    public void testInsertDefaultNoClusteredNoShuffle() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDefault_hints_insert_statement("  noclustered  :  noshuffle  ");
        this.runPlannerTestFile("insert-default-noclustered-noshuffle", options);
    }

    @Test
    public void testInsertSortBy() {
        this.addTestDb("test_sort_by", "Test DB for SORT BY clause.");
        this.addTestTable("create table test_sort_by.t (id int, int_col int, bool_col boolean) partitioned by (year int, month int) sort by (int_col, bool_col) location '/'");
        this.addTestTable("create table test_sort_by.t_nopart (id int, int_col int, bool_col boolean) sort by (int_col, bool_col) location '/'");
        this.runPlannerTestFile("insert-sort-by", "test_sort_by");
    }

    @Test
    public void testInsertSortByZorder() {
        this.addTestDb("test_sort_by_zorder", "Test DB for SORT BY ZORDER clause.");
        this.addTestTable("create table test_sort_by_zorder.t (id int, int_col int, bool_col boolean) partitioned by (year int, month int) sort by zorder (int_col, bool_col) location '/'");
        this.addTestTable("create table test_sort_by_zorder.t_nopart (id int, int_col int, bool_col boolean) sort by zorder (int_col, bool_col) location '/'");
        this.runPlannerTestFile("insert-sort-by-zorder", "test_sort_by_zorder");
    }

    @Test
    public void testHdfsInsertWriterLimit() {
        this.addTestDb("test_hdfs_insert_writer_limit", "Test DB for MAX_FS_WRITERS query option.");
        this.addTestTable("create table test_hdfs_insert_writer_limit.partitioned_table (id int) partitioned by (year int, month int) location '/'");
        this.addTestTable("create table test_hdfs_insert_writer_limit.unpartitioned_table (id int) location '/'");
        this.runPlannerTestFile("insert-hdfs-writer-limit", "test_hdfs_insert_writer_limit", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestBase.PlannerTestOption.DO_NOT_VALIDATE_ROWCOUNT_ESTIMATION_FOR_PARTITIONS)));
    }

    @Test
    public void testHdfs() {
        this.runPlannerTestFile("hdfs");
    }

    @Test
    public void testNestedCollections() {
        TQueryOptions options = new TQueryOptions();
        options.setMinmax_filter_sorted_columns(false);
        this.runPlannerTestFile("nested-collections", options);
    }

    @Test
    public void testComplexTypesFileFormats() {
        this.runPlannerTestFile("complex-types-file-formats");
    }

    @Test
    public void testZippingUnnest() {
        this.addTestDb("test_zipping_unnest_db", "For creating views for zipping unnest queries.");
        this.addTestView("create view test_zipping_unnest_db.view_arrays as select id, arr1, arr2 from functional_parquet.complextypes_arrays");
        this.runPlannerTestFile("zipping-unnest");
    }

    @Test
    public void testJoins() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDisable_hdfs_num_rows_estimate(false);
        this.runPlannerTestFile("joins-hdfs-num-rows-est-enabled", options);
    }

    @Test
    public void testJoinsWithHDFSNumRowsEstDisabled() {
        this.runCardinalityVerifyingTest("joins");
    }

    @Test
    public void testJoinOrder() {
        this.runPlannerTestFile("join-order", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testOuterJoins() {
        this.runPlannerTestFile("outer-joins", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testImplicitJoins() {
        this.runPlannerTestFile("implicit-joins", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testFkPkJoinDetection() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDisable_hdfs_num_rows_estimate(false);
        this.runPlannerTestFile("fk-pk-join-detection-hdfs-num-rows-est-enabled", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestBase.PlannerTestOption.DO_NOT_VALIDATE_ROWCOUNT_ESTIMATION_FOR_PARTITIONS)));
    }

    @Test
    public void testFkPkJoinDetectionWithHDFSNumRowsEstDisabled() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDisable_hdfs_num_rows_estimate(true);
        options.setMinmax_filter_threshold(0.0);
        this.runPlannerTestFile("fk-pk-join-detection", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testOrder() {
        this.runPlannerTestFile("order");
    }

    @Test
    public void testTopN() {
        TQueryOptions options = new TQueryOptions();
        options.setTopn_bytes_limit(0L);
        this.runPlannerTestFile("topn", options);
    }

    @Test
    public void testTopNBytesLimit() {
        this.runPlannerTestFile("topn-bytes-limit");
    }

    @Test
    public void testTopNBytesLimitSmall() {
        TQueryOptions options = new TQueryOptions();
        options.setTopn_bytes_limit(6L);
        this.runPlannerTestFile("topn-bytes-limit-small", options);
    }

    @Test
    public void testInlineView() {
        this.runPlannerTestFile("inline-view");
    }

    @Test
    public void testInlineViewLimit() {
        this.runPlannerTestFile("inline-view-limit");
    }

    @Test
    public void testSubqueryRewrite() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDisable_hdfs_num_rows_estimate(false);
        this.runPlannerTestFile("subquery-rewrite-hdfs-num-rows-est-enabled", options);
    }

    @Test
    public void testSubqueryRewriteWithHDFSNumRowsEstDisabled() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDisable_hdfs_num_rows_estimate(true);
        this.runPlannerTestFile("subquery-rewrite", options);
    }

    @Test
    public void testSemiJoinDistinct() {
        this.runPlannerTestFile("semi-join-distinct");
    }

    @Test
    public void testUnion() {
        this.runPlannerTestFile("union");
    }

    @Test
    public void testSetOperationRewrite() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setMinmax_filter_threshold(0.0);
        this.runPlannerTestFile("setoperation-rewrite", options);
    }

    @Test
    public void testRewrite() {
        this.runPlannerTestFile("rewrite");
    }

    @Test
    public void testValues() {
        this.runPlannerTestFile("values");
    }

    @Test
    public void testViews() {
        this.runPlannerTestFile("views");
    }

    @Test
    public void testWithClause() {
        this.runPlannerTestFile("with-clause");
    }

    @Test
    public void testDistinctEstimate() {
        this.runPlannerTestFile("distinct-estimate");
    }

    @Test
    public void testDataSourceTables() {
        this.runPlannerTestFile("data-source-tables");
    }

    @Test
    public void testPartitionKeyScans() {
        TQueryOptions options = new TQueryOptions();
        options.setOptimize_partition_key_scans(true);
        this.runPlannerTestFile("partition-key-scans", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testPartitionKeyScansDefault() {
        TQueryOptions options = new TQueryOptions();
        this.runPlannerTestFile("partition-key-scans-default", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testLineage() {
        this.runPlannerTestFile("lineage");
    }

    @Test
    public void testDdl() {
        this.runPlannerTestFile("ddl");
    }

    @Test
    public void testTpch() {
        this.runPlannerTestFile("tpch-all", "tpch", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.INCLUDE_RESOURCE_HEADER), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_RESOURCES), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testTpchViews() {
        this.addTestDb("tpch_views", "Test DB for TPCH with views.");
        Db tpchDb = catalog_.getDb("tpch");
        for (String tblName : tpchDb.getAllTableNames()) {
            this.addTestView(String.format("create view tpch_views.%s as select * from tpch.%s", tblName, tblName));
        }
        this.runPlannerTestFile("tpch-views", "tpch_views");
    }

    @Test
    public void testTpchNested() {
        TQueryOptions options = new TQueryOptions();
        options.setMinmax_filter_sorted_columns(false);
        this.runPlannerTestFile("tpch-nested", "tpch_nested_parquet", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.INCLUDE_RESOURCE_HEADER), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_RESOURCES), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testSmallQueryOptimization() {
        TQueryOptions options = new TQueryOptions();
        options.setExec_single_node_rows_threshold(8);
        this.addTestDb("kudu_planner_test", "Test DB for Kudu Planner.");
        this.addTestTable("CREATE EXTERNAL TABLE kudu_planner_test.no_stats STORED AS KUDU TBLPROPERTIES ('kudu.table_name' = 'impala::functional_kudu.alltypes');");
        this.runPlannerTestFile("small-query-opt", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testDisableCodegenOptimization() {
        TQueryOptions options = new TQueryOptions();
        options.setDisable_codegen_rows_threshold(3000);
        this.runPlannerTestFile("disable-codegen", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.INCLUDE_EXPLAIN_HEADER)));
    }

    @Test
    public void testSingleNodeNlJoin() {
        TQueryOptions options = new TQueryOptions();
        options.setNum_nodes(1);
        this.runPlannerTestFile("nested-loop-join", options);
    }

    @Test
    public void testMemLimit() {
        TQueryOptions options = new TQueryOptions();
        options.setMem_limit(5000L);
        this.runPlannerTestFile("mem-limit-broadcast-join", options);
    }

    @Test
    public void testDisablePreaggregations() {
        TQueryOptions options = new TQueryOptions();
        options.setDisable_streaming_preaggregations(true);
        this.runPlannerTestFile("disable-preaggregations", options);
    }

    @Test
    public void testRuntimeFilterPropagation() {
        TQueryOptions options = new TQueryOptions();
        options.setRuntime_filter_mode(TRuntimeFilterMode.GLOBAL);
        this.runPlannerTestFile("runtime-filter-propagation", options);
    }

    @Test
    public void testDisableRuntimeOverlapFilter() {
        TQueryOptions options = new TQueryOptions();
        options.setMinmax_filter_threshold(0.0);
        this.runPlannerTestFile("disable-runtime-overlap-filter", options);
        options.setMinmax_filter_threshold(1.0);
        options.unsetEnabled_runtime_filter_types();
        options.addToEnabled_runtime_filter_types(TRuntimeFilterType.BLOOM);
        this.runPlannerTestFile("disable-runtime-overlap-filter", options);
    }

    @Test
    public void testRuntimeFilterQueryOptions() {
        this.runPlannerTestFile("runtime-filter-query-options", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DO_NOT_VALIDATE_ROWCOUNT_ESTIMATION_FOR_PARTITIONS)));
    }

    @Test
    public void testBloomFilterAssignment() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setMinmax_filter_sorted_columns(false);
        options.setMinmax_filter_partition_columns(false);
        this.runPlannerTestFile("bloom-filter-assignment", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DO_NOT_VALIDATE_ROWCOUNT_ESTIMATION_FOR_PARTITIONS)));
    }

    @Test
    public void testConjunctOrdering() {
        this.runPlannerTestFile("conjunct-ordering");
    }

    @Test
    public void testParquetStatsAgg() {
        this.runPlannerTestFile("parquet-stats-agg");
    }

    @Test
    public void testParquetFiltering() {
        this.runPlannerTestFile("parquet-filtering", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestBase.PlannerTestOption.DO_NOT_VALIDATE_ROWCOUNT_ESTIMATION_FOR_PARTITIONS)));
    }

    @Test
    public void testParquetFilteringDisabled() {
        TQueryOptions options = new TQueryOptions();
        options.setParquet_dictionary_filtering(false);
        options.setParquet_read_statistics(false);
        this.runPlannerTestFile("parquet-filtering-disabled", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestBase.PlannerTestOption.DO_NOT_VALIDATE_ROWCOUNT_ESTIMATION_FOR_PARTITIONS)));
    }

    @Test
    public void testKudu() {
        TQueryOptions options = this.defaultQueryOptions();
        options.unsetEnabled_runtime_filter_types();
        options.addToEnabled_runtime_filter_types(TRuntimeFilterType.BLOOM);
        options.addToEnabled_runtime_filter_types(TRuntimeFilterType.MIN_MAX);
        this.runPlannerTestFile("kudu", options);
    }

    @Test
    public void testKuduUpsert() {
        this.runPlannerTestFile("kudu-upsert");
    }

    @Test
    public void testKuduUpdate() {
        TQueryOptions options = this.defaultQueryOptions();
        options.unsetEnabled_runtime_filter_types();
        options.addToEnabled_runtime_filter_types(TRuntimeFilterType.BLOOM);
        options.addToEnabled_runtime_filter_types(TRuntimeFilterType.MIN_MAX);
        this.runPlannerTestFile("kudu-update", options);
    }

    @Test
    public void testKuduDelete() {
        this.runPlannerTestFile("kudu-delete");
    }

    @Test
    public void testKuduSelectivity() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setExplain_level(TExplainLevel.VERBOSE);
        this.runPlannerTestFile("kudu-selectivity", options);
    }

    @Test
    public void testKuduReplicaSelection() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setExplain_level(TExplainLevel.VERBOSE);
        options.setKudu_replica_selection(TKuduReplicaSelection.LEADER_ONLY);
        this.runPlannerTestFile("kudu-replica-selection-leader-only", options);
        options.setKudu_replica_selection(TKuduReplicaSelection.CLOSEST_REPLICA);
        this.runPlannerTestFile("kudu-replica-selection-closest-replica", options);
    }

    @Test
    public void testKuduTpch() {
        TQueryOptions options = this.defaultQueryOptions();
        options.unsetEnabled_runtime_filter_types();
        options.addToEnabled_runtime_filter_types(TRuntimeFilterType.BLOOM);
        options.addToEnabled_runtime_filter_types(TRuntimeFilterType.MIN_MAX);
        this.runPlannerTestFile("tpch-kudu", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.INCLUDE_RESOURCE_HEADER), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_RESOURCES)));
    }

    @Test
    public void testKuduStatsAgg() {
        this.runPlannerTestFile("kudu-stats-agg");
    }

    @Test
    public void testKuduDmlWithUtcConversion() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setExplain_level(TExplainLevel.VERBOSE);
        options.setWrite_kudu_utc_timestamps(true);
        options.setConvert_kudu_utc_timestamps(true);
        this.runPlannerTestFile("kudu-dml-with-utc-conversion", options);
    }

    @Test
    public void testMtDopValidation() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setMt_dop(3);
        options.setDisable_hdfs_num_rows_estimate(true);
        options.setExplain_level(TExplainLevel.EXTENDED);
        this.runPlannerTestFile("mt-dop-validation", options);
    }

    @Test
    public void testComputeStatsMtDop() {
        for (int mtDop : new int[]{-1, 0, 1, 16}) {
            int effectiveMtDop = mtDop != -1 ? mtDop : 0;
            this.testEffectiveMtDop("select * from functional_parquet.alltypes", mtDop, effectiveMtDop);
            int computeStatsEffectiveMtDop = mtDop != -1 ? mtDop : 4;
            this.testEffectiveMtDop("compute stats functional_parquet.alltypes", mtDop, computeStatsEffectiveMtDop);
            this.testEffectiveMtDop("compute stats functional.alltypes", mtDop, computeStatsEffectiveMtDop);
            this.testEffectiveMtDop("compute stats functional_kudu.alltypes", mtDop, computeStatsEffectiveMtDop);
        }
    }

    private void testEffectiveMtDop(String stmt, int userMtDop, int expectedMtDop) {
        TQueryCtx queryCtx = TestUtils.createQueryContext("default", System.getProperty("user.name"));
        queryCtx.client_request.setStmt(stmt);
        queryCtx.client_request.query_options = this.defaultQueryOptions();
        if (userMtDop != -1) {
            queryCtx.client_request.query_options.setMt_dop(userMtDop);
        }
        TExecRequest request = null;
        try {
            Frontend.PlanCtx planCtx = new Frontend.PlanCtx(queryCtx);
            request = frontend_.createExecRequest(planCtx);
        }
        catch (ImpalaException e) {
            Assert.fail((String)("Failed to create exec request for '" + stmt + "': " + e.getMessage()));
        }
        Preconditions.checkNotNull((Object)request);
        int actualMtDop = -1;
        if (request.query_options.isSetMt_dop()) {
            actualMtDop = request.query_options.mt_dop;
        }
        Assert.assertEquals((long)actualMtDop, (long)expectedMtDop);
    }

    @Test
    public void testOnlyNeededStructFieldsMaterialized() throws ImpalaException {
        TQueryOptions queryOpts = this.defaultQueryOptions();
        String queryWholeStruct = "select outer_struct from functional_orc_def.complextypes_nested_structs";
        int rowSizeWholeStruct = this.getRowSize(queryWholeStruct, queryOpts);
        String queryWholeStructFromInlineView = "with sub as (select id, outer_struct from functional_orc_def.complextypes_nested_structs)select sub.outer_struct from sub";
        int rowSizeWholeStructFromInlineView = this.getRowSize(queryWholeStructFromInlineView, queryOpts);
        String queryOneField = "select outer_struct.str from functional_orc_def.complextypes_nested_structs";
        int rowSizeOneField = this.getRowSize(queryOneField, queryOpts);
        String queryOneFieldFromInlineView = "with sub as (select id, outer_struct from functional_orc_def.complextypes_nested_structs)select sub.outer_struct.str from sub";
        int rowSizeOneFieldFromInlineView = this.getRowSize(queryOneFieldFromInlineView, queryOpts);
        String queryTwoFields = "select outer_struct.str, outer_struct.inner_struct1 from functional_orc_def.complextypes_nested_structs";
        int rowSizeTwoFields = this.getRowSize(queryTwoFields, queryOpts);
        String queryTwoFieldsFromInlineView = "with sub as (select id, outer_struct from functional_orc_def.complextypes_nested_structs)select sub.outer_struct.str, sub.outer_struct.inner_struct1 from sub";
        int rowSizeTwoFieldsFromInlineView = this.getRowSize(queryTwoFieldsFromInlineView, queryOpts);
        Assert.assertEquals((long)rowSizeWholeStruct, (long)rowSizeWholeStructFromInlineView);
        Assert.assertEquals((long)rowSizeOneField, (long)rowSizeOneFieldFromInlineView);
        Assert.assertEquals((long)rowSizeTwoFields, (long)rowSizeTwoFieldsFromInlineView);
        Assert.assertTrue((rowSizeOneField < rowSizeTwoFields ? 1 : 0) != 0);
        Assert.assertTrue((rowSizeTwoFields < rowSizeWholeStruct ? 1 : 0) != 0);
    }

    @Test
    public void testStructFieldSlotSharedWithStruct() throws ImpalaException {
        TQueryOptions queryOpts = this.defaultQueryOptions();
        String queryTemplate = "select %s from functional_orc_def.complextypes_nested_structs";
        String queryWithoutFields = String.format(queryTemplate, "outer_struct");
        int rowSizeWithoutFields = this.getRowSize(queryWithoutFields, queryOpts);
        String[] fields = new String[]{"outer_struct", "outer_struct.str", "outer_struct.inner_struct3", "outer_struct.inner_struct3.s"};
        Collection permutations = Collections2.permutations(Arrays.asList(fields));
        for (List permutation : permutations) {
            String query = String.format(queryTemplate, String.join((CharSequence)", ", permutation));
            int rowSize = this.getRowSize(query, queryOpts);
            Assert.assertEquals((long)rowSizeWithoutFields, (long)rowSize);
        }
    }

    @Test
    public void testStructFieldSlotSharedWithStructFromStarExpansion() throws ImpalaException {
        TQueryOptions queryOpts = this.defaultQueryOptions();
        queryOpts.setExpand_complex_types(true);
        String queryTemplate = "select %s from functional_orc_def.complextypes_nested_structs";
        String queryWithoutFields = String.format(queryTemplate, "*");
        int rowSizeWithoutFields = this.getRowSize(queryWithoutFields, queryOpts);
        String[] fields = new String[]{"*", "outer_struct", "outer_struct.inner_struct1", "outer_struct.inner_struct1.str"};
        Collection permutations = Collections2.permutations(Arrays.asList(fields));
        for (List permutation : permutations) {
            String query = String.format(queryTemplate, String.join((CharSequence)", ", permutation));
            int rowSize = this.getRowSize(query, queryOpts);
            Assert.assertEquals((long)rowSizeWithoutFields, (long)rowSize);
        }
    }

    @Test
    public void testResourceRequirements() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setNum_scanner_threads(1);
        options.setMinmax_filter_threshold(0.0);
        options.setDisable_hdfs_num_rows_estimate(true);
        this.runPlannerTestFile("resource-requirements", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestBase.PlannerTestOption.INCLUDE_EXPLAIN_HEADER), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_RESOURCES)));
    }

    @Test
    public void testSpillableBufferSizing() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setExplain_level(TExplainLevel.EXTENDED);
        options.setNum_scanner_threads(1);
        options.setMinmax_filter_threshold(0.0);
        options.setDisable_hdfs_num_rows_estimate(true);
        this.runPlannerTestFile("spillable-buffer-sizing", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestBase.PlannerTestOption.INCLUDE_EXPLAIN_HEADER), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_RESOURCES)));
    }

    @Test
    public void testMaxRowSize() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setExplain_level(TExplainLevel.EXTENDED);
        options.setNum_scanner_threads(1);
        options.setMinmax_filter_threshold(0.0);
        options.setMax_row_size(0x800000L);
        this.runPlannerTestFile("max-row-size", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestBase.PlannerTestOption.INCLUDE_EXPLAIN_HEADER), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_RESOURCES)));
    }

    @Test
    public void testSortExprMaterialization() {
        this.addTestFunction("TestFn", Lists.newArrayList((Object[])new ScalarType[]{Type.DOUBLE}), false);
        TQueryOptions options = this.defaultQueryOptions();
        options.setAnalytic_rank_pushdown_threshold(0L);
        this.runPlannerTestFile("sort-expr-materialization", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN)));
    }

    @Test
    public void testTableSample() {
        TQueryOptions options = this.defaultQueryOptions();
        this.runPlannerTestFile("tablesample", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestBase.PlannerTestOption.DO_NOT_VALIDATE_ROWCOUNT_ESTIMATION_FOR_PARTITIONS)));
    }

    @Test
    public void testTableSampleIceberg() {
        TQueryOptions options = this.defaultQueryOptions();
        this.runPlannerTestFile("tablesample-iceberg", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestBase.PlannerTestOption.DO_NOT_VALIDATE_ROWCOUNT_ESTIMATION_FOR_PARTITIONS), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_ICEBERG_SNAPSHOT_IDS), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testDefaultJoinDistributionBroadcastMode() {
        TQueryOptions options = this.defaultQueryOptions();
        Preconditions.checkState((options.getDefault_join_distribution_mode() == TJoinDistributionMode.BROADCAST ? 1 : 0) != 0);
        this.runPlannerTestFile("default-join-distr-mode-broadcast", options);
    }

    @Test
    public void testDefaultJoinDistributionShuffleMode() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDefault_join_distribution_mode(TJoinDistributionMode.SHUFFLE);
        options.setDisable_hdfs_num_rows_estimate(false);
        this.runPlannerTestFile("default-join-distr-mode-shuffle-hdfs-num-rows-est-enabled", options);
    }

    @Test
    public void testDefaultJoinDistributionShuffleModeWithHDFSNumRowsEstDisabled() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDefault_join_distribution_mode(TJoinDistributionMode.SHUFFLE);
        options.setDisable_hdfs_num_rows_estimate(true);
        this.runPlannerTestFile("default-join-distr-mode-shuffle", options);
    }

    @Test
    public void testPartitionPruning() {
        this.runPlannerTestFile("partition-pruning", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN)));
    }

    @Test
    public void testComputeStatsDisableSpill() throws ImpalaException {
        TQueryCtx queryCtx = TestUtils.createQueryContext("default", System.getProperty("user.name"));
        TExecRequest requestWithDisableSpillOn = null;
        queryCtx.client_request.setStmt("compute stats functional.alltypes");
        queryCtx.client_request.query_options = this.defaultQueryOptions();
        Frontend.PlanCtx planCtx = new Frontend.PlanCtx(queryCtx);
        frontend_.createExecRequest(planCtx);
        queryCtx.client_request.setStmt("select * from functional.alltypes");
        queryCtx.client_request.query_options.setDisable_unsafe_spills(true);
        planCtx = new Frontend.PlanCtx(queryCtx);
        requestWithDisableSpillOn = frontend_.createExecRequest(planCtx);
        Assert.assertNotNull((Object)requestWithDisableSpillOn);
    }

    @Test
    public void testMinMaxRuntimeFilters() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setExplain_level(TExplainLevel.EXTENDED);
        options.setDisable_hdfs_num_rows_estimate(false);
        options.unsetEnabled_runtime_filter_types();
        options.addToEnabled_runtime_filter_types(TRuntimeFilterType.MIN_MAX);
        this.runPlannerTestFile("min-max-runtime-filters-hdfs-num-rows-est-enabled", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DO_NOT_VALIDATE_ROWCOUNT_ESTIMATION_FOR_PARTITIONS)));
    }

    @Test
    public void testMinMaxRuntimeFiltersWithHDFSNumRowsEstDisabled() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setExplain_level(TExplainLevel.EXTENDED);
        options.setDisable_hdfs_num_rows_estimate(true);
        options.setMinmax_filter_partition_columns(false);
        options.unsetEnabled_runtime_filter_types();
        options.addToEnabled_runtime_filter_types(TRuntimeFilterType.MIN_MAX);
        this.runPlannerTestFile("min-max-runtime-filters", options);
    }

    @Test
    public void testCardinalityOverflow() throws ImpalaException {
        String tblName = "tpch.cardinality_overflow";
        String colDefs = "(l_orderkey BIGINT, l_partkey BIGINT, l_suppkey BIGINT, l_linenumber INT, l_shipmode STRING, l_comment STRING)";
        String tblLocation = "LOCATION 'hdfs://localhost:20500/test-warehouse/tpch.lineitem'";
        String tblPropsTemplate = "TBLPROPERTIES('numRows'='%s')";
        String tblProps = String.format(tblPropsTemplate, Long.toString(Long.MAX_VALUE));
        this.addTestTable(String.format("CREATE EXTERNAL TABLE %s %s %s %s;", tblName, colDefs, tblLocation, tblProps));
        String query = "select * from tpch.cardinality_overflow a,tpch.cardinality_overflow b, tpch.cardinality_overflow c";
        this.checkCardinality(query, 0L, Long.MAX_VALUE);
        query = "select a.l_comment from tpch.cardinality_overflow a full outer join tpch.cardinality_overflow b on a.l_orderkey = b.l_partkey";
        this.checkCardinality(query, 0L, Long.MAX_VALUE);
        query = "select l_shipmode from tpch.cardinality_overflow union select l_comment from tpch.cardinality_overflow";
        this.checkCardinality(query, 0L, Long.MAX_VALUE);
        query = "select a.l_comment from tpch.cardinality_overflow a inner join tpch.cardinality_overflow b on a.l_linenumber < b.l_orderkey";
        this.checkCardinality(query, 0L, Long.MAX_VALUE);
        tblName = "tpch.ex_customer_cardinality_zero";
        tblProps = String.format(tblPropsTemplate, 0);
        this.addTestTable(String.format("CREATE EXTERNAL TABLE  %s %s %s %s;", tblName, colDefs, tblLocation, tblProps));
        query = "select * from tpch.ex_customer_cardinality_zero";
        this.checkCardinality(query, 0L, 0L);
        tblName = "tpch.ex_customer_cardinality_neg";
        tblProps = String.format(tblPropsTemplate, -1);
        this.addTestTable(String.format("CREATE EXTERNAL TABLE  %s %s %s %s;", tblName, colDefs, tblLocation, tblProps));
        query = "select * from tpch.ex_customer_cardinality_neg";
        this.checkCardinality(query, -1L, Long.MAX_VALUE);
        tblName = "functional_parquet.cardinality_overflow";
        colDefs = "(id BIGINT, int_array ARRAY<INT>)";
        String storedAs = "STORED AS PARQUET";
        tblLocation = "LOCATION 'hdfs://localhost:20500/test-warehouse/complextypestbl_parquet'";
        tblProps = String.format(tblPropsTemplate, Long.toString(Long.MAX_VALUE));
        this.addTestTable(String.format("CREATE EXTERNAL TABLE  %s %s %s %s %s;", tblName, colDefs, storedAs, tblLocation, tblProps));
        query = "select id from functional_parquet.cardinality_overflow t, t.int_array";
        this.checkCardinality(query, 0L, Long.MAX_VALUE);
    }

    @Test
    public void testHBaseScanNodeMemEstimates() {
        HBaseColumn intCol = new HBaseColumn("", ":key", "", false, (Type)Type.INT, "", 1);
        Assert.assertEquals((long)HBaseScanNode.memoryEstimateForFetchingColumns((List)Lists.newArrayList((Object[])new HBaseColumn[]{intCol})), (long)8L);
        HBaseColumn stringColWithoutStats = new HBaseColumn("", ":key", "", false, (Type)Type.STRING, "", 1);
        Assert.assertEquals((long)HBaseScanNode.memoryEstimateForFetchingColumns((List)Lists.newArrayList((Object[])new HBaseColumn[]{stringColWithoutStats})), (long)65536L);
        HBaseColumn stringColwithSmallMaxSize = new HBaseColumn("", ":key", "", false, (Type)Type.STRING, "", 1);
        stringColwithSmallMaxSize.getStats().update((Type)Type.STRING, ColumnStats.StatsKey.MAX_SIZE, (Number)50L);
        Assert.assertEquals((long)HBaseScanNode.memoryEstimateForFetchingColumns((List)Lists.newArrayList((Object[])new HBaseColumn[]{stringColwithSmallMaxSize})), (long)128L);
        HBaseColumn stringColwithLargeMaxSize = new HBaseColumn("", ":key", "", false, (Type)Type.STRING, "", 1);
        stringColwithLargeMaxSize.getStats().update((Type)Type.STRING, ColumnStats.StatsKey.MAX_SIZE, (Number)0x8000000L);
        Assert.assertEquals((long)HBaseScanNode.memoryEstimateForFetchingColumns((List)Lists.newArrayList((Object[])new HBaseColumn[]{stringColwithLargeMaxSize, stringColWithoutStats})), (long)0x8000000L);
        HBaseColumn intNonKeyCol = new HBaseColumn("", "columnFamily", "columnQualifier", false, (Type)Type.INT, "", 1);
        Assert.assertEquals((long)HBaseScanNode.memoryEstimateForFetchingColumns((List)Lists.newArrayList((Object[])new HBaseColumn[]{intNonKeyCol})), (long)64L);
        Assert.assertEquals((long)HBaseScanNode.memoryEstimateForFetchingColumns((List)Lists.newArrayList((Object[])new HBaseColumn[]{stringColwithLargeMaxSize, intNonKeyCol})), (long)0x20000000L);
        ArrayList<HBaseColumn> largeColumnList = new ArrayList<HBaseColumn>();
        largeColumnList.add(stringColwithSmallMaxSize);
        for (int i = 0; i < 100; ++i) {
            largeColumnList.add(stringColWithoutStats);
        }
        Assert.assertEquals((long)HBaseScanNode.memoryEstimateForFetchingColumns(largeColumnList), (long)0x800000L);
    }

    @Test
    public void testFilters() {
        TestUtils.IgnoreValueFilter filter = TestUtils.CARDINALITY_FILTER;
        Assert.assertEquals((Object)" foo=bar cardinality=", (Object)filter.transform(" foo=bar cardinality=10"));
        Assert.assertEquals((Object)" foo=bar cardinality=", (Object)filter.transform(" foo=bar cardinality=10.3K"));
        Assert.assertEquals((Object)" foo=bar cardinality=", (Object)filter.transform(" foo=bar cardinality=unavailable"));
        Assert.assertEquals((Object)" foo=bar cardinality=", (Object)filter.transform(" foo=bar cardinality=1.58K(filtered from 2.88M)"));
        filter = TestUtils.ROW_SIZE_FILTER;
        Assert.assertEquals((Object)" row-size= cardinality=10.3K", (Object)filter.transform(" row-size=10B cardinality=10.3K"));
        filter = TestUtils.PARTITIONS_FILTER;
        Assert.assertEquals((Object)" partitions: 0/24 rows=", (Object)filter.transform(" partitions: 0/24 rows=10.3K"));
    }

    @Test
    public void testScanNodeFsScheme() {
        this.addTestTable("CREATE TABLE abfs_tbl (col int) LOCATION 'abfs://dummy-fs@dummy-account.dfs.core.windows.net/abfs_tbl'");
        this.addTestTable("CREATE TABLE abfss_tbl (col int) LOCATION 'abfss://dummy-fs@dummy-account.dfs.core.windows.net/abfs_tbl'");
        this.addTestTable("CREATE TABLE adl_tbl (col int) LOCATION 'adl://dummy-account.azuredatalakestore.net/adl_tbl'");
        this.addTestTable("CREATE TABLE s3a_tbl (col int) LOCATION 's3a://dummy-bucket/s3_tbl'");
        this.runPlannerTestFile("scan-node-fs-scheme", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_SCAN_FS)));
    }

    @Test
    public void testResultSpooling() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setExplain_level(TExplainLevel.EXTENDED);
        options.setSpool_query_results(true);
        options.setNum_scanner_threads(1);
        this.runPlannerTestFile("result-spooling", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestBase.PlannerTestOption.INCLUDE_RESOURCE_HEADER), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_RESOURCES)));
    }

    @Test
    public void testBroadcastBytesLimit() {
        TQueryOptions options = new TQueryOptions();
        options.setBroadcast_bytes_limit(100L);
        this.runPlannerTestFile("broadcast-bytes-limit", "tpch_parquet", options);
        options.setBroadcast_bytes_limit(1000000L);
        this.runPlannerTestFile("broadcast-bytes-limit-large", "tpch_parquet", options);
    }

    @Test
    public void testPreaggBytesLimit() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setPreagg_bytes_limit(0x4000000L);
        options.setExplain_level(TExplainLevel.EXTENDED);
        this.runPlannerTestFile("preagg-bytes-limit", "tpch_parquet", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_RESOURCES)));
    }

    @Test
    public void testConvertToCNF() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setMinmax_filter_threshold(0.0);
        this.runPlannerTestFile("convert-to-cnf", "tpch_parquet", options);
    }

    @Test
    public void testAcidTableScans() {
        this.runPlannerTestFile("acid-scans", "functional_orc_def", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DO_NOT_VALIDATE_ROWCOUNT_ESTIMATION_FOR_PARTITIONS)));
    }

    @Test
    public void testIcebergPredicates() {
        this.runPlannerTestFile("iceberg-predicates", "functional_parquet", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testIcebergMixedFileFormat() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setExplain_level(TExplainLevel.VERBOSE);
        this.runPlannerTestFile("iceberg-mixed-file-format", "functional_parquet", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testDisabledIcebergPredicateSubsetting() {
        TQueryOptions queryOptions = new TQueryOptions();
        queryOptions.setIceberg_predicate_pushdown_subsetting(false);
        this.runPlannerTestFile("iceberg-predicates-disabled-subsetting", "functional_parquet", queryOptions, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_ICEBERG_SNAPSHOT_IDS)));
    }

    @Test
    public void testIcebergV2TableScans() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setTimezone("UTC");
        this.runPlannerTestFile("iceberg-v2-tables", "functional_parquet", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_ICEBERG_SNAPSHOT_IDS)));
    }

    @Test
    public void testIcebergV2TableScansWithResources() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setTimezone("UTC");
        this.runPlannerTestFile("iceberg-v2-tables-resources", "functional_parquet", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_ICEBERG_SNAPSHOT_IDS), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_RESOURCES)));
    }

    @Test
    public void testIcebergV2TableScansHashJoin() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDisable_optimized_iceberg_v2_read(true);
        this.runPlannerTestFile("iceberg-v2-tables-hash-join", "functional_parquet", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_ICEBERG_SNAPSHOT_IDS)));
    }

    @Test
    public void testIcebergV2Delete() {
        this.runPlannerTestFile("iceberg-v2-delete", "functional_parquet", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_ICEBERG_SNAPSHOT_IDS)));
    }

    @Test
    public void testIcebergV2Update() {
        this.runPlannerTestFile("iceberg-v2-update", "functional_parquet", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testIcebergOptimize() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setMax_fs_writers(2);
        options.setExplain_level(TExplainLevel.EXTENDED);
        this.runPlannerTestFile("iceberg-optimize", "functional_parquet", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testIcebergMetadataTableScans() {
        this.runPlannerTestFile("iceberg-metadata-table-scan", "functional_parquet", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
        TQueryOptions options = this.defaultQueryOptions();
        options.setExplain_level(TExplainLevel.EXTENDED);
        this.runPlannerTestFile("iceberg-metadata-table-joined-with-regular-table", "functional_parquet", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DO_NOT_VALIDATE_ROWCOUNT_ESTIMATION_FOR_PARTITIONS)));
    }

    @Test
    public void testLimitPushdownAnalytic() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setAnalytic_rank_pushdown_threshold(0L);
        this.runPlannerTestFile("limit-pushdown-analytic", options);
    }

    @Test
    public void testLimitPushdownPartitionedTopN() {
        TQueryOptions options = this.defaultQueryOptions();
        options.setDisable_hdfs_num_rows_estimate(true);
        this.runPlannerTestFile("limit-pushdown-partitioned-top-n", options);
    }

    @Test
    public void testSimplifyOuterJoins() {
        TQueryOptions options = new TQueryOptions();
        options.setEnable_outer_join_to_inner_transformation(true);
        this.runPlannerTestFile("outer-to-inner-joins", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testSimpleLimitOptimization() {
        TQueryOptions options = new TQueryOptions();
        options.setOptimize_simple_limit(true);
        this.runPlannerTestFile("optimize-simple-limit", options);
    }

    @Test
    public void testDistributionMethod() {
        this.runPlannerTestFile("tpcds-dist-method", "tpcds");
    }

    @Test
    public void testOrcStatsAgg() {
        this.runPlannerTestFile("orc-stats-agg");
    }

    @Test
    public void testTableCardinalityHint() {
        this.runPlannerTestFile("table-cardinality-hint", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testExplainVerboseMtDop() {
        this.runPlannerTestFile("explain-verbose-mt_dop", "tpcds_parquet", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.INCLUDE_RESOURCE_HEADER)));
    }

    @Test
    public void testProcessingCost() {
        TQueryOptions options = PlannerTest.tpcdsParquetQueryOptions();
        options.setCompute_processing_cost(true);
        options.setProcessing_cost_min_threads(2);
        this.runPlannerTestFile("tpcds-processing-cost", "tpcds_partitioned_parquet_snap", options, PlannerTest.tpcdsParquetTestOptions());
    }

    @Test
    public void testProcessingCostPlanAdmissionSlots() {
        TQueryOptions options = PlannerTest.tpcdsParquetQueryOptions();
        this.runPlannerTestFile("processing-cost-plan-admission-slots", "tpcds_partitioned_parquet_snap", options, PlannerTest.tpcdsParquetTestOptions());
    }

    @Test
    public void testPredicateSelectivityHints() {
        this.runPlannerTestFile("predicate-selectivity-hint", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testAggNodeMaxMemEstimate() {
        Set<PlannerTestBase.PlannerTestOption> testOptions = PlannerTest.tpcdsParquetTestOptions();
        TQueryOptions options = PlannerTest.tpcdsParquetQueryOptions();
        options.setAgg_mem_correlation_factor(0.0);
        options.setLarge_agg_mem_threshold(0x20000000L);
        this.runPlannerTestFile("agg-node-max-mem-estimate", "tpcds_parquet", options, testOptions);
        options.setAgg_mem_correlation_factor(0.5);
        options.setLarge_agg_mem_threshold(0L);
        this.runPlannerTestFile("agg-node-max-mem-estimate", "tpcds_parquet", options, testOptions);
    }

    @Test
    public void testAggNodeLowMemEstimate() {
        Set<PlannerTestBase.PlannerTestOption> testOptions = PlannerTest.tpcdsParquetTestOptions();
        TQueryOptions options = PlannerTest.tpcdsParquetQueryOptions();
        options.setAgg_mem_correlation_factor(0.9);
        this.runPlannerTestFile("agg-node-low-mem-estimate", "tpcds_parquet", options, testOptions);
    }

    @Test
    public void testAggNodeHighMemEstimate() {
        Set<PlannerTestBase.PlannerTestOption> testOptions = PlannerTest.tpcdsParquetTestOptions();
        TQueryOptions options = PlannerTest.tpcdsParquetQueryOptions();
        options.setAgg_mem_correlation_factor(0.1);
        this.runPlannerTestFile("agg-node-high-mem-estimate", "tpcds_parquet", options, testOptions);
    }

    @Test
    public void testRuntimeFilterCardinalityReduction() {
        this.runPlannerTestFile("runtime-filter-cardinality-reduction", "tpcds_parquet", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testRuntimeFilterCardinalityReductionOnKudu() {
        this.runPlannerTestFile("runtime-filter-cardinality-reduction-on-kudu", "tpch_kudu", (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.VALIDATE_CARDINALITY)));
    }

    @Test
    public void testEqualityDeleteFieldIdOrdering() {
        HashMap inp = Maps.newHashMap();
        inp.put(Lists.newArrayList((Object[])new Integer[]{2, 3}), 2L);
        inp.put(Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), 2L);
        inp.put(Lists.newArrayList((Object[])new Integer[]{1, 2}), 2L);
        inp.put(Lists.newArrayList((Object[])new Integer[]{4}), 3L);
        inp.put(Lists.newArrayList((Object[])new Integer[]{1}), 3L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new ArrayList[]{Lists.newArrayList((Object[])new Integer[]{1}), Lists.newArrayList((Object[])new Integer[]{4}), Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), Lists.newArrayList((Object[])new Integer[]{1, 2}), Lists.newArrayList((Object[])new Integer[]{2, 3})}), (Object)IcebergScanPlanner.getOrderedEqualityFieldIds((Map)inp));
    }

    @Test
    public void testManyExpressionPerformance() {
        this.addTestDb("test_many_expressions", "Test DB for many-expression perf test.");
        this.addTestTable("create table test_many_expressions.i6bd46c0a (i20868d03 bigint, i89d57f06 bigint, idc633f9e bigint, i9e32db9e bigint, ic02dc181 date, ia74a4bc0 string, i3ee20502 bigint, ic05c995e bigint, i49dcf5c5 string, i99bd997e string, i510ab56c string, i11be1ec1 bigint, i81012615 bigint) location '/'");
        this.runPlannerTestFile("many-expression", "test_many_expressions");
    }

    @Test
    public void testRuntimeFilterRepeatedExpr() {
        this.runPlannerTestFile("runtime-filter-repeated-expr", "functional");
    }

    @Test
    public void testIcebergMerge() {
        this.runPlannerTestFile("iceberg-merge");
        TQueryOptions options = new TQueryOptions();
        this.runPlannerTestFile("iceberg-merge-insert-only", options, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.EXTENDED_EXPLAIN), (Object)((Object)PlannerTestBase.PlannerTestOption.INCLUDE_EXPLAIN_HEADER)));
    }

    @Test
    public void testIcebergScanMetricsResultCardinality() {
        int expectedMethodNumber = 16;
        Method[] methods = ScanMetricsResult.class.getDeclaredMethods();
        long publicMethods = Arrays.stream(methods).filter(method -> {
            int modifiers = method.getModifiers();
            return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers);
        }).count();
        Assert.assertEquals((long)16L, (long)publicMethods);
    }
}

