/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.DescriptorTable;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.FrontendTestBase;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.HdfsScanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.thrift.TClientRequest;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ExplainTest
extends FrontendTestBase {
    @Test
    public void testScanNodeFsScheme() throws ImpalaException {
        ArrayList<HdfsPartition> partitions = new ArrayList<HdfsPartition>();
        String dummyDbName = "dummy-db";
        String dummyTblName = "dummy-tbl";
        String dummyTblPath = "hdfs://localhost/" + dummyDbName + "." + dummyTblName;
        FeDb mockDb = (FeDb)Mockito.mock(FeDb.class);
        Mockito.when((Object)mockDb.getName()).thenReturn((Object)dummyDbName);
        FeFsTable mockFeFsTable = this.createMockFeFsTable(partitions, dummyTblName, mockDb);
        TupleDescriptor tupleDescriptor = this.createMockTupleDescriptor(mockFeFsTable);
        TableRef mockTableRef = (TableRef)Mockito.mock(TableRef.class);
        Mockito.when((Object)mockTableRef.getTable()).thenReturn((Object)mockFeFsTable);
        partitions.add(this.createMockHdfsPartition("abfs://dummy-fs@dummy-account.dfs.core.windows.net/dummy-part-1", FileSystemUtil.FsType.ADLS));
        partitions.add(this.createMockHdfsPartition("abfs://dummy-fs@dummy-account.dfs.core.windows.net/dummy-part-2", FileSystemUtil.FsType.ADLS));
        partitions.add(this.createMockHdfsPartition("abfss://dummy-fs@dummy-account.dfs.core.windows.net/dummy-part-3", FileSystemUtil.FsType.ADLS));
        partitions.add(this.createMockHdfsPartition("abfss://dummy-fs@dummy-account.dfs.core.windows.net/dummy-part-4", FileSystemUtil.FsType.ADLS));
        partitions.add(this.createMockHdfsPartition("adl://dummy-account.azuredatalakestore.net/dummy-part-5", FileSystemUtil.FsType.ADLS));
        partitions.add(this.createMockHdfsPartition("adl://dummy-account.azuredatalakestore.net/dummy-part-6", FileSystemUtil.FsType.ADLS));
        partitions.add(this.createMockHdfsPartition("s3a://dummy-bucket/dummy-part-7", FileSystemUtil.FsType.S3));
        partitions.add(this.createMockHdfsPartition("s3a://dummy-bucket/dummy-part-8", FileSystemUtil.FsType.S3));
        partitions.add(this.createMockHdfsPartition(dummyTblPath + "/dummy-part-9", FileSystemUtil.FsType.HDFS));
        partitions.add(this.createMockHdfsPartition(dummyTblPath + "/dummy-part-10", FileSystemUtil.FsType.HDFS));
        HdfsScanNode hdfsScanNode = new HdfsScanNode((PlanNodeId)PlanNodeId.createGenerator().getNextId(), tupleDescriptor, new ArrayList(), partitions, mockTableRef, null, new ArrayList(), false);
        Analyzer mockAnalyer = this.createMockAnalyzer();
        hdfsScanNode.init(mockAnalyer);
        ArrayList explainString = Lists.newArrayList((Iterable)Splitter.on((char)'\n').omitEmptyStrings().trimResults().split((CharSequence)hdfsScanNode.getNodeExplainString("", "", TExplainLevel.STANDARD)));
        Assert.assertEquals((String)"Scan node explain string not of expected size", (long)4L, (long)explainString.size());
        Assert.assertTrue((String)"Scan node explain string does not contain correct base table scheme", (boolean)((String)explainString.get(0)).contains("SCAN HDFS"));
        Assert.assertTrue((String)"Scan node explain string does not correct ADLS metadata", (boolean)((String)explainString.get(1)).contains("ADLS partitions=6/10 files=6 size=6B"));
        Assert.assertTrue((String)"Scan node explain string does not correct HDFS metadata", (boolean)((String)explainString.get(2)).contains("HDFS partitions=2/10 files=2 size=2B"));
        Assert.assertTrue((String)"Scan node explain string does not correct S3 metadata", (boolean)((String)explainString.get(3)).contains("S3 partitions=2/10 files=2 size=2B"));
    }

    private TupleDescriptor createMockTupleDescriptor(FeFsTable mockFeFsTable) {
        TupleDescriptor tupleDescriptor = (TupleDescriptor)Mockito.mock(TupleDescriptor.class);
        Mockito.when((Object)tupleDescriptor.getTable()).thenReturn((Object)mockFeFsTable);
        Mockito.when((Object)tupleDescriptor.getId()).thenReturn((Object)TupleId.createGenerator().getNextId());
        Mockito.when((Object)tupleDescriptor.getPath()).thenReturn(Mockito.mock(Path.class));
        return tupleDescriptor;
    }

    private FeFsTable createMockFeFsTable(List<HdfsPartition> partitions, String dummyTblName, FeDb mockDb) {
        FeFsTable mockFeFsTable = (FeFsTable)Mockito.mock(FeFsTable.class);
        Mockito.when((Object)mockFeFsTable.getFsType()).thenReturn((Object)FileSystemUtil.FsType.HDFS);
        Mockito.when((Object)mockFeFsTable.getMetaStoreTable()).thenReturn(Mockito.mock(Table.class));
        ((FeFsTable)Mockito.doReturn(partitions).when((Object)mockFeFsTable)).getPartitions();
        Mockito.when((Object)mockFeFsTable.getDb()).thenReturn((Object)mockDb);
        Mockito.when((Object)mockFeFsTable.getName()).thenReturn((Object)dummyTblName);
        return mockFeFsTable;
    }

    private HdfsPartition createMockHdfsPartition(String path, FileSystemUtil.FsType fsType) {
        HdfsPartition mockHdfsPartition = (HdfsPartition)Mockito.mock(HdfsPartition.class);
        ArrayList<FileDescriptor> mockFilesDescs = new ArrayList<FileDescriptor>();
        FileDescriptor mockFileDesc = (FileDescriptor)Mockito.mock(FileDescriptor.class);
        Mockito.when((Object)mockFileDesc.getFileLength()).thenReturn((Object)1L);
        Mockito.when((Object)mockFileDesc.getRelativePath()).thenReturn((Object)"");
        Mockito.when((Object)mockFileDesc.getPath()).thenReturn((Object)"");
        mockFilesDescs.add(mockFileDesc);
        Mockito.when((Object)mockHdfsPartition.getLocationPath()).thenReturn((Object)new org.apache.hadoop.fs.Path(path));
        Mockito.when((Object)mockHdfsPartition.getLocation()).thenReturn((Object)path);
        Mockito.when((Object)mockHdfsPartition.getFileDescriptors()).thenReturn(mockFilesDescs);
        Mockito.when((Object)mockHdfsPartition.getFileFormat()).thenReturn((Object)HdfsFileFormat.PARQUET);
        Mockito.when((Object)mockHdfsPartition.getFsType()).thenReturn((Object)fsType);
        return mockHdfsPartition;
    }

    private Analyzer createMockAnalyzer() {
        Analyzer mockAnalyer = (Analyzer)Mockito.mock(Analyzer.class);
        TQueryCtx mockQueryCtx = (TQueryCtx)Mockito.mock(TQueryCtx.class);
        TClientRequest tClientRequest = (TClientRequest)Mockito.mock(TClientRequest.class);
        Mockito.when((Object)tClientRequest.getQuery_options()).thenReturn(Mockito.mock(TQueryOptions.class));
        mockQueryCtx.client_request = tClientRequest;
        DescriptorTable mockDescriptorTable = (DescriptorTable)Mockito.mock(DescriptorTable.class);
        Mockito.when((Object)mockDescriptorTable.getTupleDesc((TupleId)ArgumentMatchers.any())).thenReturn(Mockito.mock(TupleDescriptor.class));
        Mockito.when((Object)mockAnalyer.getQueryCtx()).thenReturn((Object)mockQueryCtx);
        Mockito.when((Object)mockAnalyer.getDescTbl()).thenReturn(Mockito.mock(DescriptorTable.class));
        Mockito.when((Object)mockAnalyer.getQueryOptions()).thenReturn(Mockito.mock(TQueryOptions.class));
        Mockito.when((Object)mockAnalyer.getDescTbl()).thenReturn((Object)mockDescriptorTable);
        Mockito.when((Object)mockAnalyer.getTupleDesc((TupleId)ArgumentMatchers.any())).thenReturn(Mockito.mock(TupleDescriptor.class));
        return mockAnalyer;
    }
}

