/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.impala.common.FrontendTestBase;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.service.Frontend;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TExecRequest;
import org.apache.impala.thrift.TQueryCtx;
import org.junit.Assert;
import org.junit.Test;

public class ColumnsTest
extends FrontendTestBase {
    private static final String ALLTYPES = "functional.alltypes";

    private void testColumns(String query, String db, List<String> select, List<String> where, List<String> join, List<String> aggregate, List<String> orderBy) {
        TQueryCtx queryCtx = TestUtils.createQueryContext(db, System.getProperty("user.name"));
        queryCtx.client_request.setStmt(query);
        Frontend.PlanCtx planCtx = new Frontend.PlanCtx(queryCtx);
        planCtx.disableDescTblSerialization();
        TExecRequest execRequest = null;
        try {
            execRequest = frontend_.createExecRequest(planCtx);
        }
        catch (ImpalaException e) {
            Assert.fail((String)e.toString());
        }
        Assert.assertNotNull((Object)execRequest);
        Assert.assertEquals(select, (Object)execRequest.getSelect_columns());
        Assert.assertEquals(where, (Object)execRequest.getWhere_columns());
        Assert.assertEquals(join, (Object)execRequest.getJoin_columns());
        Assert.assertEquals(aggregate, (Object)execRequest.getAggregate_columns());
        Assert.assertEquals(orderBy, (Object)execRequest.getOrderby_columns());
    }

    private void testColumns(String query, List<String> select, List<String> where, List<String> join, List<String> aggregate, List<String> orderBy) {
        this.testColumns(query, "default", select, where, join, aggregate, orderBy);
    }

    private List<String> fullColumns(String table, Stream<String> names) {
        return names.map(name -> table + "." + name).sorted().collect(Collectors.toList());
    }

    private List<String> allTypesColumns() {
        Stream<String> names = Stream.of("id", "bool_col", "tinyint_col", "smallint_col", "int_col", "bigint_col", "float_col", "double_col", "date_string_col", "string_col", "timestamp_col", "year", "month");
        return this.fullColumns(ALLTYPES, names);
    }

    @Test
    public void testOrderByAlias() {
        this.testColumns("select  dt.d_year \n       ,item.i_brand_id brand_id \n       ,item.i_brand brand\n       ,sum(ss_ext_sales_price) sum_agg\n from  date_dim dt \n      ,store_sales\n      ,item\n where dt.d_date_sk = store_sales.ss_sold_date_sk\n   and store_sales.ss_item_sk = item.i_item_sk\n   and item.i_manufact_id = 436\n   and dt.d_moy=12\n group by dt.d_year\n      ,item.i_brand\n      ,item.i_brand_id\n order by dt.d_year\n         ,sum_agg desc\n         ,brand_id\n limit 100", "tpcds", Stream.of("tpcds.date_dim.d_year", "tpcds.item.i_brand", "tpcds.item.i_brand_id", "tpcds.store_sales.ss_ext_sales_price").collect(Collectors.toList()), Stream.of("tpcds.date_dim.d_date_sk", "tpcds.date_dim.d_moy", "tpcds.item.i_item_sk", "tpcds.item.i_manufact_id", "tpcds.store_sales.ss_item_sk", "tpcds.store_sales.ss_sold_date_sk").collect(Collectors.toList()), Stream.of("tpcds.date_dim.d_date_sk", "tpcds.item.i_item_sk", "tpcds.store_sales.ss_item_sk", "tpcds.store_sales.ss_sold_date_sk").collect(Collectors.toList()), Stream.of("tpcds.date_dim.d_year", "tpcds.item.i_brand", "tpcds.item.i_brand_id").collect(Collectors.toList()), Stream.of("tpcds.date_dim.d_year", "tpcds.item.i_brand_id", "tpcds.store_sales.ss_ext_sales_price").collect(Collectors.toList()));
    }

    @Test
    public void testSelect() {
        this.testColumns("select count(*) from functional.alltypes", null, null, null, null, null);
        this.testColumns("select count(int_col), count(*) from functional.alltypes", this.fullColumns(ALLTYPES, Stream.of("int_col")), null, null, null, null);
        this.testColumns("select * from functional.alltypes", this.allTypesColumns(), null, null, null, null);
    }

    @Test
    public void testSelectWhereGroupOrder() {
        this.testColumns("select bool_col, int_col from functional.alltypes where smallint_col > 1 order by year, month", this.fullColumns(ALLTYPES, Stream.of("bool_col", "int_col")), this.fullColumns(ALLTYPES, Stream.of("smallint_col")), null, null, this.fullColumns(ALLTYPES, Stream.of("year", "month")));
        this.testColumns("select bool_col, sum(int_col) from functional.alltypes where smallint_col > 1 group by bool_col, year, month order by year, month", this.fullColumns(ALLTYPES, Stream.of("bool_col", "int_col")), this.fullColumns(ALLTYPES, Stream.of("smallint_col")), null, this.fullColumns(ALLTYPES, Stream.of("bool_col", "month", "year")), this.fullColumns(ALLTYPES, Stream.of("year", "month")));
    }

    @Test
    public void testSelectJoin() {
        this.testColumns("select a.month, sum(a.int_col) from functional.alltypes a join functional.alltypestiny b using (id) where a.year > 2000 and b.year > 2000 group by a.month order by a.month", this.fullColumns(ALLTYPES, Stream.of("month", "int_col")), (List<String>)ImmutableList.of((Object)"functional.alltypes.year", (Object)"functional.alltypestiny.year"), (List<String>)ImmutableList.of((Object)"functional.alltypes.id", (Object)"functional.alltypestiny.id"), (List<String>)ImmutableList.of((Object)"functional.alltypes.month"), (List<String>)ImmutableList.of((Object)"functional.alltypes.month"));
        this.testColumns("select a.month, sum(a.int_col) from functional.alltypes a, functional.alltypestiny b where a.id = b.id and a.year > 2000 and b.year > 2000 group by a.month order by a.month", this.fullColumns(ALLTYPES, Stream.of("month", "int_col")), (List<String>)ImmutableList.of((Object)"functional.alltypes.id", (Object)"functional.alltypes.year", (Object)"functional.alltypestiny.id", (Object)"functional.alltypestiny.year"), (List<String>)ImmutableList.of((Object)"functional.alltypes.id", (Object)"functional.alltypestiny.id"), (List<String>)ImmutableList.of((Object)"functional.alltypes.month"), (List<String>)ImmutableList.of((Object)"functional.alltypes.month"));
    }

    @Test
    public void testSelectJoinAcid() {
        this.testColumns("select a.month, sum(a.int_col) from functional.alltypes a, functional_orc_def.alltypes_deleted_rows b where a.id = b.id and a.year > 2000 and b.year > 2000 group by a.month order by a.month", this.fullColumns(ALLTYPES, Stream.of("month", "int_col")), (List<String>)ImmutableList.of((Object)"functional.alltypes.id", (Object)"functional.alltypes.year", (Object)"functional_orc_def.alltypes_deleted_rows.id", (Object)"functional_orc_def.alltypes_deleted_rows.year"), (List<String>)ImmutableList.of((Object)"functional.alltypes.id", (Object)"functional_orc_def.alltypes_deleted_rows.id", (Object)"functional_orc_def.alltypes_deleted_rows.month", (Object)"functional_orc_def.alltypes_deleted_rows.row__id", (Object)"functional_orc_def.alltypes_deleted_rows.year"), (List<String>)ImmutableList.of((Object)"functional.alltypes.month"), (List<String>)ImmutableList.of((Object)"functional.alltypes.month"));
    }

    @Test
    public void testSelectNestedLoopJoin() {
        this.testColumns("select DENSE_RANK() OVER (ORDER BY t1.day ASC) FROM functional.alltypesagg t1 WHERE EXISTS (SELECT t1.year AS int_col_1 FROM functional.alltypesagg t1)", (List<String>)ImmutableList.of((Object)"functional.alltypesagg.day", (Object)"functional.alltypesagg.year"), null, null, null, null);
        this.testColumns("select count(*) from tpch_parquet.lineitem, tpch_parquet.orders where l_orderkey = o_orderkey and (2 * log10(l_quantity) < 3 and cast(l_returnflag as varchar(2)) = 'Y') or l_quantity >= 50", null, (List<String>)ImmutableList.of((Object)"tpch_parquet.lineitem.l_orderkey", (Object)"tpch_parquet.lineitem.l_quantity", (Object)"tpch_parquet.lineitem.l_returnflag", (Object)"tpch_parquet.orders.o_orderkey"), (List<String>)ImmutableList.of((Object)"tpch_parquet.lineitem.l_orderkey", (Object)"tpch_parquet.lineitem.l_quantity", (Object)"tpch_parquet.lineitem.l_returnflag", (Object)"tpch_parquet.orders.o_orderkey"), null, null);
        this.testColumns("select count(*) from functional.alltypestiny a inner join functional.alltypessmall b on a.id < b.id right outer join functional.alltypesagg c on a.int_col != c.int_col right semi join functional.alltypes d on c.tinyint_col < d.tinyint_col right anti join functional.alltypesnopart e on d.tinyint_col > e.tinyint_col where e.id < 10", null, (List<String>)ImmutableList.of((Object)"functional.alltypesnopart.id"), (List<String>)ImmutableList.of((Object)"functional.alltypes.tinyint_col", (Object)"functional.alltypesagg.int_col", (Object)"functional.alltypesagg.tinyint_col", (Object)"functional.alltypesnopart.tinyint_col", (Object)"functional.alltypessmall.id", (Object)"functional.alltypestiny.id", (Object)"functional.alltypestiny.int_col"), null, null);
    }

    @Test
    public void testIcebergEqualityDeleteJoin() {
        this.testColumns("select * from functional_parquet.iceberg_v2_delete_equality", (List<String>)ImmutableList.of((Object)"functional_parquet.iceberg_v2_delete_equality.data", (Object)"functional_parquet.iceberg_v2_delete_equality.id"), null, (List<String>)ImmutableList.of((Object)"functional_parquet.iceberg_v2_delete_equality-EQUALITY-DELETE-01.iceberg__data__sequence__number", (Object)"functional_parquet.iceberg_v2_delete_equality-EQUALITY-DELETE-01.id", (Object)"functional_parquet.iceberg_v2_delete_equality.iceberg__data__sequence__number", (Object)"functional_parquet.iceberg_v2_delete_equality.id"), null, null);
    }

    @Test
    public void testGroupHaving() {
        this.testColumns("select c_name, c_custkey, o_orderkey, o_orderdate, o_totalprice, sum(l_quantity) from tpch.customer, tpch.orders, tpch.lineitem where o_orderkey in (select l_orderkey from tpch.lineitem group by l_orderkey having sum(l_quantity) > 300) and c_custkey = o_custkey and o_orderkey = l_orderkey group by c_name, c_custkey, o_orderkey, o_orderdate, o_totalprice order by o_totalprice desc, o_orderdate, o_orderkey limit 100", (List<String>)ImmutableList.of((Object)"tpch.customer.c_custkey", (Object)"tpch.customer.c_name", (Object)"tpch.lineitem.l_orderkey", (Object)"tpch.lineitem.l_quantity", (Object)"tpch.orders.o_orderdate", (Object)"tpch.orders.o_orderkey", (Object)"tpch.orders.o_totalprice"), (List<String>)ImmutableList.of((Object)"tpch.customer.c_custkey", (Object)"tpch.lineitem.l_orderkey", (Object)"tpch.orders.o_custkey", (Object)"tpch.orders.o_orderkey"), (List<String>)ImmutableList.of((Object)"tpch.customer.c_custkey", (Object)"tpch.lineitem.l_orderkey", (Object)"tpch.orders.o_custkey", (Object)"tpch.orders.o_orderkey"), (List<String>)ImmutableList.of((Object)"tpch.customer.c_custkey", (Object)"tpch.customer.c_name", (Object)"tpch.lineitem.l_orderkey", (Object)"tpch.lineitem.l_quantity", (Object)"tpch.orders.o_orderdate", (Object)"tpch.orders.o_orderkey", (Object)"tpch.orders.o_totalprice"), (List<String>)ImmutableList.of((Object)"tpch.orders.o_orderdate", (Object)"tpch.orders.o_orderkey", (Object)"tpch.orders.o_totalprice"));
    }

    @Test
    public void testUpdate() {
        this.testColumns("UPDATE functional_parquet.iceberg_v2_delete_positional SET `data` = concat(`data`,'a') where id = 15", (List<String>)ImmutableList.of((Object)"functional_parquet.iceberg_v2_delete_positional.data", (Object)"functional_parquet.iceberg_v2_delete_positional.file__position", (Object)"functional_parquet.iceberg_v2_delete_positional.id", (Object)"functional_parquet.iceberg_v2_delete_positional.input__file__name"), (List<String>)ImmutableList.of((Object)"functional_parquet.iceberg_v2_delete_positional.data", (Object)"functional_parquet.iceberg_v2_delete_positional.id"), (List<String>)ImmutableList.of((Object)"functional_parquet.iceberg_v2_delete_positional-POSITION-DELETE-01.file_path", (Object)"functional_parquet.iceberg_v2_delete_positional-POSITION-DELETE-01.pos", (Object)"functional_parquet.iceberg_v2_delete_positional.file__position", (Object)"functional_parquet.iceberg_v2_delete_positional.input__file__name"), null, null);
    }

    @Test
    public void testDelete() {
        this.testColumns("DELETE FROM functional_parquet.iceberg_v2_delete_positional where id = 15", (List<String>)ImmutableList.of((Object)"functional_parquet.iceberg_v2_delete_positional.file__position", (Object)"functional_parquet.iceberg_v2_delete_positional.input__file__name"), (List<String>)ImmutableList.of((Object)"functional_parquet.iceberg_v2_delete_positional.id"), (List<String>)ImmutableList.of((Object)"functional_parquet.iceberg_v2_delete_positional-POSITION-DELETE-01.file_path", (Object)"functional_parquet.iceberg_v2_delete_positional-POSITION-DELETE-01.pos", (Object)"functional_parquet.iceberg_v2_delete_positional.file__position", (Object)"functional_parquet.iceberg_v2_delete_positional.input__file__name"), null, null);
    }
}

