/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.planner.AggregationNode;
import org.apache.impala.planner.AnalyticEvalNode;
import org.apache.impala.planner.CardinalityCheckNode;
import org.apache.impala.planner.EmptySetNode;
import org.apache.impala.planner.ExchangeNode;
import org.apache.impala.planner.HashJoinNode;
import org.apache.impala.planner.HdfsScanNode;
import org.apache.impala.planner.HdfsTableSink;
import org.apache.impala.planner.KuduScanNode;
import org.apache.impala.planner.NestedLoopJoinNode;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlannerTestBase;
import org.apache.impala.planner.SelectNode;
import org.apache.impala.planner.SingularRowSrcNode;
import org.apache.impala.planner.SortNode;
import org.apache.impala.planner.SubplanNode;
import org.apache.impala.planner.UnionNode;
import org.apache.impala.planner.UnnestNode;
import org.apache.impala.service.Frontend;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.MathUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CardinalityTest
extends PlannerTestBase {
    private static double CARDINALITY_TOLERANCE = 0.05;

    @BeforeClass
    public static void setUpClass() throws Exception {
        RuntimeEnv.INSTANCE.setTestEnv(true);
    }

    @AfterClass
    public static void cleanUpClass() {
        RuntimeEnv.INSTANCE.reset();
    }

    @Test
    public void testBasicsWithStats() {
        this.verifyCardinality("SELECT id FROM functional.alltypes", 7300L);
        this.verifyCardinality("SELECT bool_col FROM functional.alltypes", 7300L);
        this.verifyCardinality("SELECT id FROM functional.alltypes WHERE bool_col = TRUE", 3650L);
        this.verifyCardinality("SELECT id FROM functional.alltypes WHERE int_col = 1", 730L);
        this.verifyCardinality("SELECT id FROM functional.alltypes WHERE int_col != 1", 6570L);
        this.verifyCardinality("SELECT id FROM functional.alltypes WHERE int_col > 1", 730L);
        this.verifyCardinality("SELECT id FROM functional.alltypes WHERE int_col > 1", 730L);
        this.verifyCardinality("SELECT id FROM functional.alltypes WHERE nullvalue(int_col)", 730L);
        this.verifyCardinality("select id from functional.alltypesagg where tinyint_col IS NULL", 2000L);
        this.verifyCardinality("select id from functional.alltypesagg where tinyint_col IS NOT NULL", 9000L);
        this.verifyCardinality("select id from functional.alltypesaggnonulls where int_col IS NULL", 1L);
        this.verifyCardinality("select id from functional.alltypesaggnonulls where int_col IS NOT NULL", 10000L);
        this.verifyCardinality("SELECT COUNT(*) FROM functional.alltypes GROUP BY int_col", 10L);
        this.verifyCardinality("SELECT COUNT(*) FROM functional.alltypes GROUP BY id", 7300L);
        this.verifyCardinality("SELECT COUNT(*) FROM functional.alltypes GROUP BY bool_col", 2L);
        this.verifyCardinality("SELECT * FROM tpcds_parquet.date_dim WHERE d_current_day != 'a'", 36525L);
    }

    @Test
    public void testNulls() {
        this.verifyCardinality("SELECT null_int FROM functional.nullrows", 26L);
        this.verifyCardinality("SELECT null_int FROM functional.nullrows WHERE id = 'x'", 1L);
        this.verifyCardinality("SELECT null_int FROM functional.nullrows WHERE group_str = 'x'", 4L);
        this.verifyCardinality("SELECT null_int FROM functional.nullrows WHERE null_str = 'x'", 1L);
    }

    @Test
    public void testGroupBy() {
        String baseStmt = "SELECT COUNT(*) FROM functional.nullrows GROUP BY ";
        this.verifyCardinality(baseStmt + "id", 26L);
        this.verifyCardinality(baseStmt + "group_str", 6L);
        this.verifyCardinality(baseStmt + "blank", 1L);
        this.verifyCardinality(baseStmt + "null_str", 1L);
        this.verifyCardinality(baseStmt + "id, null_str", 26L);
        this.verifyCardinality(baseStmt + "id, group_str", 26L);
    }

    @Test
    public void testNullColumnJoinCardinality() throws ImpalaException {
        String query = "select * from functional.nulltable t1 inner join [shuffle] functional.nulltable t2 on t1.d = t2.d";
        this.checkCardinality(query, 1L, 1L);
    }

    @Test
    public void testJoinWithStats() {
        this.verifyCardinality("SELECT null_int FROM functional.alltypes, functional.nullrows", 189800L);
        String baseStmt = "SELECT COUNT(*) FROM functional.alltypes, functional.nullrows GROUP BY ";
        this.verifyCardinality(baseStmt + "alltypes.id", 7300L);
        this.verifyCardinality(baseStmt + "nullrows.id", 26L);
        this.verifyCardinality(baseStmt + "blank", 1L);
        this.verifyCardinality(baseStmt + "group_str", 6L);
        this.verifyCardinality(baseStmt + "null_str", 1L);
        this.verifyCardinality(baseStmt + "nullrows.id, null_str", 26L);
        this.verifyCardinality(baseStmt + "nullrows.id, group_str", 26L);
        this.verifyCardinality(baseStmt + "nullrows.id, alltypes.month", 312L);
    }

    @Test
    public void testJoins() {
        String joinClause = " FROM functional.alltypes t1, functional.alltypes t2 ";
        this.verifyCardinality("SELECT t1.id" + joinClause, 53290000L);
        this.verifyCardinality("SELECT COUNT(*)" + joinClause + "GROUP BY t1.id", 7300L);
        this.verifyCardinality("SELECT COUNT(*)" + joinClause + "GROUP BY t1.id, t1.int_col", 7300L);
    }

    @Test
    public void testBasicsWithoutStats() {
        this.verifyApproxCardinality("SELECT a FROM functional.tinytable", 2L);
    }

    @Test
    public void testBasicsWithoutStatsWithHDFSNumRowsEstDisabled() {
        this.verifyCardinality("SELECT a FROM functional.tinytable", -1L, false, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)));
    }

    @Test
    public void testTableOfMixedTypesWithoutStats() {
        this.verifyApproxCardinality("SELECT * FROM functional.alltypesmixedformat", 2536L);
    }

    @Test
    public void testTableOfMixedTypesWithoutStatsWithHDFSNumRowsEstDisabled() {
        this.verifyCardinality("SELECT * FROM functional.alltypesmixedformat", -1L, false, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)));
    }

    @Test
    public void testTableOfMultipleFilesWithoutStats() {
        this.verifyApproxCardinality("SELECT * FROM tpch_text_gzip.lineitem", 5141177L);
    }

    @Test
    public void testTableOfMultipleFilesWithoutStatsWithHDFSNumRowsEstDisabled() {
        this.verifyCardinality("SELECT * FROM tpch_text_gzip.lineitem", -1L, false, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)));
    }

    @Test
    public void testAggregationNodeCount() {
        List<Integer> pathToFirstAggregationNode = Arrays.asList(new Integer[0]);
        List<Integer> pathToSecondAggregationNode = Arrays.asList(0, 0);
        this.verifyApproxCardinality("SELECT COUNT(a) FROM functional.tinytable", 1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToFirstAggregationNode, AggregationNode.class);
        this.verifyApproxCardinality("SELECT COUNT(a) FROM functional.tinytable", 1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToSecondAggregationNode, AggregationNode.class);
    }

    @Test
    public void testAggregationNodeCountWithHDFSNumRowsEstDisabled() {
        List<Integer> pathToFirstAggregationNode = Arrays.asList(new Integer[0]);
        List<Integer> pathToSecondAggregationNode = Arrays.asList(0, 0);
        this.verifyApproxCardinality("SELECT COUNT(a) FROM functional.tinytable", 1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), pathToFirstAggregationNode, AggregationNode.class);
        this.verifyApproxCardinality("SELECT COUNT(a) FROM functional.tinytable", 1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), pathToSecondAggregationNode, AggregationNode.class);
    }

    @Test
    public void testAggregationNodeGroupBy() {
        List<Integer> pathToFirstAggregationNode = Arrays.asList(0);
        List<Integer> pathToSecondAggregationNode = Arrays.asList(0, 0, 0);
        this.verifyCardinality("SELECT COUNT(a) FROM functional.tinytable GROUP BY a", 2L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToFirstAggregationNode, AggregationNode.class);
        this.verifyCardinality("SELECT COUNT(a) FROM functional.tinytable GROUP BY a", 2L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToSecondAggregationNode, AggregationNode.class);
        this.verifyCardinality("SELECT COUNT(a) FROM functional.tinytable GROUP BY a HAVING COUNT(a) > 0", 1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToFirstAggregationNode, AggregationNode.class);
        this.verifyCardinality("SELECT COUNT(a) FROM functional.tinytable GROUP BY a HAVING COUNT(a) > 0", 2L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToSecondAggregationNode, AggregationNode.class);
    }

    @Test
    public void testAggregationNodeGroupByWithHDFSNumRowsEstDisabled() {
        List<Integer> pathToFirstAggregationNode = Arrays.asList(0);
        List<Integer> pathToSecondAggregationNode = Arrays.asList(0, 0, 0);
        this.verifyApproxCardinality("SELECT COUNT(a) FROM functional.tinytable GROUP BY a", -1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), pathToFirstAggregationNode, AggregationNode.class);
        this.verifyApproxCardinality("SELECT COUNT(a) FROM functional.tinytable GROUP BY a", -1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), pathToSecondAggregationNode, AggregationNode.class);
    }

    @Test
    public void testAggregationNodeGroupByCardinalityCapping() {
        List<Integer> pathToFirstAggregationNode = Arrays.asList(0);
        List<Integer> pathToSecondAggregationNode = Arrays.asList(0, 0, 0);
        this.verifyCardinality("select distinct id, int_col from functional.alltypes", 7300L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToFirstAggregationNode, AggregationNode.class);
        this.verifyCardinality("select distinct id, int_col from functional.alltypes", 7300L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToSecondAggregationNode, AggregationNode.class);
        this.verifyApproxCardinality("select distinct id, int_col from functional_parquet.alltypes", 12400L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToFirstAggregationNode, AggregationNode.class);
        this.verifyApproxCardinality("select distinct id, int_col from functional_parquet.alltypes", 12400L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToSecondAggregationNode, AggregationNode.class);
        this.verifyCardinality("select distinct id, int_col from functional_parquet.alltypes", -1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), pathToFirstAggregationNode, AggregationNode.class);
        this.verifyCardinality("select distinct id, int_col from functional_parquet.alltypes", -1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), pathToSecondAggregationNode, AggregationNode.class);
    }

    @Test
    public void testAnalyticEvalNode() {
        List<Integer> path = Arrays.asList(new Integer[0]);
        this.verifyApproxCardinality("SELECT SUM(int_col) OVER() int_col FROM functional_parquet.alltypestiny", 742L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), path, AnalyticEvalNode.class);
        this.verifyCardinality("SELECT * FROM (SELECT *, row_number() OVER(order by id) as rn FROM functional.alltypestiny) v where rn != 5", 4L);
    }

    @Test
    public void testAnalyticEvalNodeWithHDFSNumRowsEstDisabled() {
        List<Integer> path = Arrays.asList(new Integer[0]);
        this.verifyApproxCardinality("SELECT SUM(int_col) OVER() int_col FROM functional_parquet.alltypestiny", -1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), path, AnalyticEvalNode.class);
    }

    @Test
    public void testCardinalityCheckNode() {
        List<Integer> path = Arrays.asList(0, 1, 0);
        String subQuery = "(SELECT id FROM functional_parquet.alltypestiny b WHERE id = 1)";
        this.verifyApproxCardinality("SELECT bigint_col FROM functional_parquet.alltypestiny a WHERE id = " + subQuery, 1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), path, CardinalityCheckNode.class);
    }

    @Test
    public void testCardinalityCheckNodeWithHDFSNumRowsEstDisabled() {
        List<Integer> path = Arrays.asList(0, 1, 0);
        String subQuery = "(SELECT id FROM functional_parquet.alltypestiny b WHERE id = 1)";
        this.verifyApproxCardinality("SELECT bigint_col FROM functional_parquet.alltypestiny a WHERE id = " + subQuery, 1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), path, CardinalityCheckNode.class);
    }

    @Test
    public void testEmptySetNode() {
        List<Integer> path = Arrays.asList(new Integer[0]);
        String subQuery = "(SELECT * FROM functional_parquet.alltypestiny LIMIT 0)";
        this.verifyApproxCardinality("SELECT 1 FROM functional_parquet.alltypessmall WHERE EXISTS " + subQuery, 0L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), path, EmptySetNode.class);
    }

    @Test
    public void testEmptySetNodeWithHDFSNumRowsEstDisabled() {
        List<Integer> path = Arrays.asList(new Integer[0]);
        String subQuery = "(SELECT * FROM functional_parquet.alltypestiny LIMIT 0)";
        this.verifyApproxCardinality("SELECT 1 FROM functional_parquet.alltypessmall WHERE EXISTS " + subQuery, 0L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), path, EmptySetNode.class);
    }

    @Test
    public void testExchangeNode() {
        List<Integer> path = Arrays.asList(new Integer[0]);
        this.verifyApproxCardinality("SELECT a FROM functional.tinytable", 2L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), path, ExchangeNode.class);
    }

    @Test
    public void testExchangeNodeWithHDFSNumRowsEstDisabled() {
        List<Integer> path = Arrays.asList(new Integer[0]);
        this.verifyApproxCardinality("SELECT a FROM functional.tinytable", -1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), path, ExchangeNode.class);
    }

    @Test
    public void testHashJoinNode() {
        List<Integer> path = Arrays.asList(0);
        this.verifyApproxCardinality("SELECT * FROM functional.tinytable x INNER JOIN functional.tinytable y ON x.a = y.a", 2L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), path, HashJoinNode.class);
    }

    @Test
    public void testHashJoinNodeWithHDFSNumRowsEstDisabled() {
        List<Integer> path = Arrays.asList(0);
        this.verifyApproxCardinality("SELECT * FROM functional.tinytable x INNER JOIN functional.tinytable y ON x.a = y.a", -1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), path, HashJoinNode.class);
    }

    @Test
    public void testNestedLoopJoinNode() {
        List<Integer> path = Arrays.asList(0);
        this.verifyApproxCardinality("SELECT * FROM functional_parquet.alltypestiny a, functional_parquet.alltypestiny b", 550564L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), path, NestedLoopJoinNode.class);
    }

    @Test
    public void testNestedLoopJoinNodeWithHDFSNumRowsEstDisabled() {
        List<Integer> path = Arrays.asList(0);
        this.verifyApproxCardinality("SELECT * FROM functional_parquet.alltypestiny a, functional_parquet.alltypestiny b", -1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), path, NestedLoopJoinNode.class);
    }

    @Test
    public void testHdfsScanNode() {
        List<Integer> path = Arrays.asList(0);
        this.verifyApproxCardinality("SELECT a FROM functional.tinytable", 2L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), path, HdfsScanNode.class);
    }

    @Test
    public void testHdfsScanNodeWithHDFSNumRowsEstDisabled() {
        List<Integer> path = Arrays.asList(0);
        this.verifyApproxCardinality("SELECT a FROM functional.tinytable", -1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), path, HdfsScanNode.class);
    }

    @Test
    public void testHdfsScanNodePartitionKeyScan() {
        this.verifyCardinality("SELECT year FROM functional.alltypes", 7300L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), Arrays.asList(0), HdfsScanNode.class);
        this.verifyCardinality("SELECT distinct year FROM functional.alltypes", 24L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), Arrays.asList(0, 0, 0, 0), HdfsScanNode.class);
        this.verifyCardinality("SELECT distinct year FROM functional_parquet.alltypes", 24L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), Arrays.asList(0, 0, 0, 0), HdfsScanNode.class);
        this.verifyCardinality("SELECT distinct year FROM functional_parquet.alltypes", 24L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), Arrays.asList(0, 0, 0, 0), HdfsScanNode.class);
    }

    @Test
    public void testSelectNode() {
        List<Integer> path = Arrays.asList(0, 1, 0);
        String singleRowSubQuery = "(SELECT int_col FROM functional_parquet.alltypestiny LIMIT 1)";
        this.verifyApproxCardinality("SELECT * FROM functional_parquet.alltypessmall WHERE 1 IN " + singleRowSubQuery, 1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), path, SelectNode.class);
        String manyRowSubQuery = "(SELECT int_col FROM functional_parquet.alltypes LIMIT 1000)";
        this.verifyApproxCardinality("SELECT * FROM functional_parquet.alltypessmall WHERE 1 IN " + manyRowSubQuery, 100L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), path, SelectNode.class);
    }

    @Test
    public void testSelectNodeWithHDFSNumRowsEstDisabled() {
        List<Integer> path = Arrays.asList(0, 1, 0);
        String subQuery = "(SELECT int_col FROM functional_parquet.alltypestiny LIMIT 1)";
        this.verifyApproxCardinality("SELECT * FROM functional_parquet.alltypes WHERE 1 IN " + subQuery, 1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), path, SelectNode.class);
    }

    @Test
    public void testSingularRowSrcNode() {
        List<Integer> path = Arrays.asList(0, 1, 1);
        this.verifyApproxCardinality("SELECT c_custkey, pos FROM tpch_nested_parquet.customer c, c.c_orders", 1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), path, SingularRowSrcNode.class);
    }

    @Test
    public void testSingularRowSrcNodeWithHDFSNumRowsEstDisabled() {
        List<Integer> path = Arrays.asList(0, 1, 1);
        this.verifyApproxCardinality("SELECT c_custkey, pos FROM tpch_nested_parquet.customer c, c.c_orders", 1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), path, SingularRowSrcNode.class);
    }

    @Test
    public void testSortNode() {
        List<Integer> path = Arrays.asList(0);
        this.verifyApproxCardinality("SELECT * FROM functional_parquet.alltypestiny ORDER BY int_col", 742L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), path, SortNode.class);
    }

    @Test
    public void testSortNodeWithHDFSNumRowsEstDisabled() {
        List<Integer> path = Arrays.asList(0);
        this.verifyApproxCardinality("SELECT * FROM functional_parquet.alltypestiny ORDER BY int_col", -1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), path, SortNode.class);
    }

    @Test
    public void testPartitionedTopNNode() {
        List<Integer> selectPath = Arrays.asList(0);
        List<Integer> sortPath = Arrays.asList(0, 0, 0);
        String lessThanQuery = "select * from (  select *, row_number() over   (partition by smallint_col, bool_col order by id) as rn  from functional.alltypesagg where id % 777 = 0 or id % 10 = 7) v where rn <= 5";
        int EXPECTED_CARDINALITY = 970;
        this.verifyApproxCardinality(lessThanQuery, 970L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), sortPath, SortNode.class);
        this.verifyApproxCardinality(lessThanQuery, 970L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), selectPath, SelectNode.class);
        String eqQuery = "select * from (  select *, row_number() over   (partition by smallint_col, bool_col order by id) as rn  from functional.alltypesagg where id % 777 = 0 or id % 10 = 7) v where rn = 5";
        this.verifyApproxCardinality(eqQuery, 970L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), sortPath, SortNode.class);
        this.verifyApproxCardinality(eqQuery, 970L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), selectPath, SelectNode.class);
    }

    @Test
    public void testSubPlanNode() {
        List<Integer> path = Arrays.asList(0);
        this.verifyApproxCardinality("SELECT c_custkey, pos FROM tpch_nested_parquet.customer c, c.c_orders", 1500000L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), path, SubplanNode.class);
    }

    @Test
    public void testSubPlanNodeWithHDFSNumRowsEstDisabled() {
        List<Integer> path = Arrays.asList(0);
        this.verifyApproxCardinality("SELECT c_custkey, pos FROM tpch_nested_parquet.customer c, c.c_orders", 1500000L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), path, SubplanNode.class);
    }

    @Test
    public void testUnionNode() {
        List<Integer> path = Arrays.asList(0);
        String subQuery = "SELECT * FROM functional.tinytable";
        this.verifyApproxCardinality(subQuery + " UNION ALL " + subQuery, 4L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), path, UnionNode.class);
    }

    @Test
    public void testUnionNodeWithHDFSNumRowsEstDisabled() {
        List<Integer> path = Arrays.asList(0);
        String subQuery = "SELECT * FROM functional.tinytable";
        this.verifyApproxCardinality(subQuery + " UNION ALL " + subQuery, -1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), path, UnionNode.class);
        this.verifyApproxCardinality(subQuery + " UNION ALL " + subQuery + " UNION ALL SELECT 'a', 'b'", -1L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), path, UnionNode.class);
        this.verifyApproxCardinality(subQuery + " UNION ALL SELECT string_col, date_string_col from functional.alltypestiny", 8L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), path, UnionNode.class);
    }

    @Test
    public void testUnnestNode() {
        List<Integer> path = Arrays.asList(0, 1, 0);
        this.verifyApproxCardinality("SELECT c_custkey, pos FROM tpch_nested_parquet.customer c, c.c_orders", 10L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), path, UnnestNode.class);
    }

    @Test
    public void testUnnestNodeWithHDFSNumRowsEstDisabled() {
        List<Integer> path = Arrays.asList(0, 1, 0);
        this.verifyApproxCardinality("SELECT c_custkey, pos FROM tpch_nested_parquet.customer c, c.c_orders", 10L, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of((Object)((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE)), path, UnnestNode.class);
    }

    @Test
    public void testAggregationNodeMemoryEstimate() {
        List<Integer> pathToFirstAggregationNode = Arrays.asList(0);
        List<Integer> pathToSecondAggregationNode = Arrays.asList(0, 0, 0);
        List<Integer> pathToAggregationNode = Arrays.asList(new Integer[0]);
        this.verifyApproxMemoryEstimate("SELECT COUNT(int_col) FROM functional.alltypes GROUP BY int_col", 0xA00000L, true, false, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToFirstAggregationNode, AggregationNode.class);
        this.verifyApproxMemoryEstimate("SELECT COUNT(int_col) FROM functional.alltypes GROUP BY int_col", 0xA00000L, false, false, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToAggregationNode, AggregationNode.class);
        this.verifyApproxMemoryEstimate("SELECT COUNT(*),MAX(B.BIGINT_COL) FROM FUNCTIONAL.ALLTYPES A , FUNCTIONAL.ALLTYPESSMALL B, FUNCTIONAL.NULLROWS C GROUP BY A.ID, B.TIMESTAMP_COL,C.BOOL_NULLS", 107310000L, true, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToFirstAggregationNode, AggregationNode.class);
        this.verifyApproxMemoryEstimate("SELECT COUNT(*),MAX(B.BIGINT_COL) FROM FUNCTIONAL.ALLTYPES A , FUNCTIONAL.ALLTYPESSMALL B, FUNCTIONAL.NULLROWS C GROUP BY A.ID, B.TIMESTAMP_COL,C.BOOL_NULLS", 107310000L, true, false, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToSecondAggregationNode, AggregationNode.class);
        this.verifyApproxMemoryEstimate("SELECT COUNT(*),MAX(B.BIGINT_COL) FROM FUNCTIONAL.ALLTYPES A , FUNCTIONAL.ALLTYPESSMALL B, FUNCTIONAL.NULLROWS C GROUP BY A.ID, B.TIMESTAMP_COL,C.BOOL_NULLS", 107310000L, false, false, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToAggregationNode, AggregationNode.class);
        List<Integer> countFirstAggregationNode = Arrays.asList(new Integer[0]);
        List<Integer> countSecondAggregationNode = Arrays.asList(new Integer[0]);
        this.verifyApproxMemoryEstimate("SELECT COUNT(*) FROM FUNCTIONAL.ALLTYPES A ", 16384L, true, false, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), countFirstAggregationNode, AggregationNode.class);
        this.verifyApproxMemoryEstimate("SELECT COUNT(*) FROM FUNCTIONAL.ALLTYPES A ", 16384L, true, false, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), countSecondAggregationNode, AggregationNode.class);
        this.verifyApproxMemoryEstimate("SELECT COUNT(*) FROM FUNCTIONAL.ALLTYPES A ", 16384L, false, false, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToAggregationNode, AggregationNode.class);
    }

    @Test
    public void testSortNodeMemoryEstimate() {
        List<Integer> pathToSortNode = Arrays.asList(0);
        List<Integer> pathToSortNodeSg = Arrays.asList(new Integer[0]);
        this.verifyApproxMemoryEstimate("SELECT A.TIMESTAMP_COL,B.TIMESTAMP_COL FROM FUNCTIONAL.ALLTYPES A , FUNCTIONAL.ALLTYPESSMALL B ORDER BY A.TIMESTAMP_COL,B.TIMESTAMP_COL", 23360000L, true, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToSortNode, SortNode.class);
        this.verifyApproxMemoryEstimate("SELECT A.TIMESTAMP_COL,B.TIMESTAMP_COL FROM FUNCTIONAL.ALLTYPES A , FUNCTIONAL.ALLTYPESSMALL B ORDER BY A.TIMESTAMP_COL,B.TIMESTAMP_COL", 23360000L, false, false, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToSortNodeSg, SortNode.class);
    }

    @Test
    public void testHashJoinNodeMemoryEstimate() {
        List<Integer> pathToJoinNode = Arrays.asList(0);
        List<Integer> pathToJoinNodeSg = Arrays.asList(new Integer[0]);
        this.verifyApproxMemoryEstimate("SELECT A.ID FROM (SELECT A1.ID,B1.DATE_STRING_COL IDB FROM FUNCTIONAL.ALLTYPES A1 , FUNCTIONAL.ALLTYPES B1 GROUP BY A1.ID,B1.DATE_STRING_COL) A JOIN (SELECT A1.ID,B1.DATE_STRING_COL IDB FROM FUNCTIONAL.ALLTYPES A1,FUNCTIONAL.ALLTYPES B1 GROUP BY A1.ID,B1.DATE_STRING_COL) B ON A.ID = B.ID AND A.IDB=B.IDB", 229610496L, true, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToJoinNode, HashJoinNode.class);
        this.verifyApproxMemoryEstimate("SELECT A.ID FROM (SELECT A1.ID,B1.DATE_STRING_COL IDB FROM FUNCTIONAL.ALLTYPES A1 , FUNCTIONAL.ALLTYPES B1 GROUP BY A1.ID,B1.DATE_STRING_COL) A JOIN (SELECT A1.ID,B1.DATE_STRING_COL IDB FROM FUNCTIONAL.ALLTYPES A1,FUNCTIONAL.ALLTYPES B1 GROUP BY A1.ID,B1.DATE_STRING_COL) B ON A.ID = B.ID AND A.IDB=B.IDB", 229610496L, false, false, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToJoinNodeSg, HashJoinNode.class);
        this.verifyApproxMemoryEstimate("SELECT A.ID FROM (SELECT A1.ID,B1.DATE_STRING_COL IDB FROM FUNCTIONAL.ALLTYPES A1 , FUNCTIONAL.ALLTYPES B1) A JOIN (SELECT A1.ID,B1.DATE_STRING_COL IDB FROM FUNCTIONAL.ALLTYPES A1,FUNCTIONAL.ALLTYPES B1) B ON A.ID = B.ID AND A.IDB=B.IDB", 3656247936L, true, true, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToJoinNode, HashJoinNode.class);
        this.verifyApproxMemoryEstimate("SELECT A.ID FROM (SELECT A1.ID,B1.DATE_STRING_COL IDB FROM FUNCTIONAL.ALLTYPES A1 , FUNCTIONAL.ALLTYPES B1) A JOIN (SELECT A1.ID,B1.DATE_STRING_COL IDB FROM FUNCTIONAL.ALLTYPES A1,FUNCTIONAL.ALLTYPES B1) B ON A.ID = B.ID AND A.IDB=B.IDB", 3656247936L, false, false, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToJoinNodeSg, HashJoinNode.class);
    }

    @Test
    public void testKuduScanNodeMemoryEstimate() {
        List<Integer> pathToKuduScanNode = Arrays.asList(0);
        List<Integer> pathToKuduScanNodeSg = Arrays.asList(new Integer[0]);
        this.verifyApproxMemoryEstimate("SELECT ID FROM FUNCTIONAL_KUDU.ALLTYPESSMALL", 786432L, true, false, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToKuduScanNode, KuduScanNode.class);
        this.verifyApproxMemoryEstimate("SELECT ID FROM FUNCTIONAL_KUDU.ALLTYPESSMALL", 786432L, false, false, (Set<PlannerTestBase.PlannerTestOption>)ImmutableSet.of(), pathToKuduScanNodeSg, KuduScanNode.class);
    }

    @Test
    public void testByteBasedNumWriters() {
        int min_bytes = 0x10000000;
        Assert.assertEquals((long)1L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)false, (long)1L, (long)min_bytes, (double)1.0));
        Assert.assertEquals((long)25L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)false, (long)1L, (long)min_bytes, (double)25.0));
        Assert.assertEquals((long)10L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)10, (boolean)false, (long)1L, (long)min_bytes, (double)25.0));
        Assert.assertEquals((long)1L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)true, (long)-1L, (long)min_bytes, (double)1.0));
        Assert.assertEquals((long)25L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)true, (long)-1L, (long)min_bytes, (double)25.0));
        Assert.assertEquals((long)10L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)10, (boolean)true, (long)-1L, (long)min_bytes, (double)25.0));
        Assert.assertEquals((long)10L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)true, (long)1L, (long)min_bytes, (double)1.0));
        Assert.assertEquals((long)10L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)true, (long)1L, (long)min_bytes, (double)25.0));
        Assert.assertEquals((long)10L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)10, (boolean)true, (long)1L, (long)min_bytes, (double)25.0));
        Assert.assertEquals((long)10L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)true, (long)50L, (long)min_bytes, (double)1.0));
        Assert.assertEquals((long)25L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)true, (long)50L, (long)min_bytes, (double)25.0));
        Assert.assertEquals((long)10L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)10, (boolean)true, (long)10L, (long)min_bytes, (double)25.0));
        Assert.assertEquals((long)10L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)true, (long)60L, (long)min_bytes, (double)1.0));
        Assert.assertEquals((long)25L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)true, (long)60L, (long)min_bytes, (double)25.0));
        Assert.assertEquals((long)10L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)10, (boolean)true, (long)11L, (long)min_bytes, (double)25.0));
        Assert.assertEquals((long)10L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)true, (long)40L, (long)min_bytes, (double)1.0));
        Assert.assertEquals((long)25L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)true, (long)40L, (long)min_bytes, (double)25.0));
        Assert.assertEquals((long)9L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)10, (boolean)true, (long)9L, (long)min_bytes, (double)25.0));
        Assert.assertEquals((long)8L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)true, (long)8L, (long)min_bytes, (double)1.0));
        Assert.assertEquals((long)8L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)true, (long)8L, (long)min_bytes, (double)25.0));
        Assert.assertEquals((long)8L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)10, (boolean)true, (long)8L, (long)min_bytes, (double)25.0));
        Assert.assertEquals((long)1L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)false, (long)1L, (long)0L, (double)25.0));
        Assert.assertEquals((long)1L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)true, (long)50L, (long)0L, (double)25.0));
        Assert.assertEquals((long)1L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)false, (long)1L, (long)min_bytes, (double)0.0));
        Assert.assertEquals((long)10L, (long)HdfsTableSink.bytesBasedNumWriters((int)10, (int)50, (boolean)true, (long)50L, (long)min_bytes, (double)0.0));
    }

    protected void verifyCardinality(String query, long expected) {
        List<PlanFragment> plan = this.getPlan(query);
        PlanNode planRoot = plan.get(0).getPlanRoot();
        Assert.assertEquals((String)("Cardinality error for: " + query), (long)expected, (long)planRoot.getCardinality());
    }

    protected void verifyCardinality(String query, long expected, boolean isDistributedPlan, Set<PlannerTestBase.PlannerTestOption> testOptions) {
        List<PlanFragment> plan = this.getPlan(query, isDistributedPlan, testOptions);
        PlanNode planRoot = plan.get(0).getPlanRoot();
        Assert.assertEquals((String)("Cardinality error for: " + query), (long)expected, (long)planRoot.getCardinality());
    }

    protected void verifyCardinality(String query, long expected, boolean isDistributedPlan, Set<PlannerTestBase.PlannerTestOption> testOptions, List<Integer> path, Class<?> cl) {
        List<PlanFragment> plan = this.getPlan(query, isDistributedPlan, testOptions);
        PlanNode currentNode = plan.get(plan.size() - 1).getPlanRoot();
        for (Integer currentChildIndex : path) {
            currentNode = (PlanNode)currentNode.getChild(currentChildIndex.intValue());
        }
        Assert.assertEquals((String)"PlanNode class not matched: ", (Object)cl.getName(), (Object)currentNode.getClass().getName());
        Assert.assertEquals((String)("Cardinality error for: " + query), (long)expected, (long)currentNode.getCardinality());
    }

    protected void verifyApproxCardinality(String query, long expected) {
        List<PlanFragment> plan = this.getPlan(query);
        PlanNode planRoot = plan.get(0).getPlanRoot();
        Assert.assertEquals((String)("Cardinality error for: " + query), (double)expected, (double)planRoot.getCardinality(), (double)((double)expected * CARDINALITY_TOLERANCE));
    }

    protected void verifyApproxCardinality(String query, long expected, boolean isDistributedPlan, Set<PlannerTestBase.PlannerTestOption> testOptions, List<Integer> path, Class<?> cl) {
        List<PlanFragment> plan = this.getPlan(query, isDistributedPlan, testOptions);
        PlanNode currentNode = plan.get(plan.size() - 1).getPlanRoot();
        for (Integer currentChildIndex : path) {
            Assert.assertTrue((String)(currentNode.getDisplayLabel() + " does not have child index " + currentChildIndex), (boolean)currentNode.hasChild(currentChildIndex.intValue()));
            currentNode = (PlanNode)currentNode.getChild(currentChildIndex.intValue());
        }
        Assert.assertEquals((String)"PlanNode class not matched: ", (Object)cl.getName(), (Object)currentNode.getClass().getName());
        Assert.assertEquals((String)("Cardinality error for: " + query), (double)expected, (double)currentNode.getCardinality(), (double)((double)expected * CARDINALITY_TOLERANCE));
    }

    private List<PlanFragment> getPlan(String query) {
        TQueryCtx queryCtx = TestUtils.createQueryContext("default", System.getProperty("user.name"));
        queryCtx.client_request.setStmt(query);
        TQueryOptions queryOptions = queryCtx.client_request.getQuery_options();
        queryOptions.setNum_nodes(1);
        Frontend.PlanCtx planCtx = new Frontend.PlanCtx(queryCtx);
        planCtx.requestPlanCapture();
        try {
            frontend_.createExecRequest(planCtx);
        }
        catch (ImpalaException e) {
            Assert.fail((String)e.getMessage());
        }
        return planCtx.getPlan();
    }

    private List<PlanFragment> getPlan(String query, boolean isDistributedPlan, Set<PlannerTestBase.PlannerTestOption> testOptions) {
        TQueryCtx queryCtx = TestUtils.createQueryContext("default", System.getProperty("user.name"));
        queryCtx.client_request.setStmt(query);
        TQueryOptions queryOptions = queryCtx.client_request.getQuery_options();
        queryOptions.setDisable_hdfs_num_rows_estimate(testOptions.contains((Object)PlannerTestBase.PlannerTestOption.DISABLE_HDFS_NUM_ROWS_ESTIMATE));
        queryOptions.setNum_nodes(isDistributedPlan ? 0 : 1);
        Frontend.PlanCtx planCtx = new Frontend.PlanCtx(queryCtx);
        planCtx.requestPlanCapture();
        try {
            frontend_.createExecRequest(planCtx);
        }
        catch (ImpalaException e) {
            Assert.fail((String)e.getMessage());
        }
        return planCtx.getPlan();
    }

    protected PlanNode getPlanNode(String query, boolean isDistributedPlan, Set<PlannerTestBase.PlannerTestOption> testOptions, List<Integer> path, Class<?> cl) {
        List<PlanFragment> plan = this.getPlan(query, isDistributedPlan, testOptions);
        PlanNode currentNode = plan.get(plan.size() - 1).getPlanRoot();
        for (Integer currentChildIndex : path) {
            currentNode = (PlanNode)currentNode.getChild(currentChildIndex.intValue());
        }
        Assert.assertEquals((String)"PlanNode class not matched: ", (Object)cl.getName(), (Object)currentNode.getClass().getName());
        return currentNode;
    }

    protected void verifyApproxMemoryEstimate(String query, long expected, boolean isDistributedPlan, boolean isMultiNodes, Set<PlannerTestBase.PlannerTestOption> testOptions, List<Integer> path, Class<?> cl) {
        PlanNode pNode = this.getPlanNode(query, isDistributedPlan, testOptions, path, cl);
        long result = pNode.getNodeResourceProfile().getMemEstimateBytes();
        if (isMultiNodes) {
            result = (long)Math.ceil(result * (long)pNode.getFragment().getNumInstances());
        }
        Assert.assertEquals((String)("Memory Estimate error for: " + query), (double)expected, (double)result, (double)((double)expected * CARDINALITY_TOLERANCE));
    }

    @Test
    public void testEstimatePreaggCardinality() {
        List<Long> positiveLong = Arrays.asList(1L, 2L, 5L, 10L, 100L, 1000L, Long.MAX_VALUE);
        ArrayList<Long> validCard = new ArrayList<Long>(positiveLong);
        validCard.add(-1L);
        validCard.add(0L);
        for (Long totalInstances : positiveLong) {
            for (Long globalNdv : positiveLong) {
                for (Long inputCard : validCard) {
                    String pattern = "totalInstances=%d, globalNdv=%d, inputCard=%d, isNonGroupingAggregation=%b, canCompteleEarly=%b, limit=%d, ouputCard=%d";
                    long outputCard = AggregationNode.estimatePreaggCardinality((long)totalInstances, (long)globalNdv, (long)inputCard, (boolean)false, (boolean)false, (long)-1L);
                    String message = String.format(pattern, totalInstances, globalNdv, inputCard, false, false, -1, outputCard);
                    Assert.assertTrue((String)(message + ", expect>=0"), (outputCard >= 0L ? 1 : 0) != 0);
                    if (inputCard == 0L) {
                        Assert.assertTrue((String)(message + ", expect=0"), (outputCard == 0L ? 1 : 0) != 0);
                    } else if (inputCard == -1L || totalInstances == 1L) {
                        long leastInputVsNdv = MathUtil.smallestValidCardinality((long)inputCard, (long)globalNdv);
                        Assert.assertTrue((String)(message + ", expect=" + leastInputVsNdv), (outputCard == leastInputVsNdv ? 1 : 0) != 0);
                    } else {
                        Assert.assertTrue((String)(message + ", expect<=" + inputCard), (outputCard <= inputCard ? 1 : 0) != 0);
                    }
                    outputCard = AggregationNode.estimatePreaggCardinality((long)totalInstances, (long)globalNdv, (long)inputCard, (boolean)true, (boolean)false, (long)-1L);
                    message = String.format(pattern, totalInstances, globalNdv, inputCard, true, false, -1, outputCard);
                    Assert.assertTrue((String)(message + ", expect>=0"), (outputCard >= 0L ? 1 : 0) != 0);
                    long allDuplicate = MathUtil.multiplyCardinalities((long)globalNdv, (long)totalInstances);
                    long leastInputVsAllDuplicate = MathUtil.smallestValidCardinality((long)inputCard, (long)allDuplicate);
                    if (allDuplicate < inputCard) {
                        Assert.assertTrue((String)(message + ", expect=" + leastInputVsAllDuplicate), (outputCard == leastInputVsAllDuplicate ? 1 : 0) != 0);
                    }
                    for (Long limit : validCard) {
                        if (limit < 0L) continue;
                        outputCard = AggregationNode.estimatePreaggCardinality((long)totalInstances, (long)globalNdv, (long)inputCard, (boolean)false, (boolean)true, (long)limit);
                        message = String.format(pattern, totalInstances, globalNdv, inputCard, false, true, limit, outputCard);
                        Assert.assertTrue((String)(message + ", expect>=0"), (outputCard >= 0L ? 1 : 0) != 0);
                        long allAtLimit = MathUtil.multiplyCardinalities((long)totalInstances, (long)limit);
                        long leastOfAll = MathUtil.smallestValidCardinality((long)allAtLimit, (long)leastInputVsAllDuplicate);
                        Assert.assertTrue((String)(message + ", expect=" + leastOfAll), (outputCard == leastOfAll ? 1 : 0) != 0);
                    }
                }
            }
        }
    }
}

