/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hooks;

import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.impala.common.InternalException;
import org.apache.impala.hooks.QueryCompleteContext;
import org.apache.impala.hooks.QueryEventHook;
import org.apache.impala.hooks.QueryEventHookManager;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.testutil.AlwaysErrorQueryEventHook;
import org.apache.impala.testutil.CountingQueryEventHook;
import org.apache.impala.testutil.PostQueryErrorEventHook;
import org.apache.impala.thrift.TBackendGflags;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class QueryEventHookManagerTest {
    private TBackendGflags origFlags;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private QueryCompleteContext mockQueryCompleteContext = new QueryCompleteContext("unit-test lineage");

    @Before
    public void setUp() {
        if (BackendConfig.INSTANCE == null) {
            BackendConfig.create((TBackendGflags)new TBackendGflags());
        }
        this.origFlags = BackendConfig.INSTANCE.getBackendCfg();
    }

    @After
    public void tearDown() {
        BackendConfig.create((TBackendGflags)this.origFlags);
    }

    private static QueryEventHookManager createQueryEventHookManager(int nThreads, String ... hooks) throws Exception {
        if (hooks.length == 0) {
            BackendConfig.INSTANCE.getBackendCfg().setQuery_event_hook_classes("");
        } else {
            BackendConfig.INSTANCE.getBackendCfg().setQuery_event_hook_classes(String.join((CharSequence)",", hooks));
        }
        BackendConfig.INSTANCE.getBackendCfg().setQuery_event_hook_nthreads(nThreads);
        return QueryEventHookManager.createFromConfig((BackendConfig)BackendConfig.INSTANCE);
    }

    @Test
    public void testHookRegistration() throws Exception {
        QueryEventHookManager mgr = QueryEventHookManagerTest.createQueryEventHookManager(1, CountingQueryEventHook.class.getCanonicalName(), CountingQueryEventHook.class.getCanonicalName());
        List hooks = mgr.getHooks();
        Assert.assertEquals((long)2L, (long)hooks.size());
        hooks.forEach(h -> Assert.assertEquals(CountingQueryEventHook.class, h.getClass()));
    }

    @Test
    public void testHookPostQueryExecuteErrorsDoNotKillExecution() throws Exception {
        QueryEventHookManager mgr = QueryEventHookManagerTest.createQueryEventHookManager(1, PostQueryErrorEventHook.class.getCanonicalName(), CountingQueryEventHook.class.getCanonicalName());
        Assert.assertEquals(((QueryEventHook)mgr.getHooks().get(0)).getClass(), PostQueryErrorEventHook.class);
        List futures = mgr.executeQueryCompleteHooks(this.mockQueryCompleteContext);
        QueryEventHook hookImpl = (QueryEventHook)((Future)futures.get(1)).get(2L, TimeUnit.SECONDS);
        Assert.assertEquals(hookImpl.getClass(), CountingQueryEventHook.class);
    }

    @Test
    public void testHookExceptionDuringStartupKillsStartup() throws Exception {
        this.expectedException.expect(InternalException.class);
        QueryEventHookManagerTest.createQueryEventHookManager(1, AlwaysErrorQueryEventHook.class.getCanonicalName(), CountingQueryEventHook.class.getCanonicalName());
    }

    @Test
    public void testHookPostQueryExecuteInvokedCorrectly() throws Exception {
        CountingQueryEventHook hook;
        QueryEventHookManager mgr = QueryEventHookManagerTest.createQueryEventHookManager(1, CountingQueryEventHook.class.getCanonicalName(), CountingQueryEventHook.class.getCanonicalName());
        List futures = mgr.executeQueryCompleteHooks(this.mockQueryCompleteContext);
        Assert.assertEquals((long)futures.size(), (long)mgr.getHooks().size());
        for (Future f : futures) {
            hook = (CountingQueryEventHook)f.get(2L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)hook.getPostQueryExecuteInvocations());
        }
        futures = mgr.executeQueryCompleteHooks(this.mockQueryCompleteContext);
        Assert.assertEquals((long)futures.size(), (long)mgr.getHooks().size());
        for (Future f : futures) {
            hook = (CountingQueryEventHook)f.get(2L, TimeUnit.SECONDS);
            Assert.assertEquals((long)2L, (long)hook.getPostQueryExecuteInvocations());
        }
    }
}

