/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hive.executor;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.ql.udf.UDFAcos;
import org.apache.hadoop.hive.ql.udf.UDFAscii;
import org.apache.hadoop.hive.ql.udf.UDFAsin;
import org.apache.hadoop.hive.ql.udf.UDFAtan;
import org.apache.hadoop.hive.ql.udf.UDFBase64;
import org.apache.hadoop.hive.ql.udf.UDFBin;
import org.apache.hadoop.hive.ql.udf.UDFConv;
import org.apache.hadoop.hive.ql.udf.UDFCos;
import org.apache.hadoop.hive.ql.udf.UDFDegrees;
import org.apache.hadoop.hive.ql.udf.UDFE;
import org.apache.hadoop.hive.ql.udf.UDFExp;
import org.apache.hadoop.hive.ql.udf.UDFFindInSet;
import org.apache.hadoop.hive.ql.udf.UDFHex;
import org.apache.hadoop.hive.ql.udf.UDFLn;
import org.apache.hadoop.hive.ql.udf.UDFLog;
import org.apache.hadoop.hive.ql.udf.UDFLog10;
import org.apache.hadoop.hive.ql.udf.UDFLog2;
import org.apache.hadoop.hive.ql.udf.UDFPI;
import org.apache.hadoop.hive.ql.udf.UDFRadians;
import org.apache.hadoop.hive.ql.udf.UDFRand;
import org.apache.hadoop.hive.ql.udf.UDFRepeat;
import org.apache.hadoop.hive.ql.udf.UDFReverse;
import org.apache.hadoop.hive.ql.udf.UDFSign;
import org.apache.hadoop.hive.ql.udf.UDFSin;
import org.apache.hadoop.hive.ql.udf.UDFSpace;
import org.apache.hadoop.hive.ql.udf.UDFSqrt;
import org.apache.hadoop.hive.ql.udf.UDFSubstr;
import org.apache.hadoop.hive.ql.udf.UDFTan;
import org.apache.hadoop.hive.ql.udf.UDFUnbase64;
import org.apache.hadoop.hive.ql.udf.UDFUnhex;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.hive.executor.ImpalaBigIntWritable;
import org.apache.impala.hive.executor.ImpalaBooleanWritable;
import org.apache.impala.hive.executor.ImpalaBytesWritable;
import org.apache.impala.hive.executor.ImpalaDoubleWritable;
import org.apache.impala.hive.executor.ImpalaFloatWritable;
import org.apache.impala.hive.executor.ImpalaIntWritable;
import org.apache.impala.hive.executor.ImpalaSmallIntWritable;
import org.apache.impala.hive.executor.ImpalaTextWritable;
import org.apache.impala.hive.executor.ImpalaTinyIntWritable;
import org.apache.impala.hive.executor.JavaUdfDataType;
import org.apache.impala.hive.executor.TestGenericUdf;
import org.apache.impala.hive.executor.TestGenericUdfWithJavaReturnTypes;
import org.apache.impala.hive.executor.TestUdf;
import org.apache.impala.hive.executor.UdfExecutor;
import org.apache.impala.thrift.TFunction;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.apache.impala.thrift.THiveUdfExecutorCtorParams;
import org.apache.impala.util.UnsafeUtil;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.junit.Assert;
import org.junit.Test;

public class UdfExecutorTest {
    private final String HIVE_BUILTIN_JAR = System.getenv("HIVE_HOME") + "/lib/hive-exec-" + System.getenv("IMPALA_HIVE_VERSION") + ".jar";
    private static final TBinaryProtocol.Factory PROTOCOL_FACTORY = new TBinaryProtocol.Factory();
    ArrayList<Long> allocations_ = Lists.newArrayList();

    long allocate(int byteSize) {
        long ptr = UnsafeUtil.UNSAFE.allocateMemory(byteSize);
        this.allocations_.add(ptr);
        return ptr;
    }

    void freeAllocations() {
        for (Long l : this.allocations_) {
            UnsafeUtil.UNSAFE.freeMemory(l);
        }
        this.allocations_.clear();
    }

    Writable createObject(PrimitiveType t, Object o) {
        long ptr = this.allocate(t.getSlotSize());
        switch (t) {
            case BOOLEAN: {
                ImpalaBooleanWritable w = new ImpalaBooleanWritable(ptr);
                w.set(((Boolean)o).booleanValue());
                return w;
            }
            case TINYINT: {
                ImpalaTinyIntWritable w = new ImpalaTinyIntWritable(ptr);
                w.set((byte)((Integer)o).intValue());
                return w;
            }
            case SMALLINT: {
                ImpalaSmallIntWritable w = new ImpalaSmallIntWritable(ptr);
                w.set(((Integer)o).shortValue());
                return w;
            }
            case INT: {
                ImpalaIntWritable w = new ImpalaIntWritable(ptr);
                w.set(((Integer)o).intValue());
                return w;
            }
            case BIGINT: {
                ImpalaBigIntWritable w = new ImpalaBigIntWritable(ptr);
                w.set(((Long)o).longValue());
                return w;
            }
            case FLOAT: {
                ImpalaFloatWritable w = new ImpalaFloatWritable(ptr);
                w.set(((Float)o).floatValue());
                return w;
            }
            case DOUBLE: {
                ImpalaDoubleWritable w = new ImpalaDoubleWritable(ptr);
                w.set(((Double)o).doubleValue());
                return w;
            }
        }
        return null;
    }

    Writable createBoolean(boolean v) {
        return this.createObject(PrimitiveType.BOOLEAN, v);
    }

    Writable createTinyInt(int v) {
        return this.createObject(PrimitiveType.TINYINT, v);
    }

    Writable createSmallInt(int v) {
        return this.createObject(PrimitiveType.SMALLINT, v);
    }

    Writable createInt(int v) {
        return this.createObject(PrimitiveType.INT, v);
    }

    Writable createBigInt(long v) {
        return this.createObject(PrimitiveType.BIGINT, v);
    }

    Writable createFloat(float v) {
        return this.createObject(PrimitiveType.FLOAT, Float.valueOf(v));
    }

    Writable createDouble(double v) {
        return this.createObject(PrimitiveType.DOUBLE, v);
    }

    Writable createBytes(String v) {
        long ptr = this.allocateStringValue(v);
        ImpalaBytesWritable bytesWritable = new ImpalaBytesWritable(ptr);
        bytesWritable.reload();
        return bytesWritable;
    }

    Writable createText(String v) {
        long ptr = this.allocateStringValue(v);
        ImpalaTextWritable textWritable = new ImpalaTextWritable(ptr);
        textWritable.reload();
        return textWritable;
    }

    private long allocateStringValue(String v) {
        long ptr = this.allocate(12);
        UnsafeUtil.UNSAFE.putInt(ptr + 8L, v.length());
        long stringPtr = this.allocate(v.length());
        UnsafeUtil.UNSAFE.putLong(ptr, stringPtr);
        UnsafeUtil.Copy((long)stringPtr, (byte[])v.getBytes(), (int)0, (int)v.length());
        return ptr;
    }

    Type getType(Object w) {
        if (w instanceof ImpalaBooleanWritable) {
            return Type.BOOLEAN;
        }
        if (w instanceof ImpalaTinyIntWritable) {
            return Type.TINYINT;
        }
        if (w instanceof ImpalaSmallIntWritable) {
            return Type.SMALLINT;
        }
        if (w instanceof ImpalaIntWritable) {
            return Type.INT;
        }
        if (w instanceof ImpalaBigIntWritable) {
            return Type.BIGINT;
        }
        if (w instanceof ImpalaFloatWritable) {
            return Type.FLOAT;
        }
        if (w instanceof ImpalaDoubleWritable) {
            return Type.DOUBLE;
        }
        if (w instanceof ImpalaTextWritable || w instanceof String) {
            return Type.STRING;
        }
        if (w instanceof ImpalaBytesWritable) {
            return Type.BINARY;
        }
        Preconditions.checkArgument((boolean)false);
        return Type.INVALID;
    }

    void validateArgType(Object w) {
        if (w == null || w instanceof String || w instanceof Text || w instanceof ImpalaBytesWritable || w instanceof ImpalaIntWritable || w instanceof ImpalaFloatWritable || w instanceof ImpalaBigIntWritable || w instanceof ImpalaDoubleWritable || w instanceof ImpalaBooleanWritable || w instanceof ImpalaTinyIntWritable || w instanceof ImpalaSmallIntWritable) {
            return;
        }
        Preconditions.checkArgument((boolean)false);
    }

    UdfExecutor createUdfExecutor(String jarFile, String udfClassPath, Type retType, Object[] originalArgs, Object[] args) throws ImpalaException, TException {
        int inputBufferSize = 0;
        ArrayList inputByteOffsets = Lists.newArrayList();
        ArrayList argTypes = Lists.newArrayList();
        for (Object originalArg : originalArgs) {
            Preconditions.checkNotNull((Object)originalArg);
            Type argType = this.getType(originalArg);
            inputByteOffsets.add(inputBufferSize);
            inputBufferSize += argType.getSlotSize();
            argTypes.add(argType);
        }
        jarFile = Strings.nullToEmpty((String)jarFile);
        ScalarFunction scalar_fn = ScalarFunction.createForTesting((String)"default", (String)"fn", (List)argTypes, (Type)retType, (String)jarFile, (String)udfClassPath, null, null, (TFunctionBinaryType)TFunctionBinaryType.JAVA);
        TFunction fn = scalar_fn.toThrift();
        long inputNullsPtr = this.allocate(argTypes.size());
        for (int i = 0; i < argTypes.size(); ++i) {
            boolean isNull = args[i] == null;
            UnsafeUtil.UNSAFE.putByte(inputNullsPtr + (long)i, (byte)(isNull ? 1 : 0));
        }
        long inputBufferPtr = this.allocate(inputBufferSize);
        long outputNullPtr = this.allocate(1);
        long outputBufferPtr = this.allocate(retType.getSlotSize());
        THiveUdfExecutorCtorParams params = new THiveUdfExecutorCtorParams(fn, jarFile, (List)inputByteOffsets, inputNullsPtr, inputBufferPtr, outputNullPtr, outputBufferPtr);
        TSerializer serializer = new TSerializer((TProtocolFactory)PROTOCOL_FACTORY);
        return new UdfExecutor(serializer.serialize((TBase)params));
    }

    void TestUdfImpl(String jarFile, Class<?> c, Object expectedValue, Type expectedType, boolean validate, Object[] originalArgs, Object[] args) throws ImpalaException, MalformedURLException, TException {
        try (UdfExecutor e = this.createUdfExecutor(jarFile, c.getName(), expectedType, originalArgs, args);){
            int i;
            Method method = e.getMethod();
            Object[] inputArgs = new Object[args.length];
            for (i = 0; i < args.length; ++i) {
                this.validateArgType(args[i]);
                if (args[i] != null && args[i] instanceof String) {
                    if (method != null && method.getParameterTypes()[i] == Text.class) {
                        inputArgs[i] = this.createText((String)args[i]);
                        continue;
                    }
                    inputArgs[i] = this.createBytes((String)args[i]);
                    continue;
                }
                inputArgs[i] = args[i];
            }
            for (i = 0; i < 10; ++i) {
                long r = e.evaluateForTesting(inputArgs);
                if (!validate) continue;
                ArrayList errMsgs = Lists.newArrayList();
                this.ValidateReturnPtr(r, expectedValue, expectedType, errMsgs);
                if (errMsgs.isEmpty()) continue;
                errMsgs.add("Eval iteration:  " + i);
                errMsgs.add("Return type:     " + expectedType.toSql());
                ArrayList argTypeStrs = Lists.newArrayList();
                for (Object arg : args) {
                    argTypeStrs.add(arg.getClass().getSimpleName());
                }
                errMsgs.add("Argument types:  " + Joiner.on((String)",").join((Iterable)argTypeStrs));
                if (e.getMethod() != null) {
                    errMsgs.add("Resolved method: " + e.getMethod().toGenericString());
                }
                Assert.fail((String)("\n" + Joiner.on((String)"\n").join((Iterable)errMsgs)));
            }
        }
    }

    void ValidateReturnPtr(long r, Object expectedValue, Type expectedType, List<String> errMsgs) {
        if (expectedValue == null) {
            if (r != 0L) {
                errMsgs.add("Expected NULL but got non-NULL result.");
            }
            return;
        }
        if (r == 0L) {
            errMsgs.add("Expected non-NULL but got NULL result.");
            return;
        }
        switch (expectedType.getPrimitiveType()) {
            case BOOLEAN: {
                boolean actual;
                boolean expected = ((ImpalaBooleanWritable)expectedValue).get();
                boolean bl = actual = UnsafeUtil.UNSAFE.getByte(r) != 0;
                if (expected == actual) break;
                errMsgs.add("Expected bool: " + expected);
                errMsgs.add("Actual bool:   " + actual);
                break;
            }
            case TINYINT: {
                byte expected = ((ImpalaTinyIntWritable)expectedValue).get();
                byte actual = UnsafeUtil.UNSAFE.getByte(r);
                if (expected == actual) break;
                errMsgs.add("Expected tinyint: " + expected);
                errMsgs.add("Actual tinyint:   " + actual);
                break;
            }
            case SMALLINT: {
                short expected = ((ImpalaSmallIntWritable)expectedValue).get();
                short actual = UnsafeUtil.UNSAFE.getShort(r);
                if (expected == actual) break;
                errMsgs.add("Expected smallint: " + expected);
                errMsgs.add("Actual smallint:   " + actual);
                break;
            }
            case INT: {
                int expected = ((ImpalaIntWritable)expectedValue).get();
                int actual = UnsafeUtil.UNSAFE.getInt(r);
                if (expected == actual) break;
                errMsgs.add("Expected int: " + expected);
                errMsgs.add("Actual int:   " + actual);
                break;
            }
            case BIGINT: {
                long expected = ((ImpalaBigIntWritable)expectedValue).get();
                long actual = UnsafeUtil.UNSAFE.getLong(r);
                if (expected == actual) break;
                errMsgs.add("Expected bigint: " + expected);
                errMsgs.add("Actual bigint:   " + actual);
                break;
            }
            case FLOAT: {
                float expected = ((ImpalaFloatWritable)expectedValue).get();
                float actual = UnsafeUtil.UNSAFE.getFloat(r);
                if (expected == actual) break;
                errMsgs.add("Expected float: " + expected);
                errMsgs.add("Actual float:   " + actual);
                break;
            }
            case DOUBLE: {
                double expected = ((ImpalaDoubleWritable)expectedValue).get();
                double actual = UnsafeUtil.UNSAFE.getDouble(r);
                if (expected == actual) break;
                errMsgs.add("Expected double: " + expected);
                errMsgs.add("Actual double:   " + actual);
                break;
            }
            case STRING: 
            case BINARY: {
                byte[] expectedBytes = null;
                if (expectedValue instanceof ImpalaBytesWritable) {
                    expectedBytes = ((ImpalaBytesWritable)expectedValue).getBytes();
                } else if (expectedValue instanceof ImpalaTextWritable) {
                    expectedBytes = ((ImpalaTextWritable)expectedValue).getBytes();
                } else if (expectedValue instanceof String) {
                    expectedBytes = ((String)expectedValue).getBytes();
                } else {
                    Preconditions.checkState((boolean)false);
                }
                byte[] bytes = JavaUdfDataType.loadStringValueFromNativeHeap((long)r);
                if (Arrays.equals(expectedBytes, bytes)) break;
                errMsgs.add("Expected string: " + Bytes.toString((byte[])expectedBytes));
                errMsgs.add("Actual string:   " + Bytes.toString((byte[])bytes));
                errMsgs.add("Expected bytes:  " + Arrays.toString(expectedBytes));
                errMsgs.add("Actual bytes:    " + Arrays.toString(bytes));
                break;
            }
            default: {
                Preconditions.checkArgument((boolean)false);
            }
        }
    }

    void TestUdf(String jar, Class<?> c, Writable expectedValue, Object ... args) throws MalformedURLException, ImpalaException, TException {
        this.TestUdfImpl(jar, c, expectedValue, this.getType(expectedValue), true, args, args);
    }

    void TestUdf(String jar, Class<?> c, String expectedValue, Object ... args) throws MalformedURLException, ImpalaException, TException {
        this.TestUdfImpl(jar, c, expectedValue, this.getType(expectedValue), true, args, args);
    }

    void TestUdfWithNulls(String jar, Class<?> c, Writable originalExpectedValue, boolean expectNull, Object[] originalArgs, Object[] args) throws MalformedURLException, ImpalaException, TException {
        this.TestUdfImpl(jar, c, expectNull ? null : originalExpectedValue, this.getType(originalExpectedValue), true, originalArgs, args);
    }

    void TestHiveUdf(Class<?> c, Writable expectedValue, Object ... args) throws MalformedURLException, ImpalaException, TException {
        this.TestUdfImpl(this.HIVE_BUILTIN_JAR, c, expectedValue, this.getType(expectedValue), true, args, args);
    }

    void TestHiveUdfNoValidate(Class<?> c, Writable expectedValue, Object ... args) throws MalformedURLException, ImpalaException, TException {
        this.TestUdfImpl(this.HIVE_BUILTIN_JAR, c, expectedValue, this.getType(expectedValue), false, args, args);
    }

    @Test
    public void HiveMathTest() throws ImpalaException, MalformedURLException, TException {
        this.TestHiveUdfNoValidate(UDFRand.class, this.createDouble(0.0), new Object[0]);
        this.TestHiveUdfNoValidate(UDFRand.class, this.createDouble(0.0), this.createBigInt(10L));
        this.TestHiveUdf(UDFExp.class, this.createDouble(Math.exp(10.0)), this.createDouble(10.0));
        this.TestHiveUdf(UDFLn.class, this.createDouble(Math.log(10.0)), this.createDouble(10.0));
        this.TestHiveUdf(UDFLog10.class, this.createDouble(Math.log10(10.0)), this.createDouble(10.0));
        this.TestHiveUdf(UDFLog2.class, this.createDouble(Math.log(10.0) / Math.log(2.0)), this.createDouble(10.0));
        this.TestHiveUdf(UDFLog.class, this.createDouble(Math.log(3.0) / Math.log(10.0)), this.createDouble(10.0), this.createDouble(3.0));
        this.TestHiveUdf(UDFSqrt.class, this.createDouble(Math.sqrt(3.0)), this.createDouble(3.0));
        this.TestHiveUdf(UDFSin.class, this.createDouble(Math.sin(1.0)), this.createDouble(1.0));
        this.TestHiveUdf(UDFAsin.class, this.createDouble(Math.asin(1.0)), this.createDouble(1.0));
        this.TestHiveUdf(UDFCos.class, this.createDouble(Math.cos(1.0)), this.createDouble(1.0));
        this.TestHiveUdf(UDFAcos.class, this.createDouble(Math.acos(1.0)), this.createDouble(1.0));
        this.TestHiveUdf(UDFTan.class, this.createDouble(Math.tan(1.0)), this.createDouble(1.0));
        this.TestHiveUdf(UDFAtan.class, this.createDouble(Math.atan(1.0)), this.createDouble(1.0));
        this.TestHiveUdf(UDFDegrees.class, this.createDouble(0.0), this.createDouble(0.0));
        this.TestHiveUdf(UDFRadians.class, this.createDouble(0.0), this.createDouble(0.0));
        this.TestHiveUdf(UDFPI.class, this.createDouble(Math.PI), new Object[0]);
        this.TestHiveUdf(UDFE.class, this.createDouble(Math.E), new Object[0]);
        this.TestHiveUdf(UDFSign.class, this.createDouble(1.0), this.createDouble(3.0));
        this.TestHiveUdf(UDFBin.class, this.createText("1100100"), this.createBigInt(100L));
        this.TestHiveUdf(UDFHex.class, this.createText("1F4"), this.createBigInt(500L));
        this.TestHiveUdf(UDFHex.class, this.createText("3E8"), this.createBigInt(1000L));
        this.TestHiveUdf(UDFHex.class, this.createText("31303030"), "1000");
        this.TestHiveUdf(UDFUnhex.class, this.createBytes("aAzZ"), "61417A5A");
        this.TestHiveUdf(UDFBase64.class, this.createText("YWJjZA=="), this.createBytes("abcd"));
        this.TestHiveUdf(UDFUnbase64.class, this.createBytes("abcd"), "YWJjZA==");
        this.TestHiveUdf(UDFConv.class, this.createText("1111011"), "123", this.createInt(10), this.createInt(2));
        this.freeAllocations();
    }

    @Test
    public void HiveStringsTest() throws ImpalaException, MalformedURLException, TException {
        this.TestHiveUdf(UDFAscii.class, this.createInt(49), "123");
        this.TestHiveUdf(UDFFindInSet.class, this.createInt(2), "31", "12,31,23");
        this.TestHiveUdf(UDFRepeat.class, this.createText("abcabc"), "abc", this.createInt(2));
        this.TestHiveUdf(UDFReverse.class, this.createText("cba"), "abc");
        this.TestHiveUdf(UDFSpace.class, this.createText("    "), this.createInt(4));
        this.TestHiveUdf(UDFSubstr.class, this.createText("World"), "HelloWorld", this.createInt(6), this.createInt(5));
        this.freeAllocations();
    }

    @Test
    public void HiveGenericTest() throws ImpalaException, MalformedURLException, TException {
        this.TestHiveUdf(GenericUDFBRound.class, this.createInt(1), this.createInt(1));
        this.TestHiveUdf(GenericUDFBRound.class, this.createDouble(1.0), this.createDouble(1.1));
        this.TestHiveUdf(GenericUDFUpper.class, this.createText("HELLO"), this.createText("Hello"));
    }

    void TestGenericUdf(Writable expectedValue, Object ... args) throws MalformedURLException, ImpalaException, TException {
        this.TestUdf(null, TestGenericUdf.class, expectedValue, args);
        this.TestUdf(null, TestGenericUdfWithJavaReturnTypes.class, expectedValue, args);
        Object[] nullArgs = new Object[args.length];
        this.TestUdfWithNulls(null, TestGenericUdf.class, expectedValue, true, args, nullArgs);
        this.TestUdfWithNulls(null, TestGenericUdfWithJavaReturnTypes.class, expectedValue, true, args, nullArgs);
    }

    @Test
    public void BasicGenericTest() throws ImpalaException, MalformedURLException, TException {
        this.TestGenericUdf(this.createBoolean(true), this.createBoolean(true));
        this.TestGenericUdf(this.createTinyInt(1), this.createTinyInt(1));
        this.TestGenericUdf(this.createSmallInt(1), this.createSmallInt(1));
        this.TestGenericUdf(this.createInt(1), this.createInt(1));
        this.TestGenericUdf(this.createBigInt(1L), this.createBigInt(1L));
        this.TestGenericUdf(this.createFloat(1.1f), this.createFloat(1.1f));
        this.TestGenericUdf(this.createDouble(1.1), this.createDouble(1.1));
        this.TestGenericUdf(this.createText("ABCD"), this.createText("ABCD"));
        this.TestGenericUdf(this.createBytes("ABCD"), this.createBytes("ABCD"));
        this.TestGenericUdf(this.createDouble(3.0), this.createDouble(1.0), this.createDouble(2.0));
        this.TestGenericUdf(this.createText("ABCXYZ"), this.createText("ABC"), this.createText("XYZ"));
        this.TestGenericUdf(this.createInt(3), this.createInt(1), this.createInt(2));
        this.TestGenericUdf(this.createFloat(2.3000002f), this.createFloat(1.1f), this.createFloat(1.2f));
        this.TestGenericUdf(this.createDouble(3.5999999999999996), this.createDouble(1.1), this.createDouble(1.2), this.createDouble(1.3));
        this.TestGenericUdf(this.createSmallInt(3), this.createSmallInt(1), this.createSmallInt(2));
        this.TestGenericUdf(this.createBoolean(true), this.createBoolean(true), this.createBoolean(false));
        this.TestGenericUdf(this.createInt(18), this.createInt(5), this.createInt(6), this.createInt(7));
        this.TestGenericUdf(this.createBoolean(true), this.createBoolean(false), this.createBoolean(false), this.createBoolean(true));
        this.TestGenericUdf(this.createFloat(3.6000001f), this.createFloat(1.1f), this.createFloat(1.2f), this.createFloat(1.3f));
        this.TestGenericUdf(this.createInt(26), this.createInt(5), this.createInt(6), this.createInt(7), this.createInt(8));
        this.TestGenericUdf(this.createBoolean(true), this.createBoolean(true), this.createBoolean(true), this.createBoolean(true), this.createBoolean(true));
        this.TestGenericUdf(this.createBytes("ABCDEFGH"), this.createBytes("ABCD"), this.createBytes("EFGH"));
        this.freeAllocations();
    }

    @Test
    public void BasicTest() throws ImpalaException, MalformedURLException, TException {
        this.TestUdf(null, TestUdf.class, this.createBoolean(true), this.createBoolean(true));
        this.TestUdf(null, TestUdf.class, this.createTinyInt(1), this.createTinyInt(1));
        this.TestUdf(null, TestUdf.class, this.createSmallInt(1), this.createSmallInt(1));
        this.TestUdf(null, TestUdf.class, this.createInt(1), this.createInt(1));
        this.TestUdf(null, TestUdf.class, this.createBigInt(1L), this.createBigInt(1L));
        this.TestUdf(null, TestUdf.class, this.createFloat(1.1f), this.createFloat(1.1f));
        this.TestUdf(null, TestUdf.class, this.createDouble(1.1), this.createDouble(1.1));
        this.TestUdf(null, TestUdf.class, this.createBytes("ABCD"), "ABCD");
        this.TestUdf(null, TestUdf.class, "ABCD", "ABCD");
        this.TestUdf(null, TestUdf.class, this.createDouble(3.0), this.createDouble(1.0), this.createDouble(2.0));
        this.TestUdf(null, TestUdf.class, "ABCXYZ", "ABC", "XYZ");
        this.TestUdf(null, TestUdf.class, this.createInt(3), this.createInt(1), this.createInt(2));
        this.TestUdf(null, TestUdf.class, this.createFloat(2.3000002f), this.createFloat(1.1f), this.createFloat(1.2f));
        this.TestUdf(null, TestUdf.class, this.createDouble(3.5999999999999996), this.createDouble(1.1), this.createDouble(1.2), this.createDouble(1.3));
        this.TestUdf(null, TestUdf.class, this.createSmallInt(3), this.createSmallInt(1), this.createSmallInt(2));
        this.TestUdf(null, TestUdf.class, this.createBoolean(true), this.createBoolean(true), this.createBoolean(true));
        this.TestUdf(null, TestUdf.class, this.createInt(18), this.createInt(5), this.createInt(6), this.createInt(7));
        this.TestUdf(null, TestUdf.class, this.createBoolean(true), this.createBoolean(true), this.createBoolean(true), this.createBoolean(true));
        this.TestUdf(null, TestUdf.class, this.createFloat(3.6000001f), this.createFloat(1.1f), this.createFloat(1.2f), this.createFloat(1.3f));
        this.TestUdf(null, TestUdf.class, this.createDouble(2.2), this.createInt(1), this.createDouble(1.2));
        this.TestUdf(null, TestUdf.class, this.createInt(26), this.createInt(5), this.createInt(6), this.createInt(7), this.createInt(8));
        this.TestUdf(null, TestUdf.class, this.createBoolean(true), this.createBoolean(true), this.createBoolean(true), this.createBoolean(true), this.createBoolean(true));
        this.freeAllocations();
    }
}

