/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hive.executor;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFAscii;
import org.apache.hadoop.hive.ql.udf.UDFLog;
import org.apache.hadoop.hive.ql.udf.UDFPI;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.hive.executor.HiveJavaFunction;
import org.apache.impala.hive.executor.HiveLegacyJavaFunction;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.junit.Assert;
import org.junit.Test;

public class HiveLegacyJavaFunctionTest {
    private static final String HIVE_BUILTIN_JAR = System.getenv("HIVE_HOME") + "/lib/hive-exec-" + System.getenv("IMPALA_HIVE_VERSION") + ".jar";
    private static final String DB = "Db";
    private static final String FN = "Fn";
    private static final String JARFILE = "JarFile";
    private static final String CLASSPATH = "ClassPath";

    @Test
    public void testExtractFailNoEvaluateMethods() {
        ExpectedFunctions expectedFuncs = new ExpectedFunctions();
        Class<DummyUDF> udfClass = DummyUDF.class;
        String expectedFunctionName = (udfClass.getSimpleName() + FN).toLowerCase();
        try {
            this.testScalar(udfClass, expectedFuncs);
        }
        catch (CatalogException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("No compatible signatures found for function: " + expectedFunctionName));
            return;
        }
        Assert.fail((String)"Extraction should not have succeeded.");
    }

    @Test
    public void testExtractFailNotAUDF() {
        ExpectedFunctions expectedFuncs = new ExpectedFunctions();
        Class<HiveLegacyJavaFunctionTest> udfClass = HiveLegacyJavaFunctionTest.class;
        try {
            this.testScalar(udfClass, expectedFuncs);
        }
        catch (CatalogException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unable to cast to UDF instance."));
            return;
        }
        Assert.fail((String)"Extraction should not have succeeded.");
    }

    @Test
    public void testExtract() throws CatalogException {
        Class<UDFPI> udfClass = UDFPI.class;
        ExpectedFunctions expectedFuncs = new ExpectedFunctions();
        expectedFuncs.add(new ExpectedFunction(udfClass, ScalarType.DOUBLE, Lists.newArrayList()));
        this.testScalar(udfClass, expectedFuncs);
        udfClass = UDFLog.class;
        expectedFuncs = new ExpectedFunctions();
        expectedFuncs.add(new ExpectedFunction(udfClass, ScalarType.DOUBLE, Lists.newArrayList((Object[])new ScalarType[]{ScalarType.DOUBLE})));
        expectedFuncs.add(new ExpectedFunction(udfClass, ScalarType.DOUBLE, Lists.newArrayList((Object[])new ScalarType[]{ScalarType.DOUBLE, ScalarType.DOUBLE})));
        this.testScalar(udfClass, expectedFuncs);
        udfClass = UDFAscii.class;
        expectedFuncs = new ExpectedFunctions();
        expectedFuncs.add(new ExpectedFunction(udfClass, ScalarType.INT, Lists.newArrayList((Object[])new ScalarType[]{ScalarType.STRING})));
        this.testScalar(udfClass, expectedFuncs);
    }

    private void testScalar(Class<?> classToTest, ExpectedFunctions expectedFuncs) throws CatalogException {
        ScalarFunction scalarFn = this.createScalarFn(classToTest);
        Function hiveFn = HiveJavaFunction.toHiveFunction((ScalarFunction)scalarFn);
        HiveLegacyJavaFunction javaFn = new HiveLegacyJavaFunction(classToTest, hiveFn, null, null);
        expectedFuncs.checkExpectedFuncs(javaFn.extract());
    }

    private ScalarFunction createScalarFn(Class<?> udfClass) {
        String simpleName = udfClass.getSimpleName();
        return ScalarFunction.createForTesting((String)(simpleName + DB), (String)(simpleName + FN), null, null, (String)(simpleName + JARFILE), (String)(simpleName + CLASSPATH), null, null, (TFunctionBinaryType)TFunctionBinaryType.JAVA);
    }

    private class ExpectedFunctions {
        public final List<ExpectedFunction> expectedFunctions = new ArrayList<ExpectedFunction>();

        private ExpectedFunctions() {
        }

        public void add(ExpectedFunction f) {
            this.expectedFunctions.add(f);
        }

        public int size() {
            return this.expectedFunctions.size();
        }

        public void checkExpectedFuncs(List<ScalarFunction> scalarFns) {
            ArrayList<ScalarFunction> scalarFnsCopy = new ArrayList<ScalarFunction>(scalarFns);
            for (ExpectedFunction expectedFunction : this.expectedFunctions) {
                boolean found = false;
                for (ScalarFunction scalarFn : scalarFnsCopy) {
                    if (!expectedFunction.matches(scalarFn)) continue;
                    found = true;
                    scalarFnsCopy.remove(scalarFn);
                    break;
                }
                if (found) continue;
                Assert.fail((String)("Expected function not extracted: " + expectedFunction.retType + " " + expectedFunction.className + "(" + Joiner.on((String)",").join(expectedFunction.paramTypes) + ")"));
            }
            if (!scalarFnsCopy.isEmpty()) {
                Assert.fail((String)("Extracted unexpected function " + ((ScalarFunction)scalarFnsCopy.get(0)).getFunctionName() + " with signature: " + ((ScalarFunction)scalarFnsCopy.get(0)).signatureString()));
            }
        }
    }

    private class ExpectedFunction {
        public final String className;
        public final ScalarType retType;
        public final List<ScalarType> paramTypes;
        public final String db;
        public final String fnName;
        public final String jarFile;
        public final String udfClassPath;

        public ExpectedFunction(Class<?> udfClass, ScalarType retType, List<ScalarType> paramTypes) {
            this.className = udfClass.getSimpleName();
            this.retType = retType;
            this.paramTypes = new ArrayList<ScalarType>(paramTypes);
            this.db = udfClass.getSimpleName() + HiveLegacyJavaFunctionTest.DB;
            this.fnName = udfClass.getSimpleName() + HiveLegacyJavaFunctionTest.FN;
            this.jarFile = udfClass.getSimpleName() + HiveLegacyJavaFunctionTest.JARFILE;
            this.udfClassPath = udfClass.getSimpleName() + HiveLegacyJavaFunctionTest.CLASSPATH;
        }

        public boolean matches(ScalarFunction fn) {
            if (!this.db.toLowerCase().equals(fn.dbName())) {
                return false;
            }
            if (!this.fnName.toLowerCase().equals(fn.functionName())) {
                return false;
            }
            if (!this.jarFile.equals(fn.getLocation().toString())) {
                return false;
            }
            if (!this.udfClassPath.equals(fn.getSymbolName())) {
                return false;
            }
            if (!this.retType.equals((Object)fn.getReturnType())) {
                return false;
            }
            if (this.paramTypes.size() != fn.getArgs().length) {
                return false;
            }
            for (int i = 0; i < this.paramTypes.size(); ++i) {
                if (this.paramTypes.get(i) == fn.getArgs()[i]) continue;
                return false;
            }
            return true;
        }
    }

    public static class DummyUDF
    extends UDF {
    }
}

