/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hive.common;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.impala.hive.common.MutableValidReaderWriteIdList;
import org.junit.Assert;
import org.junit.Test;

public class MutableValidReaderWriteIdListTest {
    private final String tableName = "t1";

    @Test
    public void noExceptions() {
        ValidReaderWriteIdList writeIdList = new ValidReaderWriteIdList("t1", new long[0], new BitSet(), 1L, Long.MAX_VALUE);
        MutableValidReaderWriteIdList mutableWriteIdList = new MutableValidReaderWriteIdList((ValidWriteIdList)writeIdList);
        String str = mutableWriteIdList.writeToString();
        Assert.assertEquals((Object)"t1:1:9223372036854775807::", (Object)str);
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdValid(1L));
        Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdValid(2L));
    }

    @Test
    public void exceptions() {
        ValidReaderWriteIdList writeIdList = new ValidReaderWriteIdList("t1", new long[]{2L, 4L}, new BitSet(), 5L, 4L);
        MutableValidReaderWriteIdList mutableWriteIdList = new MutableValidReaderWriteIdList((ValidWriteIdList)writeIdList);
        String str = mutableWriteIdList.writeToString();
        Assert.assertEquals((Object)"t1:5:4:2,4:", (Object)str);
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdValid(1L));
        Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdValid(2L));
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdValid(3L));
        Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdValid(4L));
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdValid(5L));
        Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdValid(6L));
    }

    @Test
    public void testRangeResponse() {
        int i;
        int i2;
        long[] exceptions = new long[1000];
        for (int i3 = 0; i3 < 1000; ++i3) {
            exceptions[i3] = i3 + 100;
        }
        ValidReaderWriteIdList writeIdList = new ValidReaderWriteIdList("t1", exceptions, new BitSet(), 2000L, 900L);
        MutableValidReaderWriteIdList mutableWriteIdList = new MutableValidReaderWriteIdList((ValidWriteIdList)writeIdList);
        for (i2 = 0; i2 < 100; ++i2) {
            Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdValid((long)i2));
        }
        Assert.assertEquals((Object)ValidWriteIdList.RangeResponse.ALL, (Object)mutableWriteIdList.isWriteIdRangeValid(0L, 99L));
        for (i2 = 100; i2 < 1100; ++i2) {
            Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdValid((long)i2));
        }
        Assert.assertEquals((Object)ValidWriteIdList.RangeResponse.NONE, (Object)mutableWriteIdList.isWriteIdRangeValid(100L, 1099L));
        for (i2 = 1100; i2 < 2001; ++i2) {
            Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdValid((long)i2));
        }
        Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdValid(2001L));
        Assert.assertEquals((Object)ValidWriteIdList.RangeResponse.SOME, (Object)mutableWriteIdList.isWriteIdRangeValid(1100L, 2001L));
        BitSet abortedBits = new BitSet();
        for (i = 0; i < 1000; ++i) {
            abortedBits.set(i);
        }
        writeIdList = new ValidReaderWriteIdList("t1", exceptions, abortedBits, 2000L, 900L);
        mutableWriteIdList = new MutableValidReaderWriteIdList((ValidWriteIdList)writeIdList);
        for (i = 0; i < 100; ++i) {
            Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdAborted((long)i));
        }
        Assert.assertEquals((Object)ValidWriteIdList.RangeResponse.NONE, (Object)mutableWriteIdList.isWriteIdRangeAborted(0L, 99L));
        for (i = 100; i < 1100; ++i) {
            Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdAborted((long)i));
        }
        Assert.assertEquals((Object)ValidWriteIdList.RangeResponse.ALL, (Object)mutableWriteIdList.isWriteIdRangeAborted(100L, 1099L));
        for (i = 1100; i < 2000; ++i) {
            Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdAborted((long)i));
        }
        Assert.assertEquals((Object)ValidWriteIdList.RangeResponse.SOME, (Object)mutableWriteIdList.isWriteIdRangeAborted(100L, 2000L));
    }

    @Test
    public void testAbortedTxn() {
        long[] exceptions = new long[]{2L, 4L, 6L, 8L, 10L};
        BitSet bitSet = new BitSet(exceptions.length);
        bitSet.set(0);
        bitSet.set(3);
        ValidReaderWriteIdList writeIdList = new ValidReaderWriteIdList("t1", exceptions, bitSet, 11L, 4L);
        MutableValidReaderWriteIdList mutableWriteIdList = new MutableValidReaderWriteIdList((ValidWriteIdList)writeIdList);
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdAborted(2L));
        Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdAborted(4L));
        Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdAborted(6L));
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdAborted(8L));
        Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdAborted(10L));
    }

    @Test
    public void testAddOpenWriteId() {
        long[] exceptions = new long[]{2L, 4L, 6L, 8L, 10L};
        BitSet bitSet = new BitSet(exceptions.length);
        bitSet.set(0);
        bitSet.set(3);
        ValidReaderWriteIdList writeIdList = new ValidReaderWriteIdList("t1", exceptions, bitSet, 11L, 4L);
        MutableValidReaderWriteIdList mutableWriteIdList = new MutableValidReaderWriteIdList((ValidWriteIdList)writeIdList);
        Assert.assertFalse((boolean)mutableWriteIdList.addOpenWriteId(4L));
        Assert.assertTrue((boolean)mutableWriteIdList.addOpenWriteId(13L));
        String str = mutableWriteIdList.writeToString();
        Assert.assertEquals((Object)"t1:13:4:4,6,10,12,13:2,8", (Object)str);
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdValid(11L));
        Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdValid(12L));
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdOpen(12L));
        Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdValid(13L));
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdOpen(13L));
    }

    @Test
    public void testAddAbortedWriteIds() {
        long[] exceptions = new long[]{2L, 4L, 6L, 8L, 10L};
        BitSet bitSet = new BitSet(exceptions.length);
        bitSet.set(0);
        bitSet.set(3);
        ValidReaderWriteIdList writeIdList = new ValidReaderWriteIdList("t1", exceptions, bitSet, 11L, 4L);
        MutableValidReaderWriteIdList mutableWriteIdList = new MutableValidReaderWriteIdList((ValidWriteIdList)writeIdList);
        mutableWriteIdList.addOpenWriteId(13L);
        Assert.assertFalse((boolean)mutableWriteIdList.addAbortedWriteIds(Collections.singletonList(2L)));
        Assert.assertTrue((boolean)mutableWriteIdList.addAbortedWriteIds(Arrays.asList(4L, 12L)));
        String str = mutableWriteIdList.writeToString();
        Assert.assertEquals((Object)"t1:13:6:6,10,13:2,4,8,12", (Object)str);
        Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdValid(4L));
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdAborted(4L));
        Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdValid(12L));
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdAborted(12L));
        Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdValid(13L));
        Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdAborted(13L));
    }

    @Test
    public void testAddCommittedWriteIds() {
        long[] exceptions = new long[]{2L, 4L, 6L, 8L, 10L};
        BitSet bitSet = new BitSet(exceptions.length);
        bitSet.set(0);
        bitSet.set(3);
        ValidReaderWriteIdList writeIdList = new ValidReaderWriteIdList("t1", exceptions, bitSet, 11L, 4L);
        MutableValidReaderWriteIdList mutableWriteIdList = new MutableValidReaderWriteIdList((ValidWriteIdList)writeIdList);
        Assert.assertFalse((boolean)mutableWriteIdList.addCommittedWriteIds(Collections.singletonList(1L)));
        Assert.assertTrue((boolean)mutableWriteIdList.addCommittedWriteIds(Arrays.asList(4L, 10L)));
        String str = mutableWriteIdList.writeToString();
        Assert.assertEquals((Object)"t1:11:6:6:2,8", (Object)str);
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdAborted(2L));
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdValid(4L));
        Assert.assertFalse((boolean)mutableWriteIdList.isWriteIdValid(6L));
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdValid(10L));
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdValid(11L));
    }

    @Test(expected=IllegalStateException.class)
    public void testAddAbortedToCommitted() {
        long[] exceptions = new long[]{2L, 4L, 6L, 8L, 10L};
        BitSet bitSet = new BitSet(exceptions.length);
        bitSet.set(0);
        bitSet.set(3);
        ValidReaderWriteIdList writeIdList = new ValidReaderWriteIdList("t1", exceptions, bitSet, 11L, 4L);
        MutableValidReaderWriteIdList mutableWriteIdList = new MutableValidReaderWriteIdList((ValidWriteIdList)writeIdList);
        mutableWriteIdList.addCommittedWriteIds(Collections.singletonList(2L));
    }

    @Test
    public void testAddNotOpenToCommitted() {
        long[] exceptions = new long[]{2L, 4L, 6L, 8L, 10L};
        BitSet bitSet = new BitSet(exceptions.length);
        bitSet.set(0);
        bitSet.set(3);
        ValidReaderWriteIdList writeIdList = new ValidReaderWriteIdList("t1", exceptions, bitSet, 11L, 4L);
        MutableValidReaderWriteIdList mutableWriteIdList = new MutableValidReaderWriteIdList((ValidWriteIdList)writeIdList);
        Assert.assertTrue((boolean)mutableWriteIdList.addCommittedWriteIds(Collections.singletonList(13L)));
        String str = mutableWriteIdList.writeToString();
        Assert.assertEquals((Object)"t1:13:4:4,6,10,12:2,8", (Object)str);
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdOpen(12L));
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdValid(13L));
    }

    @Test
    public void testAddNotOpenToAborted() {
        long[] exceptions = new long[]{2L, 4L, 6L, 8L, 10L};
        BitSet bitSet = new BitSet(exceptions.length);
        bitSet.set(0);
        bitSet.set(3);
        ValidReaderWriteIdList writeIdList = new ValidReaderWriteIdList("t1", exceptions, bitSet, 11L, 4L);
        MutableValidReaderWriteIdList mutableWriteIdList = new MutableValidReaderWriteIdList((ValidWriteIdList)writeIdList);
        Assert.assertTrue((boolean)mutableWriteIdList.addAbortedWriteIds(Collections.singletonList(13L)));
        String str = mutableWriteIdList.writeToString();
        Assert.assertEquals((Object)"t1:13:4:4,6,10,12:2,8,13", (Object)str);
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdOpen(12L));
        Assert.assertTrue((boolean)mutableWriteIdList.isWriteIdAborted(13L));
    }
}

