/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.extdatasource.jdbc;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.impala.extdatasource.jdbc.JdbcDataSource;
import org.apache.impala.extdatasource.thrift.TBinaryPredicate;
import org.apache.impala.extdatasource.thrift.TCloseParams;
import org.apache.impala.extdatasource.thrift.TCloseResult;
import org.apache.impala.extdatasource.thrift.TColumnDesc;
import org.apache.impala.extdatasource.thrift.TComparisonOp;
import org.apache.impala.extdatasource.thrift.TGetNextParams;
import org.apache.impala.extdatasource.thrift.TGetNextResult;
import org.apache.impala.extdatasource.thrift.TOpenParams;
import org.apache.impala.extdatasource.thrift.TOpenResult;
import org.apache.impala.extdatasource.thrift.TPrepareParams;
import org.apache.impala.extdatasource.thrift.TPrepareResult;
import org.apache.impala.extdatasource.thrift.TRowBatch;
import org.apache.impala.extdatasource.thrift.TTableSchema;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TBackendGflags;
import org.apache.impala.thrift.TColumnType;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.thrift.TErrorCode;
import org.apache.impala.thrift.TPrimitiveType;
import org.apache.impala.thrift.TScalarType;
import org.apache.impala.thrift.TTypeNode;
import org.apache.impala.thrift.TTypeNodeType;
import org.apache.impala.thrift.TUniqueId;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class JdbcDataSourceTest {
    private static TBackendGflags origFlags;
    private static final Logger LOG;
    private static String initString_;
    private static JdbcDataSource jdbcDataSource_;
    private static String scanHandle_;
    private static TTableSchema schema_;
    private static List<List<TBinaryPredicate>> predicates_;
    private static List<List<TBinaryPredicate>> acceptedPredicates_;
    private static long expectReturnRows_;

    @BeforeClass
    public static void setup() {
        if (BackendConfig.INSTANCE == null) {
            BackendConfig.create((TBackendGflags)new TBackendGflags());
        }
        origFlags = BackendConfig.INSTANCE.getBackendCfg();
    }

    @AfterClass
    public static void teardown() {
        BackendConfig.create((TBackendGflags)origFlags);
    }

    @Test
    public void test01Init() {
        String colName = "id";
        TComparisonOp op = TComparisonOp.LE;
        TTypeNode typeNode = new TTypeNode();
        typeNode.setType(TTypeNodeType.SCALAR);
        TScalarType scalarType = new TScalarType();
        scalarType.setType(TPrimitiveType.INT);
        typeNode.setScalar_type(scalarType);
        TColumnType colType = new TColumnType();
        colType.setTypes((List)Lists.newArrayList((Object[])new TTypeNode[]{typeNode}));
        TColumnDesc col = new TColumnDesc().setName(colName).setType(colType);
        TColumnValue value = new TColumnValue();
        value.setInt_val(3);
        TBinaryPredicate idPredicate = new TBinaryPredicate().setCol(col).setOp(op).setValue(value);
        predicates_.add(Lists.newArrayList((Object[])new TBinaryPredicate[]{idPredicate}));
        expectReturnRows_ = 3L;
        LOG.info("setup predicates:{}, expectReturnRows: {}", predicates_, (Object)expectReturnRows_);
        boolean ret = jdbcDataSource_.convertInitStringToConfiguration(initString_);
        Assert.assertTrue((boolean)ret);
    }

    @Test
    public void test02Prepare() {
        TPrepareParams params = new TPrepareParams();
        params.setTable_name("test_strategy");
        params.setInit_string(initString_);
        params.setPredicates(predicates_);
        TPrepareResult resp = jdbcDataSource_.prepare(params);
        Assert.assertEquals((Object)TErrorCode.OK, (Object)resp.getStatus().status_code);
        if (resp.isSetAccepted_conjuncts()) {
            acceptedPredicates_ = Lists.newArrayList();
            List acceptedPredicatesIdx = resp.getAccepted_conjuncts();
            for (int i = acceptedPredicatesIdx.size() - 1; i >= 0; --i) {
                int acceptedPredIdx = (Integer)acceptedPredicatesIdx.get(i);
                acceptedPredicates_.add(predicates_.remove(acceptedPredIdx));
            }
            acceptedPredicates_ = Lists.reverse(acceptedPredicates_);
        }
        if (resp.isSetNum_rows_estimate()) {
            long estimate = resp.getNum_rows_estimate();
            Assert.assertEquals((long)5L, (long)estimate);
        }
    }

    @Test
    public void test03Open() {
        TOpenParams params = new TOpenParams();
        TUniqueId unique_id = new TUniqueId();
        unique_id.hi = -77195680861554825L;
        unique_id.lo = 0x2020202020202020L;
        params.setQuery_id(unique_id);
        params.setTable_name("test_strategy");
        params.setInit_string(initString_);
        schema_ = JdbcDataSourceTest.initSchema();
        params.setRow_schema(schema_);
        params.setBatch_size(5);
        params.setPredicates(acceptedPredicates_);
        TOpenResult resp = jdbcDataSource_.open(params);
        Assert.assertEquals((Object)TErrorCode.OK, (Object)resp.getStatus().status_code);
        scanHandle_ = resp.getScan_handle();
        Assert.assertTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{scanHandle_}));
    }

    @Test
    public void test04GetNext() {
        boolean eos;
        TGetNextParams params = new TGetNextParams();
        params.setScan_handle(scanHandle_);
        long totalNumRows = 0L;
        do {
            TGetNextResult resp = jdbcDataSource_.getNext(params);
            Assert.assertEquals((Object)TErrorCode.OK, (Object)resp.getStatus().status_code);
            eos = resp.isEos();
            TRowBatch rowBatch = resp.getRows();
            long numRows = rowBatch.getNum_rows();
            totalNumRows += numRows;
            List cols = rowBatch.getCols();
            Assert.assertEquals((long)schema_.getColsSize(), (long)cols.size());
        } while (!eos);
        Assert.assertEquals((long)expectReturnRows_, (long)totalNumRows);
    }

    @Test
    public void test05Close() {
        TCloseParams params = new TCloseParams();
        params.setScan_handle(scanHandle_);
        TCloseResult resp = jdbcDataSource_.close(params);
        Assert.assertEquals((Object)TErrorCode.OK, (Object)resp.getStatus().status_code);
    }

    private static TTableSchema initSchema() {
        TTableSchema schema = new TTableSchema();
        TColumnDesc col = new TColumnDesc();
        col.setName("id");
        TTypeNode typeNode = new TTypeNode();
        typeNode.setType(TTypeNodeType.SCALAR);
        TScalarType scalarType = new TScalarType();
        scalarType.setType(TPrimitiveType.INT);
        typeNode.setScalar_type(scalarType);
        TColumnType colType = new TColumnType();
        colType.setTypes((List)Lists.newArrayList((Object[])new TTypeNode[]{typeNode}));
        col.setType(colType);
        schema.addToCols(col);
        col = new TColumnDesc();
        col.setName("name");
        typeNode = new TTypeNode();
        typeNode.setType(TTypeNodeType.SCALAR);
        scalarType = new TScalarType();
        scalarType.setType(TPrimitiveType.STRING);
        typeNode.setScalar_type(scalarType);
        colType = new TColumnType();
        colType.setTypes((List)Lists.newArrayList((Object[])new TTypeNode[]{typeNode}));
        col.setType(colType);
        schema.addToCols(col);
        col = new TColumnDesc();
        col.setName("priority");
        typeNode = new TTypeNode();
        typeNode.setType(TTypeNodeType.SCALAR);
        scalarType = new TScalarType();
        scalarType.setType(TPrimitiveType.INT);
        typeNode.setScalar_type(scalarType);
        colType = new TColumnType();
        colType.setTypes((List)Lists.newArrayList((Object[])new TTypeNode[]{typeNode}));
        col.setType(colType);
        schema.addToCols(col);
        col = new TColumnDesc();
        col.setName("implementation");
        typeNode = new TTypeNode();
        typeNode.setType(TTypeNodeType.SCALAR);
        scalarType = new TScalarType();
        scalarType.setType(TPrimitiveType.STRING);
        typeNode.setScalar_type(scalarType);
        colType = new TColumnType();
        colType.setTypes((List)Lists.newArrayList((Object[])new TTypeNode[]{typeNode}));
        col.setType(colType);
        schema.addToCols(col);
        col = new TColumnDesc();
        col.setName("last_modified");
        typeNode = new TTypeNode();
        typeNode.setType(TTypeNodeType.SCALAR);
        scalarType = new TScalarType();
        scalarType.setType(TPrimitiveType.TIMESTAMP);
        typeNode.setScalar_type(scalarType);
        colType = new TColumnType();
        colType.setTypes((List)Lists.newArrayList((Object[])new TTypeNode[]{typeNode}));
        col.setType(colType);
        schema.addToCols(col);
        return schema;
    }

    static {
        LOG = LoggerFactory.getLogger(JdbcDataSourceTest.class);
        initString_ = "{\"database.type\":\"POSTGRES\", \"jdbc.url\":\"jdbc:postgresql://localhost:5432/functional\", \"jdbc.driver\":\"org.postgresql.Driver\", \"driver.url\":\"hdfs://localhost:20500/test-warehouse/data-sources/jdbc-drivers/postgresql-jdbc.jar\", \"dbcp.username\":\"hiveuser\", \"dbcp.password\":\"password\", \"table\":\"test_strategy\",\"column.mapping\":\"id=strategy_id\"}";
        jdbcDataSource_ = new JdbcDataSource();
        predicates_ = Lists.newArrayList();
        acceptedPredicates_ = Lists.newArrayList();
        expectReturnRows_ = 5L;
    }
}

