/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TEndpointTransport;
import org.apache.thrift.transport.TTransportException;

public class THttpClientWithHeaders
extends TEndpointTransport {
    private URL url_ = null;
    private final ByteArrayOutputStream requestBuffer_ = new ByteArrayOutputStream();
    private InputStream inputStream_ = null;
    private int connectTimeout_ = 0;
    private int readTimeout_ = 0;
    private Map<String, String> customHeaders_ = null;
    private Map<String, List<String>> responseHeaders_ = null;
    private final HttpHost host;
    private final HttpClient client;

    public THttpClientWithHeaders(TConfiguration config, String url) throws TTransportException {
        super(config);
        try {
            this.url_ = new URL(url);
            this.client = null;
            this.host = null;
        }
        catch (IOException iox) {
            throw new TTransportException((Throwable)iox);
        }
    }

    public THttpClientWithHeaders(String url) throws TTransportException {
        super(new TConfiguration());
        try {
            this.url_ = new URL(url);
            this.client = null;
            this.host = null;
        }
        catch (IOException iox) {
            throw new TTransportException((Throwable)iox);
        }
    }

    public THttpClientWithHeaders(TConfiguration config, String url, HttpClient client) throws TTransportException {
        super(config);
        try {
            this.url_ = new URL(url);
            this.client = client;
            this.host = new HttpHost(this.url_.getHost(), -1 == this.url_.getPort() ? this.url_.getDefaultPort() : this.url_.getPort(), this.url_.getProtocol());
        }
        catch (IOException iox) {
            throw new TTransportException((Throwable)iox);
        }
    }

    public THttpClientWithHeaders(String url, HttpClient client) throws TTransportException {
        super(new TConfiguration());
        try {
            this.url_ = new URL(url);
            this.client = client;
            this.host = new HttpHost(this.url_.getHost(), -1 == this.url_.getPort() ? this.url_.getDefaultPort() : this.url_.getPort(), this.url_.getProtocol());
        }
        catch (IOException iox) {
            throw new TTransportException((Throwable)iox);
        }
    }

    public void setConnectTimeout(int timeout) {
        this.connectTimeout_ = timeout;
        if (null != this.client) {
            this.client.getParams().setParameter("http.connection.timeout", (Object)this.connectTimeout_);
        }
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout_ = timeout;
        if (null != this.client) {
            this.client.getParams().setParameter("http.socket.timeout", (Object)this.readTimeout_);
        }
    }

    public void setCustomHeaders(Map<String, String> headers) {
        this.customHeaders_ = headers;
    }

    public void setCustomHeader(String key, String value) {
        if (this.customHeaders_ == null) {
            this.customHeaders_ = new HashMap<String, String>();
        }
        this.customHeaders_.put(key, value);
    }

    public void open() {
    }

    public void close() {
        if (null != this.inputStream_) {
            try {
                this.inputStream_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream_ = null;
        }
    }

    public boolean isOpen() {
        return true;
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        if (this.inputStream_ == null) {
            throw new TTransportException("Response buffer is empty, no request.");
        }
        this.checkReadBytesAvailable(len);
        try {
            int ret = this.inputStream_.read(buf, off, len);
            if (ret == -1) {
                throw new TTransportException("No more data available.");
            }
            this.countConsumedMessageBytes(ret);
            return ret;
        }
        catch (IOException iox) {
            throw new TTransportException((Throwable)iox);
        }
    }

    public void write(byte[] buf, int off, int len) {
        this.requestBuffer_.write(buf, off, len);
    }

    private static void consume(HttpEntity entity) throws IOException {
        InputStream instream;
        if (entity == null) {
            return;
        }
        if (entity.isStreaming() && (instream = entity.getContent()) != null) {
            instream.close();
        }
    }

    private void flushUsingHttpClient() throws TTransportException {
        if (null == this.client) {
            throw new TTransportException("Null HttpClient, aborting.");
        }
        byte[] data = this.requestBuffer_.toByteArray();
        this.requestBuffer_.reset();
        HttpPost post = null;
        InputStream is = null;
        try {
            post = new HttpPost(this.url_.getFile());
            post.setHeader("Content-Type", "application/x-thrift");
            post.setHeader("Accept", "application/x-thrift");
            post.setHeader("User-Agent", "Java/THttpClient/HC");
            if (null != this.customHeaders_) {
                for (Map.Entry<String, String> header : this.customHeaders_.entrySet()) {
                    post.setHeader(header.getKey(), header.getValue());
                }
            }
            post.setEntity((HttpEntity)new ByteArrayEntity(data));
            HttpResponse response = this.client.execute(this.host, (HttpRequest)post);
            int responseCode = response.getStatusLine().getStatusCode();
            is = response.getEntity().getContent();
            if (responseCode != 200) {
                throw new TTransportException("HTTP Response code: " + responseCode);
            }
            byte[] buf = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int len = 0;
            do {
                if ((len = is.read(buf)) <= 0) continue;
                baos.write(buf, 0, len);
            } while (-1 != len);
            try {
                THttpClientWithHeaders.consume(response.getEntity());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream_ = new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ioe) {
            if (null != post) {
                post.abort();
            }
            throw new TTransportException((Throwable)ioe);
        }
        finally {
            this.resetConsumedMessageSize(-1L);
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    throw new TTransportException((Throwable)ioe);
                }
            }
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    public void flush() throws TTransportException {
        if (null != this.client) {
            this.flushUsingHttpClient();
            return;
        }
        byte[] data = this.requestBuffer_.toByteArray();
        this.requestBuffer_.reset();
        try {
            HttpURLConnection connection = (HttpURLConnection)this.url_.openConnection();
            if (this.connectTimeout_ > 0) {
                connection.setConnectTimeout(this.connectTimeout_);
            }
            if (this.readTimeout_ > 0) {
                connection.setReadTimeout(this.readTimeout_);
            }
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-thrift");
            connection.setRequestProperty("Accept", "application/x-thrift");
            connection.setRequestProperty("User-Agent", "Java/THttpClient");
            if (this.customHeaders_ != null) {
                for (Map.Entry<String, String> header : this.customHeaders_.entrySet()) {
                    connection.setRequestProperty(header.getKey(), header.getValue());
                }
            }
            connection.setDoOutput(true);
            connection.connect();
            connection.getOutputStream().write(data);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new TTransportException("HTTP Response code: " + responseCode);
            }
            this.inputStream_ = connection.getInputStream();
            this.responseHeaders_ = connection.getHeaderFields();
        }
        catch (IOException iox) {
            throw new TTransportException((Throwable)iox);
        }
        finally {
            this.resetConsumedMessageSize(-1L);
        }
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders_;
    }
}

