/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import java.io.FileOutputStream;
import java.io.IOException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SpnegoTokenGenerator {
    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.err.println("Missing argument: <output-token-file>");
                System.exit(1);
            }
            String outputPath = args[0];
            Oid krb5Oid = new Oid("1.2.840.113554.1.2.2");
            GSSManager manager = GSSManager.getInstance();
            Oid krb5PrincipalOid = new Oid("1.2.840.113554.1.2.2.1");
            String servicePrincipal = "impala/localhost@myorg.com";
            GSSName serverName = manager.createName(servicePrincipal, krb5PrincipalOid);
            GSSContext context = manager.createContext(serverName, krb5Oid, null, 0);
            context.requestMutualAuth(true);
            context.requestCredDeleg(false);
            byte[] token = context.initSecContext(new byte[0], 0, 0);
            if (token != null) {
                try {
                    FileOutputStream fos = new FileOutputStream(outputPath);
                    fos.write(token);
                    System.out.println("Token written to " + outputPath);
                }
                catch (IOException e) {
                    System.err.println("Failed to write token to file: " + e.getMessage());
                    e.printStackTrace();
                    System.exit(1);
                }
            } else {
                System.err.println("Failed to obtain SPNEGO token.");
                System.exit(1);
            }
            context.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

