/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.CreateLdapServerRule;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TCloseOperationReq;
import org.apache.hive.service.rpc.thrift.TCloseOperationResp;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TExecuteStatementReq;
import org.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import org.apache.hive.service.rpc.thrift.TFetchOrientation;
import org.apache.hive.service.rpc.thrift.TFetchResultsReq;
import org.apache.hive.service.rpc.thrift.TFetchResultsResp;
import org.apache.hive.service.rpc.thrift.TOpenSessionReq;
import org.apache.hive.service.rpc.thrift.TOpenSessionResp;
import org.apache.hive.service.rpc.thrift.TOperationHandle;
import org.apache.hive.service.rpc.thrift.TSessionHandle;
import org.apache.hive.service.rpc.thrift.TStatus;
import org.apache.hive.service.rpc.thrift.TStatusCode;
import org.apache.impala.customcluster.KerberosKdcEnvironment;
import org.apache.impala.customcluster.THttpClientWithHeaders;
import org.apache.impala.testutil.WebClient;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CreateDS(name="myDS", partitions={@CreatePartition(name="test", suffix="dc=myorg,dc=com")})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")})
@ApplyLdifFiles(value={"users.ldif"})
public class SpnegoAuthTest {
    private static final Logger LOG = LoggerFactory.getLogger(SpnegoAuthTest.class);
    @ClassRule
    public static CreateLdapServerRule serverRule = new CreateLdapServerRule();
    @ClassRule
    public static KerberosKdcEnvironment kerberosKdcEnvironment = new KerberosKdcEnvironment(new TemporaryFolder());
    WebClient client_ = new WebClient();

    protected Map<String, String> getLdapFlags() {
        String ldapUri = String.format("ldap://localhost:%s", serverRule.getLdapServer().getPort());
        String passwordCommand = String.format("'echo -n %s'", "12345");
        return ImmutableMap.builder().put((Object)"enable_ldap_auth", (Object)"true").put((Object)"ldap_uri", (Object)ldapUri).put((Object)"ldap_bind_pattern", (Object)"cn=#UID,ou=Users,dc=myorg,dc=com").put((Object)"ldap_passwords_in_clear_ok", (Object)"true").put((Object)"ldap_bind_dn", (Object)"cn=Test1Ldap,ou=Users,dc=myorg,dc=com").put((Object)"ldap_bind_password_cmd", (Object)passwordCommand).build();
    }

    @After
    public void cleanUp() throws IOException {
        this.client_.close();
    }

    protected int startImpalaCluster(String args) throws IOException, InterruptedException {
        return kerberosKdcEnvironment.startImpalaClusterWithArgs(args);
    }

    public static String flagsToArgs(Map<String, String> flags) {
        return flags.entrySet().stream().map(entry -> "--" + (String)entry.getKey() + "=" + (String)entry.getValue() + " ").collect(Collectors.joining());
    }

    @SafeVarargs
    public static Map<String, String> mergeFlags(Map<String, String> ... flags) {
        return Arrays.stream(flags).filter(Objects::nonNull).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static void verifySuccess(TStatus status) throws Exception {
        if (status.getStatusCode() == TStatusCode.SUCCESS_STATUS || status.getStatusCode() == TStatusCode.SUCCESS_WITH_INFO_STATUS) {
            return;
        }
        throw new Exception(status.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void execAndFetch(TCLIService.Iface client, TSessionHandle sessionHandle, String query, String expectedResult) throws Exception {
        TOperationHandle handle = null;
        try {
            TExecuteStatementReq execReq = new TExecuteStatementReq(sessionHandle, query);
            TExecuteStatementResp execResp = client.ExecuteStatement(execReq);
            SpnegoAuthTest.verifySuccess(execResp.getStatus());
            handle = execResp.getOperationHandle();
            TFetchResultsReq fetchReq = new TFetchResultsReq(handle, TFetchOrientation.FETCH_NEXT, 1000L);
            TFetchResultsResp fetchResp = client.FetchResults(fetchReq);
            SpnegoAuthTest.verifySuccess(fetchResp.getStatus());
            List columns = fetchResp.getResults().getColumns();
            Assert.assertEquals((long)1L, (long)columns.size());
            if (expectedResult != null) {
                Assert.assertEquals((Object)expectedResult, ((TColumn)columns.get(0)).getStringVal().getValues().get(0));
            }
            if (handle == null) return;
        }
        catch (Throwable throwable) {
            if (handle == null) throw throwable;
            TCloseOperationReq closeReq = new TCloseOperationReq(handle);
            TCloseOperationResp closeResp = client.CloseOperation(closeReq);
            SpnegoAuthTest.verifySuccess(closeResp.getStatus());
            throw throwable;
        }
        TCloseOperationReq closeReq = new TCloseOperationReq(handle);
        TCloseOperationResp closeResp = client.CloseOperation(closeReq);
        SpnegoAuthTest.verifySuccess(closeResp.getStatus());
    }

    private void verifyNegotiateAuthMetrics(long expectedBasicAuthSuccess, long expectedBasicAuthFailure) throws Exception {
        long actualBasicAuthSuccess = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-negotiate-auth-success");
        Assert.assertEquals((long)expectedBasicAuthSuccess, (long)actualBasicAuthSuccess);
        long actualBasicAuthFailure = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-negotiate-auth-failure");
        Assert.assertEquals((long)expectedBasicAuthFailure, (long)actualBasicAuthFailure);
    }

    private void verifyCookieAuthMetrics(long expectedCookieAuthSuccess, long expectedCookieAuthFailure) throws Exception {
        long actualCookieAuthSuccess = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-cookie-auth-success");
        Assert.assertEquals((long)expectedCookieAuthSuccess, (long)actualCookieAuthSuccess);
        long actualCookieAuthFailure = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-cookie-auth-failure");
        Assert.assertEquals((long)expectedCookieAuthFailure, (long)actualCookieAuthFailure);
    }

    @Test
    public void testImpersonation() throws Exception, Throwable {
        Map<String, String> flags = SpnegoAuthTest.mergeFlags(new Map[]{kerberosKdcEnvironment.getKerberosAuthFlags(), this.getLdapFlags(), ImmutableMap.of((Object)"ldap_group_filter", (Object)String.format("%s,another-group", "group1"), (Object)"ldap_user_filter", (Object)String.format("%s,%s,another-user", "Test1Ldap", "Test3Ldap"), (Object)"ldap_group_dn_pattern", (Object)"cn=%s,ou=Groups,dc=myorg,dc=com", (Object)"ldap_group_membership_key", (Object)"uniqueMember", (Object)"ldap_group_class_key", (Object)"groupOfUniqueNames", (Object)"allow_custom_ldap_filters_with_kerberos_auth", (Object)"true", (Object)"authorized_proxy_user_config", (Object)String.format("%s=*", "Test4Ldap"))});
        int ret = this.startImpalaCluster(SpnegoAuthTest.flagsToArgs(flags));
        Assert.assertEquals((long)0L, (long)ret);
        THttpClientWithHeaders transport = new THttpClientWithHeaders("http://localhost:28000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Negotiate " + SpnegoAuthTest.getSpnegoToken("Test4Ldap"));
        transport.setCustomHeaders(headers);
        transport.open();
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        TOpenSessionReq openReq = new TOpenSessionReq();
        TOpenSessionResp openResp = client.OpenSession(openReq);
        Assert.assertEquals((Object)TStatusCode.ERROR_STATUS, (Object)openResp.getStatus().getStatusCode());
        int negotiateAuthFailureCount = 0;
        int negotiateAuthSuccessCount = 1;
        this.verifyNegotiateAuthMetrics(negotiateAuthSuccessCount, negotiateAuthFailureCount);
        int cookieAuthFailureCount = 0;
        int cookieAuthSuccessCount = 0;
        this.verifyCookieAuthMetrics(cookieAuthSuccessCount, cookieAuthFailureCount);
        headers.remove("Authorization");
        headers.put("Authorization", "Negotiate " + SpnegoAuthTest.getSpnegoToken("Test4Ldap"));
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("impala.doas.user", "Test1Ldap");
        openReq.setConfiguration(config);
        openResp = client.OpenSession(openReq);
        Assert.assertEquals((Object)TStatusCode.SUCCESS_STATUS, (Object)openResp.getStatus().getStatusCode());
        this.verifyNegotiateAuthMetrics(++negotiateAuthSuccessCount, negotiateAuthFailureCount);
        this.verifyCookieAuthMetrics(cookieAuthSuccessCount, cookieAuthFailureCount);
        Map<String, List<String>> responseHeaders = transport.getResponseHeaders();
        List<String> cookies = responseHeaders.get("Set-Cookie");
        if (cookies != null) {
            for (String cookie : cookies) {
                String authMech = SpnegoAuthTest.extractCookieAuthMech(cookie);
                Assert.assertNotNull((Object)authMech);
                Assert.assertEquals((Object)"SPNEGO", (Object)authMech);
                headers.put("Cookie", cookie);
            }
        } else {
            Assert.fail((String)"'Set-Cookie' cookie not returned from Impala");
        }
        int numClients = 4;
        int numQueries = 100;
        ExecutorService executor = Executors.newFixedThreadPool(4);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        int i = 0;
        while (i < 4) {
            int clientId = i++;
            Future<Void> future = executor.submit(() -> {
                SpnegoAuthTest.simulateClient(headers, config, clientId, 100);
                return null;
            });
            futures.add(future);
        }
        executor.shutdown();
        executor.awaitTermination(5L, TimeUnit.MINUTES);
        for (i = 0; i < futures.size(); ++i) {
            try {
                ((Future)futures.get(i)).get();
                continue;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                System.err.println("Client " + i + " failed: " + cause.getMessage());
                cause.printStackTrace();
                Assert.fail((String)("Client " + i + " failed: " + cause.getMessage()));
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.err.println("Main thread interrupted.");
            }
        }
        this.verifyCookieAuthMetrics(cookieAuthSuccessCount += 1204, cookieAuthFailureCount);
        this.verifyNegotiateAuthMetrics(negotiateAuthSuccessCount, negotiateAuthFailureCount);
    }

    private static String getSpnegoToken(String user) throws Exception {
        String ccacheFilePath = kerberosKdcEnvironment.createUserPrincipalAndCredentialsCache(user);
        File spngeoTokenFile = new File(kerberosKdcEnvironment.getTestFolderPath() + "/spngeoToken.bin");
        ProcessBuilder pb = new ProcessBuilder("java", "-cp", System.getProperty("java.class.path"), "-Djava.security.krb5.conf=" + kerberosKdcEnvironment.getKrb5ConfigPath(), "-Dsun.security.krb5.debug=true", "-Djava.security.debug=gssloginconfig,configfile,configparser,logincontext,JGSS", "-Djavax.security.auth.useSubjectCredsOnly=false", "org.apache.impala.customcluster.SpnegoTokenGenerator", spngeoTokenFile.getCanonicalPath());
        Map<String, String> env = pb.environment();
        env.put("KRB5CCNAME", "FILE:" + ccacheFilePath);
        pb.inheritIO();
        Process process = pb.start();
        int exitCode = process.waitFor();
        Assert.assertEquals((long)0L, (long)exitCode);
        byte[] token = SpnegoAuthTest.readTokenFromFile(spngeoTokenFile.getCanonicalPath());
        String base64Token = Base64.getEncoder().encodeToString(token);
        return base64Token;
    }

    private static byte[] readTokenFromFile(String path) throws IOException {
        int bytesRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        FileInputStream is = new FileInputStream(path);
        byte[] temp = new byte[4096];
        while ((bytesRead = ((InputStream)is).read(temp)) != -1) {
            buffer.write(temp, 0, bytesRead);
        }
        ((InputStream)is).close();
        return buffer.toByteArray();
    }

    private static void simulateClient(Map<String, String> headers, Map<String, String> config, int clientId, int numQueries) throws Exception {
        THttpClientWithHeaders transport = new THttpClientWithHeaders("http://localhost:28000");
        transport.setCustomHeaders(headers);
        transport.open();
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        TOpenSessionReq openReq = new TOpenSessionReq();
        openReq.setConfiguration(config);
        TOpenSessionResp openResp = client.OpenSession(openReq);
        if (openResp.getStatus().getStatusCode() != TStatusCode.SUCCESS_STATUS) {
            throw new RuntimeException("Failed to open session for client " + clientId);
        }
        System.out.println("Client " + clientId + " opened session successfully.");
        for (int i = 0; i < numQueries; ++i) {
            SpnegoAuthTest.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "Test1Ldap");
            int sleepMillis = ThreadLocalRandom.current().nextInt(10, 100);
            Thread.sleep(sleepMillis);
        }
        transport.close();
        System.out.println("Client " + clientId + " finished.");
    }

    private static String extractCookieAuthMech(String cookie) throws Exception {
        if (cookie == null || cookie.isEmpty()) {
            return null;
        }
        String[] cookieFields = cookie.split(";");
        if (cookieFields.length == 0) {
            return null;
        }
        String[] cookieValueFields = cookieFields[0].trim().split("&");
        Assert.assertEquals((long)5L, (long)cookieValueFields.length);
        String[] authMech = cookieValueFields[4].trim().split("=");
        Assert.assertEquals((long)2L, (long)authMech.length);
        Assert.assertEquals((Object)"a", (Object)authMech[0]);
        return authMech[1];
    }
}

