/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.impala.customcluster.KerberosKdcEnvironment;
import org.apache.impala.customcluster.LdapImpalaShellTest;
import org.apache.impala.customcluster.LdapKerberosImpalaShellTestBase;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@CreateDS(name="myDS", partitions={@CreatePartition(name="test", suffix="dc=myorg,dc=com")})
@RunWith(value=Parameterized.class)
public class LdapSimpleBindImpalaShellTest
extends LdapImpalaShellTest {
    @ClassRule
    public static KerberosKdcEnvironment kerberosKdcEnvironment = new KerberosKdcEnvironment(new TemporaryFolder());
    private final boolean kerberosAuthenticationEnabled;

    @Parameterized.Parameters(name="kerberosAuthenticationEnabled={0}")
    public static Boolean[] kerberosAuthenticationEnabled() {
        return new Boolean[]{Boolean.FALSE, Boolean.TRUE};
    }

    public LdapSimpleBindImpalaShellTest(boolean isKerberosAuthenticationEnabled) {
        this.kerberosAuthenticationEnabled = isKerberosAuthenticationEnabled;
    }

    @Override
    protected int startImpalaCluster(String args) throws IOException, InterruptedException {
        if (this.kerberosAuthenticationEnabled) {
            return kerberosKdcEnvironment.startImpalaClusterWithArgs(args);
        }
        return super.startImpalaCluster(args);
    }

    @Override
    public void setUp(String extraArgs) throws Exception {
        String dn = "cn=#UID,ou=Users,dc=myorg,dc=com";
        String simpleBindArgs = String.format("--ldap_bind_pattern='%s' %s %s", dn, this.getKerberosArgs(), extraArgs);
        super.setUp(simpleBindArgs);
    }

    private String getKerberosArgs() throws IOException {
        return this.kerberosAuthenticationEnabled ? LdapKerberosImpalaShellTestBase.flagsToArgs(LdapKerberosImpalaShellTestBase.mergeFlags(new Map[]{kerberosKdcEnvironment.getKerberosAuthFlags(), ImmutableMap.of((Object)"allow_custom_ldap_filters_with_kerberos_auth", (Object)"true")})) : "";
    }

    @Test
    public void testShellLdapAuth() throws Exception {
        this.setUp("--test_cookie=impala.ldap=testShellLdapAuth");
        this.testShellLdapAuthImpl("impala.ldap");
    }

    @Test
    public void testHttpImpersonation() throws Exception {
        this.setUp(String.format("--authorized_proxy_user_config=%s=%s", "Test1Ldap", "proxyUser$"));
        this.testHttpImpersonationImpl();
    }

    @Test
    public void testLdapFilters() throws Exception {
        this.setUp(String.format("--ldap_group_filter=%s,another-group --ldap_user_filter=%s,%s,another-user --ldap_group_dn_pattern=%s --ldap_group_membership_key=uniqueMember --ldap_group_class_key=groupOfUniqueNames --ldap_bind_dn=%s --ldap_bind_password_cmd='echo -n %s' ", "group1", "Test1Ldap", "Test3Ldap", "cn=%s,ou=Groups,dc=myorg,dc=com", "cn=Test1Ldap,ou=Users,dc=myorg,dc=com", "12345"));
        this.testLdapFiltersImpl();
    }

    @Test
    public void testLdapFiltersWithProxy() throws Exception {
        this.setUp(String.format("--ldap_group_filter=%s,another-group --ldap_user_filter=%s,%s,another-user --ldap_group_dn_pattern=%s --ldap_group_membership_key=uniqueMember --ldap_group_class_key=groupOfUniqueNames --authorized_proxy_user_config=%s=* --ldap_bind_dn=%s --ldap_bind_password_cmd='echo -n %s' ", "group1", "Test1Ldap", "Test3Ldap", "cn=%s,ou=Groups,dc=myorg,dc=com", "Test4Ldap", "cn=Test1Ldap,ou=Users,dc=myorg,dc=com", "12345"));
        this.testLdapFiltersWithProxyImpl();
    }
}

