/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.impala.customcluster.KerberosKdcEnvironment;
import org.apache.impala.customcluster.LdapImpalaShellTest;
import org.apache.impala.customcluster.RunShellCommand;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;

public class LdapKerberosImpalaShellTestBase
extends LdapImpalaShellTest {
    protected static final String defaultUserSearchBaseDn = "dc=myorg,dc=com";
    protected static final String defaultGroupSearchBaseDn = "ou=Groups,dc=myorg,dc=com";
    @ClassRule
    public static KerberosKdcEnvironment kerberosKdcEnvironment = new KerberosKdcEnvironment(new TemporaryFolder());

    protected Map<String, String> getLdapSearchBindFlags() {
        return this.getLdapSearchBindFlags(defaultUserSearchBaseDn, defaultGroupSearchBaseDn);
    }

    protected Map<String, String> getLdapSearchBindFlags(String userSearchBaseDn, String groupSearchBaseDn) {
        String ldapUri = String.format("ldap://localhost:%s", serverRule.getLdapServer().getPort());
        String passwordCommand = String.format("'echo -n %s'", "12345");
        return ImmutableMap.builder().put((Object)"enable_ldap_auth", (Object)"true").put((Object)"ldap_uri", (Object)ldapUri).put((Object)"ldap_passwords_in_clear_ok", (Object)"true").put((Object)"ldap_user_search_basedn", (Object)userSearchBaseDn).put((Object)"ldap_group_search_basedn", (Object)groupSearchBaseDn).put((Object)"ldap_search_bind_authentication", (Object)"true").put((Object)"ldap_bind_dn", (Object)"cn=Test1Ldap,ou=Users,dc=myorg,dc=com").put((Object)"ldap_bind_password_cmd", (Object)passwordCommand).build();
    }

    protected Map<String, String> getCustomLdapFilterFlags() {
        String customLdapUserFilter = String.format("(&(objectClass=person)(cn={0})(!(cn=%s)))", "Test2Ldap");
        String customLdapGroupFilter = "(uniqueMember={0})";
        return ImmutableMap.of((Object)"ldap_user_filter", (Object)customLdapUserFilter, (Object)"ldap_group_filter", (Object)customLdapGroupFilter);
    }

    @Override
    protected int startImpalaCluster(String args) throws IOException, InterruptedException {
        return kerberosKdcEnvironment.startImpalaClusterWithArgs(args);
    }

    public static String flagsToArgs(Map<String, String> flags) {
        return flags.entrySet().stream().map(entry -> "--" + (String)entry.getKey() + "=" + (String)entry.getValue() + " ").collect(Collectors.joining());
    }

    @SafeVarargs
    public static Map<String, String> mergeFlags(Map<String, String> ... flags) {
        return Arrays.stream(flags).filter(Objects::nonNull).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected void testShellKerberosAuthWithUserWithHttpPath(KerberosKdcEnvironment kerberosKdcEnvironment, String username, String httpPath, boolean shouldSucceed, String expectedOut, String expectedErr) throws Exception {
        String[] command = new String[]{"impala-shell.sh", "--protocol=hs2-http", "--kerberos", "--query=select logged_in_user()", "--http_path=" + httpPath};
        String credentialsCacheFilePath = kerberosKdcEnvironment.createUserPrincipalAndCredentialsCache(username);
        RunShellCommand.Run(command, kerberosKdcEnvironment.getImpalaShellEnv(credentialsCacheFilePath), shouldSucceed, expectedOut, expectedErr);
    }
}

