/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.impala.customcluster.KerberosKdcEnvironment;
import org.apache.impala.customcluster.LdapKerberosImpalaShellTestBase;
import org.apache.impala.customcluster.RunShellCommand;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

@CreateDS(name="myDS", partitions={@CreatePartition(name="test", suffix="dc=myorg,dc=com")})
@ApplyLdifFiles(value={"users.ldif"})
public class LdapKerberosImpalaShellTest
extends LdapKerberosImpalaShellTestBase {
    @Test
    public void testShellKerberosAuthWithCustomLdapFiltersAndSearchBindNoGroupFilterCheck() throws Exception {
        Map<String, String> flags = LdapKerberosImpalaShellTest.mergeFlags(new Map[]{kerberosKdcEnvironment.getKerberosAuthFlags(), this.getLdapSearchBindFlags(), ImmutableMap.of((Object)"allow_custom_ldap_filters_with_kerberos_auth", (Object)"true"), this.getCustomLdapFilterFlags()});
        int ret = this.startImpalaCluster(LdapKerberosImpalaShellTest.flagsToArgs(flags));
        Assert.assertEquals((long)ret, (long)0L);
        this.testShellKerberosAuthWithUser(kerberosKdcEnvironment, "user", true);
    }

    @Test
    public void testShellKerberosAuthWithCustomLdapFiltersAndSearchBindGroupFilterCheck() throws Exception {
        Map<String, String> flags = LdapKerberosImpalaShellTest.mergeFlags(new Map[]{kerberosKdcEnvironment.getKerberosAuthFlags(), this.getLdapSearchBindFlags(), ImmutableMap.of((Object)"allow_custom_ldap_filters_with_kerberos_auth", (Object)"true"), this.getCustomLdapFilterFlags(), ImmutableMap.of((Object)"enable_group_filter_check_for_authenticated_kerberos_user", (Object)"true")});
        int ret = this.startImpalaCluster(LdapKerberosImpalaShellTest.flagsToArgs(flags));
        Assert.assertEquals((long)ret, (long)0L);
        this.testShellKerberosAuthWithUser(kerberosKdcEnvironment, "Test1Ldap", true);
        this.testShellKerberosAuthWithUser(kerberosKdcEnvironment, "Test2Ldap", false);
        this.testShellKerberosAuthWithUser(kerberosKdcEnvironment, "Test3Ldap", false);
        this.testShellKerberosAuthWithUser(kerberosKdcEnvironment, "user", false);
    }

    @Test
    public void testHttpImpersonationWithKerberosAuthAndLdapSearchBind() throws Exception {
        Assume.assumeTrue((boolean)this.pythonSupportsSSLContext());
        String ldapUri = String.format("ldap://localhost:%s", serverRule.getLdapServer().getPort());
        String passwordCommand = String.format("'echo -n %s'", "12345");
        Map<String, String> flags = LdapKerberosImpalaShellTest.mergeFlags(new Map[]{kerberosKdcEnvironment.getKerberosAuthFlags(), ImmutableMap.builder().put((Object)"enable_ldap_auth", (Object)"true").put((Object)"ldap_uri", (Object)ldapUri).put((Object)"ldap_passwords_in_clear_ok", (Object)"true").put((Object)"ldap_user_search_basedn", (Object)"dc=myorg,dc=com").put((Object)"ldap_user_filter", (Object)"(cn={0})").put((Object)"ldap_search_bind_authentication", (Object)"true").put((Object)"ldap_bind_dn", (Object)"cn=Test1Ldap,ou=Users,dc=myorg,dc=com").put((Object)"ldap_bind_password_cmd", (Object)passwordCommand).put((Object)"allow_custom_ldap_filters_with_kerberos_auth", (Object)"true").build(), ImmutableMap.of((Object)"authorized_proxy_user_config", (Object)String.format("%s=%s", "Test1Ldap", "proxyUser$"))});
        int ret = this.startImpalaCluster(LdapKerberosImpalaShellTest.flagsToArgs(flags));
        Assert.assertEquals((long)ret, (long)0L);
        String errTemplate = "User '%s' is not authorized to delegate to '%s'";
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test2Ldap", "/?doAs=proxyUser$", false, "", String.format(errTemplate, kerberosKdcEnvironment.getUserPrincipal("Test2Ldap"), "proxyUser$"));
        String invalidDelegateUser = "invalid-delegate-user";
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test1Ldap", "/?doAs=" + invalidDelegateUser, false, "", String.format(errTemplate, kerberosKdcEnvironment.getUserPrincipal("Test1Ldap"), invalidDelegateUser));
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test1Ldap", "/?doAs=%", false, "", "Not connected to Impala");
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test1Ldap", "/?doAs=proxyUser$", true, "proxyUser$", "");
        this.testShellKerberosAuthWithUser(kerberosKdcEnvironment, "Test1Ldap", true);
    }

    @Test
    public void testHttpImpersonationWithKerberosAuthAndLdapSearchBindWithGroupFilters() throws Exception {
        Assume.assumeTrue((boolean)this.pythonSupportsSSLContext());
        Map<String, String> flags = LdapKerberosImpalaShellTest.mergeFlags(new Map[]{kerberosKdcEnvironment.getKerberosAuthFlags(), this.getLdapSearchBindFlags(), ImmutableMap.of((Object)"allow_custom_ldap_filters_with_kerberos_auth", (Object)"true"), this.getCustomLdapFilterFlags(), ImmutableMap.of((Object)"authorized_proxy_user_config", (Object)String.format("%s=*", "Test1Ldap"))});
        int ret = this.startImpalaCluster(LdapKerberosImpalaShellTest.flagsToArgs(flags));
        Assert.assertEquals((long)ret, (long)0L);
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test1Ldap", "/?doAs=proxyUser$", false, "", "User is not authorized.");
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test1Ldap", "/?doAs=Test2Ldap", false, "", "User is not authorized.");
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test1Ldap", "/?doAs=Test3Ldap", false, "", "User is not authorized.");
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test1Ldap", "/?doAs=Test7Ldap", true, "Test7Ldap", "");
        this.testShellKerberosAuthWithUser(kerberosKdcEnvironment, "Test1Ldap", true);
    }

    @Test
    public void testLdapFiltersWithProxyWithKerberosAuthAndLdapSearchBind() throws Exception {
        String customLdapUserFilter = String.format("(&(objectClass=person)(cn={0})(!(cn=%s)))", "Test2Ldap");
        String customLdapGroupFilter = "(&(cn=group1)(uniqueMember={0}))";
        Map<String, String> flags = LdapKerberosImpalaShellTest.mergeFlags(new Map[]{kerberosKdcEnvironment.getKerberosAuthFlags(), this.getLdapSearchBindFlags(), ImmutableMap.of((Object)"allow_custom_ldap_filters_with_kerberos_auth", (Object)"true"), ImmutableMap.of((Object)"ldap_user_filter", (Object)customLdapUserFilter, (Object)"ldap_group_filter", (Object)customLdapGroupFilter), ImmutableMap.of((Object)"authorized_proxy_user_config", (Object)String.format("%s=*", "Test4Ldap"))});
        int ret = this.startImpalaCluster(LdapKerberosImpalaShellTest.flagsToArgs(flags));
        Assert.assertEquals((long)ret, (long)0L);
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test4Ldap", "/?doAs=Test1Ldap", true, "Test1Ldap", "");
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test4Ldap", "/?doAs=Test3Ldap", false, "", "Not connected to Impala");
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test4Ldap", "/?doAs=Test2Ldap", false, "", "Not connected to Impala");
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test4Ldap", "/?doAs=Test4Ldap", false, "", "Not connected to Impala");
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test4Ldap", "/", false, "", "");
    }

    @Test
    public void testHttpImpersonationWithKerberosAuthAndLdapSimpleBind() throws Exception {
        Assume.assumeTrue((boolean)this.pythonSupportsSSLContext());
        String ldapUri = String.format("ldap://localhost:%s", serverRule.getLdapServer().getPort());
        Map<String, String> flags = LdapKerberosImpalaShellTest.mergeFlags(new Map[]{kerberosKdcEnvironment.getKerberosAuthFlags(), ImmutableMap.of((Object)"enable_ldap_auth", (Object)"true", (Object)"ldap_uri", (Object)ldapUri, (Object)"ldap_passwords_in_clear_ok", (Object)"true", (Object)"ldap_bind_pattern", (Object)"'cn=#UID,ou=Users,dc=myorg,dc=com'"), ImmutableMap.of((Object)"authorized_proxy_user_config", (Object)String.format("%s=%s", "Test1Ldap", "proxyUser$"))});
        int ret = this.startImpalaCluster(LdapKerberosImpalaShellTest.flagsToArgs(flags));
        Assert.assertEquals((long)ret, (long)0L);
        String errTemplate = "User '%s' is not authorized to delegate to '%s'";
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test2Ldap", "/?doAs=proxyUser$", false, "", String.format(errTemplate, kerberosKdcEnvironment.getUserPrincipal("Test2Ldap"), "proxyUser$"));
        String invalidDelegateUser = "invalid-delegate-user";
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test1Ldap", "/?doAs=" + invalidDelegateUser, false, "", String.format(errTemplate, kerberosKdcEnvironment.getUserPrincipal("Test1Ldap"), invalidDelegateUser));
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test1Ldap", "/?doAs=%", false, "", "Not connected to Impala");
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test1Ldap", "/?doAs=proxyUser$", true, "proxyUser$", "");
        this.testShellKerberosAuthWithUser(kerberosKdcEnvironment, "Test1Ldap", true);
    }

    @Test
    public void testShellKerberosAuthWithCustomLdapFiltersAndSimpleBindNoGroupFilterCheck() throws Exception {
        Map<String, String> flags = LdapKerberosImpalaShellTest.mergeFlags(new Map[]{kerberosKdcEnvironment.getKerberosAuthFlags(), this.getLdapSimpleBindFlags(), ImmutableMap.of((Object)"allow_custom_ldap_filters_with_kerberos_auth", (Object)"true"), this.getCustomLdapSimpleBindSearchFilterFlags()});
        int ret = this.startImpalaCluster(LdapKerberosImpalaShellTest.flagsToArgs(flags));
        Assert.assertEquals((long)ret, (long)0L);
        this.testShellKerberosAuthWithUser(kerberosKdcEnvironment, "user", true);
    }

    @Test
    public void testShellKerberosAuthWithCustomLdapFiltersAndSimpleBindGroupFilterCheck() throws Exception {
        Map<String, String> flags = LdapKerberosImpalaShellTest.mergeFlags(new Map[]{kerberosKdcEnvironment.getKerberosAuthFlags(), this.getLdapSimpleBindFlags(), ImmutableMap.of((Object)"allow_custom_ldap_filters_with_kerberos_auth", (Object)"true"), this.getCustomLdapSimpleBindSearchFilterFlags(), ImmutableMap.of((Object)"enable_group_filter_check_for_authenticated_kerberos_user", (Object)"true")});
        int ret = this.startImpalaCluster(LdapKerberosImpalaShellTest.flagsToArgs(flags));
        Assert.assertEquals((long)ret, (long)0L);
        this.testShellKerberosAuthWithUser(kerberosKdcEnvironment, "Test1Ldap", true);
        this.testShellKerberosAuthWithUser(kerberosKdcEnvironment, "Test2Ldap", false);
        this.testShellKerberosAuthWithUser(kerberosKdcEnvironment, "Test3Ldap", false);
        this.testShellKerberosAuthWithUser(kerberosKdcEnvironment, "user", false);
    }

    @Test
    public void testLdapFiltersWithProxyWithKerberosAuthAndLdapSimpleBind() throws Exception {
        Map<String, String> flags = LdapKerberosImpalaShellTest.mergeFlags(new Map[]{kerberosKdcEnvironment.getKerberosAuthFlags(), this.getLdapSimpleBindFlags(), ImmutableMap.of((Object)"allow_custom_ldap_filters_with_kerberos_auth", (Object)"true"), this.getCustomLdapSimpleBindSearchFilterFlags(), ImmutableMap.of((Object)"authorized_proxy_user_config", (Object)String.format("%s=*", "Test4Ldap"))});
        int ret = this.startImpalaCluster(LdapKerberosImpalaShellTest.flagsToArgs(flags));
        Assert.assertEquals((long)ret, (long)0L);
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test4Ldap", "/?doAs=Test1Ldap", true, "Test1Ldap", "");
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test4Ldap", "/?doAs=Test3Ldap", false, "", "Not connected to Impala");
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test4Ldap", "/?doAs=Test2Ldap", false, "", "Not connected to Impala");
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test4Ldap", "/?doAs=Test4Ldap", false, "", "Not connected to Impala");
        this.testShellKerberosAuthWithUserWithHttpPath(kerberosKdcEnvironment, "Test4Ldap", "/", false, "", "");
    }

    @Test
    public void testShellKerberosAuthWithKerberosHostnameOverride() throws Exception {
        String kerberosHostFqdn = "any.host";
        Map<String, String> flags = LdapKerberosImpalaShellTest.mergeFlags(kerberosKdcEnvironment.getKerberosAuthFlagsWithCustomServicePrincipal("impala", kerberosHostFqdn));
        int ret = this.startImpalaCluster(LdapKerberosImpalaShellTest.flagsToArgs(flags));
        Assert.assertEquals((long)ret, (long)0L);
        this.testShellKerberosAuthWithUser(kerberosKdcEnvironment, "user", true, kerberosHostFqdn);
    }

    protected void testShellKerberosAuthWithUser(KerberosKdcEnvironment kerberosKdcEnvironment, String username, boolean shouldSucceed) throws Exception {
        this.testShellKerberosAuthWithUser(kerberosKdcEnvironment, username, shouldSucceed, null);
    }

    protected void testShellKerberosAuthWithUser(KerberosKdcEnvironment kerberosKdcEnvironment, String username, boolean shouldSucceed, String kerberosHostFqdn) throws Exception {
        List<String> protocolsToTest = Arrays.asList("beeswax", "hs2");
        if (this.pythonSupportsSSLContext()) {
            protocolsToTest = Arrays.asList("beeswax", "hs2", "hs2-http");
        }
        String credentialsCacheFilePath = kerberosKdcEnvironment.createUserPrincipalAndCredentialsCache(username);
        for (String protocol : protocolsToTest) {
            String[] command = kerberosHostFqdn == null ? this.createCommandForProtocol(protocol) : this.createCommandForProtocolAndKerberosHostFqdn(protocol, kerberosHostFqdn);
            String expectedOut = shouldSucceed ? kerberosKdcEnvironment.getUserPrincipal(username) : "";
            String expectedErr = shouldSucceed ? "Starting Impala Shell with Kerberos authentication" : "Not connected to Impala";
            RunShellCommand.Run(command, kerberosKdcEnvironment.getImpalaShellEnv(credentialsCacheFilePath), shouldSucceed, expectedOut, expectedErr);
        }
    }

    private String[] createCommandForProtocol(String protocol) {
        String[] command = new String[]{"impala-shell.sh", String.format("--protocol=%s", protocol), "--kerberos", "--query=select logged_in_user()"};
        return command;
    }

    private String[] createCommandForProtocolAndKerberosHostFqdn(String protocol, String kerberosHostFqdn) {
        String[] command = new String[]{"impala-shell.sh", String.format("--protocol=%s", protocol), "--kerberos", String.format("--kerberos_host_fqdn=%s", kerberosHostFqdn), "--query=select logged_in_user()"};
        return command;
    }

    private Map<String, String> getLdapSimpleBindFlags() {
        String ldapUri = String.format("ldap://localhost:%s", serverRule.getLdapServer().getPort());
        String passwordCommand = String.format("'echo -n %s'", "12345");
        return ImmutableMap.builder().put((Object)"enable_ldap_auth", (Object)"true").put((Object)"ldap_uri", (Object)ldapUri).put((Object)"ldap_passwords_in_clear_ok", (Object)"true").put((Object)"ldap_bind_pattern", (Object)"'cn=#UID,ou=Users,dc=myorg,dc=com'").put((Object)"ldap_group_dn_pattern", (Object)"cn=%s,ou=Groups,dc=myorg,dc=com").put((Object)"ldap_group_membership_key", (Object)"uniqueMember").put((Object)"ldap_group_class_key", (Object)"groupOfUniqueNames").put((Object)"ldap_bind_dn", (Object)"cn=Test1Ldap,ou=Users,dc=myorg,dc=com").put((Object)"ldap_bind_password_cmd", (Object)passwordCommand).build();
    }

    private Map<String, String> getCustomLdapSimpleBindSearchFilterFlags() {
        String customGroupFilter = String.format("%s,another-group", "group1");
        String customUserFilter = String.format("%s,%s,another-user", "Test1Ldap", "Test3Ldap");
        return ImmutableMap.of((Object)"ldap_group_filter", (Object)customGroupFilter, (Object)"ldap_user_filter", (Object)customUserFilter);
    }
}

