/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.CreateLdapServerRule;
import org.apache.impala.customcluster.CustomClusterRunner;
import org.apache.impala.customcluster.RunShellCommand;
import org.apache.impala.testutil.WebClient;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

@CreateDS(name="myDS", partitions={@CreatePartition(name="test", suffix="dc=myorg,dc=com")})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")})
@ApplyLdifFiles(value={"users.ldif"})
public class LdapImpylaHttpTest {
    private static final Logger LOG = Logger.getLogger(LdapImpylaHttpTest.class);
    @ClassRule
    public static CreateLdapServerRule serverRule = new CreateLdapServerRule();
    private static String query_ = "select logged_in_user()";
    private static final String testUser_ = "Test1Ldap";
    private static final String testPassword_ = "12345";
    private static final String testUser2_ = "Test2Ldap";
    private static final String testPassword2_ = "abcde";
    private static final String helper_ = System.getenv("IMPALA_HOME") + "/tests/util/run_impyla_http_query.py";
    private static final String delegateUser_ = "proxyUser$";
    WebClient client_ = new WebClient();
    private static final Range<Long> zero = Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(0L));
    private static final Range<Long> one = Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L));

    @Before
    public void setUp() throws Exception {
        String uri = String.format("ldap://localhost:%s", serverRule.getLdapServer().getPort());
        String dn = "cn=#UID,ou=Users,dc=myorg,dc=com";
        String ldapArgs = String.format("--enable_ldap_auth --ldap_uri='%s' --ldap_bind_pattern='%s' --ldap_passwords_in_clear_ok --authorized_proxy_user_config=%s=%s", uri, dn, testUser_, delegateUser_);
        int ret = CustomClusterRunner.StartImpalaCluster(ldapArgs);
        Assert.assertEquals((long)ret, (long)0L);
        this.verifyMetrics(zero, zero, zero, zero);
    }

    @After
    public void cleanUp() throws Exception {
        CustomClusterRunner.StartImpalaCluster();
        this.client_.close();
    }

    private void verifyMetrics(Range<Long> expectedBasicSuccess, Range<Long> expectedBasicFailure, Range<Long> expectedCookieSuccess, Range<Long> expectedCookieFailure) throws Exception {
        long actualBasicSuccess = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-basic-auth-success");
        Assert.assertTrue((String)("Expected: " + expectedBasicSuccess + ", Actual: " + actualBasicSuccess), (boolean)expectedBasicSuccess.contains((Comparable)Long.valueOf(actualBasicSuccess)));
        long actualBasicFailure = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-basic-auth-failure");
        Assert.assertTrue((String)("Expected: " + expectedBasicFailure + ", Actual: " + actualBasicFailure), (boolean)expectedBasicFailure.contains((Comparable)Long.valueOf(actualBasicFailure)));
        long actualCookieSuccess = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-cookie-auth-success");
        Assert.assertTrue((String)("Expected: " + expectedCookieSuccess + ", Actual: " + actualCookieSuccess), (boolean)expectedCookieSuccess.contains((Comparable)Long.valueOf(actualCookieSuccess)));
        long actualCookieFailure = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-cookie-auth-failure");
        Assert.assertTrue((String)("Expected: " + expectedCookieFailure + ", Actual: " + actualCookieFailure), (boolean)expectedCookieFailure.contains((Comparable)Long.valueOf(actualCookieFailure)));
    }

    @Test
    public void testImpylaHttpLdapAuth() throws Exception {
        String[] validCmd = this.buildCommand(testUser_, testPassword_, null, null);
        RunShellCommand.Run(validCmd, true, testUser_, "");
        this.verifyMetrics((Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), zero, (Range<Long>)Range.atLeast((Comparable)Long.valueOf(6L)), zero);
        long successBasicAuthBefore = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-basic-auth-success");
        long successCookieAuthBefore = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-cookie-auth-success");
        String[] invalidCmd = this.buildCommand("foo", "bar", null, null);
        RunShellCommand.Run(invalidCmd, false, "", "HTTP code 401: Unauthorized");
        this.verifyMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(successBasicAuthBefore), (Comparable)Long.valueOf(successBasicAuthBefore)), (Range<Long>)Range.closed((Comparable)Long.valueOf(3L), (Comparable)Long.valueOf(3L)), (Range<Long>)Range.closed((Comparable)Long.valueOf(successCookieAuthBefore), (Comparable)Long.valueOf(successCookieAuthBefore)), zero);
        long failedBasicAuthBefore = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-basic-auth-failure");
        String[] noAuthCmd = new String[]{"impala-python", helper_, "--query", query_};
        RunShellCommand.Run(noAuthCmd, false, "", "HTTP code 401: Unauthorized");
        this.verifyMetrics((Range<Long>)Range.closed((Comparable)Long.valueOf(successBasicAuthBefore), (Comparable)Long.valueOf(successBasicAuthBefore)), (Range<Long>)Range.closed((Comparable)Long.valueOf(failedBasicAuthBefore), (Comparable)Long.valueOf(failedBasicAuthBefore)), (Range<Long>)Range.closed((Comparable)Long.valueOf(successCookieAuthBefore), (Comparable)Long.valueOf(successCookieAuthBefore)), zero);
        String[] emptyCookieNamesCmd = this.buildCommand(testUser_, testPassword_, null, "");
        RunShellCommand.Run(emptyCookieNamesCmd, true, testUser_, "");
        this.verifyMetrics((Range<Long>)Range.atLeast((Comparable)Long.valueOf(successBasicAuthBefore + 7L)), (Range<Long>)Range.closed((Comparable)Long.valueOf(failedBasicAuthBefore), (Comparable)Long.valueOf(failedBasicAuthBefore)), (Range<Long>)Range.closed((Comparable)Long.valueOf(successCookieAuthBefore), (Comparable)Long.valueOf(successCookieAuthBefore)), zero);
        successBasicAuthBefore = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-basic-auth-success");
        String[] validCookieNamesCmd = this.buildCommand(testUser_, testPassword_, null, "impala.auth");
        RunShellCommand.Run(validCookieNamesCmd, true, testUser_, "");
        this.verifyMetrics((Range<Long>)Range.atLeast((Comparable)Long.valueOf(successBasicAuthBefore + 1L)), (Range<Long>)Range.closed((Comparable)Long.valueOf(failedBasicAuthBefore), (Comparable)Long.valueOf(failedBasicAuthBefore)), (Range<Long>)Range.atLeast((Comparable)Long.valueOf(successCookieAuthBefore + 6L)), zero);
        successBasicAuthBefore = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-basic-auth-success");
        successCookieAuthBefore = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-cookie-auth-success");
        String[] nonAuthCookieNamesCmd = this.buildCommand(testUser_, testPassword_, null, "impala.session.id");
        RunShellCommand.Run(nonAuthCookieNamesCmd, true, testUser_, "");
        this.verifyMetrics((Range<Long>)Range.atLeast((Comparable)Long.valueOf(successBasicAuthBefore + 7L)), (Range<Long>)Range.closed((Comparable)Long.valueOf(failedBasicAuthBefore), (Comparable)Long.valueOf(failedBasicAuthBefore)), (Range<Long>)Range.closed((Comparable)Long.valueOf(successCookieAuthBefore), (Comparable)Long.valueOf(successCookieAuthBefore)), zero);
    }

    private String[] buildCommand(String user, String password, String httpPath, String cookieNames) {
        ArrayList command = Lists.newArrayList(Arrays.asList("impala-python", helper_, "--user", user, "--password", password, "--query", query_));
        if (httpPath != null) {
            command.addAll(Arrays.asList("--http_path", httpPath));
        }
        if (cookieNames != null) {
            command.addAll(Arrays.asList("--http_cookie_names", cookieNames));
        }
        return command.toArray(new String[0]);
    }

    @Test
    public void testImpylaHttpImpersonation() throws Exception {
        String invalidDelegateUser = "invalid-delegate-user";
        String query = "select logged_in_user()";
        String errTemplate = "User '%s' is not authorized to delegate to '%s'";
        String[] cmd = this.buildCommand(testUser2_, testPassword2_, "/?doAs=proxyUser$", null);
        RunShellCommand.Run(cmd, false, "", String.format(errTemplate, testUser2_, delegateUser_));
        cmd = this.buildCommand(testUser_, testPassword_, "/?doAs=" + invalidDelegateUser, null);
        RunShellCommand.Run(cmd, false, "", String.format(errTemplate, testUser_, invalidDelegateUser));
        cmd = this.buildCommand(testUser_, testPassword_, "/?doAs=%", null);
        RunShellCommand.Run(cmd, false, "", "httplib.BadStatusLine");
        cmd = this.buildCommand(testUser_, testPassword_, "/?doAs=proxyUser$", null);
        RunShellCommand.Run(cmd, true, delegateUser_, "");
    }
}

