/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import com.google.common.collect.Range;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.integ.CreateLdapServerRule;
import org.apache.impala.customcluster.CustomClusterRunner;
import org.apache.impala.customcluster.RunShellCommand;
import org.apache.impala.testutil.WebClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.ClassRule;

@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")})
@ApplyLdifFiles(value={"users.ldif"})
public class LdapImpalaShellTest {
    @ClassRule
    public static CreateLdapServerRule serverRule = new CreateLdapServerRule();
    protected static final String delegateUser_ = "proxyUser$";
    private WebClient client_ = new WebClient();
    private static final Range<Long> zero = Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(0L));
    private static final Range<Long> one = Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1L));

    public void setUp(String extraArgs) throws Exception {
        String uri = String.format("ldap://localhost:%s", serverRule.getLdapServer().getPort());
        String ldapArgs = String.format("--enable_ldap_auth --ldap_uri='%s' --ldap_passwords_in_clear_ok %s", uri, extraArgs);
        int ret = this.startImpalaCluster(ldapArgs);
        Assert.assertEquals((long)ret, (long)0L);
        this.verifyMetrics(zero, zero, zero, zero);
    }

    @After
    public void cleanUp() throws Exception {
        this.client_.close();
    }

    protected int startImpalaCluster(String args) throws IOException, InterruptedException {
        return CustomClusterRunner.StartImpalaCluster(args);
    }

    protected boolean pythonSupportsSSLContext() throws Exception {
        String[] cmd = new String[]{"python", "-c", "import ssl; print(hasattr(ssl, 'create_default_context'))"};
        return Boolean.parseBoolean(RunShellCommand.Run((String[])cmd, (boolean)true, (String)"", (String)"").stdout.replace("\n", ""));
    }

    protected List<String> getProtocolsToTest() throws Exception {
        List<String> protocolsToTest = Arrays.asList("beeswax", "hs2");
        if (this.pythonSupportsSSLContext()) {
            protocolsToTest = Arrays.asList("beeswax", "hs2", "hs2-http");
        }
        return protocolsToTest;
    }

    private void verifyMetrics(Range<Long> expectedBasicSuccess, Range<Long> expectedBasicFailure, Range<Long> expectedCookieSuccess, Range<Long> expectedCookieFailure) throws Exception {
        long actualBasicSuccess = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-basic-auth-success");
        Assert.assertTrue((String)("Expected: " + expectedBasicSuccess + ", Actual: " + actualBasicSuccess), (boolean)expectedBasicSuccess.contains((Comparable)Long.valueOf(actualBasicSuccess)));
        long actualBasicFailure = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-basic-auth-failure");
        Assert.assertTrue((String)("Expected: " + expectedBasicFailure + ", Actual: " + actualBasicFailure), (boolean)expectedBasicFailure.contains((Comparable)Long.valueOf(actualBasicFailure)));
        long actualCookieSuccess = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-cookie-auth-success");
        Assert.assertTrue((String)("Expected: " + expectedCookieSuccess + ", Actual: " + actualCookieSuccess), (boolean)expectedCookieSuccess.contains((Comparable)Long.valueOf(actualCookieSuccess)));
        long actualCookieFailure = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-cookie-auth-failure");
        Assert.assertTrue((String)("Expected: " + expectedCookieFailure + ", Actual: " + actualCookieFailure), (boolean)expectedCookieFailure.contains((Comparable)Long.valueOf(actualCookieFailure)));
    }

    protected String[] buildCommand(String query, String protocol, String user, String password, String httpPath) {
        String[] command = new String[]{"impala-shell.sh", "--protocol=" + protocol, "--ldap", "--auth_creds_ok_in_clear", "--user=" + user, "--ldap_password_cmd=printf " + password, "--query=" + query, "--http_path=" + httpPath};
        return command;
    }

    protected void testShellLdapAuthImpl(String extra_cookie) throws Exception {
        String query = "select logged_in_user()";
        String[] validCommand = new String[]{"impala-shell.sh", "", "--ldap", "--auth_creds_ok_in_clear", "--verbose", String.format("--user=%s", "Test1Ldap"), String.format("--ldap_password_cmd=printf %s", "12345"), String.format("--query=%s", query)};
        String[] validCommandMatchingCookieNames = new String[]{"impala-shell.sh", "", "--ldap", "--auth_creds_ok_in_clear", "--verbose", "--http_cookie_names=impala.auth", String.format("--user=%s", "Test1Ldap"), String.format("--ldap_password_cmd=printf %s", "12345"), String.format("--query=%s", query)};
        String[] validCommandMismatchingCookieNames = new String[]{"impala-shell.sh", "", "--ldap", "--auth_creds_ok_in_clear", "--verbose", "--http_cookie_names=impala.conn", String.format("--user=%s", "Test1Ldap"), String.format("--ldap_password_cmd=printf %s", "12345"), String.format("--query=%s", query)};
        String[] validCommandEmptyCookieNames = new String[]{"impala-shell.sh", "", "--ldap", "--auth_creds_ok_in_clear", "--verbose", "--http_cookie_names=", String.format("--user=%s", "Test1Ldap"), String.format("--ldap_password_cmd=printf %s", "12345"), String.format("--query=%s", query)};
        String[] invalidCommand = new String[]{"impala-shell.sh", "", "--ldap", "--auth_creds_ok_in_clear", "--user=foo", "--ldap_password_cmd=printf bar", String.format("--query=%s", query)};
        String[] commandWithoutAuth = new String[]{"impala-shell.sh", "", String.format("--query=%s", query)};
        String[] validCommandLongPsw = new String[]{"impala-shell.sh", "", "--ldap", "--auth_creds_ok_in_clear", "--verbose", String.format("--user=%s", "TestLdapLongPsw"), String.format("--ldap_password_cmd=printf %s", "verylongpasswordthatcreatesalongbasic64encoding"), String.format("--query=%s", query)};
        String protocolTemplate = "--protocol=%s";
        ArrayList<String> preservedCookiesList = new ArrayList<String>();
        preservedCookiesList.add("impala.auth");
        if (extra_cookie != null) {
            preservedCookiesList.add(extra_cookie);
        }
        Collections.sort(preservedCookiesList);
        String preservedCookies = String.join((CharSequence)", ", preservedCookiesList);
        for (String p : this.getProtocolsToTest()) {
            String protocol;
            validCommand[1] = protocol = String.format(protocolTemplate, p);
            RunShellCommand.Output result = RunShellCommand.Run(validCommand, true, "Test1Ldap", "Starting Impala Shell with LDAP-based authentication");
            if (p.equals("hs2-http")) {
                this.verifyMetrics((Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), zero, (Range<Long>)Range.atLeast((Comparable)Long.valueOf(1L)), zero);
                Assert.assertTrue((String)result.stderr, (boolean)result.stderr.contains("Preserving cookies: " + preservedCookies));
            }
            validCommandMatchingCookieNames[1] = protocol;
            result = RunShellCommand.Run(validCommandMatchingCookieNames, true, "Test1Ldap", "Starting Impala Shell with LDAP-based authentication");
            if (p.equals("hs2-http")) {
                this.verifyMetrics((Range<Long>)Range.atLeast((Comparable)Long.valueOf(2L)), zero, (Range<Long>)Range.atLeast((Comparable)Long.valueOf(2L)), zero);
                Assert.assertTrue((String)result.stderr, (boolean)result.stderr.contains("Preserving cookies: impala.auth"));
            }
            validCommandMismatchingCookieNames[1] = protocol;
            result = RunShellCommand.Run(validCommandMismatchingCookieNames, true, "Test1Ldap", "Starting Impala Shell with LDAP-based authentication");
            if (p.equals("hs2-http")) {
                this.verifyMetrics((Range<Long>)Range.atLeast((Comparable)Long.valueOf(2L)), zero, (Range<Long>)Range.atLeast((Comparable)Long.valueOf(2L)), zero);
                Assert.assertFalse((String)result.stderr, (boolean)result.stderr.contains("Preserving cookies:"));
            }
            validCommandEmptyCookieNames[1] = protocol;
            result = RunShellCommand.Run(validCommandEmptyCookieNames, true, "Test1Ldap", "Starting Impala Shell with LDAP-based authentication");
            if (p.equals("hs2-http")) {
                this.verifyMetrics((Range<Long>)Range.atLeast((Comparable)Long.valueOf(2L)), zero, (Range<Long>)Range.atLeast((Comparable)Long.valueOf(2L)), zero);
                Assert.assertFalse((String)result.stderr, (boolean)result.stderr.contains("Preserving cookies:"));
            }
            invalidCommand[1] = protocol;
            RunShellCommand.Run(invalidCommand, false, "", "Not connected to Impala");
            commandWithoutAuth[1] = protocol;
            RunShellCommand.Run(commandWithoutAuth, false, "", "Not connected to Impala");
            validCommandLongPsw[1] = protocol;
            RunShellCommand.Run(validCommandLongPsw, true, "TestLdapLongPsw", "Starting Impala Shell with LDAP-based authentication");
        }
    }

    protected void testHttpImpersonationImpl() throws Exception {
        Assume.assumeTrue((boolean)this.pythonSupportsSSLContext());
        String invalidDelegateUser = "invalid-delegate-user";
        String query = "select logged_in_user()";
        String errTemplate = "User '%s' is not authorized to delegate to '%s'";
        String[] command = this.buildCommand(query, "hs2-http", "Test2Ldap", "abcde", "/?doAs=proxyUser$");
        RunShellCommand.Run(command, false, "", String.format(errTemplate, "Test2Ldap", delegateUser_));
        command = this.buildCommand(query, "hs2-http", "Test1Ldap", "12345", "/?doAs=" + invalidDelegateUser);
        RunShellCommand.Run(command, false, "", String.format(errTemplate, "Test1Ldap", invalidDelegateUser));
        command = this.buildCommand(query, "hs2-http", "Test1Ldap", "12345", "/?doAs=%");
        RunShellCommand.Run(command, false, "", "Not connected to Impala");
        command = this.buildCommand(query, "hs2-http", "Test1Ldap", "12345", "/?doAs=proxyUser$");
        RunShellCommand.Run(command, true, delegateUser_, "");
    }

    protected void testLdapFiltersImpl() throws Exception {
        String query = "select logged_in_user()";
        String[] command = this.buildCommand(query, "hs2-http", "Test2Ldap", "abcde", "/cliservice");
        RunShellCommand.Run(command, false, "", "Not connected to Impala");
        command = this.buildCommand(query, "hs2-http", "Test3Ldap", "67890", "/cliservice");
        RunShellCommand.Run(command, false, "", "Not connected to Impala");
        command = this.buildCommand(query, "hs2-http", "Test4Ldap", "fghij", "/cliservice");
        RunShellCommand.Run(command, false, "", "Not connected to Impala");
        command = this.buildCommand(query, "hs2-http", "Test1Ldap", "12345", "/cliservice");
        RunShellCommand.Run(command, true, "Test1Ldap", "");
    }

    protected void testLdapFiltersWithProxyImpl() throws Exception {
        String query = "select logged_in_user()";
        String[] command = this.buildCommand(query, "hs2-http", "Test4Ldap", "fghij", "/?doAs=Test1Ldap");
        RunShellCommand.Run(command, true, "Test1Ldap", "");
        command = this.buildCommand(query, "hs2-http", "Test4Ldap", "fghij", "/?doAs=Test3Ldap");
        RunShellCommand.Run(command, false, "", "Not connected to Impala");
        command = this.buildCommand(query, "hs2-http", "Test4Ldap", "fghij", "/?doAs=Test2Ldap");
        RunShellCommand.Run(command, false, "", "Not connected to Impala");
        command = this.buildCommand(query, "hs2-http", "Test4Ldap", "fghij", "/?doAs=Test4Ldap");
        RunShellCommand.Run(command, false, "", "Not connected to Impala");
        command = this.buildCommand(query, "hs2-http", "Test4Ldap", "fghij", "/");
        RunShellCommand.Run(command, false, "", "");
    }
}

