/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.CreateLdapServerRule;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TCancelOperationReq;
import org.apache.hive.service.rpc.thrift.TCancelOperationResp;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TExecuteStatementReq;
import org.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import org.apache.hive.service.rpc.thrift.TFetchOrientation;
import org.apache.hive.service.rpc.thrift.TFetchResultsReq;
import org.apache.hive.service.rpc.thrift.TFetchResultsResp;
import org.apache.hive.service.rpc.thrift.TOpenSessionReq;
import org.apache.hive.service.rpc.thrift.TOpenSessionResp;
import org.apache.hive.service.rpc.thrift.TOperationHandle;
import org.apache.hive.service.rpc.thrift.TSessionHandle;
import org.apache.hive.service.rpc.thrift.TStatus;
import org.apache.hive.service.rpc.thrift.TStatusCode;
import org.apache.impala.customcluster.CustomClusterRunner;
import org.apache.impala.testutil.WebClient;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CreateDS(name="myDS", partitions={@CreatePartition(name="test", suffix="dc=myorg,dc=com")})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")})
@ApplyLdifFiles(value={"users.ldif"})
public class LdapHS2Test {
    private static final Logger LOG = LoggerFactory.getLogger(LdapHS2Test.class);
    @ClassRule
    public static CreateLdapServerRule serverRule = new CreateLdapServerRule();
    WebClient client_ = new WebClient();

    public void setUp(String extraArgs) throws Exception {
        String uri = String.format("ldap://localhost:%s", serverRule.getLdapServer().getPort());
        String dn = "cn=#UID,ou=Users,dc=myorg,dc=com";
        String ldapArgs = String.format("--enable_ldap_auth --ldap_uri='%s' --ldap_bind_pattern='%s' --ldap_passwords_in_clear_ok %s ", uri, dn, extraArgs);
        int ret = CustomClusterRunner.StartImpalaCluster(ldapArgs);
        Assert.assertEquals((long)ret, (long)0L);
    }

    @After
    public void cleanUp() throws Exception {
        this.client_.close();
    }

    static void verifySuccess(TStatus status) throws Exception {
        if (status.getStatusCode() == TStatusCode.SUCCESS_STATUS || status.getStatusCode() == TStatusCode.SUCCESS_WITH_INFO_STATUS) {
            return;
        }
        throw new Exception(status.toString());
    }

    static TOperationHandle execAndFetch(TCLIService.Iface client, TSessionHandle sessionHandle, String query, String expectedResult) throws Exception {
        TExecuteStatementReq execReq = new TExecuteStatementReq(sessionHandle, query);
        TExecuteStatementResp execResp = client.ExecuteStatement(execReq);
        LdapHS2Test.verifySuccess(execResp.getStatus());
        TFetchResultsReq fetchReq = new TFetchResultsReq(execResp.getOperationHandle(), TFetchOrientation.FETCH_NEXT, 1000L);
        TFetchResultsResp fetchResp = client.FetchResults(fetchReq);
        LdapHS2Test.verifySuccess(fetchResp.getStatus());
        List columns = fetchResp.getResults().getColumns();
        Assert.assertEquals((long)1L, (long)columns.size());
        if (expectedResult != null) {
            Assert.assertEquals((Object)expectedResult, ((TColumn)columns.get(0)).getStringVal().getValues().get(0));
        }
        return execResp.getOperationHandle();
    }

    static TOperationHandle execQueryAsync(TCLIService.Iface client, TSessionHandle sessionHandle, String query) throws Exception {
        TExecuteStatementReq execReq = new TExecuteStatementReq(sessionHandle, query);
        TExecuteStatementResp execResp = client.ExecuteStatement(execReq);
        LdapHS2Test.verifySuccess(execResp.getStatus());
        return execResp.getOperationHandle();
    }

    private void verifyMetrics(long expectedBasicAuthSuccess, long expectedBasicAuthFailure) throws Exception {
        long actualBasicAuthSuccess = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-basic-auth-success");
        Assert.assertEquals((long)expectedBasicAuthSuccess, (long)actualBasicAuthSuccess);
        long actualBasicAuthFailure = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-basic-auth-failure");
        Assert.assertEquals((long)expectedBasicAuthFailure, (long)actualBasicAuthFailure);
    }

    private void verifyCookieMetrics(long expectedCookieAuthSuccess, long expectedCookieAuthFailure) throws Exception {
        long actualCookieAuthSuccess = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-cookie-auth-success");
        Assert.assertEquals((long)expectedCookieAuthSuccess, (long)actualCookieAuthSuccess);
        long actualCookieAuthFailure = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-cookie-auth-failure");
        Assert.assertEquals((long)expectedCookieAuthFailure, (long)actualCookieAuthFailure);
    }

    private void verifyTrustedDomainMetrics(long expectedAuthSuccess) throws Exception {
        long actualAuthSuccess = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-trusted-domain-check-success");
        Assert.assertEquals((long)expectedAuthSuccess, (long)actualAuthSuccess);
    }

    private void verifyTrustedAuthHeaderMetrics(long expectedAuthSuccess) throws Exception {
        long actualAuthSuccess = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-trusted-auth-header-check-success");
        Assert.assertEquals((long)expectedAuthSuccess, (long)actualAuthSuccess);
    }

    private void verifyAuthMetrics(long expectedAuthSuccess, long expectedAuthFailure, String authType) throws Exception {
        long actualAuthSuccess = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-" + authType + "-token-auth-success");
        Assert.assertEquals((long)expectedAuthSuccess, (long)actualAuthSuccess);
        long actualAuthFailure = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-" + authType + "-token-auth-failure");
        Assert.assertEquals((long)expectedAuthFailure, (long)actualAuthFailure);
    }

    @Test
    public void testHiveserver2() throws Exception {
        String[] badCookies;
        this.setUp("");
        this.verifyMetrics(0L, 0L);
        THttpClient transport = new THttpClient("http://localhost:28000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Basic VGVzdDFMZGFwOjEyMzQ1");
        transport.setCustomHeaders(headers);
        transport.open();
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        TOpenSessionReq openReq = new TOpenSessionReq();
        TOpenSessionResp openResp = client.OpenSession(openReq);
        this.verifyMetrics(1L, 0L);
        TOperationHandle operationHandle = LdapHS2Test.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "Test1Ldap");
        this.verifyMetrics(3L, 0L);
        headers.put("Authorization", "Basic VGVzdDJMZGFwOmFiY2Rl");
        transport.setCustomHeaders(headers);
        String expectedError = "The user authorized on the connection 'Test2Ldap' does not match the session username 'Test1Ldap'\n";
        try {
            LdapHS2Test.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select 1", "1");
            Assert.fail((String)("Expected error: " + expectedError));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(expectedError));
            this.verifyMetrics(4L, 0L);
        }
        TCancelOperationReq cancelReq = new TCancelOperationReq(operationHandle);
        TCancelOperationResp cancelResp = client.CancelOperation(cancelReq);
        this.verifyMetrics(5L, 0L);
        Assert.assertEquals((Object)cancelResp.getStatus().getStatusCode(), (Object)TStatusCode.ERROR_STATUS);
        Assert.assertTrue((boolean)cancelResp.getStatus().getErrorMessage().contains(expectedError));
        TOpenSessionReq openReq2 = new TOpenSessionReq();
        TOpenSessionResp openResp2 = client.OpenSession(openReq);
        this.verifyMetrics(6L, 0L);
        LdapHS2Test.execAndFetch((TCLIService.Iface)client, openResp2.getSessionHandle(), "select logged_in_user()", "Test2Ldap");
        this.verifyMetrics(8L, 0L);
        int numFailures = 0;
        for (String authStr : new String[]{"Basic VGVzdDJMZGFwOjEyMzQ1", "Basic invalid-base64"}) {
            headers.put("Authorization", authStr);
            transport.setCustomHeaders(headers);
            try {
                TOpenSessionReq openReq3 = new TOpenSessionReq();
                TOpenSessionResp openResp3 = client.OpenSession(openReq);
                Assert.fail((String)"Exception exception.");
            }
            catch (Exception e) {
                this.verifyMetrics(8L, ++numFailures);
                Assert.assertEquals((Object)e.getMessage(), (Object)"HTTP Response code: 401");
            }
        }
        headers.put("Authorization", "Negotiate VGVzdDFMZGFwOjEyMzQ1");
        transport.setCustomHeaders(headers);
        try {
            TOpenSessionReq openReq3 = new TOpenSessionReq();
            TOpenSessionResp openResp3 = client.OpenSession(openReq);
            Assert.fail((String)"Exception exception.");
        }
        catch (Exception e) {
            this.verifyMetrics(8L, numFailures);
            Assert.assertEquals((Object)e.getMessage(), (Object)"HTTP Response code: 401");
        }
        headers.put("Authorization", "Basic VGVzdDJMZGFwOmFiY2Rl");
        headers.put("Cookie", "invalid-cookie");
        transport.setCustomHeaders(headers);
        TOpenSessionReq openReq4 = new TOpenSessionReq();
        TOpenSessionResp openResp4 = client.OpenSession(openReq);
        this.verifyMetrics(9L, numFailures);
        int numCookieFailures = 1;
        this.verifyCookieMetrics(0L, numCookieFailures);
        headers.remove("Authorization");
        for (String cookieStr : badCookies = new String[]{"invalid-format", "x&impala&0&0", "eA==&impala&0&0", "\"eA==&impala&0&0\"", "eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHg=&impala&0&0"}) {
            headers.put("Cookie", "impala.auth=" + cookieStr);
            transport.setCustomHeaders(headers);
            try {
                TOpenSessionReq openReq5 = new TOpenSessionReq();
                TOpenSessionResp openResp5 = client.OpenSession(openReq);
                Assert.fail((String)("Exception exception from cookie: " + cookieStr));
            }
            catch (Exception e) {
                this.verifyMetrics(9L, numFailures);
                this.verifyCookieMetrics(0L, ++numCookieFailures);
                Assert.assertEquals((Object)e.getMessage(), (Object)"HTTP Response code: 401");
            }
        }
        LinkedHashMap<String, String> orderedHeaders = new LinkedHashMap<String, String>();
        orderedHeaders.put("Authorization", "Basic VGVzdDFMZGFwOjEyMzQ1");
        orderedHeaders.put("a", "");
        transport.setCustomHeaders(orderedHeaders);
        transport.open();
        TOpenSessionReq openReq6 = new TOpenSessionReq();
        TOpenSessionResp openResp6 = client.OpenSession(openReq);
        this.verifyMetrics(10L, numFailures);
        TOperationHandle operationHandle6 = LdapHS2Test.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "Test1Ldap");
        this.verifyMetrics(12L, numFailures);
    }

    @Test
    public void testHS2Impersonation() throws Exception {
        this.setUp(String.format("--ldap_group_filter=%s,another-group --ldap_user_filter=%s,%s,another-user --ldap_group_dn_pattern=%s --ldap_group_membership_key=uniqueMember --ldap_group_class_key=groupOfUniqueNames --authorized_proxy_user_config=%s=* --ldap_bind_dn=%s --ldap_bind_password_cmd='echo -n %s' ", "group1", "Test1Ldap", "Test3Ldap", "cn=%s,ou=Groups,dc=myorg,dc=com", "Test4Ldap", "cn=Test1Ldap,ou=Users,dc=myorg,dc=com", "12345"));
        THttpClient transport = new THttpClient("http://localhost:28000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Basic VGVzdDRMZGFwOmZnaGlq");
        transport.setCustomHeaders(headers);
        transport.open();
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        TOpenSessionReq openReq = new TOpenSessionReq();
        TOpenSessionResp openResp = client.OpenSession(openReq);
        Assert.assertEquals((Object)openResp.getStatus().getStatusCode(), (Object)TStatusCode.ERROR_STATUS);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("impala.doas.user", "Test1Ldap");
        openReq.setConfiguration(config);
        openResp = client.OpenSession(openReq);
        Assert.assertEquals((Object)openResp.getStatus().getStatusCode(), (Object)TStatusCode.SUCCESS_STATUS);
        TOperationHandle operationHandle = LdapHS2Test.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "Test1Ldap");
        config.put("impala.doas.user", "Test2Ldap");
        openResp = client.OpenSession(openReq);
        Assert.assertEquals((Object)openResp.getStatus().getStatusCode(), (Object)TStatusCode.ERROR_STATUS);
        config.put("impala.doas.user", "Test3Ldap");
        openResp = client.OpenSession(openReq);
        Assert.assertEquals((Object)openResp.getStatus().getStatusCode(), (Object)TStatusCode.ERROR_STATUS);
        config.put("impala.doas.user", "Test4Ldap");
        openResp = client.OpenSession(openReq);
        Assert.assertEquals((Object)openResp.getStatus().getStatusCode(), (Object)TStatusCode.ERROR_STATUS);
    }

    private void hiveserver2TrustedDomainAuthTestBody(boolean strictLocalhost) throws Exception {
        String strictLocalhostArgs = "--trusted_domain_strict_localhost=" + String.valueOf(strictLocalhost);
        this.setUp("--trusted_domain=localhost --trusted_domain_use_xff_header=true " + strictLocalhostArgs);
        this.verifyMetrics(0L, 0L);
        THttpClient transport = new THttpClient("http://localhost:28000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Basic VGVzdDFMZGFwOjEyMzQ1");
        headers.put("X-Forwarded-For", "127.0.0.1");
        transport.setCustomHeaders(headers);
        transport.open();
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        TOpenSessionReq openReq = new TOpenSessionReq();
        TOpenSessionResp openResp = client.OpenSession(openReq);
        this.verifyMetrics(0L, 0L);
        this.verifyTrustedDomainMetrics(1L);
        TOperationHandle operationHandle = LdapHS2Test.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "Test1Ldap");
        this.verifyMetrics(0L, 0L);
        this.verifyTrustedDomainMetrics(3L);
        headers.put("Authorization", "Basic VGVzdDFMZGFwOg==");
        headers.put("X-Forwarded-For", "127.0.0.1");
        transport.setCustomHeaders(headers);
        openResp = client.OpenSession(openReq);
        this.verifyMetrics(0L, 0L);
        this.verifyTrustedDomainMetrics(4L);
        operationHandle = LdapHS2Test.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "Test1Ldap");
        this.verifyMetrics(0L, 0L);
        this.verifyTrustedDomainMetrics(6L);
        headers.put("Authorization", "Basic VGVzdDFMZGFwOg==");
        headers.remove("X-Forwarded-For");
        headers.put("x-Forwarded-for", "127.0.0.1");
        transport.setCustomHeaders(headers);
        openResp = client.OpenSession(openReq);
        this.verifyMetrics(0L, 0L);
        this.verifyTrustedDomainMetrics(7L);
        operationHandle = LdapHS2Test.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "Test1Ldap");
        this.verifyMetrics(0L, 0L);
        this.verifyTrustedDomainMetrics(9L);
        headers.remove("x-Forwarded-for");
        headers.put("Authorization", "Basic VGVzdDFMZGFwOjEyMzQ1");
        String nontrustedIp = strictLocalhost ? "127.0.23.1" : "126.0.23.1";
        headers.put("X-Forwarded-For", nontrustedIp);
        transport.setCustomHeaders(headers);
        openResp = client.OpenSession(openReq);
        this.verifyMetrics(1L, 0L);
        this.verifyTrustedDomainMetrics(9L);
        operationHandle = LdapHS2Test.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "Test1Ldap");
        this.verifyMetrics(3L, 0L);
        this.verifyTrustedDomainMetrics(9L);
        headers.remove("Authorization");
        headers.put("X-Forwarded-For", "127.0.0.1");
        transport.setCustomHeaders(headers);
        try {
            openResp = client.OpenSession(openReq);
            Assert.fail((String)"Exception exception.");
        }
        catch (Exception e) {
            this.verifyTrustedDomainMetrics(9L);
            Assert.assertEquals((Object)e.getMessage(), (Object)"HTTP Response code: 401");
        }
        headers.put("Authorization", "Basic VGVzdDFMZGFwOg==");
        headers.put("X-Forwarded-For", nontrustedIp);
        transport.setCustomHeaders(headers);
        try {
            openResp = client.OpenSession(openReq);
            Assert.fail((String)"Exception exception.");
        }
        catch (Exception e) {
            this.verifyMetrics(3L, 1L);
            this.verifyTrustedDomainMetrics(9L);
            Assert.assertEquals((Object)e.getMessage(), (Object)"HTTP Response code: 401");
        }
        headers.put("Authorization", "Basic VGVzdDFMZGFwOjEyMzQ1");
        headers.remove("X-Forwarded-For");
        transport.setCustomHeaders(headers);
        openResp = client.OpenSession(openReq);
        this.verifyMetrics(4L, 1L);
        this.verifyTrustedDomainMetrics(9L);
    }

    @Test
    public void testHiveserver2TrustedDomainAuthStrict() throws Exception {
        this.hiveserver2TrustedDomainAuthTestBody(true);
    }

    @Test
    public void testHiveserver2TrustedDomainAuthNonstrict() throws Exception {
        this.hiveserver2TrustedDomainAuthTestBody(false);
    }

    @Test
    public void testHiveserver2TrustedDomainEmptyXffHeaderUseOrigin() throws Exception {
        this.setUp("--trusted_domain=localhost --trusted_domain_use_xff_header=true --trusted_domain_empty_xff_header_use_origin=true");
        this.verifyMetrics(0L, 0L);
        this.verifyTrustedDomainMetrics(0L);
        THttpClient transport = new THttpClient("http://localhost:28000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Basic VGVzdDFMZGFwOg==");
        headers.put("X-Forwarded-For", "127.0.0.1, 120.76.80.91");
        transport.setCustomHeaders(headers);
        transport.open();
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        TOpenSessionReq openReq = new TOpenSessionReq();
        TOpenSessionResp openResp = client.OpenSession(openReq);
        this.verifyMetrics(0L, 0L);
        this.verifyTrustedDomainMetrics(1L);
        TOperationHandle operationHandle = LdapHS2Test.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "Test1Ldap");
        this.verifyMetrics(0L, 0L);
        this.verifyTrustedDomainMetrics(3L);
        headers.put("Authorization", "Basic VGVzdDFMZGFwOg==");
        headers.remove("X-Forwarded-For");
        transport.setCustomHeaders(headers);
        openResp = client.OpenSession(openReq);
        this.verifyMetrics(0L, 0L);
        this.verifyTrustedDomainMetrics(4L);
        operationHandle = LdapHS2Test.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "Test1Ldap");
        this.verifyMetrics(0L, 0L);
        this.verifyTrustedDomainMetrics(6L);
        headers.put("Authorization", "Basic VGVzdDFMZGFwOg==");
        headers.put("X-Forwarded-For", "126.0.23.1, 127.0.0.1, 127.0.0.6");
        transport.setCustomHeaders(headers);
        try {
            openResp = client.OpenSession(openReq);
            Assert.fail((String)"Authentication should fail without password.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"HTTP Response code: 401");
            this.verifyMetrics(0L, 1L);
            this.verifyTrustedDomainMetrics(6L);
        }
        this.setUp("--trusted_domain=any.domain --trusted_domain_use_xff_header=true --trusted_domain_empty_xff_header_use_origin=true");
        headers.put("Authorization", "Basic VGVzdDFMZGFwOg==");
        headers.remove("X-Forwarded-For");
        transport.setCustomHeaders(headers);
        this.verifyMetrics(0L, 0L);
        this.verifyTrustedDomainMetrics(0L);
        try {
            openResp = client.OpenSession(openReq);
            Assert.fail((String)"Authentication should fail without password.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"HTTP Response code: 401");
            this.verifyMetrics(0L, 1L);
            this.verifyTrustedDomainMetrics(0L);
        }
    }

    @Test
    public void testHiveserver2TrustedAuthHeader() throws Exception {
        this.setUp("--trusted_auth_header=X-Trusted-Proxy-Auth-Header");
        this.verifyMetrics(0L, 0L);
        THttpClient transport = new THttpClient("http://localhost:28000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Basic VGVzdDFMZGFwOjEyMzQ1");
        headers.put("X-Trusted-Proxy-Auth-Header", "on");
        transport.setCustomHeaders(headers);
        transport.open();
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        TOpenSessionReq openReq = new TOpenSessionReq();
        TOpenSessionResp openResp = client.OpenSession(openReq);
        this.verifyMetrics(0L, 0L);
        this.verifyTrustedAuthHeaderMetrics(1L);
        TOperationHandle operationHandle = LdapHS2Test.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "Test1Ldap");
        this.verifyMetrics(0L, 0L);
        this.verifyTrustedAuthHeaderMetrics(3L);
        headers.put("Authorization", "Basic VGVzdDFMZGFwOg==");
        headers.put("X-Trusted-Proxy-Auth-Header", "");
        transport.setCustomHeaders(headers);
        openResp = client.OpenSession(openReq);
        this.verifyMetrics(0L, 0L);
        this.verifyTrustedAuthHeaderMetrics(4L);
        operationHandle = LdapHS2Test.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "Test1Ldap");
        this.verifyMetrics(0L, 0L);
        this.verifyTrustedAuthHeaderMetrics(6L);
        headers.remove("Authorization");
        headers.put("X-Trusted-Proxy-Auth-Header", "on");
        transport.setCustomHeaders(headers);
        try {
            openResp = client.OpenSession(openReq);
            Assert.fail((String)"Exception exception.");
        }
        catch (Exception e) {
            this.verifyTrustedAuthHeaderMetrics(6L);
            Assert.assertEquals((Object)e.getMessage(), (Object)"HTTP Response code: 401");
        }
        long successMetricBefore = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-trusted-auth-header-check-success");
        headers.put("Authorization", "Basic VGVzdDFMZGFwOjEyMzQ1");
        headers.remove("X-Trusted-Proxy-Auth-Header");
        transport.setCustomHeaders(headers);
        openResp = client.OpenSession(openReq);
        this.verifyMetrics(1L, 0L);
        this.verifyTrustedAuthHeaderMetrics(successMetricBefore);
    }

    @Test
    public void testHiveserver2JwtAuth() throws Exception {
        String jwksFilename = new File(System.getenv("IMPALA_HOME"), "testdata/jwt/jwks_rs256.json").getPath();
        this.setUp(String.format("--jwt_token_auth=true --jwt_validate_signature=true --jwks_file_path=%s --jwt_allow_without_tls=true", jwksFilename));
        this.verifyMetrics(0L, 0L);
        THttpClient transport = new THttpClient("http://localhost:28000");
        HashMap<String, String> headers = new HashMap<String, String>();
        String jwtToken = "eyJhbGciOiJSUzI1NiIsImtpZCI6InB1YmxpYzpjNDI0YjY3Yi1mZTI4LTQ1ZDctYjAxNS1mNzlkYTUwYjViMjEiLCJ0eXAiOiJKV1MifQ.eyJpc3MiOiJhdXRoMCIsInVzZXJuYW1lIjoiaW1wYWxhIn0.OW5H2SClLlsotsCarTHYEbqlbRh43LFwOyo9WubpNTwE7hTuJDsnFoVrvHiWI02W69TZNat7DYcC86A_ogLMfNXagHjlMFJaRnvG5Ekag8NRuZNJmHVqfX-qr6x7_8mpOdU554kc200pqbpYLhhuK4Qf7oT7y9mOrtNrUKGDCZ0Q2y_mizlbY6SMg4RWqSz0RQwJbRgXIWSgcbZd0GbD_MQQ8x7WRE4nluU-5Fl4N2Wo8T9fNTuxALPiuVeIczO25b5n4fryfKasSgaZfmk0CoOJzqbtmQxqiK9QNSJAiH2kaqMwLNgAdgn8fbd-lB1RAEGeyPH8Px8ipqcKsPk0bg";
        headers.put("Authorization", "Bearer " + jwtToken);
        headers.put("X-Forwarded-For", "127.0.0.1");
        transport.setCustomHeaders(headers);
        transport.open();
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        TOpenSessionReq openReq = new TOpenSessionReq();
        TOpenSessionResp openResp = client.OpenSession(openReq);
        this.verifyMetrics(0L, 0L);
        this.verifyAuthMetrics(1L, 0L, "jwt");
        TOperationHandle operationHandle = LdapHS2Test.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "impala");
        this.verifyMetrics(0L, 0L);
        this.verifyAuthMetrics(3L, 0L, "jwt");
        String invalidJwtToken = "eyJhbGciOiJSUzI1NiIsImtpZCI6InB1YmxpYzpjNDI0YjY3Yi1mZTI4LTQ1ZDctYjAxNS1mNzlkYTUwYjViMjEiLCJ0eXAiOiJKV1MifQ.eyJpc3MiOiJhdXRoMCIsInVzZXJuYW1lIjoiaW1wYWxhIn0.";
        headers.put("Authorization", "Bearer " + invalidJwtToken);
        headers.put("X-Forwarded-For", "127.0.0.1");
        transport.setCustomHeaders(headers);
        try {
            openResp = client.OpenSession(openReq);
            Assert.fail((String)"Exception exception.");
        }
        catch (Exception e) {
            this.verifyAuthMetrics(3L, 1L, "jwt");
            Assert.assertEquals((Object)e.getMessage(), (Object)"HTTP Response code: 401");
        }
    }

    @Test
    public void testHiveserver2JwtAndOAuthAuth() throws Exception {
        String jwtJwksFilename = new File(System.getenv("IMPALA_HOME"), "testdata/jwt/jwks_rs256.json").getPath();
        String oauthJwksFilename = new File(System.getenv("IMPALA_HOME"), "testdata/jwt/jwks_signing.json").getPath();
        this.setUp(String.format("--jwt_token_auth=true --jwt_validate_signature=true --jwks_file_path=%s --jwt_allow_without_tls=true --oauth_token_auth=true --oauth_jwt_validate_signature=true --oauth_jwks_file_path=%s --jwt_allow_without_tls=true --oauth_jwt_custom_claim_username=sub --oauth_allow_without_tls=true", jwtJwksFilename, oauthJwksFilename));
        this.verifyMetrics(0L, 0L);
        THttpClient transport = new THttpClient("http://localhost:28000");
        HashMap<String, String> headers = new HashMap<String, String>();
        String jwtToken = "eyJhbGciOiJSUzI1NiIsImtpZCI6InB1YmxpYzpjNDI0YjY3Yi1mZTI4LTQ1ZDctYjAxNS1mNzlkYTUwYjViMjEiLCJ0eXAiOiJKV1MifQ.eyJpc3MiOiJhdXRoMCIsInVzZXJuYW1lIjoiaW1wYWxhIn0.OW5H2SClLlsotsCarTHYEbqlbRh43LFwOyo9WubpNTwE7hTuJDsnFoVrvHiWI02W69TZNat7DYcC86A_ogLMfNXagHjlMFJaRnvG5Ekag8NRuZNJmHVqfX-qr6x7_8mpOdU554kc200pqbpYLhhuK4Qf7oT7y9mOrtNrUKGDCZ0Q2y_mizlbY6SMg4RWqSz0RQwJbRgXIWSgcbZd0GbD_MQQ8x7WRE4nluU-5Fl4N2Wo8T9fNTuxALPiuVeIczO25b5n4fryfKasSgaZfmk0CoOJzqbtmQxqiK9QNSJAiH2kaqMwLNgAdgn8fbd-lB1RAEGeyPH8Px8ipqcKsPk0bg";
        headers.put("Authorization", "Bearer " + jwtToken);
        headers.put("X-Forwarded-For", "127.0.0.1");
        transport.setCustomHeaders(headers);
        transport.open();
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        TOpenSessionReq openReq = new TOpenSessionReq();
        TOpenSessionResp openResp = client.OpenSession(openReq);
        this.verifyMetrics(0L, 0L);
        this.verifyAuthMetrics(1L, 0L, "jwt");
        TOperationHandle operationHandle = LdapHS2Test.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "impala");
        this.verifyMetrics(0L, 0L);
        this.verifyAuthMetrics(3L, 0L, "jwt");
        this.verifyAuthMetrics(0L, 0L, "oauth");
        String oauthToken = "eyJhbGciOiJSUzI1NiIsImtpZCI6IjIwMjMwNTA5LTE2MDQxNSIsInR5cGUiOiJKV1QifQ.eyJhdWQiOiJpbXBhbGEtdGVzdHMiLCJleHAiOjE5OTkwMDgyNTUsImlhdCI6MTY4MzY0ODI1NSwiaXNzIjoiZmlsZTovL3Rlc3RzL3V0aWwvand0L2p3dF91dGlsLnB5Iiwia2lkIjoiMjAyMzA1MDktMTYwNDE1Iiwic3ViIjoidGVzdC11c2VyIn0.dWMOkcBrwRansZrCZrlbYzr9alIQ23qlnw4t8Kx_v87CBB90qtmTV88nZAh4APtTE8IUnP0e45R2XyDoH3a8UVrrSOkEzI47wJ0I3GqSc_R_MsGoeGlKreZmcjGhY_ceOo7RWYaBdzsAZe1YXcKJbq2sQJ3issfjBa_fWt0Qhy0DvzssUf3V-g5nQUM3W3pOULiFtMhA8YmIdheHalRz3D_NWMAqe79iUv6tG0Eg08x-cl8GXYsDm45sU4WkP5fZps6Q4Fm05640FWXG8K0PoLzSI_Iac3zzSAPs-iYNeeNE6C9QxBYSLBvQrWL0SETafP82Mo-nEZsAJbMMSqm0cQ";
        transport = new THttpClient("http://localhost:28000");
        headers = new HashMap();
        headers.put("Authorization", "Bearer " + oauthToken);
        headers.put("X-Forwarded-For", "127.0.0.1");
        transport.setCustomHeaders(headers);
        transport.open();
        client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        openReq = new TOpenSessionReq();
        openResp = client.OpenSession(openReq);
        this.verifyMetrics(0L, 0L);
        this.verifyAuthMetrics(1L, 0L, "oauth");
        operationHandle = LdapHS2Test.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "test-user");
        this.verifyMetrics(0L, 0L);
        this.verifyAuthMetrics(3L, 0L, "oauth");
        this.verifyAuthMetrics(3L, 0L, "jwt");
        headers.clear();
        String invalidJwtToken = "eyJhbGciOiJSUzI1NiIsImtpZCI6InB1YmxpYzpjNDI0YjY3Yi1mZTI4LTQ1ZDctYjAxNS1mNzlkYTUwYjViMjEiLCJ0eXAiOiJKV1MifQ.eyJpc3MiOiJhdXRoMCIsInVzZXJuYW1lIjoiaW1wYWxhIn0.";
        headers.put("Authorization", "Bearer " + invalidJwtToken);
        headers.put("X-Forwarded-For", "127.0.0.1");
        transport.setCustomHeaders(headers);
        try {
            openResp = client.OpenSession(openReq);
            Assert.fail((String)"Exception exception.");
        }
        catch (Exception e) {
            this.verifyAuthMetrics(3L, 1L, "jwt");
            this.verifyAuthMetrics(3L, 1L, "oauth");
            Assert.assertEquals((Object)e.getMessage(), (Object)"HTTP Response code: 401");
        }
    }

    @Test
    public void testImpalaExtJdbcTables() throws Exception {
        this.setUp("");
        this.verifyMetrics(0L, 0L);
        THttpClient transport = new THttpClient("http://localhost:28000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Basic VGVzdDFMZGFwOjEyMzQ1");
        transport.setCustomHeaders(headers);
        transport.open();
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        TOpenSessionReq openReq = new TOpenSessionReq();
        TOpenSessionResp openResp = client.OpenSession(openReq);
        TSessionHandle session = openResp.getSessionHandle();
        this.verifyMetrics(1L, 0L);
        String fileSystemPrefix = System.getenv("FILESYSTEM_PREFIX");
        String internalListenHost = System.getenv("INTERNAL_LISTEN_HOST");
        String dropTableQuery = "DROP TABLE IF EXISTS %s";
        String createTableQuery = String.format("CREATE EXTERNAL TABLE impala_jdbc_ext_test_table (id INT, bool_col BOOLEAN, tinyint_col TINYINT, smallint_col SMALLINT, int_col INT, bigint_col BIGINT, float_col FLOAT, double_col DOUBLE, date_string_col STRING, string_col STRING, timestamp_col TIMESTAMP) STORED BY JDBC TBLPROPERTIES (\"database.type\"=\"IMPALA\", \"jdbc.url\"=\"jdbc:impala://%s:21050/functional\", \"jdbc.auth\"=\"AuthMech=3\", \"jdbc.driver\"=\"com.cloudera.impala.jdbc.Driver\", \"driver.url\"=\"%s/test-warehouse/data-sources/jdbc-drivers/ImpalaJDBC42.jar\", \"dbcp.username\"=\"%s\", \"dbcp.password\"=\"%s\", \"table\"=\"alltypes\")", internalListenHost, fileSystemPrefix, "Test1Ldap", "12345");
        String createTableWithWrongPassword = String.format("CREATE EXTERNAL TABLE impala_jdbc_tbl_wrong_password (id INT, bool_col BOOLEAN, tinyint_col TINYINT, smallint_col SMALLINT, int_col INT, bigint_col BIGINT, float_col FLOAT, double_col DOUBLE, date_string_col STRING, string_col STRING, timestamp_col TIMESTAMP) STORED BY JDBC TBLPROPERTIES (\"database.type\"=\"IMPALA\", \"jdbc.url\"=\"jdbc:impala://%s:21050/functional\", \"jdbc.auth\"=\"AuthMech=3\", \"jdbc.driver\"=\"com.cloudera.impala.jdbc.Driver\", \"driver.url\"=\"%s/test-warehouse/data-sources/jdbc-drivers/ImpalaJDBC42.jar\", \"dbcp.username\"=\"%s\", \"dbcp.password\"=\"wrong-password\", \"table\"=\"alltypes\")", internalListenHost, fileSystemPrefix, "Test1Ldap");
        String createTableWithoutAuthMech = String.format("CREATE EXTERNAL TABLE impala_jdbc_tbl_without_auth_mech (id INT, bool_col BOOLEAN, tinyint_col TINYINT, smallint_col SMALLINT, int_col INT, bigint_col BIGINT, float_col FLOAT, double_col DOUBLE, date_string_col STRING, string_col STRING, timestamp_col TIMESTAMP) STORED BY JDBC TBLPROPERTIES (\"database.type\"=\"IMPALA\", \"jdbc.url\"=\"jdbc:impala://%s:21050/functional\", \"jdbc.driver\"=\"com.cloudera.impala.jdbc.Driver\", \"driver.url\"=\"%s/test-warehouse/data-sources/jdbc-drivers/ImpalaJDBC42.jar\", \"dbcp.username\"=\"%s\", \"dbcp.password\"=\"%s\", \"table\"=\"alltypes\")", internalListenHost, fileSystemPrefix, "Test1Ldap", "12345");
        String selectQuery = "select string_col from %s where id=9";
        LdapHS2Test.execAndFetch((TCLIService.Iface)client, session, String.format(dropTableQuery, "impala_jdbc_ext_test_table"), null);
        LdapHS2Test.execAndFetch((TCLIService.Iface)client, session, createTableQuery, "Table has been created.");
        LdapHS2Test.execAndFetch((TCLIService.Iface)client, session, String.format(dropTableQuery, "impala_jdbc_tbl_wrong_password"), null);
        LdapHS2Test.execAndFetch((TCLIService.Iface)client, session, createTableWithWrongPassword, "Table has been created.");
        LdapHS2Test.execAndFetch((TCLIService.Iface)client, session, String.format(dropTableQuery, "impala_jdbc_tbl_without_auth_mech"), null);
        LdapHS2Test.execAndFetch((TCLIService.Iface)client, session, createTableWithoutAuthMech, "Table has been created.");
        LdapHS2Test.execAndFetch((TCLIService.Iface)client, session, String.format(selectQuery, "impala_jdbc_ext_test_table"), "9");
        String expectedError = "Error initialized or created transport for authentication";
        try {
            LdapHS2Test.execAndFetch((TCLIService.Iface)client, session, String.format(selectQuery, "impala_jdbc_tbl_wrong_password"), "9");
            Assert.fail((String)("Expected error: " + expectedError));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(expectedError));
        }
        expectedError = "Communication link failure. Failed to connect to server";
        try {
            LdapHS2Test.execAndFetch((TCLIService.Iface)client, session, String.format(selectQuery, "impala_jdbc_tbl_without_auth_mech"), "9");
            Assert.fail((String)("Expected error: " + expectedError));
        }
        catch (Exception e) {
            Assert.assertTrue((String)String.format("Authentication failed with error: %s", e.getMessage()), (boolean)e.getMessage().contains(expectedError));
        }
        LdapHS2Test.execAndFetch((TCLIService.Iface)client, session, String.format(dropTableQuery, "impala_jdbc_ext_test_table"), "Table has been dropped.");
        LdapHS2Test.execAndFetch((TCLIService.Iface)client, session, String.format(dropTableQuery, "impala_jdbc_tbl_wrong_password"), "Table has been dropped.");
        LdapHS2Test.execAndFetch((TCLIService.Iface)client, session, String.format(dropTableQuery, "impala_jdbc_tbl_without_auth_mech"), "Table has been dropped.");
        this.verifyMetrics(25L, 0L);
    }
}

