/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.customcluster;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TExecuteStatementReq;
import org.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import org.apache.hive.service.rpc.thrift.TFetchOrientation;
import org.apache.hive.service.rpc.thrift.TFetchResultsReq;
import org.apache.hive.service.rpc.thrift.TFetchResultsResp;
import org.apache.hive.service.rpc.thrift.TOpenSessionReq;
import org.apache.hive.service.rpc.thrift.TOpenSessionResp;
import org.apache.hive.service.rpc.thrift.TOperationHandle;
import org.apache.hive.service.rpc.thrift.TSessionHandle;
import org.apache.hive.service.rpc.thrift.TStatus;
import org.apache.hive.service.rpc.thrift.TStatusCode;
import org.apache.impala.customcluster.CustomClusterRunner;
import org.apache.impala.testutil.WebClient;
import org.apache.impala.testutil.X509CertChain;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.StringContains;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtHttpTest {
    private static final Logger LOG = LoggerFactory.getLogger(JwtHttpTest.class);
    private static final String CA_CERT = "cacert.pem";
    private static final String SERVER_CERT = "server-cert.pem";
    private static final String SERVER_KEY = "server-key.pem";
    private static final String JWKS_FILE_NAME = "jwks_rs256.json";
    WebClient client_ = new WebClient();
    String jwtToken_ = "eyJhbGciOiJSUzI1NiIsImtpZCI6InB1YmxpYzpjNDI0YjY3Yi1mZTI4LTQ1ZDctYjAxNS1mNzlkYTUwYjViMjEiLCJ0eXAiOiJKV1MifQ.eyJpc3MiOiJhdXRoMCIsInVzZXJuYW1lIjoiaW1wYWxhIn0.OW5H2SClLlsotsCarTHYEbqlbRh43LFwOyo9WubpNTwE7hTuJDsnFoVrvHiWI02W69TZNat7DYcC86A_ogLMfNXagHjlMFJaRnvG5Ekag8NRuZNJmHVqfX-qr6x7_8mpOdU554kc200pqbpYLhhuK4Qf7oT7y9mOrtNrUKGDCZ0Q2y_mizlbY6SMg4RWqSz0RQwJbRgXIWSgcbZd0GbD_MQQ8x7WRE4nluU-5Fl4N2Wo8T9fNTuxALPiuVeIczO25b5n4fryfKasSgaZfmk0CoOJzqbtmQxqiK9QNSJAiH2kaqMwLNgAdgn8fbd-lB1RAEGeyPH8Px8ipqcKsPk0bg";
    String jwtTokenX5c_ = "eyJhbGciOiJSUzI1NiIsImtpZCI6ImtpZF94NWMiLCJ0eXAiOiJKV1QifQ.eyJleHAiOjI1ODk4MzQ2NzUsImlhdCI6MTcxNTYzMjM1MSwiaXNzIjoiYXV0aDAiLCJqdGkiOiJ4OEpoSDZVd21XQUZfSGZ2cnR0aEREbWYzREwzTVRzWSIsInN1YiI6Imp3dC1jcHAuZXhhbXBsZS5sb2NhbGhvc3QifQ.JZxb9GPuhtlbxWT6_XWX0uZ9EN7PP4frfHNxjquDIlgv7At8sEFw21mVWKoafDHKRPzt35zhRlRO9saXQOyVFxSzHHv23RSS47bgUqcpkHQQltP6P9SRbJDT7GB13Kusx5Pzl-kJosNR-ZpiQY_nkJEUPHj9vIYAc6B5eGudGEoyWAvjtNE2uBCrt5UodEO1RqcZOwjZivTjIIjCOgu3ibz2lmJfhEGwSHOm5uld7sdjjnAviVvVSRASoHP4e2Yu4aFevvNaW-CNNlNLXq1QlLE9ClB-IgecZUFOexGZaLSNGiKuAvAqzN6ks_gUJKgtqBeQGeDVqCNPE8JuNTfIG0W7Ywb3U9zFBeZ3CtI4RwQsKOYncuy54AC841iGAWkAChsWtBkgTjupSExjvUsKTu3MK5ffbh4LARrj3fTOZlmOqRCM884WG2KoN695dqxcmQKf5QiYMTrFXEVUCM-Y4smZqHsTQI3PxfcU6neYnwDDMS-FUNePX8yLX_3E2FpBTIuBitwInO1Bk6SsbZvZRmG-2CwEWlclIr9hMxSeProDSamS5mI89VuShDLYUXaDISSKXoKriFdOxICL2uTdbQLsb_6Z5GbYW42CcUSgG9lJmImtMKH9bS2wwSOmUBi03XBLrraODdI69_EFWFgCG9WjcWJo0R74GJbHAi3cyLM";
    boolean createJWKSForWebServer_ = false;

    private void setUp(String extraArgs) throws Exception {
        int ret = CustomClusterRunner.StartImpalaCluster(extraArgs);
        Assert.assertEquals((long)ret, (long)0L);
    }

    private void setUp(String impaladArgs, String catalogdArgs, String statestoredArgs, int expectedRetCode) throws Exception {
        if (this.createJWKSForWebServer_) {
            this.createTempJWKSInWebServerRootDir(JWKS_FILE_NAME);
        }
        int ret = CustomClusterRunner.StartImpalaCluster(impaladArgs, catalogdArgs, statestoredArgs);
        Assert.assertEquals((long)expectedRetCode, (long)ret);
    }

    private void setUpWithSingleCoordinator(String impaladArgs, String catalogdArgs, String statestoredArgs, int expectedRetCode) throws Exception {
        if (this.createJWKSForWebServer_) {
            this.createTempJWKSInWebServerRootDir(JWKS_FILE_NAME);
        }
        int ret = CustomClusterRunner.StartImpalaCluster(impaladArgs, catalogdArgs, statestoredArgs, new HashMap<String, String>(), "--num_coordinators=1");
        Assert.assertEquals((long)expectedRetCode, (long)ret);
    }

    @After
    public void cleanUp() throws Exception {
        CustomClusterRunner.StartImpalaCluster();
        if (this.createJWKSForWebServer_) {
            this.deleteTempJWKSFromWebServerRootDir();
        }
        this.client_.close();
    }

    private void createTempJWKSInWebServerRootDir(String srcFilename) {
        Path srcJwksPath = Paths.get(System.getenv("IMPALA_HOME"), "testdata", "jwt", srcFilename);
        Path tempJwksPath = Paths.get(System.getenv("IMPALA_HOME"), "www", "temp_jwks.json");
        try {
            Files.copy(srcJwksPath, tempJwksPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Assert.fail((String)("Failed to copy file: " + e.getMessage()));
        }
    }

    private void deleteTempJWKSFromWebServerRootDir() {
        Path tempJwksPath = Paths.get(System.getenv("IMPALA_HOME"), "www", "temp_jwks.json");
        try {
            Files.delete(tempJwksPath);
        }
        catch (IOException e) {
            Assert.fail((String)("Failed to delete file: " + e.getMessage()));
        }
    }

    static void verifySuccess(TStatus status) throws Exception {
        if (status.getStatusCode() == TStatusCode.SUCCESS_STATUS || status.getStatusCode() == TStatusCode.SUCCESS_WITH_INFO_STATUS) {
            return;
        }
        throw new Exception(status.toString());
    }

    static TOperationHandle execAndFetch(TCLIService.Iface client, TSessionHandle sessionHandle, String query, String expectedResult) throws Exception {
        TExecuteStatementReq execReq = new TExecuteStatementReq(sessionHandle, query);
        TExecuteStatementResp execResp = client.ExecuteStatement(execReq);
        JwtHttpTest.verifySuccess(execResp.getStatus());
        TFetchResultsReq fetchReq = new TFetchResultsReq(execResp.getOperationHandle(), TFetchOrientation.FETCH_NEXT, 1000L);
        TFetchResultsResp fetchResp = client.FetchResults(fetchReq);
        JwtHttpTest.verifySuccess(fetchResp.getStatus());
        List columns = fetchResp.getResults().getColumns();
        Assert.assertEquals((long)1L, (long)columns.size());
        Assert.assertEquals((Object)expectedResult, ((TColumn)columns.get(0)).getStringVal().getValues().get(0));
        return execResp.getOperationHandle();
    }

    private void verifyJwtAuthMetrics(long expectedAuthSuccess, long expectedAuthFailure) throws Exception {
        long actualAuthSuccess = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-jwt-token-auth-success");
        Assert.assertEquals((long)expectedAuthSuccess, (long)actualAuthSuccess);
        long actualAuthFailure = (Long)this.client_.getMetric("impala.thrift-server.hiveserver2-http-frontend.total-jwt-token-auth-failure");
        Assert.assertEquals((long)expectedAuthFailure, (long)actualAuthFailure);
    }

    @Test
    public void testJwtAuth() throws Exception {
        this.createJWKSForWebServer_ = false;
        String jwksFilename = new File(System.getenv("IMPALA_HOME"), String.format("testdata/jwt/%s", JWKS_FILE_NAME)).getPath();
        this.setUp(String.format("--jwt_token_auth=true --jwt_validate_signature=true --jwks_file_path=%s --jwt_allow_without_tls=true", jwksFilename));
        THttpClient transport = new THttpClient("http://localhost:28000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.jwtToken_);
        headers.put("X-Forwarded-For", "127.0.0.1");
        transport.setCustomHeaders(headers);
        transport.open();
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        TOpenSessionReq openReq = new TOpenSessionReq();
        TOpenSessionResp openResp = client.OpenSession(openReq);
        this.verifyJwtAuthMetrics(1L, 0L);
        TOperationHandle operationHandle = JwtHttpTest.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "impala");
        this.verifyJwtAuthMetrics(3L, 0L);
        String invalidJwtToken = "eyJhbGciOiJSUzI1NiIsImtpZCI6InB1YmxpYzpjNDI0YjY3Yi1mZTI4LTQ1ZDctYjAxNS1mNzlkYTUwYjViMjEiLCJ0eXAiOiJKV1MifQ.eyJpc3MiOiJhdXRoMCIsInVzZXJuYW1lIjoiaW1wYWxhIn0.";
        headers.put("Authorization", "Bearer " + invalidJwtToken);
        headers.put("X-Forwarded-For", "127.0.0.1");
        transport.setCustomHeaders(headers);
        try {
            openResp = client.OpenSession(openReq);
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception e) {
            this.verifyJwtAuthMetrics(3L, 1L);
            Assert.assertEquals((Object)e.getMessage(), (Object)"HTTP Response code: 401");
        }
        headers.put("Authorization", "Basic VGVzdDFMZGFwOjEyMzQ1");
        headers.put("X-Forwarded-For", "127.0.0.1");
        transport.setCustomHeaders(headers);
        try {
            openResp = client.OpenSession(openReq);
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception e) {
            this.verifyJwtAuthMetrics(3L, 1L);
            Assert.assertEquals((Object)e.getMessage(), (Object)"HTTP Response code: 401");
        }
        headers.put("X-Forwarded-For", "127.0.0.1");
        transport.setCustomHeaders(headers);
        try {
            openResp = client.OpenSession(openReq);
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception e) {
            this.verifyJwtAuthMetrics(3L, 1L);
            Assert.assertEquals((Object)e.getMessage(), (Object)"HTTP Response code: 401");
        }
    }

    @Test
    public void testJwtAuthNotVerifySig() throws Exception {
        this.createJWKSForWebServer_ = false;
        this.setUp("--jwt_token_auth=true --jwt_validate_signature=false --jwt_allow_without_tls=true");
        THttpClient transport = new THttpClient("http://localhost:28000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.jwtToken_);
        headers.put("X-Forwarded-For", "127.0.0.1");
        transport.setCustomHeaders(headers);
        transport.open();
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        TOpenSessionReq openReq = new TOpenSessionReq();
        TOpenSessionResp openResp = client.OpenSession(openReq);
        this.verifyJwtAuthMetrics(1L, 0L);
        TOperationHandle operationHandle = JwtHttpTest.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "impala");
        this.verifyJwtAuthMetrics(3L, 0L);
    }

    @Test
    public void testJwtAuthWithJwksHttpUrl() throws Exception {
        this.createJWKSForWebServer_ = true;
        String statestoreWebserverArgs = "--webserver_port=25010";
        String jwksHttpUrl = "http://localhost:25010/www/temp_jwks.json";
        String impaladJwtArgs = String.format("--jwt_token_auth=true --jwt_validate_signature=true --jwks_url=%s --jwks_update_frequency_s=1 --jwt_allow_without_tls=true", jwksHttpUrl);
        this.setUp(impaladJwtArgs, "", statestoreWebserverArgs, 0);
        THttpClient transport = new THttpClient("http://localhost:28000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.jwtToken_);
        headers.put("X-Forwarded-For", "127.0.0.1");
        transport.setCustomHeaders(headers);
        transport.open();
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        TOpenSessionReq openReq = new TOpenSessionReq();
        TOpenSessionResp openResp = client.OpenSession(openReq);
        this.verifyJwtAuthMetrics(1L, 0L);
        TOperationHandle operationHandle = JwtHttpTest.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "impala");
        this.verifyJwtAuthMetrics(3L, 0L);
        this.createTempJWKSInWebServerRootDir("jwks_es256.json");
        Thread.sleep(3000L);
        transport.setCustomHeaders(headers);
        try {
            openResp = client.OpenSession(openReq);
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception e) {
            this.verifyJwtAuthMetrics(3L, 1L);
            Assert.assertEquals((Object)e.getMessage(), (Object)"HTTP Response code: 401");
        }
    }

    @Test
    public void testJwtAuthWithInsecureJwksHttpsUrl() throws Exception {
        this.createJWKSForWebServer_ = true;
        String certDir = this.setupServerAndRootCerts("testJwtAuthWithInsecureJwksHttpsUrl", "testJwtAuthWithInsecureJwksHttpsUrl Root", "localhostlocalhost");
        String statestoreWebserverArgs = String.format("--webserver_certificate_file=%s --webserver_private_key_file=%s --webserver_interface=localhost --webserver_port=25010 --hostname=localhost ", Paths.get(certDir, SERVER_CERT), Paths.get(certDir, SERVER_KEY));
        String jwksHttpUrl = "https://localhost:25010/www/temp_jwks.json";
        String impaladJwtArgs = String.format("--jwt_token_auth=true --jwt_validate_signature=true --jwks_url=%s --jwt_allow_without_tls=true --jwks_verify_server_certificate=false ", jwksHttpUrl);
        this.setUp(impaladJwtArgs, "", statestoreWebserverArgs, 0);
        THttpClient transport = new THttpClient("http://localhost:28000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.jwtToken_);
        headers.put("X-Forwarded-For", "127.0.0.1");
        transport.setCustomHeaders(headers);
        transport.open();
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        TOpenSessionReq openReq = new TOpenSessionReq();
        TOpenSessionResp openResp = client.OpenSession(openReq);
        this.verifyJwtAuthMetrics(1L, 0L);
        TOperationHandle operationHandle = JwtHttpTest.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "impala");
        this.verifyJwtAuthMetrics(3L, 0L);
    }

    @Test
    public void testJwtAuthWithUntrustedJwksHttpsUrl() throws Exception {
        this.createJWKSForWebServer_ = true;
        String certDir = this.setupServerAndRootCerts("testJwtAuthWithUntrustedJwksHttpsUrl", "testJwtAuthWithUntrustedJwksHttpsUrl Root", "localhost");
        Path logDir = Files.createTempDirectory("testJwtAuthWithUntrustedJwksHttpsUrl", new FileAttribute[0]);
        String statestoreWebserverArgs = String.format("--webserver_certificate_file=%s --webserver_private_key_file=%s --webserver_interface=localhost --webserver_port=25010 --hostname=localhost ", Paths.get(certDir, SERVER_CERT), Paths.get(certDir, SERVER_KEY));
        String jwksHttpUrl = "https://localhost:25010/www/temp_jwks.json";
        String impaladJwtArgs = String.format("--jwt_token_auth=true --jwt_validate_signature=true --jwks_url=%s --jwt_allow_without_tls=true --log_dir=%s --logbuflevel=-1 ", jwksHttpUrl, logDir.toAbsolutePath());
        String expectedErrString = String.format("Impalad services did not start correctly, exiting.  Error: Error downloading JWKS from '%s': Network error: curl error: SSL peer certificate or SSH remote key was not OK: SSL certificate problem: unable to get local issuer certificate", jwksHttpUrl);
        this.setUpWithSingleCoordinator(impaladJwtArgs, "", statestoreWebserverArgs, 1);
        this.checkCoordinatorLogs(expectedErrString, logDir);
    }

    @Test
    public void testJwtAuthWithTrustedJwksHttpsUrlInvalidCN() throws Exception {
        this.createJWKSForWebServer_ = true;
        String certCN = "notvalid";
        String certDir = this.setupServerAndRootCerts("testJwtAuthWithTrustedJwksHttpsUrlInvalidCN", "testJwtAuthWithTrustedJwksHttpsUrlInvalidCN Root", certCN);
        Path logDir = Files.createTempDirectory("testJwtAuthWithTrustedJwksHttpsUrlInvalidCN", new FileAttribute[0]);
        String statestoreWebserverArgs = String.format("--webserver_certificate_file=%s --webserver_private_key_file=%s --webserver_interface=localhost --webserver_port=25010 --hostname=localhost ", Paths.get(certDir, SERVER_CERT), Paths.get(certDir, SERVER_KEY));
        String jwksHttpUrl = "https://localhost:25010/www/temp_jwks.json";
        String impaladJwtArgs = String.format("--jwt_token_auth=true --jwt_validate_signature=true --jwks_url=%s --jwt_allow_without_tls=true --log_dir=%s --jwks_ca_certificate=%s --logbuflevel=-1 ", jwksHttpUrl, logDir.toAbsolutePath(), Paths.get(certDir, CA_CERT));
        String expectedErrString = String.format("Impalad services did not start correctly, exiting.  Error: Error downloading JWKS from '%s': Network error: curl error: SSL peer certificate or SSH remote key was not OK: SSL: certificate subject name '%s' does not match target hostname '%s'", jwksHttpUrl, certCN, "localhost");
        this.setUpWithSingleCoordinator(impaladJwtArgs, "", statestoreWebserverArgs, 1);
        this.checkCoordinatorLogs(expectedErrString, logDir);
    }

    @Test
    public void testJwtAuthWithTrustedJwksHttpsUrl() throws Exception {
        this.createJWKSForWebServer_ = true;
        String certDir = this.setupServerAndRootCerts("testJwtAuthWithTrustedJwksHttpsUrl", "testJwtAuthWithTrustedJwksHttpsUrl Root", "localhost");
        String statestoreWebserverArgs = String.format("--webserver_certificate_file=%s --webserver_private_key_file=%s --webserver_interface=localhost --webserver_port=25010 --hostname=localhost ", Paths.get(certDir, SERVER_CERT), Paths.get(certDir, SERVER_KEY));
        String jwksHttpUrl = "https://localhost:25010/www/temp_jwks.json";
        String impaladJwtArgs = String.format("--jwt_token_auth=true --jwt_validate_signature=true --jwks_url=%s --jwt_allow_without_tls=true --jwks_ca_certificate=%s ", jwksHttpUrl, Paths.get(certDir, CA_CERT));
        this.setUp(impaladJwtArgs, "", statestoreWebserverArgs, 0);
    }

    private String setupServerAndRootCerts(String testName, String rootCaCertCN, String rootLeafCertCN) throws Exception {
        Path certDir = Files.createTempDirectory(testName, new FileAttribute[0]);
        Path rootCACert = certDir.resolve(Paths.get(CA_CERT, new String[0]));
        Path serverCert = certDir.resolve(Paths.get(SERVER_CERT, new String[0]));
        Path serverKey = certDir.resolve(Paths.get(SERVER_KEY, new String[0]));
        FileWriter rootCACertWriter = new FileWriter(rootCACert.toFile());
        FileWriter serverCertWriter = new FileWriter(serverCert.toFile());
        FileWriter serverKeyWriter = new FileWriter(serverKey.toFile());
        X509CertChain certChain = new X509CertChain(rootCaCertCN, rootLeafCertCN);
        certChain.writeLeafCertAsPem(serverCertWriter);
        certChain.writeLeafPrivateKeyAsPem(serverKeyWriter);
        certChain.writeRootCertAsPem(rootCACertWriter);
        rootCACertWriter.close();
        serverCertWriter.close();
        serverKeyWriter.close();
        return certDir.toString();
    }

    @Test
    public void testJwtAuthWithJwksX5cHttpUrl() throws Exception {
        this.createJWKSForWebServer_ = false;
        String jwksFilename = new File(System.getenv("IMPALA_HOME"), "testdata/jwt/jwks_x5c_rs256.json").getPath();
        String impaladJwtArgs = String.format("--jwt_token_auth=true --jwt_validate_signature=true --jwks_file_path=%s --jwt_custom_claim_username=sub --jwt_allow_without_tls=true", jwksFilename);
        this.setUp(impaladJwtArgs);
        THttpClient transport = new THttpClient("http://localhost:28000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.jwtTokenX5c_);
        headers.put("X-Forwarded-For", "127.0.0.1");
        transport.setCustomHeaders(headers);
        transport.open();
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol((TTransport)transport));
        TOpenSessionReq openReq = new TOpenSessionReq();
        TOpenSessionResp openResp = client.OpenSession(openReq);
        this.verifyJwtAuthMetrics(1L, 0L);
        TOperationHandle operationHandle = JwtHttpTest.execAndFetch((TCLIService.Iface)client, openResp.getSessionHandle(), "select logged_in_user()", "jwt-cpp.example.localhost");
        this.verifyJwtAuthMetrics(3L, 0L);
    }

    private void checkCoordinatorLogs(String expectedString, Path logDir) throws IOException, InterruptedException {
        List<String> logLines = null;
        Matcher m = IsCollectionContaining.hasItem((Matcher)StringContains.containsString((String)expectedString));
        for (int i = 0; i < 10; ++i) {
            Path log_file_path = logDir.resolve("impalad.ERROR");
            try {
                logLines = Files.readAllLines(log_file_path);
                if (m.matches(logLines)) {
                    break;
                }
            }
            catch (Exception e) {
                LOG.info("attempt '" + Integer.toString(i) + "' could not read logfile '" + log_file_path.toString() + "'", (Throwable)e);
            }
            Thread.sleep(250L);
        }
        Assert.assertThat((String)String.format("Impalad startup failed but not for the expected reason. See logs in the '%s' folder for details.", logDir), logLines, (Matcher)IsCollectionContaining.hasItem((Matcher)StringContains.containsString((String)expectedString)));
    }
}

