/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.InsertStmt;
import org.apache.impala.analysis.ParseNode;
import org.apache.impala.analysis.ParsedStatement;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.StmtMetadataLoader;
import org.apache.impala.authorization.AuthorizationChecker;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.authorization.AuthorizationContext;
import org.apache.impala.authorization.AuthorizationException;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.AuthorizationManager;
import org.apache.impala.authorization.AuthorizationPolicy;
import org.apache.impala.authorization.BaseAuthorizationChecker;
import org.apache.impala.authorization.NoopAuthorizationFactory;
import org.apache.impala.authorization.PrivilegeRequest;
import org.apache.impala.authorization.User;
import org.apache.impala.catalog.Catalog;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AbstractFrontendTest;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.service.CompilerFactory;
import org.apache.impala.service.CompilerFactoryImpl;
import org.apache.impala.service.Frontend;
import org.apache.impala.service.FrontendProfile;
import org.apache.impala.service.catalogmanager.FeCatalogManager;
import org.apache.impala.testutil.ImpaladTestCatalog;
import org.apache.impala.thrift.TAccessEvent;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TSessionState;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.TSessionStateUtil;
import org.junit.Assert;

public class FrontendTestBase
extends AbstractFrontendTest {
    protected static Frontend frontend_ = feFixture_.frontend();
    protected static ImpaladTestCatalog catalog_ = feFixture_.catalog();
    protected final String[][] hintStyles_ = new String[][]{{"/* +", "*/"}, {"-- +", "\n"}, {"[", "]"}};

    protected Function addTestFunction(String name, ArrayList<ScalarType> args, boolean varArgs) {
        return this.addTestFunction("default", name, args, varArgs);
    }

    protected Function addTestFunction(String name, ScalarType arg, boolean varArgs) {
        return this.addTestFunction("default", name, Lists.newArrayList((Object[])new ScalarType[]{arg}), varArgs);
    }

    protected Function addTestFunction(String db, String fnName, ArrayList<ScalarType> args, boolean varArgs) {
        return feFixture_.addTestFunction(db, fnName, args, varArgs);
    }

    protected void addTestUda(String name, Type retType, Type ... argTypes) {
        feFixture_.addTestUda(name, retType, argTypes);
    }

    protected Db addTestDb(String dbName, String comment) {
        return feFixture_.addTestDb(dbName, comment);
    }

    protected Table addTestTable(String createTableSql) {
        return feFixture_.addTestTable(createTableSql);
    }

    protected Table addTestView(String createViewSql) {
        return feFixture_.addTestView(createViewSql);
    }

    protected Table addTestView(Catalog catalog, String createViewSql) {
        return feFixture_.addTestView(catalog, createViewSql);
    }

    protected Table addAllScalarTypesTestTable() {
        this.addTestDb("allscalartypesdb", "");
        return this.addTestTable("create table allscalartypes (bool_col boolean, tinyint_col tinyint, smallint_col smallint, int_col int, bigint_col bigint, float_col float, double_col double, dec1 decimal(9,0), d2 decimal(10, 0), d3 decimal(20, 10), d4 decimal(38, 38), d5 decimal(10, 5), timestamp_col timestamp, string_col string, varchar_col varchar(50), char_col char (30), date_col date)");
    }

    protected String InjectInsertHint(String pattern, String hint, InsertStmt.HintLocation loc) {
        String oracleHint = loc == InsertStmt.HintLocation.Start ? hint : "";
        String defaultHint = loc == InsertStmt.HintLocation.End ? hint : "";
        return String.format(pattern, oracleHint, defaultHint);
    }

    public ParsedStatement ParsesOk(String stmt) {
        return feFixture_.parseStmt(stmt);
    }

    public ParseNode AnalyzesOk(String stmt) {
        return this.AnalyzesOk(stmt, this.createAnalysisCtx(), null);
    }

    public ParseNode AnalyzesOk(String stmt, AnalysisContext analysisCtx) {
        return this.AnalyzesOk(stmt, analysisCtx, null);
    }

    public ParseNode AnalyzesOk(String stmt, String expectedWarning) {
        return this.AnalyzesOk(stmt, this.createAnalysisCtx(), expectedWarning, true);
    }

    public ParseNode AnalyzesOkWithoutWarnings(String stmt) {
        return this.AnalyzesOk(stmt, this.createAnalysisCtx(), null, true);
    }

    protected AnalysisContext createAnalysisCtx() {
        return feFixture_.createAnalysisCtx();
    }

    protected AnalysisContext createAnalysisCtx(String defaultDb) {
        return feFixture_.createAnalysisCtx(defaultDb);
    }

    protected AnalysisContext createAnalysisCtx(TQueryOptions queryOptions) {
        return feFixture_.createAnalysisCtx(queryOptions);
    }

    protected AnalysisContext createAnalysisCtx(TQueryOptions queryOptions, AuthorizationFactory authzFactory) {
        return feFixture_.createAnalysisCtx(queryOptions, authzFactory);
    }

    protected AnalysisContext createAnalysisCtx(TQueryOptions queryOptions, AuthorizationFactory authzFactory, String user) {
        return feFixture_.createAnalysisCtx(queryOptions, authzFactory, user);
    }

    protected AnalysisContext createAnalysisCtx(AuthorizationFactory authzFactory) {
        return feFixture_.createAnalysisCtx(authzFactory);
    }

    protected AnalysisContext createAnalysisCtx(AuthorizationFactory authzFactory, String user) {
        return feFixture_.createAnalysisCtx(authzFactory, user);
    }

    protected AnalysisContext createAnalysisCtxUsingHiveColLabels() {
        AnalysisContext analysisCtx = this.createAnalysisCtx();
        analysisCtx.setUseHiveColLabels(true);
        return analysisCtx;
    }

    public ParseNode AnalyzesOk(String stmt, AnalysisContext ctx, String expectedWarning, boolean assertNoWarnings) {
        try (FrontendProfile.Scope scope = FrontendProfile.createNewWithScope();){
            ParseNode parseNode = feFixture_.analyzeStmt(stmt, ctx, expectedWarning, assertNoWarnings);
            return parseNode;
        }
    }

    public ParseNode AnalyzesOk(String stmt, AnalysisContext ctx, String expectedWarning) {
        return this.AnalyzesOk(stmt, ctx, expectedWarning, false);
    }

    public ParseNode AnalyzesOkWithoutWarnings(String stmt, AnalysisContext ctx) {
        return this.AnalyzesOk(stmt, ctx, null, true);
    }

    public StatementBase AnalyzesOkNoRewrite(ParsedStatement stmt) throws ImpalaException {
        try (FrontendProfile.Scope scope = FrontendProfile.createNewWithScope();){
            AnalysisContext ctx = this.createAnalysisCtx();
            StmtMetadataLoader mdLoader = new StmtMetadataLoader(frontend_, ctx.getQueryCtx().session.database, null);
            StmtMetadataLoader.StmtTableCache loadedTables = mdLoader.loadTables(stmt);
            Analyzer analyzer = AnalysisContext.AnalysisDriverImpl.createAnalyzer((AnalysisContext)ctx, (StmtMetadataLoader.StmtTableCache)loadedTables);
            StatementBase stmtBase = (StatementBase)stmt.getTopLevelNode();
            stmtBase.analyze(analyzer);
            StatementBase statementBase = stmtBase;
            return statementBase;
        }
    }

    public void AnalysisError(String stmt) {
        this.AnalysisError(stmt, null);
    }

    public void AnalysisError(String stmt, String expectedErrorString) {
        this.AnalysisError(stmt, this.createAnalysisCtx(), expectedErrorString);
    }

    public void AnalysisError(String stmt, AnalysisContext ctx, String expectedErrorString) {
        Preconditions.checkNotNull((Object)expectedErrorString, (Object)"No expected error message given.");
        try {
            AnalysisContext.AnalysisResult analysisResult = this.parseAndAnalyze(stmt, ctx);
            Preconditions.checkNotNull((Object)analysisResult.getStmt());
        }
        catch (Exception e) {
            String errorString = e.getMessage();
            Preconditions.checkNotNull((Object)errorString, (Object)"Stack trace lost during exception.");
            String msg = "got error:\n" + errorString + "\nexpected:\n" + expectedErrorString;
            if (errorString.contains("No FileSystem for scheme ")) {
                errorString = errorString.replace("\"", "");
                errorString = errorString.replace("No FileSystem for scheme ", "No FileSystem for scheme: ");
            }
            errorString = errorString.replace("org.codehaus.jackson.JsonParseException", "com.fasterxml.jackson.core.JsonParseException");
            Assert.assertTrue((String)msg, (boolean)errorString.startsWith(expectedErrorString));
            return;
        }
        Assert.fail((String)("Stmt didn't result in analysis error: " + stmt));
    }

    protected AnalysisContext.AnalysisResult parseAndAnalyze(String stmt, AnalysisContext ctx) throws ImpalaException {
        return this.parseAndAnalyze(stmt, ctx, frontend_);
    }

    protected AnalysisContext.AnalysisResult parseAndAnalyze(String stmt, AnalysisContext ctx, Frontend fe) throws ImpalaException {
        try (FrontendProfile.Scope scope = FrontendProfile.createNewWithScope();){
            ctx.getQueryCtx().getClient_request().setStmt(stmt);
            CompilerFactoryImpl compilerFactory = new CompilerFactoryImpl();
            ParsedStatement parsedStmt = compilerFactory.createParsedStatement(ctx.getQueryCtx());
            User user = new User(TSessionStateUtil.getEffectiveUser((TSessionState)ctx.getQueryCtx().session));
            StmtMetadataLoader mdLoader = new StmtMetadataLoader(fe, ctx.getQueryCtx().session.database, null, user, null);
            StmtMetadataLoader.StmtTableCache stmtTableCache = mdLoader.loadTables(parsedStmt);
            AnalysisContext.AnalysisResult analysisResult = ctx.analyzeAndAuthorize((CompilerFactory)compilerFactory, parsedStmt, stmtTableCache, fe.getAuthzChecker());
            Preconditions.checkState((analysisResult.getException() == null ? 1 : 0) != 0);
            AnalysisContext.AnalysisResult analysisResult2 = analysisResult;
            return analysisResult2;
        }
    }

    protected Set<TAccessEvent> AnalyzeAccessEvents(String stmt) throws AuthorizationException, AnalysisException {
        return this.AnalyzeAccessEvents(stmt, "default");
    }

    protected Set<TAccessEvent> AnalyzeAccessEvents(String stmt, String db) throws AuthorizationException, AnalysisException {
        AnalysisContext ctx = this.createAnalysisCtx(db);
        this.AnalyzesOk(stmt, ctx);
        return ctx.getAnalyzer().getAccessEvents();
    }

    protected AuthorizationFactory createAuthorizationFactory() {
        return this.createAuthorizationFactory(true);
    }

    protected AuthorizationFactory createAuthorizationFactory(final boolean authorized) {
        return new AuthorizationFactory(){

            public AuthorizationConfig getAuthorizationConfig() {
                return new AuthorizationConfig(){

                    public boolean isEnabled() {
                        return true;
                    }

                    public String getProviderName() {
                        return "noop";
                    }

                    public String getServerName() {
                        return "server1";
                    }
                };
            }

            public AuthorizationChecker newAuthorizationChecker(AuthorizationPolicy authzPolicy) {
                AuthorizationConfig authzConfig = this.getAuthorizationConfig();
                return new BaseAuthorizationChecker(authzConfig){

                    protected boolean authorizeResource(AuthorizationContext authzCtx, User user, PrivilegeRequest request) throws InternalException {
                        return authorized;
                    }

                    public Set<String> getUserGroups(User user) throws InternalException {
                        return Collections.emptySet();
                    }

                    protected void authorizeRowFilterAndColumnMask(User user, List<PrivilegeRequest> privilegeRequests) throws AuthorizationException, InternalException {
                    }

                    public void invalidateAuthorizationCache() {
                    }

                    public boolean needsMaskingOrFiltering(User user, String dbName, String tableName, List<String> requiredColumns) {
                        return false;
                    }

                    public boolean needsRowFiltering(User user, String dbName, String tableName) {
                        return false;
                    }

                    public String createColumnMask(User user, String dbName, String tableName, String columnName, AuthorizationContext authzCtx) {
                        return null;
                    }

                    public String createRowFilter(User user, String dbName, String tableName, AuthorizationContext rangerCtx) {
                        return null;
                    }

                    public void postAnalyze(AuthorizationContext authzCtx) {
                    }

                    public boolean roleExists(String roleName) {
                        return catalog_.getAuthPolicy().getRole(roleName) != null;
                    }

                    public AuthorizationContext createAuthorizationContext(boolean doAudits, String sqlStmt, TSessionState sessionState, Optional<EventSequence> timeline) {
                        return new AuthorizationContext(timeline);
                    }
                };
            }

            public AuthorizationManager newAuthorizationManager(FeCatalogManager catalog, Supplier<? extends AuthorizationChecker> authzChecker) {
                return new NoopAuthorizationFactory.NoopAuthorizationManager();
            }

            public AuthorizationManager newAuthorizationManager(CatalogServiceCatalog catalog) {
                return new NoopAuthorizationFactory.NoopAuthorizationManager();
            }

            public boolean supportsTableMasking() {
                return false;
            }
        };
    }
}

