/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.common;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.CreateTableStmt;
import org.apache.impala.analysis.CreateViewStmt;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.ParseNode;
import org.apache.impala.analysis.ParsedStatement;
import org.apache.impala.analysis.ParsedStatementImpl;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.StmtMetadataLoader;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.NoopAuthorizationFactory;
import org.apache.impala.authorization.User;
import org.apache.impala.catalog.AggregateFunction;
import org.apache.impala.catalog.Catalog;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.KuduTable;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.View;
import org.apache.impala.common.AnalysisSessionFixture;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.service.CatalogOpExecutor;
import org.apache.impala.service.CompilerFactory;
import org.apache.impala.service.CompilerFactoryImpl;
import org.apache.impala.service.Frontend;
import org.apache.impala.testutil.ImpaladTestCatalog;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TCreateTableParams;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TSessionState;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.NoOpEventSequence;
import org.apache.impala.util.TSessionStateUtil;
import org.junit.Assert;

public class FrontendFixture {
    protected static final FrontendFixture instance_;
    protected final ImpaladTestCatalog catalog_ = new ImpaladTestCatalog();
    protected final Frontend frontend_;
    protected final List<Db> testDbs_ = new ArrayList<Db>();
    protected final List<Table> testTables_ = new ArrayList<Table>();
    protected final AnalysisSessionFixture defaultSession_ = new AnalysisSessionFixture();

    public static FrontendFixture instance() {
        return instance_;
    }

    private FrontendFixture() throws ImpalaException {
        this.frontend_ = new Frontend((AuthorizationFactory)new NoopAuthorizationFactory(), (FeCatalog)this.catalog_);
    }

    public void setUp() throws Exception {
        RuntimeEnv.INSTANCE.setTestEnv(true);
    }

    public void cleanUp() throws Exception {
        RuntimeEnv.INSTANCE.reset();
        this.catalog_.close();
    }

    public void tearDown() {
        this.clearTestTables();
        this.clearTestDbs();
    }

    public Frontend frontend() {
        return this.frontend_;
    }

    public ImpaladTestCatalog catalog() {
        return this.catalog_;
    }

    public AnalysisSessionFixture session() {
        return this.defaultSession_;
    }

    public Db addTestDb(String dbName, String comment) {
        Db db = this.catalog_.getDb(dbName);
        Preconditions.checkState((db == null ? 1 : 0) != 0, (Object)"Test db must not already exist.");
        db = new Db(dbName, new Database(dbName, comment, "", Collections.emptyMap()));
        this.catalog_.addDb(db);
        this.testDbs_.add(db);
        return db;
    }

    protected void clearTestDbs() {
        for (Db testDb : this.testDbs_) {
            this.catalog_.removeDb(testDb.getName());
        }
    }

    public Table addTestTable(String createTableSql) {
        CreateTableStmt createTableStmt = (CreateTableStmt)this.analyzeStmt(createTableSql);
        Db db = this.catalog_.getDb(createTableStmt.getDb());
        Preconditions.checkNotNull((Object)db, (Object)"Test tables must be created in an existing db.");
        org.apache.hadoop.hive.metastore.api.Table msTbl = CatalogOpExecutor.createMetaStoreTable((TCreateTableParams)createTableStmt.toThrift());
        Table dummyTable = Table.fromMetastoreTable((Db)db, (org.apache.hadoop.hive.metastore.api.Table)msTbl);
        if (dummyTable instanceof HdfsTable) {
            ArrayList columnDefs = Lists.newArrayList((Iterable)createTableStmt.getPartitionColumnDefs());
            dummyTable.setNumClusteringCols(columnDefs.size());
            columnDefs.addAll(createTableStmt.getColumnDefs());
            for (int i = 0; i < columnDefs.size(); ++i) {
                ColumnDef colDef = (ColumnDef)columnDefs.get(i);
                dummyTable.addColumn(new Column(colDef.getColName(), colDef.getType(), colDef.getComment(), i));
            }
            try {
                HdfsTable hdfsTable = (HdfsTable)dummyTable;
                hdfsTable.initializePartitionMetadata(msTbl);
            }
            catch (CatalogException e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to add test table:\n" + createTableSql));
            }
        } else if (dummyTable instanceof KuduTable) {
            if (!Table.isExternalTable((org.apache.hadoop.hive.metastore.api.Table)msTbl)) {
                Assert.fail((String)("Failed to add table, external kudu table expected:\n" + createTableSql));
            }
            try {
                KuduTable kuduTable = (KuduTable)dummyTable;
                kuduTable.loadSchemaFromKudu((EventSequence)NoOpEventSequence.INSTANCE);
            }
            catch (ImpalaRuntimeException e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to add test table:\n" + createTableSql));
            }
        } else {
            Assert.fail((String)("Test table type not supported:\n" + createTableSql));
        }
        db.addTable(dummyTable);
        this.testTables_.add(dummyTable);
        return dummyTable;
    }

    protected void clearTestTables() {
        for (Table testTable : this.testTables_) {
            testTable.getDb().removeTable(testTable.getName());
        }
    }

    public Table addTestView(String createViewSql) {
        return this.addTestView((Catalog)this.catalog_, createViewSql);
    }

    public Table addTestView(Catalog catalog, String createViewSql) {
        CreateViewStmt createViewStmt = (CreateViewStmt)this.analyzeStmt(createViewSql);
        Db db = catalog.getDb(createViewStmt.getDb());
        Preconditions.checkNotNull((Object)db, (Object)"Test views must be created in an existing db.");
        QueryStmt viewStmt = (QueryStmt)this.parseStmt(createViewStmt.getInlineViewDef()).getTopLevelNode();
        View dummyView = View.createTestView((Db)db, (String)createViewStmt.getTbl(), (QueryStmt)viewStmt);
        db.addTable((Table)dummyView);
        this.testTables_.add((Table)dummyView);
        return dummyView;
    }

    public Function addTestFunction(String name, ArrayList<ScalarType> args, boolean varArgs) {
        return this.addTestFunction("default", name, args, varArgs);
    }

    public Function addTestFunction(String name, ScalarType arg, boolean varArgs) {
        return this.addTestFunction("default", name, Lists.newArrayList((Object[])new ScalarType[]{arg}), varArgs);
    }

    public Function addTestFunction(String db, String fnName, ArrayList<ScalarType> args, boolean varArgs) {
        ArrayList<ScalarType> argTypes = new ArrayList<ScalarType>();
        argTypes.addAll(args);
        ScalarFunction fn = ScalarFunction.createForTesting((String)db, (String)fnName, argTypes, (Type)Type.INT, (String)"/Foo", (String)"Foo.class", null, null, (TFunctionBinaryType)TFunctionBinaryType.NATIVE);
        fn.setHasVarArgs(varArgs);
        this.catalog_.addFunction((Function)fn);
        return fn;
    }

    public void addTestUda(String name, Type retType, Type ... argTypes) {
        FunctionName fnName = new FunctionName("default", name);
        this.catalog_.addFunction((Function)AggregateFunction.createForTesting((FunctionName)fnName, (List)Lists.newArrayList((Object[])argTypes), (Type)retType, (Type)retType, null, (String)"init_fn_symbol", (String)"update_fn_symbol", null, null, null, null, null, (TFunctionBinaryType)TFunctionBinaryType.NATIVE));
    }

    public AnalysisContext createAnalysisCtx() {
        return this.createAnalysisCtx("default");
    }

    public AnalysisContext createAnalysisCtx(String defaultDb) {
        TQueryCtx queryCtx = TestUtils.createQueryContext(defaultDb, System.getProperty("user.name"));
        EventSequence timeline = new EventSequence("Frontend Test Timeline");
        AnalysisContext analysisCtx = new AnalysisContext(queryCtx, (AuthorizationFactory)new NoopAuthorizationFactory(), timeline);
        return analysisCtx;
    }

    public AnalysisContext createAnalysisCtx(TQueryOptions queryOptions) {
        return this.createAnalysisCtx(queryOptions, (AuthorizationFactory)new NoopAuthorizationFactory());
    }

    public AnalysisContext createAnalysisCtx(TQueryOptions queryOptions, AuthorizationFactory authzFactory) {
        TQueryCtx queryCtx = TestUtils.createQueryContext();
        queryCtx.client_request.query_options = queryOptions;
        EventSequence timeline = new EventSequence("Frontend Test Timeline");
        AnalysisContext analysisCtx = new AnalysisContext(queryCtx, authzFactory, timeline);
        return analysisCtx;
    }

    public AnalysisContext createAnalysisCtx(TQueryOptions queryOptions, AuthorizationFactory authzFactory, String user) {
        TQueryCtx queryCtx = TestUtils.createQueryContext("default", user);
        queryCtx.client_request.query_options = queryOptions;
        EventSequence timeline = new EventSequence("Frontend Test Timeline");
        AnalysisContext analysisCtx = new AnalysisContext(queryCtx, authzFactory, timeline);
        return analysisCtx;
    }

    public AnalysisContext createAnalysisCtx(AuthorizationFactory authzFactory) {
        return this.createAnalysisCtx(authzFactory, System.getProperty("user.name"));
    }

    public AnalysisContext createAnalysisCtx(AuthorizationFactory authzFactory, String user) {
        TQueryCtx queryCtx = TestUtils.createQueryContext("default", user);
        EventSequence timeline = new EventSequence("Frontend Test Timeline");
        AnalysisContext analysisCtx = new AnalysisContext(queryCtx, authzFactory, timeline);
        return analysisCtx;
    }

    public ParsedStatement parseStmt(String stmt) {
        try {
            ParsedStatementImpl parsedStmt = new ParsedStatementImpl(stmt);
            Assert.assertNotNull((Object)parsedStmt.getTopLevelNode());
            return parsedStmt;
        }
        catch (ImpalaException e) {
            Assert.fail((String)("Parser error:\n" + e.getMessage()));
            throw new IllegalStateException();
        }
    }

    public AnalysisContext.AnalysisResult parseAndAnalyze(String stmt, AnalysisContext ctx) throws ImpalaException {
        User user;
        StmtMetadataLoader mdLoader;
        StmtMetadataLoader.StmtTableCache stmtTableCache;
        CompilerFactoryImpl compilerFactory = new CompilerFactoryImpl();
        ParsedStatementImpl parsedStmt = new ParsedStatementImpl(stmt, ctx.getQueryOptions());
        AnalysisContext.AnalysisResult analysisResult = ctx.analyzeAndAuthorize((CompilerFactory)compilerFactory, (ParsedStatement)parsedStmt, stmtTableCache = (mdLoader = new StmtMetadataLoader(this.frontend_, ctx.getQueryCtx().session.database, null, user = new User(TSessionStateUtil.getEffectiveUser((TSessionState)ctx.getQueryCtx().session)), null)).loadTables((ParsedStatement)parsedStmt), this.frontend_.getAuthzChecker());
        Preconditions.checkState((analysisResult.getException() == null ? 1 : 0) != 0);
        return analysisResult;
    }

    public ParseNode analyzeStmt(String stmt, AnalysisContext ctx, String expectedWarning, boolean assertNoWarnings) {
        try {
            AnalysisContext.AnalysisResult analysisResult = this.parseAndAnalyze(stmt, ctx);
            List actualWarnings = analysisResult.getAnalyzer().getWarnings();
            if (expectedWarning != null) {
                boolean matchedWarning = false;
                for (String actualWarning : actualWarnings) {
                    if (!actualWarning.startsWith(expectedWarning)) continue;
                    matchedWarning = true;
                    break;
                }
                if (!matchedWarning) {
                    Assert.fail((String)String.format("Did not produce expected warning.\nExpected warning:\n%s.\nActual warnings:\n%s\nsql:\n%s", expectedWarning, Joiner.on((String)"\n").join((Iterable)actualWarnings), stmt));
                }
            } else if (assertNoWarnings && !actualWarnings.isEmpty()) {
                Assert.fail((String)String.format("Should not produce any warnings. Got:\n%s\nsql:\n%s", Joiner.on((String)"\n").join((Iterable)actualWarnings), stmt));
            }
            Preconditions.checkNotNull((Object)analysisResult.getStmt());
            return analysisResult.getStmt();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error during analysis:\n" + e.toString() + "\nsql:\n" + stmt));
            throw new IllegalStateException();
        }
    }

    public ParseNode analyzeStmt(String stmt) {
        return this.analyzeStmt(stmt, this.createAnalysisCtx(), null, false);
    }

    static {
        try {
            instance_ = new FrontendFixture();
        }
        catch (ImpalaException e) {
            throw new RuntimeException(e);
        }
    }
}

