/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.paimon;

import java.util.Arrays;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.MapType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.paimon.ImpalaTypeUtils;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarCharType;
import org.junit.Assert;
import org.junit.Test;

public class ImpalaTypeUtilsTest {
    private static void assertThrowUnexpected(ConvFunc convFunc) {
        try {
            convFunc.convertFun();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testToImpalaType() {
        Assert.assertEquals((Object)Type.BOOLEAN, (Object)ImpalaTypeUtils.toImpalaType((DataType)new BooleanType()));
        Assert.assertEquals((Object)Type.TINYINT, (Object)ImpalaTypeUtils.toImpalaType((DataType)new TinyIntType()));
        Assert.assertEquals((Object)Type.SMALLINT, (Object)ImpalaTypeUtils.toImpalaType((DataType)new SmallIntType()));
        Assert.assertEquals((Object)Type.INT, (Object)ImpalaTypeUtils.toImpalaType((DataType)new IntType()));
        Assert.assertEquals((Object)Type.BIGINT, (Object)ImpalaTypeUtils.toImpalaType((DataType)new BigIntType()));
        Assert.assertEquals((Object)Type.FLOAT, (Object)ImpalaTypeUtils.toImpalaType((DataType)new FloatType()));
        Assert.assertEquals((Object)Type.DOUBLE, (Object)ImpalaTypeUtils.toImpalaType((DataType)new DoubleType()));
        Assert.assertEquals((Object)Type.DATE, (Object)ImpalaTypeUtils.toImpalaType((DataType)DataTypes.DATE()));
        Assert.assertEquals((Object)Type.TIMESTAMP, (Object)ImpalaTypeUtils.toImpalaType((DataType)new TimestampType()));
        DecimalType decimalType = new DecimalType(10, 2);
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)10, (int)2), (Object)ImpalaTypeUtils.toImpalaType((DataType)decimalType));
        Assert.assertEquals((Object)ScalarType.createCharType((int)10), (Object)ImpalaTypeUtils.toImpalaType((DataType)new CharType(10)));
        Assert.assertEquals((Object)ScalarType.createVarcharType((int)10), (Object)ImpalaTypeUtils.toImpalaType((DataType)new VarCharType(10)));
        Assert.assertEquals((Object)Type.STRING, (Object)ImpalaTypeUtils.toImpalaType((DataType)new CharType(256)));
        Assert.assertEquals((Object)Type.STRING, (Object)ImpalaTypeUtils.toImpalaType((DataType)new VarCharType(65536)));
        org.apache.paimon.types.ArrayType arrayType = new org.apache.paimon.types.ArrayType((DataType)new IntType());
        Assert.assertEquals((Object)new ArrayType((Type)Type.INT), (Object)ImpalaTypeUtils.toImpalaType((DataType)arrayType));
        org.apache.paimon.types.MapType mapType = new org.apache.paimon.types.MapType((DataType)new IntType(), (DataType)DataTypes.STRING());
        Assert.assertEquals((Object)new MapType((Type)Type.INT, (Type)Type.STRING), (Object)ImpalaTypeUtils.toImpalaType((DataType)mapType));
        RowType rowType = new RowType(Arrays.asList(new DataField(0, "id", (DataType)new IntType()), new DataField(1, "name", (DataType)DataTypes.STRING())));
        StructType expectedStructType = new StructType(Arrays.asList(new StructField("id", (Type)Type.INT), new StructField("name", (Type)Type.STRING)));
        Assert.assertEquals((Object)expectedStructType, (Object)ImpalaTypeUtils.toImpalaType((DataType)rowType));
        ImpalaTypeUtilsTest.assertThrowUnexpected(() -> ImpalaTypeUtils.toImpalaType((DataType)DataTypes.TIME()));
        ImpalaTypeUtilsTest.assertThrowUnexpected(() -> ImpalaTypeUtils.toImpalaType((DataType)DataTypes.MULTISET((DataType)DataTypes.INT())));
        ImpalaTypeUtilsTest.assertThrowUnexpected(() -> ImpalaTypeUtils.toImpalaType((DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE()));
    }

    @Test
    public void testFromImpalaType() {
        Assert.assertEquals((Object)DataTypes.BOOLEAN(), (Object)ImpalaTypeUtils.fromImpalaType((Type)Type.BOOLEAN));
        Assert.assertEquals((Object)DataTypes.TINYINT(), (Object)ImpalaTypeUtils.fromImpalaType((Type)Type.TINYINT));
        Assert.assertEquals((Object)DataTypes.SMALLINT(), (Object)ImpalaTypeUtils.fromImpalaType((Type)Type.SMALLINT));
        Assert.assertEquals((Object)DataTypes.INT(), (Object)ImpalaTypeUtils.fromImpalaType((Type)Type.INT));
        Assert.assertEquals((Object)DataTypes.BIGINT(), (Object)ImpalaTypeUtils.fromImpalaType((Type)Type.BIGINT));
        Assert.assertEquals((Object)DataTypes.FLOAT(), (Object)ImpalaTypeUtils.fromImpalaType((Type)Type.FLOAT));
        Assert.assertEquals((Object)DataTypes.DOUBLE(), (Object)ImpalaTypeUtils.fromImpalaType((Type)Type.DOUBLE));
        Assert.assertEquals((Object)DataTypes.DATE(), (Object)ImpalaTypeUtils.fromImpalaType((Type)Type.DATE));
        Assert.assertEquals((Object)DataTypes.TIMESTAMP(), (Object)ImpalaTypeUtils.fromImpalaType((Type)Type.TIMESTAMP));
        ScalarType decimalType = ScalarType.createDecimalType((int)10, (int)2);
        Assert.assertEquals((Object)DataTypes.DECIMAL((int)10, (int)2), (Object)ImpalaTypeUtils.fromImpalaType((Type)decimalType));
        Assert.assertEquals((Object)DataTypes.CHAR((int)10), (Object)ImpalaTypeUtils.fromImpalaType((Type)ScalarType.createCharType((int)10)));
        Assert.assertEquals((Object)DataTypes.VARCHAR((int)255), (Object)ImpalaTypeUtils.fromImpalaType((Type)ScalarType.createVarcharType((int)255)));
        ArrayType arrayType = new ArrayType((Type)Type.INT);
        Assert.assertEquals((Object)DataTypes.ARRAY((DataType)DataTypes.INT()), (Object)ImpalaTypeUtils.fromImpalaType((Type)arrayType));
        MapType mapType = new MapType((Type)Type.INT, (Type)Type.STRING);
        Assert.assertEquals((Object)DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING()), (Object)ImpalaTypeUtils.fromImpalaType((Type)mapType));
        StructType structType = new StructType(Arrays.asList(new StructField("id", (Type)Type.INT), new StructField("name", (Type)Type.STRING)));
        RowType expectedRowType = RowType.of((DataField[])new DataField[]{new DataField(0, "id", (DataType)DataTypes.INT()), new DataField(1, "name", (DataType)DataTypes.STRING())});
        Assert.assertEquals((Object)expectedRowType, (Object)ImpalaTypeUtils.fromImpalaType((Type)structType));
        ImpalaTypeUtilsTest.assertThrowUnexpected(() -> ImpalaTypeUtils.fromImpalaType((Type)Type.DATETIME));
        ImpalaTypeUtilsTest.assertThrowUnexpected(() -> ImpalaTypeUtils.fromImpalaType((Type)Type.NULL));
        ImpalaTypeUtilsTest.assertThrowUnexpected(() -> ImpalaTypeUtils.fromImpalaType((Type)Type.INVALID));
        ImpalaTypeUtilsTest.assertThrowUnexpected(() -> ImpalaTypeUtils.fromImpalaType((Type)Type.FIXED_UDA_INTERMEDIATE));
    }

    private static interface ConvFunc {
        public void convertFun();
    }
}

