/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.monitor;

import java.util.List;
import org.apache.impala.catalog.monitor.CatalogFinalizeDmlCounter;
import org.apache.impala.thrift.TCatalogServiceRequestHeader;
import org.apache.impala.thrift.TOperationUsageCounter;
import org.apache.impala.thrift.TUpdateCatalogRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CatalogFinalizeDmlCounterTest {
    private CatalogFinalizeDmlCounter catalogFinalizeDmlCounter;
    private final String TEST_UPDATE_SQL = "UPDATE table SET c3 = 'test';";
    private final String TEST_CTAS_SQL = "CREATE TABLE test AS SELECT * FROM t;";
    private final String TEST_INSERT_SQL = "insert into table text_table select * from tab1;";
    private static final String TEST_DML_SQL = "load data inpath 'test.txt' into table t1;";
    private final String TEST_DB_NAME = "TEST";
    private final String TEST_TABLE_NAME = "TABLE";
    private final TUpdateCatalogRequest testUpdateRequest = this.createTestTUpdateCatalogRequest("TEST", "TABLE", "UPDATE table SET c3 = 'test';");

    @Before
    public void setUp() {
        this.catalogFinalizeDmlCounter = new CatalogFinalizeDmlCounter();
    }

    @Test
    public void testIncrementOperationIncrementsCounter() {
        this.catalogFinalizeDmlCounter.incrementOperation(this.testUpdateRequest);
        TOperationUsageCounter tOperationUsageCounter = (TOperationUsageCounter)this.catalogFinalizeDmlCounter.getOperationUsage().get(0);
        Assert.assertEquals((Object)CatalogFinalizeDmlCounter.FinalizeDmlType.FINALIZE_UPDATE.name(), (Object)tOperationUsageCounter.catalog_op_name);
        Assert.assertEquals((long)1L, (long)tOperationUsageCounter.op_counter);
        Assert.assertEquals((Object)"TEST.TABLE", (Object)tOperationUsageCounter.table_name);
    }

    @Test
    public void testDecrementOperationDecrementsCounter() {
        this.catalogFinalizeDmlCounter.incrementOperation(this.testUpdateRequest);
        this.catalogFinalizeDmlCounter.decrementOperation(this.testUpdateRequest);
        List counterList = this.catalogFinalizeDmlCounter.getOperationUsage();
        Assert.assertEquals((long)0L, (long)counterList.size());
    }

    @Test
    public void testIncrementOperationInfersCTAS() {
        TUpdateCatalogRequest testCTASRequest = this.createTestTUpdateCatalogRequest("TEST", "TABLE", "CREATE TABLE test AS SELECT * FROM t;");
        this.catalogFinalizeDmlCounter.incrementOperation(testCTASRequest);
        TOperationUsageCounter operationUsageCounter = (TOperationUsageCounter)this.catalogFinalizeDmlCounter.getOperationUsage().get(0);
        Assert.assertEquals((Object)CatalogFinalizeDmlCounter.FinalizeDmlType.FINALIZE_CREATE_TABLE_AS_SELECT.name(), (Object)operationUsageCounter.catalog_op_name);
    }

    @Test
    public void testIncrementOperationInfersInsertInto() {
        TUpdateCatalogRequest testInsertRequest = this.createTestTUpdateCatalogRequest("TEST", "TABLE", "insert into table text_table select * from tab1;");
        this.catalogFinalizeDmlCounter.incrementOperation(testInsertRequest);
        TOperationUsageCounter operationUsageCounter = (TOperationUsageCounter)this.catalogFinalizeDmlCounter.getOperationUsage().get(0);
        Assert.assertEquals((Object)CatalogFinalizeDmlCounter.FinalizeDmlType.FINALIZE_INSERT_INTO.name(), (Object)operationUsageCounter.catalog_op_name);
    }

    @Test
    public void testIncrementOperationInfersDml() {
        TUpdateCatalogRequest testDmlRequest = this.createTestTUpdateCatalogRequest("TEST", "TABLE", TEST_DML_SQL);
        this.catalogFinalizeDmlCounter.incrementOperation(testDmlRequest);
        TOperationUsageCounter operationUsageCounter = (TOperationUsageCounter)this.catalogFinalizeDmlCounter.getOperationUsage().get(0);
        Assert.assertEquals((Object)CatalogFinalizeDmlCounter.FinalizeDmlType.FINALIZE_DML.name(), (Object)operationUsageCounter.catalog_op_name);
    }

    @Test
    public void testGetOperationUsageReturnsMultipleDMLs() {
        TUpdateCatalogRequest testCTASRequest = this.createTestTUpdateCatalogRequest("TEST", "TABLE", "CREATE TABLE test AS SELECT * FROM t;");
        this.catalogFinalizeDmlCounter.incrementOperation(this.testUpdateRequest);
        this.catalogFinalizeDmlCounter.incrementOperation(testCTASRequest);
        List operationUsage = this.catalogFinalizeDmlCounter.getOperationUsage();
        Assert.assertEquals((long)2L, (long)operationUsage.size());
    }

    private TUpdateCatalogRequest createTestTUpdateCatalogRequest(String dBName, String tableName, String redacted_sql_stmt) {
        TUpdateCatalogRequest tUpdateCatalogRequest = new TUpdateCatalogRequest();
        tUpdateCatalogRequest.setDb_name(dBName);
        tUpdateCatalogRequest.setTarget_table(tableName);
        tUpdateCatalogRequest.setHeader(new TCatalogServiceRequestHeader());
        tUpdateCatalogRequest.getHeader().setRedacted_sql_stmt(redacted_sql_stmt);
        return tUpdateCatalogRequest;
    }
}

