/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.monitor;

import java.util.List;
import java.util.Optional;
import org.apache.impala.catalog.monitor.CatalogDdlCounter;
import org.apache.impala.thrift.TDdlType;
import org.apache.impala.thrift.TOperationUsageCounter;
import org.apache.impala.thrift.TTableName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CatalogDdlCounterTest {
    private CatalogDdlCounter catalogDdlCounter;
    private final TDdlType TEST_DDL_CREATE = TDdlType.CREATE_TABLE;
    private final TDdlType TEST_DDL_DROP = TDdlType.DROP_TABLE;
    private final String TEST_DB_NAME = "TEST";
    private final String TEST_TABLE_NAME = "TABLE";
    private final Optional<TTableName> TEST_TTABLENAME = Optional.of(new TTableName("TEST", "TABLE"));

    @Before
    public void setUp() {
        this.catalogDdlCounter = new CatalogDdlCounter();
    }

    @Test
    public void testIncrementOperationIncrementsCounter() {
        this.catalogDdlCounter.incrementOperation(this.TEST_DDL_CREATE, this.TEST_TTABLENAME);
        TOperationUsageCounter operationUsageCounter = (TOperationUsageCounter)this.catalogDdlCounter.getOperationUsage().get(0);
        Assert.assertEquals((Object)this.TEST_DDL_CREATE.name(), (Object)operationUsageCounter.catalog_op_name);
        Assert.assertEquals((long)1L, (long)operationUsageCounter.op_counter);
        Assert.assertEquals((Object)"TEST.TABLE", (Object)operationUsageCounter.table_name);
    }

    @Test
    public void testDecrementOperationDecrementsCounter() {
        this.catalogDdlCounter.incrementOperation(this.TEST_DDL_CREATE, this.TEST_TTABLENAME);
        this.catalogDdlCounter.decrementOperation(this.TEST_DDL_CREATE, this.TEST_TTABLENAME);
        List operationUsage = this.catalogDdlCounter.getOperationUsage();
        Assert.assertEquals((long)0L, (long)operationUsage.size());
    }

    @Test
    public void testGetOperationUsageReturnsListOfCounters() {
        this.catalogDdlCounter.incrementOperation(this.TEST_DDL_CREATE, this.TEST_TTABLENAME);
        this.catalogDdlCounter.incrementOperation(this.TEST_DDL_DROP, this.TEST_TTABLENAME);
        List operationUsage = this.catalogDdlCounter.getOperationUsage();
        Assert.assertEquals((long)2L, (long)operationUsage.size());
    }
}

