/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.metastore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesResult;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.metastore.AbstractCatalogMetastoreTest;
import org.apache.impala.catalog.metastore.CatalogHmsClientUtils;
import org.apache.impala.catalog.metastore.CatalogHmsFileMetadataTest;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.util.ListMap;
import org.junit.Assert;
import org.junit.Test;

public class EnableCatalogdHmsCacheFlagTest
extends AbstractCatalogMetastoreTest {
    @Test
    public void testEnableCatalogdCachingFlag() throws Exception {
        BackendConfig.INSTANCE.setEnableCatalogdHMSCache(true);
        HdfsTable tbl = (HdfsTable)catalog_.getOrLoadTable("functional", "alltypes", "test", null);
        HdfsPartition hdfsPartition1 = (HdfsPartition)tbl.getPartitionsForNames(Arrays.asList("year=2009/month=1")).get(0);
        HdfsPartition hdfsPartition2 = (HdfsPartition)tbl.getPartitionsForNames(Arrays.asList("year=2009/month=2")).get(0);
        BackendConfig.INSTANCE.setEnableCatalogdHMSCache(false);
        GetPartitionsByNamesRequest request = new GetPartitionsByNamesRequest();
        String dbName = MetaStoreUtils.prependCatalogToDbName((String)"functional", (Configuration)CONF);
        request.setDb_name(dbName);
        request.setTbl_name("alltypes");
        request.setNames(new ArrayList());
        request.setGetFileMetadata(true);
        GetPartitionsByNamesResult result = catalogHmsClient_.getPartitionsByNames(request);
        Assert.assertTrue((boolean)result.getPartitions().isEmpty());
        Map fds = CatalogHmsClientUtils.extractFileDescriptors((GetPartitionsByNamesResult)result, (ListMap)tbl.getHostIndex());
        Assert.assertTrue((boolean)fds.isEmpty());
        request = new GetPartitionsByNamesRequest();
        dbName = MetaStoreUtils.prependCatalogToDbName((String)"functional", (Configuration)CONF);
        request.setDb_name(dbName);
        request.setTbl_name("alltypes");
        request.setNames(Arrays.asList("year=2009/month=1", "year=2009/month=2"));
        request.setGetFileMetadata(true);
        result = catalogHmsClient_.getPartitionsByNames(request);
        EnableCatalogdHmsCacheFlagTest.sortPartitionsByNames(tbl.getMetaStoreTable().getPartitionKeys(), result.getPartitions());
        for (Partition part : result.getPartitions()) {
            Assert.assertNotNull((Object)part.getFileMetadata());
        }
        Assert.assertNotNull((Object)result.getDictionary());
        fds = CatalogHmsClientUtils.extractFileDescriptors((GetPartitionsByNamesResult)result, (ListMap)tbl.getHostIndex());
        Assert.assertEquals((long)2L, (long)fds.size());
        for (List partFds : fds.values()) {
            Assert.assertFalse((boolean)partFds.isEmpty());
            Assert.assertEquals((long)1L, (long)partFds.size());
        }
        CatalogHmsFileMetadataTest.assertFdsAreSame(hdfsPartition1.getFileDescriptors(), (List)fds.get(result.getPartitions().get(0)));
        CatalogHmsFileMetadataTest.assertFdsAreSame(hdfsPartition2.getFileDescriptors(), (List)fds.get(result.getPartitions().get(1)));
    }
}

