/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.metastore;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.IncompleteTable;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.MetastoreApiTestUtils;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.events.ExternalEventsProcessor;
import org.apache.impala.catalog.events.NoOpEventProcessor;
import org.apache.impala.catalog.events.SynchronousHMSEventProcessorForTests;
import org.apache.impala.catalog.metastore.AbstractCatalogMetastoreTest;
import org.apache.impala.catalog.metastore.CatalogMetastoreServer;
import org.apache.impala.catalog.metastore.ICatalogMetastoreServer;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.CatalogOpExecutor;
import org.apache.impala.service.MetadataOp;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.apache.impala.testutil.CatalogTestMetastoreServer;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class CatalogHmsSyncToLatestEventIdTest
extends AbstractCatalogMetastoreTest {
    private static String TEST_DB_NAME = "sync_to_latest_events_test_db";
    private static Logger LOG = LoggerFactory.getLogger(CatalogHmsSyncToLatestEventIdTest.class);
    protected static CatalogServiceTestCatalog catalog_;
    protected static CatalogOpExecutor catalogOpExecutor_;
    protected static CatalogMetastoreServer catalogMetastoreServer_;
    protected static HiveMetaStoreClient catalogHmsClient_;
    private static SynchronousHMSEventProcessorForTests eventsProcessor_;
    protected static final Configuration CONF;
    private String tableType_;
    private static String managedTableType;
    private static String externalTableType;
    private static boolean flagEnableCatalogCache;
    private static boolean flagInvalidateCache;
    private static boolean flagSyncToLatestEventId;

    @BeforeClass
    public static void setup() throws Exception {
        catalog_ = CatalogServiceTestCatalog.create();
        catalogOpExecutor_ = catalog_.getCatalogOpExecutor();
        catalogMetastoreServer_ = new CatalogTestMetastoreServer(catalogOpExecutor_);
        catalog_.setCatalogMetastoreServer((ICatalogMetastoreServer)catalogMetastoreServer_);
        try (MetaStoreClientPool.MetaStoreClient metaStoreClient = catalog_.getMetaStoreClient();){
            CurrentNotificationEventId currentNotificationId = metaStoreClient.getHiveClient().getCurrentNotificationEventId();
            eventsProcessor_ = new SynchronousHMSEventProcessorForTests(catalogOpExecutor_, currentNotificationId.getEventId(), 10000L);
            eventsProcessor_.start();
        }
        catalogMetastoreServer_.start();
        MetastoreConf.setVar((Configuration)CONF, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://localhost:" + catalogMetastoreServer_.getPort()));
        CONF.set("hive.metastore.execute.setugi", "false");
        catalogHmsClient_ = new HiveMetaStoreClient(CONF);
        Assert.assertTrue((String)"Event processor should not be set", (boolean)(catalog_.getMetastoreEventProcessor() instanceof NoOpEventProcessor));
        flagEnableCatalogCache = BackendConfig.INSTANCE.enableCatalogdHMSCache();
        flagInvalidateCache = BackendConfig.INSTANCE.invalidateCatalogdHMSCacheOnDDLs();
        flagSyncToLatestEventId = BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls();
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        BackendConfig.INSTANCE.setEnableCatalogdHMSCache(flagEnableCatalogCache);
        BackendConfig.INSTANCE.setEnableSyncToLatestEventOnDdls(flagSyncToLatestEventId);
        BackendConfig.INSTANCE.setInvalidateCatalogdHMSCacheOnDDLs(flagInvalidateCache);
        if (eventsProcessor_ != null) {
            eventsProcessor_.shutdown();
        }
        catalogMetastoreServer_.stop();
        catalog_.close();
    }

    @After
    public void afterTest() throws TException, CatalogException {
        String dbName = TEST_DB_NAME;
        try {
            try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
                msClient.getHiveClient().dropDatabase(dbName, true, true, true);
            }
            catalog_.removeDb(dbName);
        }
        catch (NoSuchObjectException e) {
            LOG.error("database {} does not exist in catalogd", (Object)dbName);
            catalog_.removeDb(dbName);
        }
    }

    @Before
    public void beforeTest() throws Exception {
        BackendConfig.INSTANCE.setEnableCatalogdHMSCache(true);
        BackendConfig.INSTANCE.setEnableSyncToLatestEventOnDdls(true);
        BackendConfig.INSTANCE.setInvalidateCatalogdHMSCacheOnDDLs(false);
    }

    public CatalogHmsSyncToLatestEventIdTest(String tableType) {
        this.tableType_ = tableType;
    }

    @Parameterized.Parameters
    public static String[] createTableTypes() {
        return new String[]{managedTableType, externalTableType};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateDatabase() throws Exception {
        LOG.info("Executing testCreateDatabase");
        String dbName = "test_create_database";
        try {
            Database msDb = MetastoreApiTestUtils.createHmsDatabaseObject(null, dbName, null);
            catalogHmsClient_.createDatabase(msDb);
            Db db = catalog_.getDb(dbName);
            Assert.assertTrue((db != null ? 1 : 0) != 0);
            Assert.assertTrue((db.getLastSyncedEventId() != -1L ? 1 : 0) != 0);
            Assert.assertTrue((db.getLastSyncedEventId() == db.getCreateEventId() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            catalogHmsClient_.dropDatabase(dbName, true, true, true);
            Assert.assertTrue((String)("db " + dbName + " should not be present in catalogd"), (catalog_.getDb(dbName) == null ? 1 : 0) != 0);
            throw throwable;
        }
        catalogHmsClient_.dropDatabase(dbName, true, true, true);
        Assert.assertTrue((String)("db " + dbName + " should not be present in catalogd"), (catalog_.getDb(dbName) == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlterDatabase() throws Exception {
        LOG.info("Executing testAlterDatabase");
        String dbName = "test_alter_database";
        try {
            this.createDatabaseInCatalog(dbName);
            eventsProcessor_.processEvents();
            long lastSkippedEventsCount = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
            Db catalogDb = catalog_.getDb(dbName);
            long prevSyncedEventId = catalogDb.getLastSyncedEventId();
            try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
                MetastoreApiTestUtils.addDatabaseParametersInHms(msClient, dbName, "key1", "val1");
            }
            String newOwner = "new_owner";
            Database alteredMsDb = this.getDatabaseInHms(dbName);
            alteredMsDb.setOwnerName(newOwner);
            catalogHmsClient_.alterDatabase(dbName, alteredMsDb);
            catalogDb = catalog_.getDb(dbName);
            Assert.assertTrue((boolean)catalogDb.getOwnerUser().equals(newOwner));
            Assert.assertTrue((boolean)((String)catalogDb.getMetaStoreDb().getParameters().get("key1")).equals("val1"));
            Assert.assertTrue((catalogDb.getLastSyncedEventId() > prevSyncedEventId ? 1 : 0) != 0);
            eventsProcessor_.processEvents();
            long currentSkippedEventsCount = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
            Assert.assertTrue((lastSkippedEventsCount + 2L == currentSkippedEventsCount ? 1 : 0) != 0);
        }
        finally {
            catalogHmsClient_.dropDatabase(dbName, true, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddDropAlterPartitions() throws Exception {
        LOG.info("Executing testAddDropAlterPartitions");
        String tblName = "test_add_drop_alter_partitions_" + this.tableType_ + "_tbl";
        try {
            this.createDatabaseInCatalog(TEST_DB_NAME);
            try {
                catalogHmsClient_.dropTable(TEST_DB_NAME, tblName, true, true);
            }
            catch (Exception e) {
                LOG.error("Failed to drop table {} from HMS", (Object)tblName);
            }
            catalogHmsClient_.createTable(MetastoreApiTestUtils.getTestTable(null, TEST_DB_NAME, tblName, null, true, this.tableType_));
            HdfsTable tbl = this.getCatalogHdfsTable(TEST_DB_NAME, tblName);
            Assert.assertTrue((tbl != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"table's last synced id should not be -1", (tbl.getLastSyncedEventId() != -1L ? 1 : 0) != 0);
            Assert.assertTrue((tbl.getLastSyncedEventId() == tbl.getCreateEventId() ? 1 : 0) != 0);
            eventsProcessor_.processEvents();
            long lastSkippedCount = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
            long prevSyncedEventId = tbl.getLastSyncedEventId();
            ArrayList<List<String>> partVals = new ArrayList<List<String>>();
            partVals.add(Arrays.asList("1"));
            partVals.add(Arrays.asList("2"));
            partVals.add(Arrays.asList("3"));
            this.addPartitionsInHms(TEST_DB_NAME, tblName, partVals);
            Assert.assertTrue((tbl.getPartitions().size() == 0 ? 1 : 0) != 0);
            Partition partitionToAlter = this.getPartitionInHms(TEST_DB_NAME, tblName, Arrays.asList("2"));
            String newLocation = "/path/to/newLocation/";
            partitionToAlter.getSd().setLocation(newLocation);
            this.alterPartitionInHms(TEST_DB_NAME, tblName, partitionToAlter);
            catalogHmsClient_.dropPartition(TEST_DB_NAME, tblName, Arrays.asList("3"), true);
            tbl = this.getCatalogHdfsTable(TEST_DB_NAME, tblName);
            Assert.assertTrue((String)"Table should have 2 partitions after dropping 1 out of 3 partitions", (tbl.getPartitions().size() == 2 ? 1 : 0) != 0);
            FeFsPartition modifiedPartition = null;
            for (FeFsPartition part : tbl.loadAllPartitions()) {
                if (!part.getLocation().equals(newLocation)) continue;
                modifiedPartition = part;
                break;
            }
            Assert.assertTrue((modifiedPartition != null ? 1 : 0) != 0);
            Assert.assertTrue((tbl.getLastSyncedEventId() > prevSyncedEventId ? 1 : 0) != 0);
            eventsProcessor_.processEvents();
            long currentSkippedCount = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
            Assert.assertTrue((String)String.format("CurrentSkippedCount %s differs from lastSkippedCount + 3 %s", currentSkippedCount, lastSkippedCount), (currentSkippedCount == lastSkippedCount + 3L ? 1 : 0) != 0);
        }
        finally {
            catalogHmsClient_.dropTable(TEST_DB_NAME, tblName, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExchangePartition() throws Exception {
        Assume.assumeTrue((boolean)this.tableType_.equals(managedTableType));
        LOG.info("Executing testExchangePartition");
        String srcTblName = "test_exchange_partition_src_" + this.tableType_ + "_tbl";
        String destTblName = "test_exchange_partition_dest_" + this.tableType_ + "_tbl";
        try {
            this.createDatabaseInCatalog(TEST_DB_NAME);
            catalogHmsClient_.dropTable(TEST_DB_NAME, srcTblName, true, true);
            catalogHmsClient_.dropTable(TEST_DB_NAME, destTblName, true, true);
            org.apache.hadoop.hive.metastore.api.Table srcMsTable = MetastoreApiTestUtils.getTestTable(null, TEST_DB_NAME, srcTblName, null, true, managedTableType);
            catalogHmsClient_.createTable(srcMsTable);
            ArrayList<List<String>> srcPartVals = new ArrayList<List<String>>();
            srcPartVals.add(Arrays.asList("1"));
            srcPartVals.add(Arrays.asList("2"));
            srcPartVals.add(Arrays.asList("3"));
            this.addPartitionsInHms(TEST_DB_NAME, srcTblName, srcPartVals);
            Map<String, String> partitionSpec = this.getPartitionSpec(srcMsTable, Arrays.asList("1"));
            org.apache.hadoop.hive.metastore.api.Table destMsTable = MetastoreApiTestUtils.getTestTable(null, TEST_DB_NAME, destTblName, null, true, managedTableType);
            catalogHmsClient_.createTable(destMsTable);
            ArrayList<List<String>> destPartVals = new ArrayList<List<String>>();
            destPartVals.add(Arrays.asList("4"));
            this.addPartitionsInHms(TEST_DB_NAME, destTblName, destPartVals);
            long eventIdBeforeExchange = this.getLatestEventIdFromHMS();
            catalogHmsClient_.exchange_partition(partitionSpec, TEST_DB_NAME, srcTblName, TEST_DB_NAME, destTblName);
            HdfsTable srcCatalogTbl = this.getCatalogHdfsTable(TEST_DB_NAME, srcTblName);
            HdfsTable destCatalogTbl = this.getCatalogHdfsTable(TEST_DB_NAME, destTblName);
            Assert.assertTrue((srcCatalogTbl.getPartitions().size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((destCatalogTbl.getPartitions().size() == 2 ? 1 : 0) != 0);
            for (FeFsPartition srcPartition : srcCatalogTbl.loadAllPartitions()) {
                List partVals = srcPartition.getPartitionValuesAsStrings(false);
                Assert.assertFalse((boolean)partVals.equals(Arrays.asList("1")));
            }
            Assert.assertTrue((srcCatalogTbl.getLastSyncedEventId() > eventIdBeforeExchange ? 1 : 0) != 0);
            Assert.assertTrue((destCatalogTbl.getLastSyncedEventId() > eventIdBeforeExchange ? 1 : 0) != 0);
        }
        finally {
            catalogHmsClient_.dropTable(TEST_DB_NAME, srcTblName, true, true);
            catalogHmsClient_.dropTable(TEST_DB_NAME, destTblName, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableCreateDropCreate() throws Exception {
        LOG.info("Executing testTableCreateDropCreate");
        String tblName = "test_create_drop_create_" + this.tableType_ + "_tbl";
        String tblNameLowerCase = tblName.toLowerCase();
        try {
            this.createDatabaseInCatalog(TEST_DB_NAME);
            catalogHmsClient_.dropTable(TEST_DB_NAME, tblName, true, true);
            catalogHmsClient_.createTable(MetastoreApiTestUtils.getTestTable(null, TEST_DB_NAME, tblName, null, true, this.tableType_));
            HdfsTable tbl = (HdfsTable)catalog_.getTable(TEST_DB_NAME, tblNameLowerCase);
            Assert.assertTrue((boolean)tbl.isPartitioned());
            long prevCreateEventId = tbl.getLastSyncedEventId();
            try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
                msClient.getHiveClient().dropTable(TEST_DB_NAME, tblName, true, false);
            }
            catalogHmsClient_.createTable(MetastoreApiTestUtils.getTestTable(null, TEST_DB_NAME, tblName, null, false, this.tableType_));
            HdfsTable currentTbl = (HdfsTable)catalog_.getTable(TEST_DB_NAME, tblNameLowerCase);
            Assert.assertTrue((currentTbl.getLastSyncedEventId() != prevCreateEventId ? 1 : 0) != 0);
            Assert.assertTrue((!currentTbl.isPartitioned() ? 1 : 0) != 0);
        }
        finally {
            catalogHmsClient_.dropTable(TEST_DB_NAME, tblName, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlterTableNoRename() throws Exception {
        LOG.info("Executing testAlterTableNoRename");
        String tblName = "test_alter_table_" + this.tableType_ + "_tbl";
        try {
            this.createDatabaseInCatalog(TEST_DB_NAME);
            catalogHmsClient_.dropTable(TEST_DB_NAME, tblName, true, true);
            catalogHmsClient_.createTable(MetastoreApiTestUtils.getTestTable(null, TEST_DB_NAME, tblName, null, true, this.tableType_));
            HdfsTable tbl = this.getCatalogHdfsTable(TEST_DB_NAME, tblName);
            eventsProcessor_.processEvents();
            long lastSkippedEventsCount = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
            org.apache.hadoop.hive.metastore.api.Table newMsTable = tbl.getMetaStoreTable().deepCopy();
            ArrayList cols = Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("c1", "string", "c1 description")});
            StorageDescriptor updatedSd = newMsTable.getSd();
            updatedSd.setCols((List)cols);
            newMsTable.setSd(updatedSd);
            try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
                msClient.getHiveClient().alter_table_with_environmentContext(TEST_DB_NAME, tblName, newMsTable, null);
            }
            tbl = this.getCatalogHdfsTable(TEST_DB_NAME, tblName);
            long prevSyncedEventId = tbl.getLastSyncedEventId();
            StorageDescriptor oldSd = tbl.getMetaStoreTable().getSd();
            Assert.assertFalse((boolean)oldSd.equals(updatedSd));
            org.apache.hadoop.hive.metastore.api.Table latestMsTable = this.getHmsTable(TEST_DB_NAME, tblName);
            String newOwner = "newOwnerForTestAlterTable";
            latestMsTable.setOwner(newOwner);
            catalogHmsClient_.alter_table_with_environmentContext(TEST_DB_NAME, tblName, latestMsTable, null);
            HdfsTable updatedTbl = this.getCatalogHdfsTable(TEST_DB_NAME, tblName);
            Assert.assertTrue((boolean)updatedTbl.getOwnerUser().equals(newOwner));
            Assert.assertTrue((boolean)updatedTbl.getMetaStoreTable().getSd().equals(updatedSd));
            Assert.assertTrue((updatedTbl.getLastSyncedEventId() > prevSyncedEventId ? 1 : 0) != 0);
            eventsProcessor_.processEvents();
            long currentSkippedEventsCount = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
            Assert.assertTrue((lastSkippedEventsCount + 2L == currentSkippedEventsCount ? 1 : 0) != 0);
        }
        finally {
            catalogHmsClient_.dropTable(TEST_DB_NAME, tblName, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlterTableRename() throws Exception {
        LOG.info("Executing testALterTableRename");
        String tblName = ("test_alter_table_rename_" + this.tableType_ + "_tbl").toLowerCase();
        String newTblName = tblName + "_new";
        try {
            this.createDatabaseInCatalog(TEST_DB_NAME);
            catalogHmsClient_.dropTable(TEST_DB_NAME, tblName, true, true);
            catalogHmsClient_.dropTable(TEST_DB_NAME, newTblName, true, true);
            catalogHmsClient_.createTable(MetastoreApiTestUtils.getTestTable(null, TEST_DB_NAME, tblName, null, true, this.tableType_));
            HdfsTable oldTbl = this.getCatalogHdfsTable(TEST_DB_NAME, tblName);
            eventsProcessor_.processEvents();
            long lastSkippedEventsCount = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
            org.apache.hadoop.hive.metastore.api.Table newMsTable = oldTbl.getMetaStoreTable().deepCopy();
            newMsTable.setTableName(newTblName);
            catalogHmsClient_.alter_table_with_environmentContext(TEST_DB_NAME, tblName, newMsTable, null);
            Assert.assertTrue((catalog_.getTableNoThrow(TEST_DB_NAME, tblName) == null ? 1 : 0) != 0);
            HdfsTable newTbl = this.getCatalogHdfsTable(TEST_DB_NAME, newTblName);
            Assert.assertTrue((newTbl != null ? 1 : 0) != 0);
            Assert.assertTrue((newTbl.getLastSyncedEventId() > -1L ? 1 : 0) != 0);
            eventsProcessor_.processEvents();
            long currentSkippedEventsCount = eventsProcessor_.getMetrics().getCounter("events-skipped").getCount();
            Assert.assertTrue((lastSkippedEventsCount + 1L == currentSkippedEventsCount ? 1 : 0) != 0);
        }
        finally {
            catalogHmsClient_.dropTable(TEST_DB_NAME, tblName, true, true);
            catalogHmsClient_.dropTable(TEST_DB_NAME, newTblName, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSyncToLatestEventIdFlag() throws Exception {
        String tblName = "test_sync_to_latest_event_id_flag_" + this.tableType_ + "_tbl";
        LOG.info("Executing testSyncToLatestEventIdFlag");
        boolean prevFlag = BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls();
        try {
            this.createDatabaseInCatalog(TEST_DB_NAME);
            catalogHmsClient_.dropTable(TEST_DB_NAME, tblName, true, true);
            catalogHmsClient_.createTable(MetastoreApiTestUtils.getTestTable(null, TEST_DB_NAME, tblName, null, true, this.tableType_));
            HdfsTable tbl = this.getCatalogHdfsTable(TEST_DB_NAME, tblName);
            long lastSyncedEventId = tbl.getLastSyncedEventId();
            BackendConfig.INSTANCE.setEnableSyncToLatestEventOnDdls(false);
            ArrayList<List<String>> partVals = new ArrayList<List<String>>();
            partVals.add(Arrays.asList("1"));
            partVals.add(Arrays.asList("2"));
            partVals.add(Arrays.asList("3"));
            this.addPartitionsInHms(TEST_DB_NAME, tblName, partVals);
            catalogHmsClient_.dropPartition(TEST_DB_NAME, tblName, Arrays.asList("3"), true);
            tbl = this.getCatalogHdfsTable(TEST_DB_NAME, tblName);
            Assert.assertTrue((lastSyncedEventId == tbl.getLastSyncedEventId() ? 1 : 0) != 0);
        }
        finally {
            BackendConfig.INSTANCE.setEnableSyncToLatestEventOnDdls(prevFlag);
            catalogHmsClient_.dropTable(TEST_DB_NAME, tblName, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFullTableReload() throws Exception {
        LOG.info("Executing testFullTableReload");
        String tblName = "full_table_reload_test_" + this.tableType_ + "_tbl";
        try {
            this.createDatabaseInCatalog(TEST_DB_NAME);
            catalogHmsClient_.dropTable(TEST_DB_NAME, tblName, true, true);
            this.createTableInHms(TEST_DB_NAME, tblName, true);
            IncompleteTable tbl = IncompleteTable.createUninitializedTable((Db)catalog_.getDb(TEST_DB_NAME), (String)tblName, (TImpalaTableType)MetadataOp.getImpalaTableType((String)this.tableType_), null, (long)this.getLatestEventIdFromHMS());
            catalog_.addTable(catalog_.getDb(TEST_DB_NAME), (Table)tbl);
            long prevLastSyncedEventId = catalog_.getTable(TEST_DB_NAME, tblName).getLastSyncedEventId();
            ArrayList<List<String>> partVals = new ArrayList<List<String>>();
            partVals.add(Arrays.asList("1"));
            partVals.add(Arrays.asList("2"));
            partVals.add(Arrays.asList("3"));
            this.addPartitionsInHms(TEST_DB_NAME, tblName, partVals);
            Table refreshedTbl = catalog_.getOrLoadTable(TEST_DB_NAME, tblName, "testing table syncing to latest event id", null);
            Assert.assertTrue((refreshedTbl.getLastSyncedEventId() > refreshedTbl.getCreateEventId() ? 1 : 0) != 0);
            Assert.assertTrue((refreshedTbl.getLastSyncedEventId() > prevLastSyncedEventId ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(refreshedTbl instanceof HdfsTable));
            HdfsTable hdfsTable = (HdfsTable)refreshedTbl;
            Assert.assertTrue((hdfsTable.getPartitions().size() == 3 ? 1 : 0) != 0);
        }
        finally {
            catalogHmsClient_.dropTable(TEST_DB_NAME, tblName, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableEventsProcessedByEventProcessor() throws Exception {
        LOG.info("Executing testEventsProcessedByEventProcessor");
        String tblName = "test_table_events_processed_by_event_processor_" + this.tableType_ + "_tbl";
        ExternalEventsProcessor prevEventProcessor = catalog_.getMetastoreEventProcessor();
        try {
            catalog_.setMetastoreEventProcessor((ExternalEventsProcessor)eventsProcessor_);
            eventsProcessor_.processEvents();
            this.createDatabaseInCatalog(TEST_DB_NAME);
            catalogHmsClient_.dropTable(TEST_DB_NAME, tblName, true, true);
            catalogHmsClient_.createTable(MetastoreApiTestUtils.getTestTable(null, TEST_DB_NAME, tblName, null, true, this.tableType_));
            HdfsTable tbl = this.getCatalogHdfsTable(TEST_DB_NAME, tblName);
            Assert.assertTrue((tbl != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"table's last synced id should not be -1", (tbl.getLastSyncedEventId() != -1L ? 1 : 0) != 0);
            Assert.assertTrue((tbl.getLastSyncedEventId() == tbl.getCreateEventId() ? 1 : 0) != 0);
            long prevSyncedEventId = tbl.getLastSyncedEventId();
            eventsProcessor_.processEvents();
            ArrayList<List<String>> partVals = new ArrayList<List<String>>();
            partVals.add(Arrays.asList("1"));
            partVals.add(Arrays.asList("2"));
            partVals.add(Arrays.asList("3"));
            this.addPartitionsInHms(TEST_DB_NAME, tblName, partVals);
            Assert.assertTrue((tbl.getPartitions().size() == 0 ? 1 : 0) != 0);
            eventsProcessor_.processEvents();
            tbl = this.getCatalogHdfsTable(TEST_DB_NAME, tblName);
            LOG.info("After add partititons, table last synced event id {}, latest event id in HMS {}", (Object)tbl.getLastSyncedEventId(), (Object)this.getLatestEventIdFromHMS());
            Assert.assertTrue((tbl.getLastSyncedEventId() > prevSyncedEventId ? 1 : 0) != 0);
            prevSyncedEventId = tbl.getLastSyncedEventId();
            Partition partitionToAlter = this.getPartitionInHms(TEST_DB_NAME, tblName, Arrays.asList("2"));
            String newLocation = "/path/to/newLocation/";
            partitionToAlter.getSd().setLocation(newLocation);
            this.alterPartitionInHms(TEST_DB_NAME, tblName, partitionToAlter);
            eventsProcessor_.processEvents();
            LOG.info("After alter partititons, table last synced event id {}, latest event id in HMS {}", (Object)tbl.getLastSyncedEventId(), (Object)this.getLatestEventIdFromHMS());
            Assert.assertTrue((tbl.getLastSyncedEventId() > prevSyncedEventId ? 1 : 0) != 0);
            prevSyncedEventId = tbl.getLastSyncedEventId();
            this.dropPartitionInHms(TEST_DB_NAME, tblName, Arrays.asList("3"), true);
            eventsProcessor_.processEvents();
            LOG.info("After drop partitions, table last synced event id {}, latest event id in HMS {}", (Object)tbl.getLastSyncedEventId(), (Object)this.getLatestEventIdFromHMS());
            Assert.assertTrue((tbl.getLastSyncedEventId() > prevSyncedEventId ? 1 : 0) != 0);
            tbl = this.getCatalogHdfsTable(TEST_DB_NAME, tblName);
            Assert.assertTrue((String)"Table should have 2 partitions after dropping 1 out of 3 partitions", (tbl.getPartitions().size() == 2 ? 1 : 0) != 0);
            FeFsPartition modifiedPartition = null;
            for (FeFsPartition part : tbl.loadAllPartitions()) {
                if (!part.getLocation().equals(newLocation)) continue;
                modifiedPartition = part;
                break;
            }
            Assert.assertTrue((modifiedPartition != null ? 1 : 0) != 0);
        }
        finally {
            catalog_.setMetastoreEventProcessor(prevEventProcessor);
            eventsProcessor_.processEvents();
            catalogHmsClient_.dropTable(TEST_DB_NAME, tblName, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDbEventProcessedByEventProcessor() throws Exception {
        LOG.info("Executing testDbEventProcessedByEventProcessor");
        String dbName = "test_db_event_processed_by_event_processor_db";
        ExternalEventsProcessor prevEventProcessor = catalog_.getMetastoreEventProcessor();
        try {
            catalog_.setMetastoreEventProcessor((ExternalEventsProcessor)eventsProcessor_);
            this.createDatabaseInCatalog(dbName);
            long prevSyncedEventId = catalog_.getDb(dbName).getLastSyncedEventId();
            try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
                MetastoreApiTestUtils.addDatabaseParametersInHms(msClient, dbName, "key1", "val1");
            }
            Assert.assertTrue((catalog_.getDb(dbName).getMetaStoreDb().getParameters() == null ? 1 : 0) != 0);
            eventsProcessor_.processEvents();
            Assert.assertTrue((boolean)((String)catalog_.getDb(dbName).getMetaStoreDb().getParameters().get("key1")).equals("val1"));
            Assert.assertTrue((catalog_.getDb(dbName).getLastSyncedEventId() > prevSyncedEventId ? 1 : 0) != 0);
        }
        finally {
            catalog_.setMetastoreEventProcessor(prevEventProcessor);
            catalogHmsClient_.dropDatabase(dbName, true, true, true);
        }
    }

    private void createDatabaseInHms(String catName, String dbName, Map<String, String> params) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            MetastoreApiTestUtils.createDatabase(msClient, null, TEST_DB_NAME, null);
        }
    }

    private void createTableInHms(String dbName, String tblName, boolean isPartitioned) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            MetastoreApiTestUtils.createTable(msClient, null, dbName, tblName, null, isPartitioned);
        }
    }

    private void addPartitionsInHms(String dbName, String tblName, List<List<String>> partitionValues) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            MetastoreApiTestUtils.addPartitions(msClient, dbName, tblName, partitionValues);
        }
    }

    private long getLatestEventIdFromHMS() throws TException {
        long lastEventId = -1L;
        try (MetaStoreClientPool.MetaStoreClient client = catalog_.getMetaStoreClient();){
            lastEventId = client.getHiveClient().getCurrentNotificationEventId().getEventId();
        }
        return lastEventId;
    }

    private org.apache.hadoop.hive.metastore.api.Table getHmsTable(String dbName, String tblName) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            org.apache.hadoop.hive.metastore.api.Table table = msClient.getHiveClient().getTable(dbName, tblName);
            return table;
        }
    }

    private HdfsTable getCatalogHdfsTable(String dbName, String tblName) throws CatalogException {
        Table tbl = catalog_.getTable(dbName, tblName);
        if (tbl instanceof HdfsTable) {
            return (HdfsTable)tbl;
        }
        return null;
    }

    private Partition getPartitionInHms(String dbName, String tblName, List<String> partVal) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            Partition partition = msClient.getHiveClient().getPartition(dbName, tblName, partVal);
            return partition;
        }
    }

    private void alterPartitionInHms(String dbName, String tblName, Partition partition) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            msClient.getHiveClient().alter_partition(dbName, tblName, partition);
        }
    }

    private void dropPartitionInHms(String dbName, String tblName, List<String> partVals, boolean deleteData) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            msClient.getHiveClient().dropPartition(dbName, tblName, partVals, deleteData);
        }
    }

    private Database getDatabaseInHms(String dbName) throws TException {
        try (MetaStoreClientPool.MetaStoreClient msClient = catalog_.getMetaStoreClient();){
            Database database = msClient.getHiveClient().getDatabase(dbName);
            return database;
        }
    }

    private Map<String, String> getPartitionSpec(org.apache.hadoop.hive.metastore.api.Table tbl, List<String> vals) {
        HashMap<String, String> partitionSpec = new HashMap<String, String>();
        for (int i = 0; i < tbl.getPartitionKeys().size(); ++i) {
            FieldSchema partCol = (FieldSchema)tbl.getPartitionKeys().get(i);
            partitionSpec.put(partCol.getName(), vals.get(i));
        }
        return partitionSpec;
    }

    private void createDatabaseInCatalog(String dbName) throws TException {
        Database msDb = MetastoreApiTestUtils.createHmsDatabaseObject(null, dbName, null);
        catalogHmsClient_.createDatabase(msDb);
        Assert.assertTrue((String)("db " + dbName + " not present in catalogd"), (catalog_.getDb(dbName) != null ? 1 : 0) != 0);
    }

    static {
        CONF = MetastoreConf.newMetastoreConf();
        managedTableType = TableType.MANAGED_TABLE.toString();
        externalTableType = TableType.EXTERNAL_TABLE.toString();
    }
}

