/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.metastore;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesResult;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.impala.catalog.FileBlock;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.metastore.AbstractCatalogMetastoreTest;
import org.apache.impala.catalog.metastore.CatalogHmsClientUtils;
import org.apache.impala.fb.FbFileBlock;
import org.apache.impala.util.ListMap;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Test;

public class CatalogHmsFileMetadataTest
extends AbstractCatalogMetastoreTest {
    @Test
    public void testFileMetadataForPartitions() throws Exception {
        HdfsTable tbl = (HdfsTable)catalog_.getOrLoadTable("functional", "alltypes", "test", null);
        HdfsPartition hdfsPartition1 = (HdfsPartition)tbl.getPartitionsForNames(Arrays.asList("year=2009/month=1")).get(0);
        HdfsPartition hdfsPartition2 = (HdfsPartition)tbl.getPartitionsForNames(Arrays.asList("year=2009/month=2")).get(0);
        GetPartitionsByNamesRequest request = new GetPartitionsByNamesRequest();
        String dbName = MetaStoreUtils.prependCatalogToDbName((String)"functional", (Configuration)CONF);
        request.setDb_name(dbName);
        request.setTbl_name("alltypes");
        request.setNames(new ArrayList());
        request.setGetFileMetadata(true);
        GetPartitionsByNamesResult result = catalogHmsClient_.getPartitionsByNames(request);
        Assert.assertTrue((boolean)result.getPartitions().isEmpty());
        Map fds = CatalogHmsClientUtils.extractFileDescriptors((GetPartitionsByNamesResult)result, (ListMap)tbl.getHostIndex());
        Assert.assertTrue((boolean)fds.isEmpty());
        request = new GetPartitionsByNamesRequest();
        dbName = MetaStoreUtils.prependCatalogToDbName((String)"functional", (Configuration)CONF);
        request.setDb_name(dbName);
        request.setTbl_name("alltypes");
        request.setNames(Arrays.asList("year=2009/month=1", "year=2009/month=2"));
        request.setGetFileMetadata(true);
        result = catalogHmsClient_.getPartitionsByNames(request);
        CatalogHmsFileMetadataTest.sortPartitionsByNames(tbl.getMetaStoreTable().getPartitionKeys(), result.getPartitions());
        for (Partition part : result.getPartitions()) {
            Assert.assertNotNull((Object)part.getFileMetadata());
        }
        Assert.assertNotNull((Object)result.getDictionary());
        fds = CatalogHmsClientUtils.extractFileDescriptors((GetPartitionsByNamesResult)result, (ListMap)tbl.getHostIndex());
        Assert.assertEquals((long)2L, (long)fds.size());
        for (List partFds : fds.values()) {
            Assert.assertFalse((boolean)partFds.isEmpty());
            Assert.assertEquals((long)1L, (long)partFds.size());
        }
        CatalogHmsFileMetadataTest.assertFdsAreSame(hdfsPartition1.getFileDescriptors(), (List)fds.get(result.getPartitions().get(0)));
        CatalogHmsFileMetadataTest.assertFdsAreSame(hdfsPartition2.getFileDescriptors(), (List)fds.get(result.getPartitions().get(1)));
    }

    @Test
    public void testFileMetadataForAcidPartitions() throws Exception {
        ValidWriteIdList writeIdList = this.getValidWriteIdList("function_orc_def", "alltypes_deleted_rows");
        HdfsTable tbl = (HdfsTable)catalog_.getOrLoadTable("functional_orc_def", "alltypes_deleted_rows", "test", writeIdList);
        HdfsPartition hdfsPartition1 = (HdfsPartition)tbl.getPartitionsForNames(Arrays.asList("year=2010/month=10")).get(0);
        GetPartitionsByNamesRequest request = new GetPartitionsByNamesRequest();
        String dbName = MetaStoreUtils.prependCatalogToDbName((String)"functional_orc_def", (Configuration)CONF);
        request.setDb_name(dbName);
        request.setTbl_name("alltypes_deleted_rows");
        request.setNames(Arrays.asList("year=2010/month=10"));
        request.setGetFileMetadata(true);
        request.setValidWriteIdList(tbl.getValidWriteIds().toString());
        GetPartitionsByNamesResult result = catalogHmsClient_.getPartitionsByNames(request);
        CatalogHmsFileMetadataTest.sortPartitionsByNames(tbl.getMetaStoreTable().getPartitionKeys(), result.getPartitions());
        for (Partition part : result.getPartitions()) {
            Assert.assertNotNull((Object)part.getFileMetadata());
        }
        Assert.assertNotNull((Object)result.getDictionary());
        Map fds = CatalogHmsClientUtils.extractFileDescriptors((GetPartitionsByNamesResult)result, (ListMap)tbl.getHostIndex());
        Assert.assertEquals((long)1L, (long)fds.size());
        for (List partFds : fds.values()) {
            Assert.assertFalse((boolean)partFds.isEmpty());
            Assert.assertEquals((long)2L, (long)partFds.size());
        }
        CatalogHmsFileMetadataTest.assertFdsAreSame(hdfsPartition1.getFileDescriptors(), (List)fds.get(result.getPartitions().get(0)));
    }

    public static void assertFdsAreSame(List<FileDescriptor> fdsFromCatalog, List<FileDescriptor> fdsFromHMS) {
        Assert.assertEquals((long)fdsFromCatalog.size(), (long)fdsFromHMS.size());
        ArrayList<FileDescriptor> fds1 = new ArrayList<FileDescriptor>(fdsFromCatalog);
        ArrayList<FileDescriptor> fds2 = new ArrayList<FileDescriptor>(fdsFromHMS);
        fds1.sort(Comparator.comparing(FileDescriptor::getRelativePath));
        fds2.sort(Comparator.comparing(FileDescriptor::getRelativePath));
        for (int i = 0; i < fds1.size(); ++i) {
            FileDescriptor fdFromCatalog = (FileDescriptor)fds1.get(i);
            FileDescriptor fdFromHMS = (FileDescriptor)fds2.get(i);
            Assert.assertEquals((Object)fdFromCatalog.getRelativePath(), (Object)fdFromHMS.getRelativePath());
            Assert.assertEquals((Object)fdFromCatalog.getFileCompression(), (Object)fdFromHMS.getFileCompression());
            Assert.assertEquals((long)fdFromCatalog.getFileLength(), (long)fdFromHMS.getFileLength());
            Assert.assertEquals((Object)fdFromCatalog.getIsEc(), (Object)fdFromHMS.getIsEc());
            Assert.assertEquals((long)fdFromCatalog.getModificationTime(), (long)fdFromHMS.getModificationTime());
            Assert.assertEquals((long)fdFromCatalog.getNumFileBlocks(), (long)fdFromHMS.getNumFileBlocks());
            for (int j = 0; j < fdFromCatalog.getNumFileBlocks(); ++j) {
                FbFileBlock blockFromCat = fdFromCatalog.getFbFileBlock(j);
                FbFileBlock blockFromHMS = fdFromCatalog.getFbFileBlock(j);
                Assert.assertEquals((Object)FileBlock.debugString((FbFileBlock)blockFromCat), (Object)FileBlock.debugString((FbFileBlock)blockFromHMS));
            }
        }
    }

    @Test
    public void testFileMetadataForTable() throws Exception {
        Table tbl = catalogHmsClient_.getTable(null, "functional", "zipcode_incomes", null, false, null, true);
        Assert.assertNotNull((Object)tbl.getFileMetadata());
        HdfsTable catTbl = (HdfsTable)catalog_.getOrLoadTable("functional", "zipcode_incomes", "test", null);
        HdfsPartition part = (HdfsPartition)Iterables.getOnlyElement((Iterable)catTbl.getPartitions());
        List hmsTblFds = CatalogHmsClientUtils.extractFileDescriptors((Table)tbl, (ListMap)catTbl.getHostIndex());
        CatalogHmsFileMetadataTest.assertFdsAreSame(part.getFileDescriptors(), hmsTblFds);
    }

    private ValidWriteIdList getValidWriteIdList(String db, String tbl) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = catalog_.getMetaStoreClient();){
            ValidWriteIdList validWriteIdList = client.getHiveClient().getValidWriteIds(db + "." + tbl);
            return validWriteIdList;
        }
    }
}

