/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.metastore;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.impala.catalog.metastore.CatalogMetastoreServer;
import org.apache.impala.catalog.metastore.ICatalogMetastoreServer;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.service.CatalogOpExecutor;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.apache.impala.testutil.CatalogTestMetastoreServer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class AbstractCatalogMetastoreTest {
    protected static CatalogServiceTestCatalog catalog_;
    protected static CatalogOpExecutor catalogOpExecutor_;
    protected static CatalogMetastoreServer catalogMetastoreServer_;
    protected static HiveMetaStoreClient catalogHmsClient_;
    protected static final Configuration CONF;

    @BeforeClass
    public static void setup() throws Exception {
        catalog_ = CatalogServiceTestCatalog.create();
        catalogOpExecutor_ = catalog_.getCatalogOpExecutor();
        catalogMetastoreServer_ = new CatalogTestMetastoreServer(catalogOpExecutor_);
        catalog_.setCatalogMetastoreServer((ICatalogMetastoreServer)catalogMetastoreServer_);
        catalogMetastoreServer_.start();
        MetastoreConf.setVar((Configuration)CONF, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://localhost:" + catalogMetastoreServer_.getPort()));
        CONF.set("hive.metastore.execute.setugi", "false");
        catalogHmsClient_ = new HiveMetaStoreClient(CONF);
    }

    protected static void sortPartitionsByNames(List<FieldSchema> partitionKeys, List<Partition> retPartitions) {
        Assert.assertTrue((retPartitions.isEmpty() || partitionKeys.size() == retPartitions.get(0).getValuesSize() ? 1 : 0) != 0);
        ArrayList<String> partitionColNames = new ArrayList<String>();
        for (FieldSchema partSchema : partitionKeys) {
            partitionColNames.add(partSchema.getName());
        }
        retPartitions.sort(Comparator.comparing(part -> MetastoreShim.makePartName((List)partitionColNames, (List)part.getValues())));
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        catalogMetastoreServer_.stop();
        catalog_.close();
    }

    static {
        CONF = MetastoreConf.newMetastoreConf();
    }
}

