/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hive.service.rpc.thrift.TGetColumnsReq;
import org.apache.hive.service.rpc.thrift.TGetTablesReq;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.NoopAuthorizationFactory;
import org.apache.impala.catalog.CatalogTest;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.IcebergContentFileStore;
import org.apache.impala.catalog.IcebergFileDescriptor;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.local.CatalogdMetaProvider;
import org.apache.impala.catalog.local.LocalCatalog;
import org.apache.impala.catalog.local.LocalFsTable;
import org.apache.impala.catalog.local.LocalHbaseTable;
import org.apache.impala.catalog.local.LocalIcebergTable;
import org.apache.impala.catalog.local.LocalIncompleteTable;
import org.apache.impala.catalog.local.LocalKuduTable;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.fb.FbFileBlock;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.FeSupport;
import org.apache.impala.service.Frontend;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.thrift.TIcebergContentFileStore;
import org.apache.impala.thrift.TMetadataOpRequest;
import org.apache.impala.thrift.TMetadataOpcode;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPartialTableInfo;
import org.apache.impala.thrift.TResultRow;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.util.IcebergUtil;
import org.apache.impala.util.ListMap;
import org.apache.impala.util.PatternMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalCatalogTest {
    private CatalogdMetaProvider provider_;
    private LocalCatalog catalog_;
    private Frontend fe_;

    @Before
    public void setupCatalog() throws Exception {
        FeSupport.loadLibrary();
        this.provider_ = new CatalogdMetaProvider(BackendConfig.INSTANCE.getBackendCfg());
        this.catalog_ = new LocalCatalog((MetaProvider)this.provider_);
        this.fe_ = new Frontend((AuthorizationFactory)new NoopAuthorizationFactory(), (FeCatalog)this.catalog_);
    }

    @Test
    public void testDbs() throws Exception {
        FeDb functionalDb = this.catalog_.getDb("functional");
        Assert.assertNotNull((Object)functionalDb);
        FeDb functionalSeqDb = this.catalog_.getDb("functional_seq");
        Assert.assertNotNull((Object)functionalSeqDb);
        ImmutableSet dbs = ImmutableSet.copyOf((Collection)this.catalog_.getDbs(PatternMatcher.MATCHER_MATCH_ALL));
        Assert.assertTrue((boolean)dbs.contains(functionalDb));
        Assert.assertTrue((boolean)dbs.contains(functionalSeqDb));
        dbs = ImmutableSet.copyOf((Collection)this.catalog_.getDbs(PatternMatcher.createHivePatternMatcher((String)"*_seq")));
        Assert.assertFalse((boolean)dbs.contains(functionalDb));
        Assert.assertTrue((boolean)dbs.contains(functionalSeqDb));
    }

    @Test
    public void testListTables() throws Exception {
        ImmutableSet names = ImmutableSet.copyOf((Collection)this.catalog_.getTableNames("functional", PatternMatcher.MATCHER_MATCH_ALL));
        Assert.assertTrue((boolean)names.contains("alltypes"));
        FeDb db = this.catalog_.getDb("functional");
        Assert.assertNotNull((Object)db);
        FeTable t = this.catalog_.getTable("functional", "alltypes");
        Assert.assertNotNull((Object)t);
        Assert.assertSame((Object)t, (Object)db.getTable("alltypes"));
        Assert.assertSame((Object)db, (Object)t.getDb());
        Assert.assertEquals((Object)"alltypes", (Object)t.getName());
        Assert.assertEquals((Object)"functional", (Object)t.getDb().getName());
        Assert.assertEquals((Object)"functional.alltypes", (Object)t.getFullName());
    }

    @Test
    public void testLoadTableBasics() throws Exception {
        FeDb functionalDb = this.catalog_.getDb("functional");
        CatalogTest.checkTableCols(functionalDb, "alltypes", 2, new String[]{"year", "month", "id", "bool_col", "tinyint_col", "smallint_col", "int_col", "bigint_col", "float_col", "double_col", "date_string_col", "string_col", "timestamp_col"}, new Type[]{Type.INT, Type.INT, Type.INT, Type.BOOLEAN, Type.TINYINT, Type.SMALLINT, Type.INT, Type.BIGINT, Type.FLOAT, Type.DOUBLE, Type.STRING, Type.STRING, Type.TIMESTAMP});
        FeTable t = functionalDb.getTable("alltypes");
        Assert.assertEquals((long)7300L, (long)t.getNumRows());
        Assert.assertTrue((boolean)(t instanceof LocalFsTable));
        FeFsTable fsTable = (FeFsTable)t;
        Assert.assertEquals((Object)"__HIVE_DEFAULT_PARTITION__", (Object)fsTable.getNullPartitionKeyValue());
        TResultSet stats = fsTable.getTableStats();
        Assert.assertEquals((long)25L, (long)stats.getRowsSize());
    }

    @Test
    public void testLoadDateTableBasics() throws Exception {
        FeDb functionalDb = this.catalog_.getDb("functional");
        CatalogTest.checkTableCols(functionalDb, "date_tbl", 1, new String[]{"date_part", "id_col", "date_col"}, new Type[]{Type.DATE, Type.INT, Type.DATE});
        FeTable t = functionalDb.getTable("date_tbl");
        Assert.assertEquals((long)22L, (long)t.getNumRows());
        Assert.assertTrue((boolean)(t instanceof LocalFsTable));
        FeFsTable fsTable = (FeFsTable)t;
        Assert.assertEquals((Object)"__HIVE_DEFAULT_PARTITION__", (Object)fsTable.getNullPartitionKeyValue());
        TResultSet stats = fsTable.getTableStats();
        Assert.assertEquals((long)5L, (long)stats.getRowsSize());
    }

    @Test
    public void testLoadBinaryTableBasics() throws Exception {
        FeDb functionalDb = this.catalog_.getDb("functional");
        CatalogTest.checkTableCols(functionalDb, "binary_tbl", 0, new String[]{"id", "string_col", "binary_col"}, new Type[]{Type.INT, Type.STRING, Type.BINARY});
        FeTable t = functionalDb.getTable("binary_tbl");
        Assert.assertEquals((long)8L, (long)t.getNumRows());
        Assert.assertTrue((boolean)(t instanceof LocalFsTable));
        FeFsTable fsTable = (FeFsTable)t;
        Assert.assertEquals((Object)"__HIVE_DEFAULT_PARTITION__", (Object)fsTable.getNullPartitionKeyValue());
        TResultSet stats = fsTable.getTableStats();
        Assert.assertEquals((long)1L, (long)stats.getRowsSize());
    }

    @Test
    public void testPartitioning() throws Exception {
        FeFsTable t = (FeFsTable)this.catalog_.getTable("functional", "alltypes");
        CatalogTest.checkAllTypesPartitioning(t);
    }

    @Test
    public void testGetSqlConstraints() throws Exception {
        FeFsTable t = (FeFsTable)this.catalog_.getTable("functional", "parent_table");
        Assert.assertNotNull((Object)t);
        Assert.assertTrue((boolean)(t instanceof LocalFsTable));
        List primaryKeys = t.getSqlConstraints().getPrimaryKeys();
        List foreignKeys = t.getSqlConstraints().getForeignKeys();
        Assert.assertEquals((long)2L, (long)primaryKeys.size());
        Assert.assertEquals((long)0L, (long)foreignKeys.size());
        for (SQLPrimaryKey pk : primaryKeys) {
            Assert.assertEquals((Object)"functional", (Object)pk.getTable_db());
            Assert.assertEquals((Object)"parent_table", (Object)pk.getTable_name());
        }
        Assert.assertEquals((Object)"id", (Object)((SQLPrimaryKey)primaryKeys.get(0)).getColumn_name());
        Assert.assertEquals((Object)"year", (Object)((SQLPrimaryKey)primaryKeys.get(1)).getColumn_name());
        t = (FeFsTable)this.catalog_.getTable("functional", "child_table");
        Assert.assertNotNull((Object)t);
        Assert.assertTrue((boolean)(t instanceof LocalFsTable));
        primaryKeys = t.getSqlConstraints().getPrimaryKeys();
        foreignKeys = t.getSqlConstraints().getForeignKeys();
        Assert.assertEquals((long)1L, (long)primaryKeys.size());
        Assert.assertEquals((long)3L, (long)foreignKeys.size());
        Assert.assertEquals((Object)"functional", (Object)((SQLPrimaryKey)primaryKeys.get(0)).getTable_db());
        Assert.assertEquals((Object)"child_table", (Object)((SQLPrimaryKey)primaryKeys.get(0)).getTable_name());
        for (SQLForeignKey fk : foreignKeys) {
            Assert.assertEquals((Object)"functional", (Object)fk.getFktable_db());
            Assert.assertEquals((Object)"child_table", (Object)fk.getFktable_name());
            Assert.assertEquals((Object)"functional", (Object)fk.getPktable_db());
        }
        Assert.assertEquals((Object)"parent_table", (Object)((SQLForeignKey)foreignKeys.get(0)).getPktable_name());
        Assert.assertEquals((Object)"parent_table", (Object)((SQLForeignKey)foreignKeys.get(1)).getPktable_name());
        Assert.assertEquals((Object)"parent_table_2", (Object)((SQLForeignKey)foreignKeys.get(2)).getPktable_name());
        Assert.assertEquals((Object)"id", (Object)((SQLForeignKey)foreignKeys.get(0)).getPkcolumn_name());
        Assert.assertEquals((Object)"year", (Object)((SQLForeignKey)foreignKeys.get(1)).getPkcolumn_name());
        Assert.assertEquals((Object)"a", (Object)((SQLForeignKey)foreignKeys.get(2)).getPkcolumn_name());
        Assert.assertEquals((Object)((SQLForeignKey)foreignKeys.get(0)).getFk_name(), (Object)((SQLForeignKey)foreignKeys.get(1)).getFk_name());
        t = (FeFsTable)this.catalog_.getTable("functional", "alltypes");
        Assert.assertNotNull((Object)t);
        Assert.assertTrue((boolean)(t instanceof FeFsTable));
        primaryKeys = t.getSqlConstraints().getPrimaryKeys();
        foreignKeys = t.getSqlConstraints().getForeignKeys();
        Assert.assertNotNull((Object)primaryKeys);
        Assert.assertNotNull((Object)foreignKeys);
        Assert.assertEquals((long)0L, (long)primaryKeys.size());
        Assert.assertEquals((long)0L, (long)foreignKeys.size());
    }

    @Test
    public void testEmptyPartitionValue() throws Exception {
        FeFsTable t = (FeFsTable)this.catalog_.getTable("functional", "alltypesagg");
        int dayCol = t.getColumn("day").getPosition();
        Set ids = t.getNullPartitionIds(dayCol);
        Assert.assertEquals((long)1L, (long)ids.size());
        FeFsPartition partition = t.loadPartition(((Long)Iterables.getOnlyElement((Iterable)ids)).longValue());
        Assert.assertTrue((boolean)Expr.IS_NULL_VALUE.apply((Object)partition.getPartitionValue(dayCol)));
    }

    @Test
    public void testLoadFileDescriptors() throws Exception {
        FeFsTable t = (FeFsTable)this.catalog_.getTable("functional", "alltypes");
        int totalFds = 0;
        for (FeFsPartition p : t.loadAllPartitions()) {
            List fds = p.getFileDescriptors();
            totalFds += fds.size();
            for (FileDescriptor fd : fds) {
                Assert.assertTrue((fd.getFileLength() > 0L ? 1 : 0) != 0);
                Assert.assertEquals((long)fd.getNumFileBlocks(), (long)1L);
                Assert.assertEquals((long)3L, (long)fd.getFbFileBlock(0).diskIdsLength());
            }
        }
        Assert.assertEquals((long)24L, (long)totalFds);
        Assert.assertTrue((t.getHostIndex().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadIcebergFileDescriptors() throws Exception {
        LocalIcebergTable t = (LocalIcebergTable)this.catalog_.getTable("functional_parquet", "iceberg_partitioned");
        IcebergContentFileStore fileStore = t.getContentFileStore();
        TPartialTableInfo tblInfo = this.provider_.loadIcebergTable(t.ref_);
        ListMap catalogdHostIndexes = new ListMap();
        catalogdHostIndexes.populate(tblInfo.getNetwork_addresses());
        IcebergContentFileStore catalogFileStore = IcebergContentFileStore.fromThrift((TIcebergContentFileStore)tblInfo.getIceberg_table().getContent_files(), null, null);
        TIcebergContentFileStore icebergContentFileStore = catalogFileStore.toThrift();
        Assert.assertEquals((Object)tblInfo.getIceberg_table().getContent_files(), (Object)icebergContentFileStore);
        for (FileDescriptor localFd : fileStore.getAllDataFiles()) {
            String path = localFd.getAbsolutePath(t.getLocation());
            path = path.substring(path.indexOf("/test-warehouse"));
            String pathHash = IcebergUtil.getFilePathHash((String)path);
            IcebergFileDescriptor catalogFd = catalogFileStore.getDataFileDescriptor(pathHash);
            Assert.assertEquals((long)localFd.getNumFileBlocks(), (long)1L);
            FbFileBlock localBlock = localFd.getFbFileBlock(0);
            FbFileBlock catalogBlock = catalogFd.getFbFileBlock(0);
            Assert.assertEquals((long)localBlock.replicaHostIdxsLength(), (long)3L);
            for (int i = 0; i < localBlock.replicaHostIdxsLength(); ++i) {
                TNetworkAddress localAddr = (TNetworkAddress)t.getHostIndex().getEntry(localBlock.replicaHostIdxs(i));
                TNetworkAddress catalogAddr = (TNetworkAddress)catalogdHostIndexes.getEntry(catalogBlock.replicaHostIdxs(i));
                Assert.assertEquals((Object)localAddr, (Object)catalogAddr);
            }
        }
    }

    @Test
    public void testLoadFileDescriptorsUnpartitioned() throws Exception {
        FeFsTable t = (FeFsTable)this.catalog_.getTable("tpch", "region");
        int totalFds = 0;
        for (FeFsPartition p : t.loadAllPartitions()) {
            List fds = p.getFileDescriptors();
            totalFds += fds.size();
            for (FileDescriptor fd : fds) {
                Assert.assertTrue((fd.getFileLength() > 0L ? 1 : 0) != 0);
                Assert.assertEquals((long)fd.getNumFileBlocks(), (long)1L);
                Assert.assertEquals((long)3L, (long)fd.getFbFileBlock(0).diskIdsLength());
            }
        }
        Assert.assertEquals((long)1L, (long)totalFds);
    }

    @Test
    public void testColumnStats() throws Exception {
        FeFsTable t = (FeFsTable)this.catalog_.getTable("functional", "alltypesagg");
        ColumnStats stats = t.getColumn("day").getStats();
        Assert.assertEquals((long)11L, (long)stats.getNumDistinctValues());
        Assert.assertEquals((long)1L, (long)stats.getNumNulls());
        stats = t.getColumn("timestamp_col").getStats();
        Assert.assertEquals((long)10210L, (long)stats.getNumDistinctValues());
        Assert.assertEquals((long)0L, (long)stats.getNumNulls());
    }

    @Test
    public void testDateColumnStats() throws Exception {
        FeFsTable t = (FeFsTable)this.catalog_.getTable("functional", "date_tbl");
        ColumnStats stats = t.getColumn("date_part").getStats();
        Assert.assertEquals((long)4L, (long)stats.getNumDistinctValues());
        Assert.assertEquals((long)0L, (long)stats.getNumNulls());
        stats = t.getColumn("date_col").getStats();
        Assert.assertEquals((long)16L, (long)stats.getNumDistinctValues());
        Assert.assertEquals((long)2L, (long)stats.getNumNulls());
    }

    @Test
    public void testBinaryColumnStats() throws Exception {
        FeFsTable t = (FeFsTable)this.catalog_.getTable("functional", "binary_tbl");
        ColumnStats stats = t.getColumn("binary_col").getStats();
        Assert.assertEquals((long)26L, (long)stats.getMaxSize());
        Assert.assertEquals((double)8.714285850524902, (double)stats.getAvgSize(), (double)1.0E-4);
        Assert.assertEquals((long)-1L, (long)stats.getNumDistinctValues());
        Assert.assertEquals((long)1L, (long)stats.getNumNulls());
    }

    @Test
    public void testView() throws Exception {
        FeView v = (FeView)this.catalog_.getTable("functional", "alltypes_view");
        Assert.assertEquals((Object)TCatalogObjectType.VIEW, (Object)v.getCatalogObjectType());
        Assert.assertEquals((Object)"SELECT * FROM functional.alltypes", (Object)v.getQueryStmt().toSql());
    }

    @Test
    public void testKuduTable() throws Exception {
        LocalKuduTable t = (LocalKuduTable)this.catalog_.getTable("functional_kudu", "alltypes");
        Assert.assertEquals((Object)"id,bool_col,tinyint_col,smallint_col,int_col,bigint_col,float_col,double_col,date_string_col,string_col,timestamp_col,year,month", (Object)Joiner.on((String)",").join((Iterable)t.getColumnNames()));
        boolean areDefaultSynchronizedTablesExternal = TestUtils.getHiveMajorVersion() > 2;
        String expectedOutputPrefix = areDefaultSynchronizedTablesExternal ? "CREATE EXTERNAL TABLE" : "CREATE TABLE";
        String expectedOutput = expectedOutputPrefix + " functional_kudu.alltypes (\n  id INT NOT NULL ENCODING AUTO_ENCODING COMPRESSION DEFAULT_COMPRESSION,\n  bool_col BOOLEAN NULL ENCODING AUTO_ENCODING COMPRESSION DEFAULT_COMPRESSION,\n  tinyint_col TINYINT NULL ENCODING AUTO_ENCODING COMPRESSION DEFAULT_COMPRESSION,\n  smallint_col SMALLINT NULL ENCODING AUTO_ENCODING COMPRESSION DEFAULT_COMPRESSION,\n  int_col INT NULL ENCODING AUTO_ENCODING COMPRESSION DEFAULT_COMPRESSION,\n  bigint_col BIGINT NULL ENCODING AUTO_ENCODING COMPRESSION DEFAULT_COMPRESSION,\n  float_col FLOAT NULL ENCODING AUTO_ENCODING COMPRESSION DEFAULT_COMPRESSION,\n  double_col DOUBLE NULL ENCODING AUTO_ENCODING COMPRESSION DEFAULT_COMPRESSION,\n  date_string_col STRING NULL ENCODING AUTO_ENCODING COMPRESSION DEFAULT_COMPRESSION,\n  string_col STRING NULL ENCODING AUTO_ENCODING COMPRESSION DEFAULT_COMPRESSION,\n  timestamp_col TIMESTAMP NULL ENCODING AUTO_ENCODING COMPRESSION DEFAULT_COMPRESSION,\n  year INT NULL ENCODING AUTO_ENCODING COMPRESSION DEFAULT_COMPRESSION,\n  month INT NULL ENCODING AUTO_ENCODING COMPRESSION DEFAULT_COMPRESSION,\n  PRIMARY KEY (id)\n)\nPARTITION BY HASH (id) PARTITIONS 3\nSTORED AS KUDU\nTBLPROPERTIES";
        if (areDefaultSynchronizedTablesExternal) {
            String output = ToSqlUtils.getCreateTableSql((FeTable)t);
            Assert.assertThat((Object)output, (Matcher)CoreMatchers.startsWith((String)expectedOutput));
            Assert.assertTrue((String)"Synchronized Kudu tables in Hive-3 must contain external.table.purge table property", (boolean)output.contains("'external.table.purge'='TRUE'"));
            Assert.assertTrue((String)"Internal property TRANSLATED_TO_EXTERNAL not found in table properties", (boolean)output.contains("TRANSLATED_TO_EXTERNAL"));
        } else {
            Assert.assertThat((Object)ToSqlUtils.getCreateTableSql((FeTable)t), (Matcher)CoreMatchers.startsWith((String)expectedOutput));
        }
    }

    @Test
    public void testHbaseTable() throws Exception {
        LocalHbaseTable t = (LocalHbaseTable)this.catalog_.getTable("functional_hbase", "alltypes");
        Assert.assertThat((Object)ToSqlUtils.getCreateTableSql((FeTable)t), (Matcher)CoreMatchers.startsWith((String)"CREATE EXTERNAL TABLE functional_hbase.alltypes (\n  id INT COMMENT 'Add a comment',\n  bigint_col BIGINT,\n  bool_col BOOLEAN,\n  date_string_col STRING,\n  double_col DOUBLE,\n  float_col FLOAT,\n  int_col INT,\n  month INT,\n  smallint_col SMALLINT,\n  string_col STRING,\n  timestamp_col TIMESTAMP,\n  tinyint_col TINYINT,\n  year INT\n)\nSTORED BY 'org.apache.hadoop.hive.hbase.HBaseStorageHandler'\nWITH SERDEPROPERTIES ('hbase.columns.mapping'=':key,d:bool_col,d:tinyint_col,d:smallint_col,d:int_col,d:bigint_col,d:float_col,d:double_col,d:date_string_col,d:string_col,d:timestamp_col,d:year,d:month', 'serialization.format'='1')"));
        t = (LocalHbaseTable)this.catalog_.getTable("functional_hbase", "date_tbl");
        Assert.assertThat((Object)ToSqlUtils.getCreateTableSql((FeTable)t), (Matcher)CoreMatchers.startsWith((String)"CREATE EXTERNAL TABLE functional_hbase.date_tbl (\n  id_col INT,\n  date_col DATE,\n  date_part DATE\n)\nSTORED BY 'org.apache.hadoop.hive.hbase.HBaseStorageHandler'\nWITH SERDEPROPERTIES ('hbase.columns.mapping'=':key,d:date_col,d:date_part', 'serialization.format'='1')"));
        t = (LocalHbaseTable)this.catalog_.getTable("functional_hbase", "binary_tbl");
        Assert.assertThat((Object)ToSqlUtils.getCreateTableSql((FeTable)t), (Matcher)CoreMatchers.startsWith((String)"CREATE EXTERNAL TABLE functional_hbase.binary_tbl (\n  id INT,\n  binary_col BINARY,\n  string_col STRING\n)\nSTORED BY 'org.apache.hadoop.hive.hbase.HBaseStorageHandler'\nWITH SERDEPROPERTIES ('hbase.columns.mapping'=':key,d:string_col,d:binary_col', 'serialization.format'='1')"));
    }

    @Test
    public void testAvroExplicitSchema() throws Exception {
        FeFsTable t = (FeFsTable)this.catalog_.getTable("functional_avro", "zipcode_incomes");
        Assert.assertNotNull((Object)t.toThriftDescriptor((int)0, null).hdfsTable.avroSchema);
        Assert.assertTrue((boolean)t.usesAvroSchemaOverride());
    }

    @Test
    public void testAvroImplicitSchema() throws Exception {
        FeFsTable t = (FeFsTable)this.catalog_.getTable("functional_avro_snap", "no_avro_schema");
        Assert.assertNotNull((Object)t.toThriftDescriptor((int)0, null).hdfsTable.avroSchema);
        Assert.assertEquals((Object)t.getColumn("tinyint_col").getType(), (Object)Type.INT);
        Assert.assertTrue((boolean)t.usesAvroSchemaOverride());
    }

    @Test
    public void testSkipHeaderLine() throws Exception {
        FeFsTable alltypes = (FeFsTable)this.catalog_.getTable("functional", "alltypes");
        StringBuilder error = new StringBuilder();
        Assert.assertEquals((long)alltypes.parseSkipHeaderLineCount(error), (long)0L);
        Assert.assertEquals((long)error.length(), (long)0L);
        FeFsTable table_with_header = (FeFsTable)this.catalog_.getTable("functional", "table_with_header");
        Assert.assertEquals((long)table_with_header.parseSkipHeaderLineCount(error), (long)1L);
        Assert.assertEquals((long)error.length(), (long)0L);
    }

    @Test
    public void testGetTables() throws Exception {
        TMetadataOpRequest req = new TMetadataOpRequest();
        req.opcode = TMetadataOpcode.GET_TABLES;
        req.get_tables_req = new TGetTablesReq();
        req.get_tables_req.setSchemaName("functional");
        req.get_tables_req.setTableName("bad_serde");
        TResultSet resp = this.fe_.execHiveServer2MetadataOp(req);
        Assert.assertEquals((long)1L, (long)resp.rows.size());
        Assert.assertEquals((Object)((TColumnValue)((TResultRow)resp.rows.get((int)0)).colVals.get((int)1)).string_val, (Object)"functional");
        Assert.assertEquals((Object)((TColumnValue)((TResultRow)resp.rows.get((int)0)).colVals.get((int)2)).string_val, (Object)"bad_serde");
    }

    @Test
    public void testGetTableIfCached() throws Exception {
        FeTable tbl = this.catalog_.getTableIfCachedNoThrow("functional", "alltypes");
        Assert.assertTrue((boolean)(tbl instanceof LocalIncompleteTable));
        TMetadataOpRequest req = new TMetadataOpRequest();
        req.opcode = TMetadataOpcode.GET_TABLES;
        req.get_tables_req = new TGetTablesReq();
        this.fe_.execHiveServer2MetadataOp(req);
        tbl = this.catalog_.getDb("functional").getTableIfCached("alltypes");
        Assert.assertTrue((boolean)(tbl instanceof LocalIncompleteTable));
        req = new TMetadataOpRequest();
        req.opcode = TMetadataOpcode.GET_COLUMNS;
        req.get_columns_req = new TGetColumnsReq();
        req.get_columns_req.setSchemaName("functional");
        req.get_columns_req.setTableName("alltypes");
        this.fe_.execHiveServer2MetadataOp(req);
        tbl = this.catalog_.getDb("functional").getTableIfCached("alltypes");
        Assert.assertTrue((boolean)(tbl instanceof LocalFsTable));
    }
}

