/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.iceberg;

import java.util.Map;
import java.util.Properties;
import org.apache.impala.catalog.iceberg.RESTCatalogProperties;
import org.junit.Assert;
import org.junit.Test;

public class TestRESTCatalogProperties {
    @Test
    public void testEmptyConfig() {
        try {
            Properties props = new Properties();
            RESTCatalogProperties rESTCatalogProperties = new RESTCatalogProperties(props);
        }
        catch (Exception e) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testUriOnlyConfig() {
        Properties props = new Properties();
        props.setProperty("uri", "test-uri");
        RESTCatalogProperties restProps = new RESTCatalogProperties(props);
        Assert.assertEquals((Object)"test-uri", (Object)restProps.getUri());
        Assert.assertEquals((Object)"", (Object)restProps.getName());
        Assert.assertEquals((long)1L, (long)restProps.getCatalogProperties().size());
        Assert.assertTrue((boolean)restProps.getCatalogProperties().containsKey("uri"));
    }

    @Test
    public void testIcebergNativeConfig() {
        Properties props = new Properties();
        props.setProperty("uri", "test-uri");
        props.setProperty("iceberg.rest-catalog.name", "catalog-name");
        props.setProperty("warehouse", "warehouse-loc");
        props.setProperty("auth.session-timeout-ms", "5000");
        props.setProperty("oauth2-server-uri", "oauth-uri");
        props.setProperty("token", "oauth-token");
        props.setProperty("scope", "oauth-scope");
        RESTCatalogProperties restProps = new RESTCatalogProperties(props);
        Assert.assertEquals((Object)"test-uri", (Object)restProps.getUri());
        Assert.assertEquals((Object)"catalog-name", (Object)restProps.getName());
        Assert.assertEquals((long)6L, (long)restProps.getCatalogProperties().size());
        Map catProps = restProps.getCatalogProperties();
        Assert.assertEquals((Object)"test-uri", catProps.get("uri"));
        Assert.assertEquals((Object)"warehouse-loc", catProps.get("warehouse"));
        Assert.assertEquals((Object)"5000", catProps.get("auth.session-timeout-ms"));
        Assert.assertEquals((Object)"oauth-uri", catProps.get("oauth2-server-uri"));
        Assert.assertEquals((Object)"oauth-token", catProps.get("token"));
        Assert.assertEquals((Object)"oauth-scope", catProps.get("scope"));
    }

    @Test
    public void testTrinoConfig() {
        Properties props = new Properties();
        props.setProperty("iceberg.rest-catalog.uri", "test-uri");
        props.setProperty("iceberg.rest-catalog.name", "catalog-name");
        props.setProperty("iceberg.rest-catalog.warehouse", "warehouse-loc");
        props.setProperty("iceberg.rest-catalog.session-timeout", "5000");
        props.setProperty("iceberg.rest-catalog.oauth2.server-uri", "oauth-uri");
        props.setProperty("iceberg.rest-catalog.oauth2.credential", "oauth-cred");
        RESTCatalogProperties restProps = new RESTCatalogProperties(props);
        Assert.assertEquals((Object)"test-uri", (Object)restProps.getUri());
        Assert.assertEquals((Object)"catalog-name", (Object)restProps.getName());
        Assert.assertEquals((long)5L, (long)restProps.getCatalogProperties().size());
        Map catProps = restProps.getCatalogProperties();
        Assert.assertEquals((Object)"test-uri", catProps.get("uri"));
        Assert.assertEquals((Object)"warehouse-loc", catProps.get("warehouse"));
        Assert.assertEquals((Object)"5000", catProps.get("auth.session-timeout-ms"));
        Assert.assertEquals((Object)"oauth-uri", catProps.get("oauth2-server-uri"));
        Assert.assertEquals((Object)"oauth-cred", catProps.get("credential"));
    }

    @Test
    public void testAmbiguousKeys() {
        try {
            Properties props = new Properties();
            props.setProperty("iceberg.rest-catalog.uri", "test-uri");
            props.setProperty("uri", "test-uri2");
            props.setProperty("warehouse", "warehouse-loc");
            RESTCatalogProperties rESTCatalogProperties = new RESTCatalogProperties(props);
        }
        catch (Exception e) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testVerifiedConfigsSucceed() {
        Properties props = new Properties();
        props.setProperty("iceberg.rest-catalog.uri", "test-uri");
        props.setProperty("iceberg.rest-catalog.session", "none");
        props.setProperty("iceberg.rest-catalog.vended-credentials-enabled", "false");
        RESTCatalogProperties restProps = new RESTCatalogProperties(props);
        Map catProps = restProps.getCatalogProperties();
        Assert.assertEquals((long)3L, (long)catProps.size());
        Assert.assertEquals((Object)"test-uri", catProps.get("uri"));
        Assert.assertEquals((Object)"none", catProps.get("iceberg.rest-catalog.session"));
        Assert.assertEquals((Object)"false", catProps.get("iceberg.rest-catalog.vended-credentials-enabled"));
    }

    @Test
    public void testVerifiedConfigsFail() {
        try {
            Properties props = new Properties();
            props.setProperty("iceberg.rest-catalog.uri", "test-uri");
            props.setProperty("iceberg.rest-catalog.session", "user");
            RESTCatalogProperties rESTCatalogProperties = new RESTCatalogProperties(props);
        }
        catch (Exception e) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testIgnoredConfigs() {
        Properties props = new Properties();
        props.setProperty("uri", "test-uri");
        props.setProperty("iceberg.rest-catalog.name", "catalog-name");
        props.setProperty("warehouse", "warehouse-loc");
        props.setProperty("iceberg.rest-catalog.session-timeout", "5000");
        props.setProperty("iceberg.rest-catalog.oauth2.server-uri", "oauth-uri");
        props.setProperty("credential", "oauth-cred");
        props.setProperty("connector.name", "iceberg");
        props.setProperty("iceberg.catalog.type", "rest");
        RESTCatalogProperties restProps = new RESTCatalogProperties(props);
        Assert.assertEquals((Object)"test-uri", (Object)restProps.getUri());
        Assert.assertEquals((Object)"catalog-name", (Object)restProps.getName());
        Map catProps = restProps.getCatalogProperties();
        Assert.assertEquals((long)5L, (long)catProps.size());
        Assert.assertFalse((boolean)catProps.containsKey("connector.name"));
        Assert.assertFalse((boolean)catProps.containsKey("iceberg.catalog.type"));
        Assert.assertEquals((Object)"test-uri", catProps.get("uri"));
        Assert.assertEquals((Object)"warehouse-loc", catProps.get("warehouse"));
        Assert.assertEquals((Object)"5000", catProps.get("auth.session-timeout-ms"));
        Assert.assertEquals((Object)"oauth-uri", catProps.get("oauth2-server-uri"));
        Assert.assertEquals((Object)"oauth-cred", catProps.get("credential"));
    }
}

