/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.events;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.events.MetastoreEventsProcessor;
import org.apache.impala.catalog.events.MetastoreNotificationException;
import org.apache.impala.common.Metrics;
import org.apache.impala.service.CatalogOpExecutor;
import org.junit.Assert;

public class SynchronousHMSEventProcessorForTests
extends MetastoreEventsProcessor {
    public SynchronousHMSEventProcessorForTests(CatalogOpExecutor catalogOpExecutor, long startSyncFromId, long pollingFrequencyInMilliSec) throws CatalogException {
        super(catalogOpExecutor, startSyncFromId, pollingFrequencyInMilliSec);
    }

    public Metrics getMetrics() {
        return super.getMetrics();
    }

    public void startScheduler() {
    }

    public void processEvents() {
        super.processEvents();
        Assert.assertTrue((boolean)this.ensureEventsProcessedInHierarchicalMode(100000));
        super.updateLatestEventId();
        this.verifyEventSyncedMetrics();
    }

    protected void processEvents(long currentEventId, List<NotificationEvent> events) throws MetastoreNotificationException {
        super.processEvents(currentEventId, events);
        Assert.assertTrue((boolean)this.ensureEventsProcessedInHierarchicalMode(100000));
    }

    private void verifyEventSyncedMetrics() {
        Metrics metrics = this.getMetrics();
        long lastSyncedEventId = (Long)metrics.getGauge("last-synced-event-id").getValue();
        long latestEventId = (Long)metrics.getGauge("latest-event-id").getValue();
        long lastSyncedEventTime = (Long)metrics.getGauge("last-synced-event-time").getValue();
        long latestEventTime = (Long)metrics.getGauge("latest-event-time").getValue();
        long greatestSyncedEventId = (Long)metrics.getGauge("greatest-synced-event-id").getValue();
        long greatestSyncedEventTime = (Long)metrics.getGauge("greatest-synced-event-time").getValue();
        Assert.assertEquals((long)greatestSyncedEventId, (long)lastSyncedEventId);
        Assert.assertEquals((long)greatestSyncedEventTime, (long)lastSyncedEventTime);
        if (lastSyncedEventId == latestEventId) {
            Assert.assertEquals((String)("Incorrect last synced event time for event " + latestEventId), (long)latestEventTime, (long)lastSyncedEventTime);
        }
    }
}

