/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.util.ArrayList;
import java.util.List;
import org.apache.impala.catalog.PrincipalPrivilege;
import org.apache.impala.catalog.PrincipalPrivilegeTree;
import org.apache.impala.thrift.TPrivilege;
import org.apache.impala.thrift.TPrivilegeLevel;
import org.apache.impala.thrift.TPrivilegeScope;
import org.junit.Assert;
import org.junit.Test;

public class PrincipalPrivilegeTreeTest {
    @Test
    public void testPrincipalPrivilegeTree() {
        ArrayList<PrincipalPrivilege> privs = new ArrayList<PrincipalPrivilege>();
        privs.add(this.createTablePriv("server1", "db1", "t1"));
        privs.add(this.createTablePriv("server1", "db2", "t1"));
        privs.add(this.createTablePriv("server1", "db1", "t2"));
        privs.add(this.createDbPriv("server1", "db1"));
        privs.add(this.createServerPriv("server1"));
        privs.add(this.createServerPriv("server2"));
        privs.add(this.createColumnPriv("server1", "db1", "t1", "c1"));
        privs.add(this.createUriPriv("server1", "uri1"));
        PrincipalPrivilegeTree tree = new PrincipalPrivilegeTree();
        for (int i = 0; i < 2; ++i) {
            for (PrincipalPrivilege priv : privs) {
                tree.add(priv);
            }
            PrincipalPrivilege newServer2Priv = this.createServerPriv("server2");
            tree.add(newServer2Priv);
            List results = tree.getFilteredList(this.createFilter("server2", null, null));
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertSame(results.get(0), (Object)newServer2Priv);
            Assert.assertEquals((long)7L, (long)tree.getFilteredList(this.createFilter("server1", null, null)).size());
            Assert.assertEquals((long)5L, (long)tree.getFilteredList(this.createFilter("server1", "db1", null)).size());
            Assert.assertEquals((long)2L, (long)tree.getFilteredList(this.createFilter("server1", "db2", null)).size());
            Assert.assertEquals((long)4L, (long)tree.getFilteredList(this.createFilter("server1", "db1", "t1")).size());
            Assert.assertEquals((long)2L, (long)tree.getFilteredList(this.createFilter("server1", "db2", "t1")).size());
            Assert.assertEquals((long)2L, (long)tree.getFilteredList(this.createUriFilter("server1")).size());
            for (PrincipalPrivilege priv : privs) {
                tree.remove(priv);
            }
            Assert.assertEquals((long)0L, (long)tree.getFilteredList(this.createFilter("server1", null, null)).size());
        }
    }

    PrincipalPrivilege createColumnPriv(String server, String db, String table, String column) {
        TPrivilege priv = new TPrivilege(TPrivilegeLevel.SELECT, TPrivilegeScope.COLUMN, false);
        priv.setServer_name(server);
        priv.setDb_name(db);
        priv.setTable_name(table);
        priv.setColumn_name(column);
        return PrincipalPrivilege.fromThrift((TPrivilege)priv);
    }

    PrincipalPrivilege createTablePriv(String server, String db, String table) {
        TPrivilege priv = new TPrivilege(TPrivilegeLevel.SELECT, TPrivilegeScope.TABLE, false);
        priv.setServer_name(server);
        priv.setDb_name(db);
        priv.setTable_name(table);
        return PrincipalPrivilege.fromThrift((TPrivilege)priv);
    }

    PrincipalPrivilege createDbPriv(String server, String db) {
        TPrivilege priv = new TPrivilege(TPrivilegeLevel.SELECT, TPrivilegeScope.DATABASE, false);
        priv.setServer_name(server);
        priv.setDb_name(db);
        return PrincipalPrivilege.fromThrift((TPrivilege)priv);
    }

    PrincipalPrivilege createUriPriv(String server, String uri) {
        TPrivilege priv = new TPrivilege(TPrivilegeLevel.SELECT, TPrivilegeScope.URI, false);
        priv.setServer_name(server);
        priv.setUri(uri);
        return PrincipalPrivilege.fromThrift((TPrivilege)priv);
    }

    PrincipalPrivilege createServerPriv(String server) {
        TPrivilege priv = new TPrivilege(TPrivilegeLevel.SELECT, TPrivilegeScope.SERVER, false);
        priv.setServer_name(server);
        return PrincipalPrivilege.fromThrift((TPrivilege)priv);
    }

    PrincipalPrivilegeTree.Filter createFilter(String server, String db, String table) {
        PrincipalPrivilegeTree.Filter filter = new PrincipalPrivilegeTree.Filter();
        filter.setServer(server);
        filter.setDb(db);
        filter.setTable(table);
        filter.setIsUri(false);
        return filter;
    }

    PrincipalPrivilegeTree.Filter createUriFilter(String server) {
        PrincipalPrivilegeTree.Filter filter = new PrincipalPrivilegeTree.Filter();
        filter.setServer(server);
        filter.setIsUri(true);
        return filter;
    }
}

