/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import org.apache.impala.catalog.PartitionMetaSummary;
import org.apache.impala.service.FeSupport;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PartitionMetaSummaryTest {
    @BeforeClass
    public static void setUp() {
        FeSupport.loadLibrary();
    }

    @Test
    public void testSortingInCatalogd() {
        PartitionMetaSummary summary = new PartitionMetaSummary("test_db.test_tbl", true, true, false);
        summary.update(true, false, "p=1", 123L, 100, 10);
        summary.update(true, false, "p=4", 123L, 100, 10);
        summary.update(true, false, "p=3", 123L, 100, 10);
        summary.update(true, false, "p=5", 123L, 100, 10);
        summary.update(true, false, "p=2", 123L, 100, 10);
        Assert.assertEquals((Object)"Collected 5 partition update(s): 1:HDFS_PARTITION:test_db.test_tbl:(p=1,p=2,...,p=5), version=123, original size=(avg=100, min=100, max=100, sum=500), compressed size=(avg=10, min=10, max=10, sum=50)", (Object)summary.toString());
    }

    @Test
    public void testSorting2InCatalogd() {
        PartitionMetaSummary summary = new PartitionMetaSummary("test_db.test_tbl", true, false, true);
        summary.update(false, false, "p=5", 123L, 100, 10);
        summary.update(false, false, "p=4", 123L, 100, 10);
        summary.update(false, false, "p=3", 123L, 100, 10);
        summary.update(false, false, "p=2", 123L, 100, 10);
        summary.update(false, false, "p=1", 123L, 100, 10);
        Assert.assertEquals((Object)"Collected 5 partition update(s): 2:HDFS_PARTITION:test_db.test_tbl:(p=1,p=2,...,p=5), version=123, original size=(avg=100, min=100, max=100, sum=500), compressed size=(avg=10, min=10, max=10, sum=50)", (Object)summary.toString());
    }

    @Test
    public void testMixModeInCatalogd() {
        PartitionMetaSummary summary = new PartitionMetaSummary("test_db.test_tbl", true, true, true);
        summary.update(true, false, "p=2", 123L, 100, 10);
        summary.update(false, false, "p=2", 123L, 10, 10);
        summary.update(true, false, "p=4", 123L, 100, 10);
        summary.update(false, false, "p=4", 123L, 10, 10);
        summary.update(true, false, "p=3", 123L, 100, 10);
        summary.update(false, false, "p=3", 123L, 10, 10);
        summary.update(true, true, "p=0", 121L, 100, 10);
        summary.update(false, true, "p=0", 121L, 10, 10);
        summary.update(true, true, "p=1", 122L, 100, 10);
        summary.update(false, true, "p=1", 122L, 10, 10);
        Assert.assertEquals((Object)"Collected 3 partition update(s): 1:HDFS_PARTITION:test_db.test_tbl:(p=2,p=3,p=4), version=123, original size=(avg=100, min=100, max=100, sum=300), compressed size=(avg=10, min=10, max=10, sum=30)\nCollected 3 partition update(s): 2:HDFS_PARTITION:test_db.test_tbl:(p=2,p=3,p=4), version=123, original size=(avg=10, min=10, max=10, sum=30), compressed size=(avg=10, min=10, max=10, sum=30)\nCollected 2 partition deletion(s): 1:HDFS_PARTITION:test_db.test_tbl:(p=0,p=1), versions=[121, 122], original size=(avg=100, min=100, max=100, sum=200), compressed size=(avg=10, min=10, max=10, sum=20)\nCollected 2 partition deletion(s): 2:HDFS_PARTITION:test_db.test_tbl:(p=0,p=1), versions=[121, 122], original size=(avg=10, min=10, max=10, sum=20), compressed size=(avg=10, min=10, max=10, sum=20)", (Object)summary.toString());
    }

    @Test
    public void testUpdatesAndDeletesInCatalogd() {
        PartitionMetaSummary summary = new PartitionMetaSummary("test_db.test_tbl", true, true, false);
        summary.update(true, false, "p=1", 123L, 100, 10);
        summary.update(true, false, "p=2", 123L, 100, 10);
        summary.update(true, false, "p=3", 123L, 100, 10);
        summary.update(true, false, "p=4", 123L, 100, 10);
        summary.update(true, false, "p=5", 123L, 100, 10);
        summary.update(true, true, "p=0", 200L, 100, 10);
        Assert.assertEquals((Object)"Collected 5 partition update(s): 1:HDFS_PARTITION:test_db.test_tbl:(p=1,p=2,...,p=5), version=123, original size=(avg=100, min=100, max=100, sum=500), compressed size=(avg=10, min=10, max=10, sum=50)\nCollected 1 partition deletion(s): 1:HDFS_PARTITION:test_db.test_tbl:p=0, version=200, original size=100, compressed size=10", (Object)summary.toString());
    }

    @Test
    public void testSortingInImpalad() {
        PartitionMetaSummary summary = new PartitionMetaSummary("test_db.test_tbl", false, true, false);
        summary.update(true, false, "p=1", 123L, 100, 10);
        summary.update(true, false, "p=2", 123L, 100, 10);
        summary.update(true, false, "p=4", 123L, 100, 10);
        summary.update(true, false, "p=3", 123L, 100, 10);
        summary.update(true, true, "p=0", 200L, 100, 10);
        Assert.assertEquals((Object)"Adding 4 partition(s): HDFS_PARTITION:test_db.test_tbl:(p=1,p=2,...,p=4), version=123, size=(avg=100, min=100, max=100, sum=400)\nDeleting 1 partition(s): HDFS_PARTITION:test_db.test_tbl:p=0, version=200, size=100", (Object)summary.toString());
    }
}

